/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.List;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.Parameter;
import org.alfresco.repo.virtual.ref.Protocol;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.ReferenceEncodingException;
import org.alfresco.repo.virtual.ref.ReferenceParameter;
import org.alfresco.repo.virtual.ref.RepositoryLocation;
import org.alfresco.repo.virtual.ref.RepositoryNodeRef;
import org.alfresco.repo.virtual.ref.RepositoryPath;
import org.alfresco.repo.virtual.ref.RepositoryResource;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.ResourceParameter;
import org.alfresco.repo.virtual.ref.StringParameter;
import org.alfresco.repo.virtual.ref.Stringifier;
import org.alfresco.repo.virtual.ref.ZeroEncoding;
import org.alfresco.service.cmr.repository.NodeRef;

public class ZeroStringifier
implements Stringifier,
ZeroEncoding {
    private static final long serialVersionUID = 6777894566062875199L;

    private int getProtocolEncoding(Protocol protocol) throws ReferenceEncodingException {
        String protocolStr = protocol.toString();
        if (protocolStr.equals("vanilla")) {
            return 0;
        }
        if (protocolStr.equals("virtual")) {
            return 3;
        }
        if (protocolStr.equals("node")) {
            return 6;
        }
        throw new ReferenceEncodingException("Invalid protocol: " + protocolStr);
    }

    @Override
    public String stringify(Reference reference) throws ReferenceEncodingException {
        String resource = this.stringify(reference.getResource());
        int protocolResourceEncoding = this.getProtocolEncoding(reference.getProtocol());
        return String.valueOf(protocolResourceEncoding += Integer.parseInt(resource.substring(0, 1))) + ":" + resource.substring(2) + this.stringify(reference.getParameters());
    }

    @Override
    public String stringify(Resource resource) throws ReferenceEncodingException {
        return resource.stringify(this);
    }

    @Override
    public String stringifyResource(Resource resource) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Invalid reference " + resource.getClass());
    }

    @Override
    public String stringifyResource(RepositoryResource resource) throws ReferenceEncodingException {
        String resourceLocation = this.stringify(resource.getLocation());
        int locationCode = Integer.parseInt(resourceLocation.substring(0, 1));
        return String.valueOf(locationCode += 0) + ":" + resourceLocation.substring(2);
    }

    @Override
    public String stringifyResource(ClasspathResource resource) {
        return "2:" + resource.getClasspath();
    }

    @Override
    public String stringify(RepositoryLocation repositoryLocation) throws ReferenceEncodingException {
        return repositoryLocation.stringify(this);
    }

    @Override
    public String stringifyRepositoryLocation(RepositoryLocation repositoryLocation) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Invalid location: " + repositoryLocation.getClass());
    }

    @Override
    public String stringifyRepositoryLocation(RepositoryNodeRef repositoryNodeRef) throws ReferenceEncodingException {
        NodeRef nodeRef = repositoryNodeRef.getNodeRef();
        return "1:" + nodeRef.getId();
    }

    @Override
    public String stringifyRepositoryLocation(RepositoryPath repositoryPath) throws ReferenceEncodingException {
        return "0:" + repositoryPath.getPath();
    }

    @Override
    public String stringify(List<Parameter> parameters) throws ReferenceEncodingException {
        StringBuilder parametersBuilder = new StringBuilder();
        for (Parameter parameter : parameters) {
            parametersBuilder.append(":");
            parametersBuilder.append(this.stringify(parameter));
        }
        return parametersBuilder.toString();
    }

    @Override
    public String stringify(Parameter parameter) throws ReferenceEncodingException {
        return parameter.stringify(this);
    }

    @Override
    public String stringifyParameter(ResourceParameter resourceParameter) throws ReferenceEncodingException {
        return this.stringify((Resource)resourceParameter.getValue());
    }

    @Override
    public String stringifyParameter(StringParameter stringParameter) throws ReferenceEncodingException {
        return "s:" + (String)stringParameter.getValue();
    }

    @Override
    public String stringifyParameter(Parameter parameter) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Invalid parameter: " + parameter.getClass());
    }

    @Override
    public String stringifyParameter(ReferenceParameter parameter) throws ReferenceEncodingException {
        return "r:" + this.stringify((Reference)parameter.getValue()) + ":" + "*";
    }
}

