/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.usage;

import java.util.Date;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.repo.usage.RepoUsageComponent;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.cmr.admin.RepoUsageStatus;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class RepoUsageMonitor
implements RepoUsageComponent.RestrictionObserver {
    private static Log logger = LogFactory.getLog(RepoUsageMonitor.class);
    public static final Long LOCK_TTL = 60000L;
    public static final QName LOCK_USAGE = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"RepoUsageMonitor");
    private Scheduler scheduler;
    private TransactionServiceImpl transactionService;
    private RepoUsageComponent repoUsageComponent;
    private JobLockService jobLockService;
    private final QName vetoName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"RepoUsageMonitor");

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setTransactionService(TransactionService transactionService) {
        try {
            this.transactionService = (TransactionServiceImpl)transactionService;
        }
        catch (ClassCastException classCastException) {
            throw new AlfrescoRuntimeException("The RepoUsageMonitor needs direct access to the TransactionServiceImpl");
        }
    }

    public void setRepoUsageComponent(RepoUsageComponent repoUsageComponent) {
        this.repoUsageComponent = repoUsageComponent;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void init() throws SchedulerException {
        PropertyCheck.mandatory((Object)this, (String)"scheduler", (Object)this.scheduler);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"repoUsageComponent", (Object)this.repoUsageComponent);
        PropertyCheck.mandatory((Object)this, (String)"jobLockService", (Object)this.jobLockService);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("RepoUsageMonitor", (Object)this);
        JobDetail jobDetail = JobBuilder.newJob().withIdentity("rmj").usingJobData(jobDataMap).ofType(RepoUsageMonitorJob.class).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("rmt").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatHourlyForever().withIntervalInHours(12)).startAt(new Date(System.currentTimeMillis() + 3600000L)).build();
        this.repoUsageComponent.observeRestrictions(this);
        this.scheduler.unscheduleJob(trigger.getKey());
        this.scheduler.scheduleJob(jobDetail, trigger);
    }

    public void checkUsages() {
        block12: {
            final RetryingTransactionHelper.RetryingTransactionCallback<Void> checkWork = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    RepoUsage restrictions = RepoUsageMonitor.this.repoUsageComponent.getRestrictions();
                    if (restrictions.getUsers() == null && restrictions.getDocuments() == null) {
                        RepoUsageMonitor.this.transactionService.setAllowWrite(true, RepoUsageMonitor.this.vetoName);
                        return null;
                    }
                    if (restrictions.getUsers() != null) {
                        RepoUsageMonitor.this.repoUsageComponent.updateUsage(RepoUsage.UsageType.USAGE_USERS);
                    }
                    if (restrictions.getDocuments() != null) {
                        RepoUsageMonitor.this.repoUsageComponent.updateUsage(RepoUsage.UsageType.USAGE_DOCUMENTS);
                    }
                    RepoUsageMonitor.this.onChangeRestriction(restrictions);
                    return null;
                }
            };
            AuthenticationUtil.RunAsWork<Void> runAs = new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    RepoUsageMonitor.this.transactionService.getRetryingTransactionHelper().doInTransaction(checkWork, false);
                    return null;
                }
            };
            String lockToken = null;
            TrackerJobLockRefreshCallback callback = new TrackerJobLockRefreshCallback();
            try {
                try {
                    lockToken = this.jobLockService.getLock(LOCK_USAGE, LOCK_TTL);
                    this.jobLockService.refreshLock(lockToken, LOCK_USAGE, LOCK_TTL / 2L, callback);
                    AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)runAs, (String)AuthenticationUtil.getSystemUserName());
                }
                catch (LockAcquisitionException e) {
                    logger.debug((Object)("Failed to get lock for usage monitor: " + e.getMessage()));
                    if (lockToken == null) break block12;
                    try {
                        callback.isActive = false;
                        this.jobLockService.releaseLock(lockToken, LOCK_USAGE);
                    }
                    catch (LockAcquisitionException e2) {
                        logger.debug((Object)("Failed to release lock for usage monitor: " + e2.getMessage()));
                    }
                }
            }
            finally {
                if (lockToken != null) {
                    try {
                        callback.isActive = false;
                        this.jobLockService.releaseLock(lockToken, LOCK_USAGE);
                    }
                    catch (LockAcquisitionException e) {
                        logger.debug((Object)("Failed to release lock for usage monitor: " + e.getMessage()));
                    }
                }
            }
        }
    }

    @Override
    public void onChangeRestriction(RepoUsage restrictions) {
        RepoUsageStatus status = this.repoUsageComponent.getUsageStatus();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Current status is " + status));
        }
        status.logMessages(logger);
        if (status.getLevel() == RepoUsageStatus.RepoUsageLevel.LOCKED_DOWN) {
            this.transactionService.setAllowWrite(false, this.vetoName);
        } else {
            this.transactionService.setAllowWrite(true, this.vetoName);
        }
    }

    public static class RepoUsageMonitorJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            JobDataMap jdm = context.getJobDetail().getJobDataMap();
            RepoUsageMonitor repoUsageMonitor = (RepoUsageMonitor)jdm.get((Object)"RepoUsageMonitor");
            repoUsageMonitor.checkUsages();
        }
    }

    private class TrackerJobLockRefreshCallback
    implements JobLockService.JobLockRefreshCallback {
        public boolean isActive = true;

        private TrackerJobLockRefreshCallback() {
        }

        @Override
        public boolean isActive() {
            return this.isActive;
        }

        @Override
        public void lockReleased() {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"lock released");
            }
        }
    }
}

