/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.Deque;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.repo.content.transform.DebugEntry;
import org.alfresco.repo.content.transform.TransformerLogger;

public class TransformerDebugLog
extends TransformerLogger<DebugEntry> {
    private static Pattern END_OF_REQUEST_ID_PATTERN = Pattern.compile("[^0-9]");

    @Override
    protected int getUpperMaxEntries() {
        return 100;
    }

    @Override
    protected String getPropertyName() {
        return "transformer.debug.entries";
    }

    @Override
    protected void addOrModify(Deque<DebugEntry> entries, Object message) {
        String msg = (String)message;
        String requestId = this.getRequestId(msg);
        if (requestId != null) {
            Iterator<DebugEntry> iterator = entries.descendingIterator();
            while (iterator.hasNext()) {
                DebugEntry entry = iterator.next();
                if (!requestId.equals(entry.requestId)) continue;
                entry.addLine(msg);
                return;
            }
            entries.add(new DebugEntry(requestId, msg));
        }
    }

    private String getRequestId(String message) {
        Matcher matcher;
        String requestId = null;
        if (message != null && (matcher = END_OF_REQUEST_ID_PATTERN.matcher(message)).find()) {
            int i = matcher.start();
            requestId = message.substring(0, i);
        }
        return requestId;
    }
}

