/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.store;

import org.alfresco.repo.virtual.ActualEnvironment;
import org.alfresco.repo.virtual.ActualEnvironmentException;
import org.alfresco.repo.virtual.VirtualizationException;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.VirtualProtocol;
import org.alfresco.repo.virtual.store.AspectVirtualizationMethod;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

public class SystemVirtualizationMethod
extends AspectVirtualizationMethod {
    private QName systemPathPropertyQName;
    private String systemPathPropertyName;

    @Override
    public void init() {
        super.init();
        if (this.systemPathPropertyName != null) {
            this.systemPathPropertyQName = QName.createQName((String)this.systemPathPropertyName, (NamespacePrefixResolver)this.namespacePrefixResolver);
        }
    }

    public void setSystemPathPropertyName(String systemPathPropertyName) {
        this.systemPathPropertyName = systemPathPropertyName;
    }

    @Override
    public Reference virtualize(ActualEnvironment env, NodeRef nodeRef) throws VirtualizationException {
        String templateSystemPath = (String)((Object)env.getProperty(nodeRef, this.systemPathPropertyQName));
        if (templateSystemPath != null) {
            return this.newVirtualReference(env, nodeRef, templateSystemPath);
        }
        throw new VirtualizationException("Invalid virtualization : missing template system-path.");
    }

    @Override
    public boolean canVirtualize(ActualEnvironment env, NodeRef nodeRef) throws ActualEnvironmentException {
        boolean canVirtualize = super.canVirtualize(env, nodeRef);
        if (canVirtualize) {
            String templateSystemPath = (String)((Object)env.getProperty(nodeRef, this.systemPathPropertyQName));
            if (templateSystemPath == null) {
                return false;
            }
            char systemToken = templateSystemPath.charAt(0);
            if (systemToken == VirtualProtocol.NODE_TEMPLATE_PATH_TOKEN.charValue()) {
                return env.exists(new NodeRef(templateSystemPath.substring(1)));
            }
            if (systemToken == VirtualProtocol.CLASS_TEMPLATE_PATH_TOKEN.charValue()) {
                return env.exists(templateSystemPath.substring(1));
            }
            canVirtualize = !templateSystemPath.equals("nullSystemTemplate");
        }
        return canVirtualize;
    }
}

