/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.rule.ruletrigger.RuleTrigger;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.rule.RuleType;
import org.alfresco.service.namespace.QName;

public abstract class RuleTriggerAbstractBase
implements RuleTrigger {
    private Set<RuleType> ruleTypes = new HashSet<RuleType>();
    private Set<QName> ignoredAspects = Collections.emptySet();
    private Set<QName> ignoredTypes = Collections.emptySet();
    protected PolicyComponent policyComponent;
    protected NodeService nodeService;
    protected ContentService contentService;
    protected AuthenticationComponent authenticationComponent;
    protected DictionaryService dictionaryService;
    protected RuleService ruleService;
    protected boolean executeRuleImmediately = false;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setExecuteRuleImmediately(boolean executeRuleImmediately) {
        this.executeRuleImmediately = executeRuleImmediately;
    }

    @Override
    public void registerRuleType(RuleType ruleType) {
        this.ruleTypes.add(ruleType);
    }

    protected void triggerRules(NodeRef nodeRef, NodeRef actionedUponNodeRef) {
        if (!this.areRulesEnabled()) {
            return;
        }
        if (!this.ignoreTrigger(actionedUponNodeRef)) {
            for (RuleType ruleType : this.ruleTypes) {
                ruleType.triggerRuleType(nodeRef, actionedUponNodeRef, this.executeRuleImmediately);
            }
        }
    }

    protected boolean areRulesEnabled() {
        return this.ruleService.isEnabled();
    }

    protected boolean ignoreTrigger(NodeRef actionedUponNodeRef) {
        boolean result = false;
        QName typeQName = this.nodeService.getType(actionedUponNodeRef);
        if (this.ignoredTypes.contains(typeQName)) {
            result = true;
        }
        for (QName aspectToIgnore : this.getIgnoredAspects()) {
            if (!this.nodeService.hasAspect(actionedUponNodeRef, aspectToIgnore)) continue;
            return true;
        }
        return result;
    }

    public Set<QName> getIgnoredAspects() {
        return this.ignoredAspects;
    }

    public void setIgnoredAspectsStr(List<String> ignoredAspects) {
        this.ignoredAspects = new HashSet<QName>(13);
        for (String ignoredAspectStr : ignoredAspects) {
            this.ignoredAspects.add(QName.createQName((String)ignoredAspectStr));
        }
    }

    public Set<QName> getIgnoredTypes() {
        return this.ignoredTypes;
    }

    public void setIgnoredTypeStr(List<String> ignoredTypes) {
        this.ignoredTypes = new HashSet<QName>(13);
        for (String ignoredTypeStr : ignoredTypes) {
            this.ignoredTypes.add(QName.createQName((String)ignoredTypeStr));
        }
    }
}

