/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TransformRequest
implements Serializable {
    private String requestId;
    private String transformName;
    private String nodeRef;
    private String targetMediaType;
    private Map<String, String> transformOptions = new HashMap<String, String>();
    private String clientData;
    private String replyQueue;

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getTransformName() {
        return this.transformName;
    }

    public void setTransformName(String transformName) {
        this.transformName = transformName;
    }

    public String getNodeRef() {
        return this.nodeRef;
    }

    public void setNodeRef(String nodeRef) {
        this.nodeRef = nodeRef;
    }

    public String getTargetMediaType() {
        return this.targetMediaType;
    }

    public void setTargetMediaType(String targetMediaType) {
        this.targetMediaType = targetMediaType;
    }

    public Map<String, String> getTransformOptions() {
        return this.transformOptions;
    }

    public String getClientData() {
        return this.clientData;
    }

    public void setClientData(String clientData) {
        this.clientData = clientData;
    }

    public void setTransformOptions(Map<String, String> transformOptions) {
        this.transformOptions = transformOptions;
    }

    public String getReplyQueue() {
        return this.replyQueue;
    }

    public void setReplyQueue(String replyQueue) {
        this.replyQueue = replyQueue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformRequest that = (TransformRequest)o;
        return this.requestId.equals(that.requestId) && this.nodeRef.equals(that.nodeRef);
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.nodeRef);
    }

    public String toString() {
        return "{\"requestId\":\"" + this.requestId + '\"' + ", \"transformName\":\"" + this.transformName + '\"' + ", \"nodeRef\":\"" + this.nodeRef + '\"' + ", \"targetMediaType\":\"" + this.targetMediaType + '\"' + ", \"transformOptions\":" + this.transformOptions + ", \"clientData\":\"" + this.clientData + '\"' + ", \"replyQueue\":\"" + this.replyQueue + '\"' + '}';
    }

    public static class Builder {
        private final TransformRequest request = new TransformRequest();

        private Builder() {
        }

        public Builder withRequestId(String requestId) {
            this.request.requestId = requestId;
            return this;
        }

        public Builder withTransformName(String transformName) {
            this.request.transformName = transformName;
            return this;
        }

        public Builder withNodeRef(String nodeRef) {
            this.request.nodeRef = nodeRef;
            return this;
        }

        public Builder withTargetMediaType(String targetMediaType) {
            this.request.targetMediaType = targetMediaType;
            return this;
        }

        public Builder withTransformOptions(Map<String, String> transformOptions) {
            this.request.transformOptions = transformOptions;
            return this;
        }

        public Builder withUserData(String userData) {
            this.request.clientData = userData;
            return this;
        }

        public Builder withReplyQueue(String replyQueue) {
            this.request.replyQueue = replyQueue;
            return this;
        }

        public TransformRequest build() {
            return this.request;
        }
    }
}

