/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.schema;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.sql.DataSource;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngineConfiguration;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.ibatis.SerializableTypeHandler;
import org.alfresco.repo.admin.patch.AppliedPatch;
import org.alfresco.repo.admin.patch.Patch;
import org.alfresco.repo.admin.patch.impl.SchemaUpgradeScriptPatch;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.dialect.MySQLClusterNDBDialect;
import org.alfresco.repo.domain.dialect.MySQLInnoDBDialect;
import org.alfresco.repo.domain.dialect.Oracle9Dialect;
import org.alfresco.repo.domain.dialect.PostgreSQLDialect;
import org.alfresco.repo.domain.dialect.SQLServerDialect;
import org.alfresco.repo.domain.patch.AppliedPatchDAO;
import org.alfresco.repo.domain.schema.SchemaAvailableEvent;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.util.DatabaseMetaDataHelper;
import org.alfresco.util.DialectUtil;
import org.alfresco.util.LogUtil;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.schemacomp.ExportDb;
import org.alfresco.util.schemacomp.MultiFileDumper;
import org.alfresco.util.schemacomp.Result;
import org.alfresco.util.schemacomp.Results;
import org.alfresco.util.schemacomp.SchemaComparator;
import org.alfresco.util.schemacomp.SchemaDifferenceHelper;
import org.alfresco.util.schemacomp.XMLToSchema;
import org.alfresco.util.schemacomp.model.Schema;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.extensions.surf.util.I18NUtil;

public class SchemaBootstrap
extends AbstractLifecycleBean {
    private static final String PROPERTY_DEFAULT_BATCH_SIZE = "system.upgrade.default.batchsize";
    private static final String MSG_DIALECT_USED = "schema.update.msg.dialect_used";
    private static final String MSG_DATABASE_USED = "schema.update.msg.database_used";
    private static final String MSG_BYPASSING_SCHEMA_UPDATE = "schema.update.msg.bypassing";
    private static final String MSG_NORMALIZED_SCHEMA = "schema.update.msg.normalized_schema";
    private static final String MSG_NO_CHANGES = "schema.update.msg.no_changes";
    private static final String MSG_ALL_STATEMENTS = "schema.update.msg.all_statements";
    private static final String MSG_EXECUTING_GENERATED_SCRIPT = "schema.update.msg.executing_generated_script";
    private static final String MSG_EXECUTING_COPIED_SCRIPT = "schema.update.msg.executing_copied_script";
    private static final String MSG_EXECUTING_STATEMENT = "schema.update.msg.executing_statement";
    private static final String MSG_OPTIONAL_STATEMENT_FAILED = "schema.update.msg.optional_statement_failed";
    private static final String MSG_OPTIONAL_PATCH_RUN_SUGGESTION = "system.schema_comp.patch_run_suggestion";
    private static final String ERR_FORCED_STOP = "schema.update.err.forced_stop";
    private static final String ERR_MULTIPLE_SCHEMAS = "schema.update.err.found_multiple";
    private static final String ERR_PREVIOUS_FAILED_BOOTSTRAP = "schema.update.err.previous_failed";
    private static final String ERR_UPDATE_IN_PROGRESS_ON_ANOTHER_NODE = "schema.update.err.upgrade_in_progress_on_another_node";
    private static final String ERR_STATEMENT_FAILED = "schema.update.err.statement_failed";
    private static final String ERR_UPDATE_FAILED = "schema.update.err.update_failed";
    private static final String ERR_VALIDATION_FAILED = "schema.update.err.validation_failed";
    private static final String ERR_SCRIPT_NOT_RUN = "schema.update.err.update_script_not_run";
    private static final String ERR_SCRIPT_NOT_FOUND = "schema.update.err.script_not_found";
    private static final String ERR_STATEMENT_INCLUDE_BEFORE_SQL = "schema.update.err.statement_include_before_sql";
    private static final String ERR_STATEMENT_VAR_ASSIGNMENT_BEFORE_SQL = "schema.update.err.statement_var_assignment_before_sql";
    private static final String ERR_STATEMENT_VAR_ASSIGNMENT_FORMAT = "schema.update.err.statement_var_assignment_format";
    private static final String ERR_STATEMENT_TERMINATOR = "schema.update.err.statement_terminator";
    private static final String ERR_DELIMITER_SET_BEFORE_SQL = "schema.update.err.delimiter_set_before_sql";
    private static final String ERR_DELIMITER_INVALID = "schema.update.err.delimiter_invalid";
    private static final String DEBUG_SCHEMA_COMP_NO_REF_FILE = "system.schema_comp.debug.no_ref_file";
    private static final String INFO_SCHEMA_COMP_ALL_OK = "system.schema_comp.info.all_ok";
    private static final String WARN_SCHEMA_COMP_PROBLEMS_FOUND = "system.schema_comp.warn.problems_found";
    private static final String WARN_SCHEMA_COMP_PROBLEMS_FOUND_NO_FILE = "system.schema_comp.warn.problems_found_no_file";
    private static final String DEBUG_SCHEMA_COMP_TIME_TAKEN = "system.schema_comp.debug.time_taken";
    public static final int DEFAULT_LOCK_RETRY_COUNT = 24;
    public static final int DEFAULT_LOCK_RETRY_WAIT_SECONDS = 5;
    public static final int DEFAULT_MAX_STRING_LENGTH = 1024;
    public static final int DEFAULT_MAX_STRING_LENGTH_NDB = 400;
    private static volatile int maxStringLength = 1024;
    private Dialect dialect;
    private SchemaDifferenceHelper differenceHelper;
    private ResourcePatternResolver rpr = new PathMatchingResourcePatternResolver(((Object)((Object)this)).getClass().getClassLoader());
    private static Log logger = LogFactory.getLog(SchemaBootstrap.class);
    private DescriptorService descriptorService;
    private DataSource dataSource;
    private AppliedPatchDAO appliedPatchDAO;
    private String schemaOuputFilename;
    private boolean updateSchema;
    private boolean stopAfterSchemaBootstrap;
    private List<String> preCreateScriptUrls;
    private List<String> postCreateScriptUrls;
    private List<String> schemaReferenceUrls;
    private List<SchemaUpgradeScriptPatch> preUpdateScriptPatches;
    private List<SchemaUpgradeScriptPatch> postUpdateScriptPatches;
    private List<SchemaUpgradeScriptPatch> updateActivitiScriptPatches;
    private int schemaUpdateLockRetryCount = 24;
    private int schemaUpdateLockRetryWaitSeconds = 5;
    private int maximumStringLength = -1;
    private Properties globalProperties;
    private String dbSchemaName;
    private DatabaseMetaDataHelper databaseMetaDataHelper;
    private ThreadLocal<StringBuilder> executedStatementsThreadLocal = new ThreadLocal();

    public static final void setMaxStringLength(int length, Dialect dialect) {
        int max;
        int n = max = dialect instanceof MySQLClusterNDBDialect ? 400 : 1024;
        if (length < max) {
            throw new AlfrescoRuntimeException("The maximum string length must >= " + max + " characters.");
        }
        maxStringLength = length;
    }

    public static final int getMaxStringLength() {
        return maxStringLength;
    }

    public static final String trimStringForTextFields(String value) {
        if (value != null && value.length() > maxStringLength) {
            return value.substring(0, maxStringLength);
        }
        return value;
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public void setDatabaseMetaDataHelper(DatabaseMetaDataHelper databaseMetaDataHelper) {
        this.databaseMetaDataHelper = databaseMetaDataHelper;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public void setDifferenceHelper(SchemaDifferenceHelper differenceHelper) {
        this.differenceHelper = differenceHelper;
    }

    public SchemaBootstrap() {
        this.preCreateScriptUrls = new ArrayList<String>(1);
        this.postCreateScriptUrls = new ArrayList<String>(1);
        this.preUpdateScriptPatches = new ArrayList<SchemaUpgradeScriptPatch>(4);
        this.postUpdateScriptPatches = new ArrayList<SchemaUpgradeScriptPatch>(4);
        this.updateActivitiScriptPatches = new ArrayList<SchemaUpgradeScriptPatch>(4);
        this.globalProperties = new Properties();
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setAppliedPatchDAO(AppliedPatchDAO appliedPatchDAO) {
        this.appliedPatchDAO = appliedPatchDAO;
    }

    public void setSchemaOuputFilename(String schemaOuputFilename) {
        this.schemaOuputFilename = schemaOuputFilename;
    }

    public void setUpdateSchema(boolean updateSchema) {
        this.updateSchema = updateSchema;
    }

    public void setStopAfterSchemaBootstrap(boolean stopAfterSchemaBootstrap) {
        this.stopAfterSchemaBootstrap = stopAfterSchemaBootstrap;
    }

    public void setSchemaReferenceUrls(List<String> schemaReferenceUrls) {
        this.schemaReferenceUrls = schemaReferenceUrls;
    }

    public void setSchemaUpdateLockRetryCount(int schemaUpdateLockRetryCount) {
        this.schemaUpdateLockRetryCount = schemaUpdateLockRetryCount;
    }

    public void setSchemaUpdateLockRetryWaitSeconds(int schemaUpdateLockRetryWaitSeconds) {
        this.schemaUpdateLockRetryWaitSeconds = schemaUpdateLockRetryWaitSeconds;
    }

    public void setMaximumStringLength(int maximumStringLength) {
        if (maximumStringLength > 0) {
            this.maximumStringLength = maximumStringLength;
        }
    }

    public void setDbSchemaName(String dbSchemaName) {
        if (PropertyCheck.isValidPropertyString((String)dbSchemaName)) {
            this.dbSchemaName = dbSchemaName;
        }
    }

    public void setGlobalProperties(Properties globalProperties) {
        this.globalProperties = globalProperties;
    }

    public void addPreCreateScriptUrl(String preCreateScriptUrl) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered create script URL (pre-Hibernate): " + preCreateScriptUrl));
        }
        this.preCreateScriptUrls.add(preCreateScriptUrl);
    }

    public void addPostCreateScriptUrl(String postUpdateScriptUrl) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered create script URL (post-Hibernate): " + postUpdateScriptUrl));
        }
        this.postCreateScriptUrls.add(postUpdateScriptUrl);
    }

    public void addPreUpdateScriptPatch(SchemaUpgradeScriptPatch scriptPatch) {
        if (!scriptPatch.isIgnored()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registered script patch (pre-Hibernate): " + scriptPatch.getId()));
            }
            this.preUpdateScriptPatches.add(scriptPatch);
        } else {
            logger.info((Object)("Ignoring script patch (pre-Hibernate): " + scriptPatch.getId()));
        }
    }

    public void addPostUpdateScriptPatch(SchemaUpgradeScriptPatch scriptPatch) {
        if (!scriptPatch.isIgnored()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registered script patch (post-Hibernate): " + scriptPatch.getId()));
            }
            this.postUpdateScriptPatches.add(scriptPatch);
        } else {
            logger.info((Object)("Ignoring script patch (post-Hibernate): " + scriptPatch.getId()));
        }
    }

    public void addUpdateActivitiScriptPatch(SchemaUpgradeScriptPatch scriptPatch) {
        if (!scriptPatch.isIgnored()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registered Activiti script patch: " + scriptPatch.getId()));
            }
            this.updateActivitiScriptPatches.add(scriptPatch);
        } else {
            logger.info((Object)("Ignoring Activiti script patch: " + scriptPatch.getId()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int countAppliedPatches(Connection connection) throws Exception {
        int n;
        ResultSet rs;
        String defaultCatalog;
        String defaultSchema;
        String string = defaultSchema = this.dbSchemaName != null ? this.dbSchemaName : this.databaseMetaDataHelper.getSchema(connection);
        if (defaultSchema != null && defaultSchema.length() == 0) {
            defaultSchema = null;
        }
        if ((defaultCatalog = connection.getCatalog()) != null && defaultCatalog.length() == 0) {
            defaultCatalog = null;
        }
        DatabaseMetaData dbMetadata = connection.getMetaData();
        ResultSet tableRs = dbMetadata.getTables(defaultCatalog, defaultSchema, "%", null);
        boolean newPatchTable = false;
        boolean oldPatchTable = false;
        try {
            boolean multipleSchemas = false;
            while (true) {
                if (!tableRs.next()) {
                    if (!multipleSchemas) break;
                    throw new AlfrescoRuntimeException(ERR_MULTIPLE_SCHEMAS);
                }
                String tableName = tableRs.getString("TABLE_NAME");
                if (tableName.equalsIgnoreCase("applied_patch")) {
                    if (oldPatchTable || newPatchTable) {
                        multipleSchemas = true;
                    }
                    oldPatchTable = true;
                    continue;
                }
                if (!tableName.equalsIgnoreCase("alf_applied_patch")) continue;
                if (oldPatchTable || newPatchTable) {
                    multipleSchemas = true;
                }
                newPatchTable = true;
            }
        }
        finally {
            try {
                tableRs.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (newPatchTable) {
            int n2;
            Statement stmt = connection.createStatement();
            try {
                int count;
                rs = stmt.executeQuery("select count(id) from alf_applied_patch");
                rs.next();
                n2 = count = rs.getInt(1);
            }
            catch (SQLException sQLException) {
                try {
                    throw new AlfrescoRuntimeException(ERR_MULTIPLE_SCHEMAS);
                }
                catch (Throwable throwable) {
                    try {
                        stmt.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {}
                    throw throwable;
                }
            }
            try {
                stmt.close();
                return n2;
            }
            catch (Throwable throwable) {}
            return n2;
        }
        if (!oldPatchTable) throw new NoSchemaException();
        Statement stmt = connection.createStatement();
        try {
            int count;
            rs = stmt.executeQuery("select count(id) from applied_patch");
            rs.next();
            n = count = rs.getInt(1);
        }
        catch (Throwable throwable) {
            try {
                stmt.close();
                throw throwable;
            }
            catch (Throwable throwable3) {}
            throw throwable;
        }
        try {
            stmt.close();
            return n;
        }
        catch (Throwable throwable) {}
        return n;
    }

    /*
     * Loose catch block
     */
    private boolean checkActivitiTablesExist(Connection connection) {
        Statement stmt = null;
        stmt = connection.createStatement();
        stmt.executeQuery("select min(id_) from ACT_RU_TASK");
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Throwable throwable) {}
        return true;
        catch (SQLException sQLException) {
            try {
                logger.debug((Object)"Did not find ACT_RU_TASK table.");
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Throwable throwable) {}
            return false;
        }
    }

    /*
     * Loose catch block
     */
    private String getAppliedPatchTableName(Connection connection) throws Exception {
        Statement stmt = connection.createStatement();
        stmt.executeQuery("select * from alf_applied_patch");
        try {
            stmt.close();
        }
        catch (Throwable throwable) {}
        return "alf_applied_patch";
        catch (Throwable throwable) {
            try {}
            catch (Throwable throwable2) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable3) {}
                throw throwable2;
            }
            try {
                stmt.close();
            }
            catch (Throwable throwable4) {}
        }
        stmt = connection.createStatement();
        stmt.executeQuery("select * from applied_patch");
        try {
            stmt.close();
        }
        catch (Throwable throwable) {}
        return "applied_patch";
        catch (Throwable throwable) {
            try {}
            catch (Throwable throwable5) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable6) {}
                throw throwable5;
            }
            try {
                stmt.close();
            }
            catch (Throwable throwable7) {}
            return null;
        }
    }

    private boolean didPatchSucceed(Connection connection, String patchId, boolean alternative) throws Exception {
        boolean succeeded;
        Statement stmt;
        block14: {
            ResultSet rs;
            block13: {
                String patchTableName = this.getAppliedPatchTableName(connection);
                if (patchTableName == null) {
                    return false;
                }
                stmt = connection.createStatement();
                try {
                    rs = stmt.executeQuery("select succeeded, was_executed from " + patchTableName + " where id = '" + patchId + "'");
                    if (rs.next()) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable2) {}
                    throw throwable;
                }
                try {
                    stmt.close();
                }
                catch (Throwable throwable) {}
                return false;
            }
            succeeded = rs.getBoolean(1);
            boolean wasExecuted = rs.getBoolean(2);
            if (!alternative) break block14;
            boolean bl = succeeded && wasExecuted;
            try {
                stmt.close();
            }
            catch (Throwable throwable) {}
            return bl;
        }
        boolean bl = succeeded;
        try {
            stmt.close();
        }
        catch (Throwable throwable) {}
        return bl;
    }

    private int getInstalledSchemaNumber(Connection connection) throws Exception {
        int installedSchema;
        ResultSet rs;
        Statement stmt;
        block13: {
            block12: {
                stmt = connection.createStatement();
                try {
                    rs = stmt.executeQuery("select min(applied_to_schema) from alf_applied_patch where applied_to_schema > -1");
                    if (rs.next()) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable2) {}
                    throw throwable;
                }
                try {
                    stmt.close();
                }
                catch (Throwable throwable) {}
                return -1;
            }
            if (rs.getObject(1) != null) break block13;
            try {
                stmt.close();
            }
            catch (Throwable throwable) {}
            return -1;
        }
        int n = installedSchema = rs.getInt(1);
        try {
            stmt.close();
        }
        catch (Throwable throwable) {}
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void setBootstrapStarted(Connection connection) throws Exception {
        Statement stmt = connection.createStatement();
        try {
            stmt.executeUpdate("create table alf_bootstrap_lock (charval CHAR(1) NOT NULL)");
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Bootstrap started.");
            }
        }
        catch (Throwable throwable) {
            try {
                throw new LockFailedException();
            }
            catch (Throwable throwable2) {
                try {
                    stmt.close();
                    throw throwable2;
                }
                catch (Throwable throwable3) {}
                throw throwable2;
            }
        }
        try {
            stmt.close();
            return;
        }
        catch (Throwable throwable) {}
    }

    /*
     * Loose catch block
     */
    private synchronized boolean isBootstrapInProgress(Connection connection) throws Exception {
        Statement stmt;
        block10: {
            stmt = connection.createStatement();
            stmt.executeQuery("select * from alf_bootstrap_lock");
            if (!logger.isInfoEnabled()) break block10;
            logger.info((Object)"Bootstrap marker still present in the DB.");
        }
        try {
            stmt.close();
        }
        catch (Throwable throwable) {}
        return true;
        catch (Throwable throwable) {
            try {}
            catch (Throwable throwable2) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable3) {}
                throw throwable2;
            }
            try {
                stmt.close();
            }
            catch (Throwable throwable4) {}
            return false;
        }
    }

    private void setBootstrapCompleted(Connection connection) throws Exception {
        Statement stmt = connection.createStatement();
        try {
            try {
                stmt.executeUpdate("drop table alf_bootstrap_lock");
                this.executedStatementsThreadLocal.set(null);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Bootstrap completed.");
                }
            }
            catch (Throwable e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Exception in deleting the alf_bootstrap_lock table: " + e.getMessage()), e);
                }
                throw AlfrescoRuntimeException.create((String)ERR_PREVIOUS_FAILED_BOOTSTRAP, (Object[])new Object[0]);
            }
        }
        catch (Throwable throwable) {
            try {
                stmt.close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            stmt.close();
        }
        catch (Throwable throwable) {}
    }

    private boolean updateSchema(Connection connection) throws Exception {
        long start;
        boolean create = false;
        try {
            int numberOfPatchesApplied = this.countAppliedPatches(connection);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Applied patches detected: " + numberOfPatchesApplied));
            }
        }
        catch (NoSchemaException noSchemaException) {
            create = true;
        }
        Dialect dialect = this.dialect;
        dialect.getClass().getSimpleName();
        if (create) {
            long start2 = System.currentTimeMillis();
            for (String scriptUrl : this.preCreateScriptUrls) {
                this.executeScriptUrl(connection, scriptUrl);
            }
            for (String scriptUrl : this.postCreateScriptUrls) {
                this.executeScriptUrl(connection, scriptUrl);
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Creating Alfresco tables took " + (System.currentTimeMillis() - start2) + " ms"));
            }
        } else {
            long start2 = System.currentTimeMillis();
            this.checkSchemaPatchScripts(connection, this.preUpdateScriptPatches, true);
            this.checkSchemaPatchScripts(connection, this.postUpdateScriptPatches, true);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Checking and patching Alfresco tables took " + (System.currentTimeMillis() - start2) + " ms"));
            }
        }
        this.ensureCurrentClusterMemberIsBootstrapping(connection);
        boolean activitiTablesExist = this.checkActivitiTablesExist(connection);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Activiti tables need to be " + (activitiTablesExist ? "checked for patches" : " created")));
        }
        if (!activitiTablesExist) {
            start = System.currentTimeMillis();
            this.ensureCurrentClusterMemberIsBootstrapping(connection);
            this.initialiseActivitiDBSchema(new UnclosableConnection(connection));
            int installedSchemaNumber = this.getInstalledSchemaNumber(connection);
            for (Patch patch : this.updateActivitiScriptPatches) {
                AppliedPatch appliedPatch = new AppliedPatch();
                appliedPatch.setId(patch.getId());
                appliedPatch.setDescription(patch.getDescription());
                appliedPatch.setFixesFromSchema(patch.getFixesFromSchema());
                appliedPatch.setFixesToSchema(patch.getFixesToSchema());
                appliedPatch.setTargetSchema(patch.getTargetSchema());
                appliedPatch.setAppliedToSchema(installedSchemaNumber);
                appliedPatch.setAppliedToServer("UNKNOWN");
                appliedPatch.setAppliedOnDate(new Date());
                appliedPatch.setSucceeded(true);
                appliedPatch.setWasExecuted(false);
                appliedPatch.setReport("Placeholder for Activiti bootstrap at schema " + installedSchemaNumber);
                this.appliedPatchDAO.createAppliedPatch(appliedPatch);
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Creating Activiti tables took " + (System.currentTimeMillis() - start) + " ms"));
            }
        } else {
            start = System.currentTimeMillis();
            this.checkSchemaPatchScripts(connection, this.updateActivitiScriptPatches, true);
            this.checkSchemaPatchScripts(connection, this.updateActivitiScriptPatches, false);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Checking and patching Activiti tables took " + (System.currentTimeMillis() - start) + " ms"));
            }
        }
        if (!create) {
            start = System.currentTimeMillis();
            this.checkSchemaPatchScripts(connection, this.preUpdateScriptPatches, false);
            this.checkSchemaPatchScripts(connection, this.postUpdateScriptPatches, false);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Checking that all patches have been applied took " + (System.currentTimeMillis() - start) + " ms"));
            }
        }
        return create;
    }

    private void initialiseActivitiDBSchema(Connection connection) {
        ProcessEngineConfiguration engineConfig = ProcessEngineConfiguration.createStandaloneProcessEngineConfiguration();
        try (ProcessEngine engine = null;){
            String schemaName;
            engine = engineConfig.setDataSource(this.dataSource).setDatabaseSchemaUpdate("none").setProcessEngineName("activitiBootstrapEngine").setHistory("full").setJobExecutorActivate(false).buildProcessEngine();
            String string = schemaName = this.dbSchemaName != null ? this.dbSchemaName : this.databaseMetaDataHelper.getSchema(connection);
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Creating Activiti DB schema tables");
            }
            engine.getManagementService().databaseSchemaUpgrade(connection, null, schemaName);
        }
    }

    private void checkSchemaPatchScripts(Connection connection, List<SchemaUpgradeScriptPatch> scriptPatches, boolean apply) throws Exception {
        int appliedPatchCount = this.countAppliedPatches(connection);
        if (appliedPatchCount == 0) {
            return;
        }
        this.ensureCurrentClusterMemberIsBootstrapping(connection);
        int installedSchema = this.getInstalledSchemaNumber(connection);
        block0: for (SchemaUpgradeScriptPatch patch : scriptPatches) {
            String patchId = patch.getId();
            String scriptUrl = patch.getScriptUrl();
            List<Patch> alternatives = patch.getAlternatives();
            for (Patch alternativePatch : alternatives) {
                String alternativePatchId = alternativePatch.getId();
                boolean alternativeSucceeded = this.didPatchSucceed(connection, alternativePatchId, true);
                if (alternativeSucceeded) continue block0;
            }
            boolean wasSuccessfullyApplied = this.didPatchSucceed(connection, patchId, false);
            if (wasSuccessfullyApplied || !patch.applies(installedSchema)) continue;
            if (!apply) {
                throw AlfrescoRuntimeException.create((String)ERR_SCRIPT_NOT_RUN, (Object[])new Object[]{scriptUrl});
            }
            this.executeScriptUrl(connection, scriptUrl);
        }
    }

    private void ensureCurrentClusterMemberIsBootstrapping(Connection connection) throws Exception {
        if (this.isAnotherClusterMemberBootstrapping(connection)) {
            logger.info((Object)"Another Alfresco cluster node is updating the DB");
            throw new LockFailedException();
        }
    }

    private boolean isAnotherClusterMemberBootstrapping(Connection connection) throws Exception {
        return this.executedStatementsThreadLocal.get() == null && this.isBootstrapInProgress(connection);
    }

    private void executeScriptUrl(Connection connection, String scriptUrl) throws Exception {
        Dialect dialect = this.dialect;
        String dialectStr = dialect.getClass().getSimpleName();
        InputStream scriptInputStream = this.getScriptInputStream(dialect.getClass(), scriptUrl);
        if (scriptInputStream == null) {
            throw AlfrescoRuntimeException.create((String)ERR_SCRIPT_NOT_FOUND, (Object[])new Object[]{scriptUrl});
        }
        File tempFile = null;
        try {
            tempFile = TempFileProvider.createTempFile((String)("AlfrescoSchema-" + dialectStr + "-Update-"), (String)".sql");
            FileContentWriter writer = new FileContentWriter(tempFile);
            writer.putContent(scriptInputStream);
        }
        catch (Throwable throwable) {
            try {
                scriptInputStream.close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            scriptInputStream.close();
        }
        catch (Throwable throwable) {}
        String dialectScriptUrl = scriptUrl.replaceAll("\\$\\{db\\.script\\.dialect\\}", dialect.getClass().getName());
        this.executeScriptFile(connection, tempFile, dialectScriptUrl);
    }

    private InputStream getScriptInputStream(Class<?> dialectClazz, String scriptUrl) throws Exception {
        Resource resource = DialectUtil.getDialectResource(this.rpr, dialectClazz, scriptUrl);
        if (resource == null) {
            throw new AlfrescoRuntimeException("Script [ " + scriptUrl + " ] can't be found for " + dialectClazz);
        }
        return resource.getInputStream();
    }

    private void executeScriptFile(Connection connection, File scriptFile, String scriptUrl) throws Exception {
        Dialect dialect = this.dialect;
        if (this.executedStatementsThreadLocal.get() == null) {
            this.validateSchema("Alfresco-{0}-Validation-Pre-Upgrade-{1}-", null);
            this.dumpSchema("pre-upgrade");
            this.setBootstrapStarted(connection);
            this.executedStatementsThreadLocal.set(new StringBuilder(8094));
        }
        if (scriptUrl == null) {
            LogUtil.info((Log)logger, (String)MSG_EXECUTING_GENERATED_SCRIPT, (Object[])new Object[]{scriptFile});
        } else {
            LogUtil.info((Log)logger, (String)MSG_EXECUTING_COPIED_SCRIPT, (Object[])new Object[]{scriptFile, scriptUrl});
        }
        FileInputStream scriptInputStream = new FileInputStream(scriptFile);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)scriptInputStream, "UTF-8"));
        try {
            int line = 0;
            StringBuilder sb = new StringBuilder(1024);
            String fetchVarName = null;
            String fetchColumnName = null;
            String defaultFetchValue = null;
            boolean doBatch = false;
            int batchUpperLimit = 0;
            int batchSize = 1;
            HashMap<String, Object> varAssignments = new HashMap<String, Object>(13);
            String delimiter = ";";
            if (dialect instanceof PostgreSQLDialect) {
                varAssignments.put("true", "true");
                varAssignments.put("false", "false");
                varAssignments.put("TRUE", "TRUE");
                varAssignments.put("FALSE", "FALSE");
            } else {
                varAssignments.put("true", "1");
                varAssignments.put("false", "0");
                varAssignments.put("TRUE", "1");
                varAssignments.put("FALSE", "0");
            }
            long now = System.currentTimeMillis();
            varAssignments.put("now", Long.valueOf(now).toString());
            varAssignments.put("NOW", Long.valueOf(now).toString());
            while (true) {
                String sqlOriginal = reader.readLine();
                ++line;
                if (sqlOriginal != null) {
                    int endIndex;
                    String sql = sqlOriginal.trim();
                    if (sql.startsWith("--INCLUDE:")) {
                        if (sb.length() > 0) {
                            throw AlfrescoRuntimeException.create((String)ERR_STATEMENT_INCLUDE_BEFORE_SQL, (Object[])new Object[]{line - 1, scriptUrl});
                        }
                        String includedScriptUrl = sql.substring(10, sql.length());
                        this.executeScriptUrl(connection, includedScriptUrl);
                    } else {
                        if (sql.startsWith("--ASSIGN:")) {
                            if (sb.length() > 0) {
                                throw AlfrescoRuntimeException.create((String)ERR_STATEMENT_VAR_ASSIGNMENT_BEFORE_SQL, (Object[])new Object[]{line - 1, scriptUrl});
                            }
                            String assignStr = sql.substring(9, sql.length());
                            String[] fetchMapping = assignStr.split("!");
                            String[] assigns = fetchMapping[0].split("=");
                            if (assigns.length != 2 || assigns[0].length() == 0 || assigns[1].length() == 0) {
                                throw AlfrescoRuntimeException.create((String)ERR_STATEMENT_VAR_ASSIGNMENT_FORMAT, (Object[])new Object[]{line - 1, scriptUrl});
                            }
                            fetchVarName = assigns[0];
                            fetchColumnName = assigns[1];
                            if (fetchMapping.length <= 1 || fetchMapping[1].length() <= 0) continue;
                            defaultFetchValue = fetchMapping[1];
                            continue;
                        }
                        if (sql.startsWith("--FOREACH")) {
                            int sepIndex;
                            String[] args = sql.split("[ \\t]+");
                            if (args.length != 3 || (sepIndex = args[1].indexOf(46)) == -1) continue;
                            doBatch = true;
                            String stmt = "SELECT MAX(" + args[1].substring(sepIndex + 1) + ") AS upper_limit FROM " + args[1].substring(0, sepIndex);
                            Object fetchedVal = this.executeStatement(connection, stmt, "upper_limit", false, line, scriptFile);
                            if (!(fetchedVal instanceof Number)) continue;
                            batchUpperLimit = ((Number)fetchedVal).intValue();
                            String batchSizeString = this.globalProperties.getProperty(args[2]);
                            if (batchSizeString == null) {
                                batchSizeString = this.globalProperties.getProperty(PROPERTY_DEFAULT_BATCH_SIZE);
                            }
                            batchSize = batchSizeString == null ? 10000 : Integer.parseInt(batchSizeString);
                            continue;
                        }
                        if (sql.startsWith("--BEGIN TXN")) {
                            connection.setAutoCommit(false);
                            continue;
                        }
                        if (sql.startsWith("--END TXN")) {
                            connection.commit();
                            connection.setAutoCommit(true);
                            continue;
                        }
                        if (sql.startsWith("--SET-DELIMITER:")) {
                            if (sb.length() > 0) {
                                throw AlfrescoRuntimeException.create((String)ERR_DELIMITER_SET_BEFORE_SQL, (Object[])new Object[]{line - 1, scriptUrl});
                            }
                            String newDelim = sql.substring(16).trim();
                            if (newDelim.length() == 0) {
                                throw AlfrescoRuntimeException.create((String)ERR_DELIMITER_INVALID, (Object[])new Object[]{line - 1, scriptUrl});
                            }
                            delimiter = newDelim;
                        }
                    }
                    if (sql.length() == 0 || sql.startsWith("--") || sql.startsWith("//") || sql.startsWith("/*")) {
                        if (sb.length() <= 0) continue;
                        throw AlfrescoRuntimeException.create((String)ERR_STATEMENT_TERMINATOR, (Object[])new Object[]{delimiter, line - 1, scriptUrl});
                    }
                    boolean execute = false;
                    boolean optional = false;
                    if (sql.endsWith(delimiter)) {
                        sql = sql.substring(0, sql.length() - 1);
                        execute = true;
                        optional = false;
                    } else if ((sql.endsWith("(optional)") || sql.endsWith("(OPTIONAL)")) && (endIndex = sql.lastIndexOf(delimiter)) > -1) {
                        sql = sql.substring(0, endIndex);
                        execute = true;
                        optional = true;
                    }
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    int whitespaceCount = sqlOriginal.indexOf(sql);
                    int i = 0;
                    while (i < whitespaceCount) {
                        sb.append(" ");
                        ++i;
                    }
                    sb.append(sql);
                    if (!execute) continue;
                    String unsubstituted = sb.toString();
                    int lowerBound = 0;
                    while (lowerBound <= batchUpperLimit) {
                        sql = unsubstituted;
                        if (doBatch) {
                            varAssignments.put("LOWERBOUND", String.valueOf(lowerBound));
                            varAssignments.put("UPPERBOUND", String.valueOf(lowerBound + batchSize - 1));
                        }
                        for (Map.Entry entry : varAssignments.entrySet()) {
                            String var = (String)entry.getKey();
                            Object val = entry.getValue();
                            sql = sql.replaceAll("\\$\\{" + var + "\\}", val.toString());
                        }
                        sql = this.dialect != null && this.dialect instanceof PostgreSQLDialect ? sql.replaceAll("\\$\\{TRUE\\}", "TRUE") : sql.replaceAll("\\$\\{TRUE\\}", "1");
                        if (this.dialect != null && this.dialect instanceof MySQLInnoDBDialect) {
                            sql = sql.replaceAll("(?i)TYPE=InnoDB", "ENGINE=InnoDB");
                        }
                        if (this.dialect != null && this.dialect instanceof MySQLClusterNDBDialect) {
                            sql = sql.replaceAll("(?i)TYPE=InnoDB", "ENGINE=NDB");
                            sql = sql.replaceAll("(?i)ENGINE=InnoDB", "ENGINE=NDB");
                            sql = sql.replaceAll("(?i) BIT ", " BOOLEAN ");
                            sql = sql.replaceAll("(?i) BIT,", " BOOLEAN,");
                            sql = sql.replaceAll("(?i) string_value text", " string_value VARCHAR(400)");
                            sql = sql.replaceAll("(?i) VARCHAR(4000)", "TEXT(4000)");
                        }
                        Object fetchedVal = this.executeStatement(connection, sql, fetchColumnName, optional, line, scriptFile);
                        if (fetchVarName != null && fetchColumnName != null) {
                            if (fetchedVal != null) {
                                varAssignments.put(fetchVarName, fetchedVal);
                            } else {
                                varAssignments.put(fetchVarName, defaultFetchValue);
                            }
                        }
                        lowerBound += batchSize;
                    }
                    sb.setLength(0);
                    fetchVarName = null;
                    fetchColumnName = null;
                    defaultFetchValue = null;
                    doBatch = false;
                    batchUpperLimit = 0;
                    batchSize = 1;
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            try {
                reader.close();
            }
            catch (Throwable throwable2) {}
            try {
                ((InputStream)scriptInputStream).close();
            }
            catch (Throwable throwable3) {}
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (Throwable throwable) {}
        try {
            ((InputStream)scriptInputStream).close();
        }
        catch (Throwable throwable) {}
    }

    private Object executeStatement(Connection connection, String sql, String fetchColumnName, boolean optional, int line, File file) throws Exception {
        Object ret;
        block15: {
            StringBuilder executedStatements = this.executedStatementsThreadLocal.get();
            if (executedStatements == null) {
                throw new IllegalArgumentException("The executedStatementsThreadLocal must be populated");
            }
            Statement stmt = connection.createStatement();
            ret = null;
            try {
                try {
                    ResultSet rs;
                    if (logger.isDebugEnabled()) {
                        LogUtil.debug((Log)logger, (String)MSG_EXECUTING_STATEMENT, (Object[])new Object[]{sql});
                    }
                    boolean haveResults = stmt.execute(sql);
                    executedStatements.append(sql).append(";\n\n");
                    if (haveResults && fetchColumnName != null && (rs = stmt.getResultSet()).next()) {
                        ret = rs.getObject(fetchColumnName);
                    }
                }
                catch (SQLException e) {
                    if (!optional) {
                        LogUtil.error((Log)logger, (String)ERR_STATEMENT_FAILED, (Object[])new Object[]{sql, e.getMessage(), file.getAbsolutePath(), line});
                        throw e;
                    }
                    LogUtil.debug((Log)logger, (String)MSG_OPTIONAL_STATEMENT_FAILED, (Object[])new Object[]{sql, e.getMessage(), file.getAbsolutePath(), line});
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                stmt.close();
            }
            catch (Throwable throwable) {}
        }
        return ret;
    }

    private void checkDialect(Dialect dialect) {
        Class<?> dialectClazz = dialect.getClass();
        LogUtil.info((Log)logger, (String)MSG_DIALECT_USED, (Object[])new Object[]{dialectClazz.getName()});
        int maxStringLength = 1024;
        int serializableType = SerializableTypeHandler.getSerializableType();
        if (dialect instanceof SQLServerDialect) {
            maxStringLength = 1024;
        } else if (dialect instanceof MySQLClusterNDBDialect) {
            maxStringLength = 400;
        } else if (dialect instanceof MySQLInnoDBDialect) {
            maxStringLength = Integer.MAX_VALUE;
        } else if (dialect instanceof Oracle9Dialect) {
            maxStringLength = 1024;
        } else if (dialect instanceof PostgreSQLDialect) {
            maxStringLength = 1024;
        }
        SchemaBootstrap.setMaxStringLength(maxStringLength, dialect);
        SerializableTypeHandler.setSerializableType(serializableType);
        if (this.maximumStringLength > 0) {
            SchemaBootstrap.setMaxStringLength(this.maximumStringLength, dialect);
        }
    }

    public synchronized void onBootstrap(ApplicationEvent event) {
        if (event != null) {
            this.rpr = (ApplicationContext)event.getSource();
        }
        Connection connection = null;
        try {
            try {
                connection = this.dataSource.getConnection();
                connection.setAutoCommit(true);
                LogUtil.info((Log)logger, (String)MSG_DATABASE_USED, (Object[])new Object[]{connection});
                this.checkDialect(this.dialect);
                if (this.updateSchema) {
                    boolean updatedSchema = false;
                    boolean createdSchema = false;
                    int i = 0;
                    while (i < this.schemaUpdateLockRetryCount) {
                        try {
                            long start = System.currentTimeMillis();
                            createdSchema = this.updateSchema(connection);
                            updatedSchema = true;
                            if (!logger.isInfoEnabled()) break;
                            logger.info((Object)(String.valueOf(createdSchema ? "Creating" : "Updating") + " the DB schema took " + (System.currentTimeMillis() - start) + " ms"));
                            break;
                        }
                        catch (LockFailedException lockFailedException) {
                            logger.info((Object)("The current Alfresco cluster node is waiting for another chance to bootstrap the DB schema. Attempt: " + (i + 1) + " of " + this.schemaUpdateLockRetryCount));
                            try {
                                ((Object)((Object)this)).wait((long)this.schemaUpdateLockRetryWaitSeconds * 1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            ++i;
                        }
                    }
                    if (!updatedSchema) {
                        throw new AlfrescoRuntimeException(ERR_UPDATE_IN_PROGRESS_ON_ANOTHER_NODE);
                    }
                    this.writeLogsWithDBStatementExecuted();
                    if (this.executedStatementsThreadLocal.get() != null) {
                        this.setBootstrapCompleted(connection);
                        this.validateSchema("Alfresco-{0}-Validation-Post-Upgrade-{1}-", null);
                        this.dumpSchema("post-upgrade");
                    }
                } else {
                    LogUtil.info((Log)logger, (String)MSG_BYPASSING_SCHEMA_UPDATE, (Object[])new Object[0]);
                }
                if (this.stopAfterSchemaBootstrap) {
                    this.dumpSchema("forced-exit");
                    LogUtil.error((Log)logger, (String)ERR_FORCED_STOP, (Object[])new Object[0]);
                    throw new BootstrapStopException();
                }
                if (event != null) {
                    ((ApplicationContext)event.getSource()).publishEvent((ApplicationEvent)new SchemaAvailableEvent((Object)this));
                }
            }
            catch (BootstrapStopException e) {
                throw e;
            }
            catch (Throwable e) {
                LogUtil.error((Log)logger, (Throwable)e, (String)ERR_UPDATE_FAILED, (Object[])new Object[0]);
                if (this.updateSchema) {
                    throw new AlfrescoRuntimeException(ERR_UPDATE_FAILED, e);
                }
                throw new AlfrescoRuntimeException(ERR_VALIDATION_FAILED, e);
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Throwable e) {
                logger.warn((Object)("Error closing DB connection: " + e.getMessage()));
            }
        }
    }

    private void writeLogsWithDBStatementExecuted() {
        File schemaOutputFile = null;
        schemaOutputFile = this.schemaOuputFilename != null ? new File(this.schemaOuputFilename) : TempFileProvider.createTempFile((String)("AlfrescoSchema-" + this.dialect.getClass().getSimpleName() + "-All_Statements-"), (String)".sql");
        StringBuilder executedStatements = this.executedStatementsThreadLocal.get();
        if (executedStatements == null) {
            LogUtil.info((Log)logger, (String)MSG_NO_CHANGES, (Object[])new Object[0]);
        } else {
            FileContentWriter writer = new FileContentWriter(schemaOutputFile);
            writer.setEncoding("UTF-8");
            String executedStatementsStr = executedStatements.toString();
            writer.putContent(executedStatementsStr);
            LogUtil.info((Log)logger, (String)MSG_ALL_STATEMENTS, (Object[])new Object[]{schemaOutputFile.getPath()});
        }
    }

    public synchronized int validateSchema(String outputFileNameTemplate, PrintWriter out) {
        int totalProblems = 0;
        for (String schemaReferenceUrl : this.schemaReferenceUrls) {
            Resource referenceResource = DialectUtil.getDialectResource(this.rpr, this.dialect.getClass(), schemaReferenceUrl);
            if (referenceResource == null || !referenceResource.exists()) {
                String resourceUrl = DialectUtil.resolveDialectUrl(this.dialect.getClass(), schemaReferenceUrl);
                LogUtil.debug((Log)logger, (String)DEBUG_SCHEMA_COMP_NO_REF_FILE, (Object[])new Object[]{resourceUrl});
                continue;
            }
            int problems = this.validateSchema(referenceResource, outputFileNameTemplate, out);
            totalProblems += problems;
        }
        return totalProblems;
    }

    private int validateSchema(Resource referenceResource, String outputFileNameTemplate, PrintWriter out) {
        try {
            return this.attemptValidateSchema(referenceResource, outputFileNameTemplate, out);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"Unable to validate database schema.", e);
            }
            return 0;
        }
    }

    private int attemptValidateSchema(Resource referenceResource, String outputFileNameTemplate, PrintWriter out) {
        Date startTime = new Date();
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(referenceResource.getInputStream());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to open schema reference file: " + referenceResource);
        }
        XMLToSchema xmlToSchema = new XMLToSchema(is);
        xmlToSchema.parse();
        Schema reference = xmlToSchema.getSchema();
        ExportDb exporter = new ExportDb(this.dataSource, this.dialect, this.descriptorService, this.databaseMetaDataHelper);
        exporter.setDbSchemaName(this.dbSchemaName);
        exporter.setNamePrefix(reference.getDbPrefix());
        exporter.execute();
        Schema target = exporter.getSchema();
        SchemaComparator schemaComparator = new SchemaComparator(reference, target, this.dialect);
        schemaComparator.validateAndCompare();
        Results results = schemaComparator.getComparisonResults();
        Object[] outputFileNameParams = new Object[]{this.dialect.getClass().getSimpleName(), reference.getDbPrefix()};
        PrintWriter pw = null;
        File outputFile = null;
        try {
            if (out == null) {
                String outputFileName = MessageFormat.format(outputFileNameTemplate, outputFileNameParams);
                outputFile = TempFileProvider.createTempFile((String)outputFileName, (String)".txt");
                try {
                    pw = new PrintWriter(outputFile, "UTF-8");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new RuntimeException("Unable to open file for writing: " + outputFile);
                }
                catch (UnsupportedEncodingException error) {
                    throw new RuntimeException("Unsupported char set: UTF-8", error);
                }
            } else {
                pw = out;
            }
            HashMap optionalPatchMessages = new HashMap();
            for (Result result : results) {
                String optionalPatchId = this.findPatchCausingDifference(result, target);
                String differenceMessage = result.describe();
                if (optionalPatchId == null) {
                    pw.print(differenceMessage);
                    pw.print("\r\n");
                    continue;
                }
                if (optionalPatchMessages.containsKey(optionalPatchId)) {
                    ((List)optionalPatchMessages.get(optionalPatchId)).add(differenceMessage);
                    continue;
                }
                ArrayList<String> newResults = new ArrayList<String>();
                newResults.add(differenceMessage);
                optionalPatchMessages.put(optionalPatchId, newResults);
            }
            for (String optionalPatchId : optionalPatchMessages.keySet()) {
                pw.print("\r\n");
                pw.print(I18NUtil.getMessage((String)MSG_OPTIONAL_PATCH_RUN_SUGGESTION, (Object[])new Object[]{optionalPatchId}));
                pw.print("\r\n");
                for (String optionalPatchMessage : (List)optionalPatchMessages.get(optionalPatchId)) {
                    pw.print(optionalPatchMessage);
                    pw.print("\r\n");
                }
            }
        }
        finally {
            if (out == null) {
                pw.close();
            }
        }
        if (results.size() == 0) {
            LogUtil.info((Log)logger, (String)INFO_SCHEMA_COMP_ALL_OK, (Object[])new Object[]{referenceResource});
        } else {
            int numProblems = results.size();
            if (outputFile == null) {
                LogUtil.warn((Log)logger, (String)WARN_SCHEMA_COMP_PROBLEMS_FOUND_NO_FILE, (Object[])new Object[]{numProblems});
            } else {
                LogUtil.warn((Log)logger, (String)WARN_SCHEMA_COMP_PROBLEMS_FOUND, (Object[])new Object[]{numProblems, outputFile});
            }
        }
        Date endTime = new Date();
        long durationMillis = endTime.getTime() - startTime.getTime();
        LogUtil.debug((Log)logger, (String)DEBUG_SCHEMA_COMP_TIME_TAKEN, (Object[])new Object[]{durationMillis});
        return results.size();
    }

    private String findPatchCausingDifference(Result result, Schema currentDb) {
        if (!currentDb.containsByName("alf_applied_patch")) {
            return null;
        }
        return this.differenceHelper.findPatchCausingDifference(result);
    }

    public List<File> dumpSchema() {
        return this.dumpSchema("", null);
    }

    public List<File> dumpSchema(String[] dbPrefixes) {
        return this.dumpSchema("", dbPrefixes);
    }

    private List<File> dumpSchema(String whenDumped, String[] dbPrefixes) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Alfresco-schema-").append(this.dialect.getClass().getSimpleName());
        if (whenDumped != null && whenDumped.length() > 0) {
            sb.append("-");
            sb.append(whenDumped);
        }
        sb.append("-{0}-");
        File outputDir = TempFileProvider.getTempDir();
        String fileNameTemplate = sb.toString();
        return this.dumpSchema(outputDir, fileNameTemplate, dbPrefixes);
    }

    private List<File> dumpSchema(String whenDumped) {
        return this.dumpSchema(whenDumped, null);
    }

    private List<File> dumpSchema(File outputDir, String fileNameTemplate, String[] dbPrefixes) {
        try {
            return this.attemptDumpSchema(outputDir, fileNameTemplate, dbPrefixes);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)("Unable to dump schema to directory " + outputDir), e);
            }
            return null;
        }
    }

    private List<File> attemptDumpSchema(File outputDir, String fileNameTemplate, String[] dbPrefixes) {
        MultiFileDumper.DbToXMLFactoryImpl dbToXMLFactory = new MultiFileDumper.DbToXMLFactoryImpl(this.getApplicationContext());
        MultiFileDumper dumper = dbPrefixes == null ? new MultiFileDumper(outputDir, fileNameTemplate, dbToXMLFactory, this.dbSchemaName) : new MultiFileDumper(dbPrefixes, outputDir, fileNameTemplate, dbToXMLFactory, this.dbSchemaName);
        List<File> files = dumper.dumpFiles();
        for (File file : files) {
            if (!logger.isInfoEnabled()) continue;
            LogUtil.info((Log)logger, (String)MSG_NORMALIZED_SCHEMA, (Object[])new Object[]{file.getAbsolutePath()});
        }
        return files;
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    private static class BootstrapStopException
    extends RuntimeException {
        private static final long serialVersionUID = 4250016675538442181L;

        private BootstrapStopException() {
            super(I18NUtil.getMessage((String)SchemaBootstrap.ERR_FORCED_STOP));
        }
    }

    private static class LockFailedException
    extends Exception {
        private static final long serialVersionUID = -6676398230191205456L;

        private LockFailedException() {
        }
    }

    private static class NoSchemaException
    extends Exception {
        private static final long serialVersionUID = 5574280159910824660L;

        private NoSchemaException() {
        }
    }

    public class UnclosableConnection
    implements Connection {
        private Connection wrapped;

        public UnclosableConnection(Connection wrappedConnection) {
            this.wrapped = wrappedConnection;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.wrapped.isWrapperFor(iface);
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.wrapped.unwrap(iface);
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.wrapped.clearWarnings();
        }

        @Override
        public void close() throws SQLException {
        }

        @Override
        public void commit() throws SQLException {
            this.wrapped.commit();
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            return this.wrapped.createArrayOf(typeName, elements);
        }

        @Override
        public Blob createBlob() throws SQLException {
            return this.wrapped.createBlob();
        }

        @Override
        public Clob createClob() throws SQLException {
            return this.wrapped.createClob();
        }

        @Override
        public NClob createNClob() throws SQLException {
            return this.wrapped.createNClob();
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            return this.wrapped.createSQLXML();
        }

        @Override
        public Statement createStatement() throws SQLException {
            return this.wrapped.createStatement();
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.wrapped.createStatement(resultSetType, resultSetConcurrency);
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.wrapped.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            return this.wrapped.createStruct(typeName, attributes);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return this.wrapped.getAutoCommit();
        }

        @Override
        public String getCatalog() throws SQLException {
            return this.wrapped.getCatalog();
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            return this.wrapped.getClientInfo();
        }

        @Override
        public String getClientInfo(String name) throws SQLException {
            return this.wrapped.getClientInfo(name);
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.wrapped.getHoldability();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return this.wrapped.getMetaData();
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this.wrapped.getTransactionIsolation();
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this.wrapped.getTypeMap();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.wrapped.getWarnings();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.wrapped.isClosed();
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.wrapped.isReadOnly();
        }

        @Override
        public boolean isValid(int timeout) throws SQLException {
            return this.wrapped.isValid(timeout);
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            return this.wrapped.nativeSQL(sql);
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            return this.wrapped.prepareCall(sql);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.wrapped.prepareCall(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.wrapped.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return this.wrapped.prepareStatement(sql);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            return this.wrapped.prepareStatement(sql, autoGeneratedKeys);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            return this.wrapped.prepareStatement(sql, columnIndexes);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            return this.wrapped.prepareStatement(sql, columnNames);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.wrapped.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.wrapped.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.wrapped.releaseSavepoint(savepoint);
        }

        @Override
        public void rollback() throws SQLException {
            this.wrapped.rollback();
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            this.wrapped.rollback(savepoint);
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.wrapped.setAutoCommit(autoCommit);
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
            this.wrapped.setCatalog(catalog);
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
            this.wrapped.setClientInfo(properties);
        }

        @Override
        public void setClientInfo(String name, String value) throws SQLClientInfoException {
            this.wrapped.setClientInfo(name, value);
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
            this.wrapped.setHoldability(holdability);
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            this.wrapped.setReadOnly(readOnly);
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return this.wrapped.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            return this.wrapped.setSavepoint(name);
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
            this.wrapped.setTransactionIsolation(level);
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this.wrapped.setTypeMap(map);
        }

        @Override
        public void setSchema(String schema) throws SQLException {
            this.wrapped.setSchema(schema);
        }

        @Override
        public String getSchema() throws SQLException {
            return this.wrapped.getSchema();
        }

        @Override
        public void abort(Executor executor) throws SQLException {
            this.wrapped.abort(executor);
        }

        @Override
        public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
            this.wrapped.setNetworkTimeout(executor, milliseconds);
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            return this.wrapped.getNetworkTimeout();
        }
    }
}

