/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.scheduled;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionModel;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.repo.action.scheduled.ScheduledPersistedActionImpl;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.scheduled.SchedulableAction;
import org.alfresco.service.cmr.action.scheduled.ScheduledPersistedAction;
import org.alfresco.service.cmr.action.scheduled.ScheduledPersistedActionService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.alfresco.util.transaction.TransactionListener;
import org.alfresco.util.transaction.TransactionListenerAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class ScheduledPersistedActionServiceImpl
implements ScheduledPersistedActionService {
    protected static final String JOB_SCHEDULE_NODEREF = "ScheduleNodeRef";
    protected static final String JOB_ACTION_NODEREF = "ActionNodeRef";
    protected NodeRef SCHEDULED_ACTION_ROOT_NODE_REF;
    protected static final Set<QName> ACTION_TYPES = new HashSet<QName>(Arrays.asList(ActionModel.TYPE_ACTION_SCHEDULE));
    protected static final String SCHEDULER_GROUP = "PersistedActions";
    private static final Log log = LogFactory.getLog(ScheduledPersistedActionServiceImpl.class);
    private BehaviourFilter behaviourFilter;
    private Scheduler scheduler;
    private NodeService nodeService;
    private NodeService startupNodeService;
    private RuntimeActionService runtimeActionService;
    private Repository repositoryHelper;

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setStartupNodeService(NodeService startupNodeService) {
        this.startupNodeService = startupNodeService;
    }

    public void setRepositoryHelper(Repository repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }

    public void setRuntimeActionService(RuntimeActionService runtimeActionService) {
        this.runtimeActionService = runtimeActionService;
    }

    protected void locatePersistanceFolder() {
        List dictionaryAssocs = this.startupNodeService.getChildAssocs(this.repositoryHelper.getCompanyHome(), (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"dictionary"));
        if (dictionaryAssocs.size() == 0) {
            throw new AlfrescoRuntimeException("Failed to find 'app:dictionary' node");
        }
        NodeRef dataDictionary = ((ChildAssociationRef)dictionaryAssocs.get(0)).getChildRef();
        List scheduledAssocs = this.startupNodeService.getChildAssocs(dataDictionary, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Scheduled Actions"));
        if (scheduledAssocs.size() == 0) {
            throw new AlfrescoRuntimeException("Failed to find 'cm:Scheduled Actions' location.");
        }
        this.SCHEDULED_ACTION_ROOT_NODE_REF = ((ChildAssociationRef)scheduledAssocs.get(0)).getChildRef();
    }

    public void schedulePreviouslyPersisted() {
        List<ScheduledPersistedAction> actions = this.listSchedules(this.startupNodeService);
        for (ScheduledPersistedAction action : actions) {
            if (action.getActionNodeRef() == null) continue;
            this.addToScheduler((ScheduledPersistedActionImpl)action);
        }
    }

    @Override
    public ScheduledPersistedAction createSchedule(Action persistedAction) {
        return new ScheduledPersistedActionImpl(persistedAction);
    }

    @Override
    public void saveSchedule(ScheduledPersistedAction schedule) {
        ScheduledPersistedActionImpl scheduleImpl = (ScheduledPersistedActionImpl)schedule;
        this.removeFromScheduler(scheduleImpl);
        if (scheduleImpl.getPersistedAtNodeRef() == null) {
            this.createPersistentSchedule(scheduleImpl);
        }
        this.updatePersistentSchedule(scheduleImpl);
        this.addToScheduler(scheduleImpl);
    }

    private void createPersistentSchedule(ScheduledPersistedActionImpl schedule) {
        ChildAssociationRef childAssoc = this.nodeService.createNode(this.SCHEDULED_ACTION_ROOT_NODE_REF, ContentModel.ASSOC_CONTAINS, QName.createQName((String)GUID.generate()), ActionModel.TYPE_ACTION_SCHEDULE);
        schedule.setPersistedAtNodeRef(childAssoc.getChildRef());
    }

    private void updatePersistentSchedule(ScheduledPersistedActionImpl schedule) {
        NodeRef nodeRef = schedule.getPersistedAtNodeRef();
        if (nodeRef == null) {
            throw new IllegalStateException("Must be persisted first");
        }
        this.nodeService.setProperty(nodeRef, ActionModel.PROP_START_DATE, (Serializable)schedule.getScheduleStart());
        this.nodeService.setProperty(nodeRef, ActionModel.PROP_INTERVAL_COUNT, (Serializable)schedule.getScheduleIntervalCount());
        SchedulableAction.IntervalPeriod period = schedule.getScheduleIntervalPeriod();
        this.nodeService.setProperty(nodeRef, ActionModel.PROP_INTERVAL_PERIOD, (Serializable)((Object)(period == null ? null : period.name())));
        AssociationRef actionAssoc = this.findActionAssociationFromSchedule(nodeRef);
        NodeRef actionNodeRef = schedule.getActionNodeRef();
        try {
            this.behaviourFilter.disableBehaviour(ActionModel.TYPE_ACTION_SCHEDULE);
            if (actionNodeRef == null) {
                if (actionAssoc != null) {
                    this.nodeService.removeAssociation(actionAssoc.getSourceRef(), actionAssoc.getTargetRef(), actionAssoc.getTypeQName());
                }
            } else if (actionAssoc == null) {
                this.nodeService.createAssociation(nodeRef, actionNodeRef, ActionModel.ASSOC_SCHEDULED_ACTION);
            } else if (!actionAssoc.getTargetRef().equals((Object)actionNodeRef)) {
                this.nodeService.removeAssociation(actionAssoc.getSourceRef(), actionAssoc.getTargetRef(), actionAssoc.getTypeQName());
                this.nodeService.createAssociation(nodeRef, actionNodeRef, ActionModel.ASSOC_SCHEDULED_ACTION);
            }
        }
        finally {
            this.behaviourFilter.enableBehaviour(ActionModel.TYPE_ACTION_SCHEDULE);
        }
    }

    @Override
    public void deleteSchedule(ScheduledPersistedAction schedule) {
        ScheduledPersistedActionImpl scheduleImpl = (ScheduledPersistedActionImpl)schedule;
        this.removeFromScheduler(scheduleImpl);
        this.deletePersistentSchedule(scheduleImpl);
    }

    private void deletePersistentSchedule(ScheduledPersistedActionImpl schedule) {
        NodeRef nodeRef = schedule.getPersistedAtNodeRef();
        if (nodeRef == null) {
            return;
        }
        this.nodeService.deleteNode(nodeRef);
        schedule.setPersistedAtNodeRef(null);
    }

    @Override
    public ScheduledPersistedAction getSchedule(Action persistedAction) {
        NodeRef nodeRef = persistedAction.getNodeRef();
        return this.getSchedule(nodeRef);
    }

    @Override
    public ScheduledPersistedAction getSchedule(NodeRef persistedActionNodeRef) {
        if (persistedActionNodeRef == null) {
            return null;
        }
        List assocs = this.nodeService.getSourceAssocs(persistedActionNodeRef, (QNamePattern)ActionModel.ASSOC_SCHEDULED_ACTION);
        AssociationRef scheduledAssoc = null;
        Iterator iterator = assocs.iterator();
        while (iterator.hasNext()) {
            AssociationRef assoc;
            scheduledAssoc = assoc = (AssociationRef)iterator.next();
        }
        if (scheduledAssoc == null) {
            return null;
        }
        return this.loadPersistentSchedule(scheduledAssoc.getSourceRef());
    }

    @Override
    public List<ScheduledPersistedAction> listSchedules() {
        return this.listSchedules(this.nodeService);
    }

    private List<ScheduledPersistedAction> listSchedules(NodeService nodeService) {
        List childAssocs = nodeService.getChildAssocs(this.SCHEDULED_ACTION_ROOT_NODE_REF, ACTION_TYPES);
        ArrayList<ScheduledPersistedAction> scheduledActions = new ArrayList<ScheduledPersistedAction>(childAssocs.size());
        for (ChildAssociationRef actionAssoc : childAssocs) {
            ScheduledPersistedActionImpl scheduleImpl = this.loadPersistentSchedule(actionAssoc.getChildRef());
            scheduledActions.add(scheduleImpl);
        }
        return scheduledActions;
    }

    protected ScheduledPersistedActionImpl loadPersistentSchedule(NodeRef schedule) {
        if (!this.nodeService.exists(schedule)) {
            return null;
        }
        Action action = null;
        AssociationRef actionAssoc = this.findActionAssociationFromSchedule(schedule);
        if (actionAssoc != null) {
            action = this.runtimeActionService.createAction(actionAssoc.getTargetRef());
        }
        ScheduledPersistedActionImpl scheduleImpl = new ScheduledPersistedActionImpl(action);
        scheduleImpl.setPersistedAtNodeRef(schedule);
        scheduleImpl.setScheduleLastExecutedAt((Date)this.nodeService.getProperty(schedule, ActionModel.PROP_LAST_EXECUTED_AT));
        scheduleImpl.setScheduleStart((Date)this.nodeService.getProperty(schedule, ActionModel.PROP_START_DATE));
        scheduleImpl.setScheduleIntervalCount((Integer)this.nodeService.getProperty(schedule, ActionModel.PROP_INTERVAL_COUNT));
        String period = (String)((Object)this.nodeService.getProperty(schedule, ActionModel.PROP_INTERVAL_PERIOD));
        if (period != null) {
            scheduleImpl.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.valueOf(period));
        }
        return scheduleImpl;
    }

    private AssociationRef findActionAssociationFromSchedule(NodeRef schedule) {
        List assocs = this.nodeService.getTargetAssocs(schedule, (QNamePattern)ActionModel.ASSOC_SCHEDULED_ACTION);
        AssociationRef actionAssoc = null;
        Iterator iterator = assocs.iterator();
        while (iterator.hasNext()) {
            AssociationRef assoc;
            actionAssoc = assoc = (AssociationRef)iterator.next();
        }
        return actionAssoc;
    }

    protected void removeFromScheduler(ScheduledPersistedActionImpl schedule) {
        if (schedule.getPersistedAtNodeRef() == null) {
            return;
        }
        try {
            this.scheduler.deleteJob(new JobKey(schedule.getPersistedAtNodeRef().toString(), SCHEDULER_GROUP));
        }
        catch (SchedulerException e) {
            log.warn((Object)e);
        }
    }

    protected void addToScheduler(ScheduledPersistedActionImpl schedule) {
        final JobDetail details = this.buildJobDetail(schedule);
        final Trigger trigger = schedule.asTrigger();
        AlfrescoTransactionSupport.bindListener((TransactionListener)new TransactionListenerAdapter(){

            public void afterCommit() {
                try {
                    ScheduledPersistedActionServiceImpl.this.scheduler.scheduleJob(details, trigger);
                }
                catch (SchedulerException e) {
                    log.warn((Object)e);
                }
            }
        });
    }

    protected JobDetail buildJobDetail(ScheduledPersistedActionImpl schedule) {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(JOB_ACTION_NODEREF, schedule.getActionNodeRef().toString());
        jobDataMap.put(JOB_SCHEDULE_NODEREF, schedule.getPersistedAtNodeRef().toString());
        return JobBuilder.newJob().withIdentity(schedule.getPersistedAtNodeRef().toString(), SCHEDULER_GROUP).ofType(ScheduledJobWrapper.class).setJobData(jobDataMap).build();
    }

    public static class ScheduledJobWrapper
    implements Job,
    ApplicationContextAware {
        private ActionService actionService;
        private NodeService nodeService;
        private TransactionService transactionService;
        private RuntimeActionService runtimeActionService;

        public void setApplicationContext(ApplicationContext applicationContext) {
            this.nodeService = (NodeService)applicationContext.getBean("NodeService");
            this.actionService = (ActionService)applicationContext.getBean("ActionService");
            this.transactionService = (TransactionService)applicationContext.getBean("transactionService");
            this.runtimeActionService = (RuntimeActionService)applicationContext.getBean("actionService");
        }

        public void execute(final JobExecutionContext jobContext) {
            AuthenticationUtil.setRunAsUserSystem();
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    NodeRef scheduleNodeRef = new NodeRef(jobContext.getMergedJobDataMap().getString(ScheduledPersistedActionServiceImpl.JOB_SCHEDULE_NODEREF));
                    nodeService.setProperty(scheduleNodeRef, ActionModel.PROP_LAST_EXECUTED_AT, (Serializable)new Date());
                    NodeRef actionNodeRef = new NodeRef(jobContext.getMergedJobDataMap().getString(ScheduledPersistedActionServiceImpl.JOB_ACTION_NODEREF));
                    Action action = runtimeActionService.createAction(actionNodeRef);
                    actionService.executeAction(action, null, false, true);
                    return null;
                }
            }, false, true);
        }
    }

    public static class ScheduledPersistedActionServiceBootstrap
    extends AbstractLifecycleBean {
        private ScheduledPersistedActionServiceImpl service;
        private RetryingTransactionHelper txnHelper;

        public void setScheduledPersistedActionService(ScheduledPersistedActionServiceImpl scheduledPersistedActionService) {
            this.service = scheduledPersistedActionService;
        }

        public void setTransactionHelper(RetryingTransactionHelper txnHelper) {
            this.txnHelper = txnHelper;
        }

        public void onBootstrap(ApplicationEvent event) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() {
                    RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                        @Override
                        public Object execute() throws Throwable {
                            service.locatePersistanceFolder();
                            service.schedulePreviouslyPersisted();
                            return null;
                        }
                    };
                    return txnHelper.doInTransaction(callback);
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }

        public void onShutdown(ApplicationEvent event) {
        }
    }
}

