/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.scheduled;

import java.util.Date;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.scheduled.SchedulableAction;
import org.alfresco.service.cmr.action.scheduled.ScheduledPersistedAction;
import org.alfresco.service.cmr.repository.NodeRef;
import org.quartz.CalendarIntervalScheduleBuilder;
import org.quartz.DateBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class ScheduledPersistedActionImpl
implements ScheduledPersistedAction {
    private NodeRef persistedAtNodeRef;
    private Action action;
    private Date lastExecutedAt;
    private Date scheduleStart;
    private Date scheduleEnd;
    private Integer intervalCount;
    private SchedulableAction.IntervalPeriod intervalPeriod;

    protected ScheduledPersistedActionImpl(Action action) {
        this.action = action;
    }

    protected NodeRef getPersistedAtNodeRef() {
        return this.persistedAtNodeRef;
    }

    protected void setPersistedAtNodeRef(NodeRef nodeRef) {
        this.persistedAtNodeRef = nodeRef;
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public NodeRef getActionNodeRef() {
        return this.action == null ? null : this.action.getNodeRef();
    }

    @Override
    public Date getScheduleLastExecutedAt() {
        return this.lastExecutedAt;
    }

    public void setScheduleLastExecutedAt(Date executedAt) {
        this.lastExecutedAt = executedAt;
    }

    @Override
    public Date getScheduleStart() {
        return this.scheduleStart;
    }

    @Override
    public void setScheduleStart(Date startDate) {
        this.scheduleStart = startDate;
    }

    protected Date getScheduleEnd() {
        return this.scheduleEnd;
    }

    protected void setScheduleEnd(Date endDate) {
        this.scheduleEnd = endDate;
    }

    @Override
    public Integer getScheduleIntervalCount() {
        return this.intervalCount;
    }

    @Override
    public void setScheduleIntervalCount(Integer count) {
        this.intervalCount = count;
    }

    @Override
    public SchedulableAction.IntervalPeriod getScheduleIntervalPeriod() {
        return this.intervalPeriod;
    }

    @Override
    public void setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod period) {
        this.intervalPeriod = period;
    }

    @Override
    public String getScheduleInterval() {
        if (this.intervalCount == null || this.intervalPeriod == null) {
            return null;
        }
        return String.valueOf(this.intervalCount.toString()) + this.intervalPeriod.name();
    }

    public Trigger asTrigger() {
        if (this.persistedAtNodeRef == null) {
            throw new IllegalStateException("Must be persisted first");
        }
        String triggerName = this.persistedAtNodeRef.toString();
        if (this.getScheduleInterval() == null && this.scheduleStart == null) {
            return null;
        }
        if (this.scheduleEnd != null && this.scheduleEnd.getTime() < System.currentTimeMillis()) {
            return null;
        }
        Date startAt = this.scheduleStart;
        Date endAt = this.scheduleEnd;
        if (startAt == null) {
            startAt = new Date();
        } else if (startAt.getTime() < System.currentTimeMillis()) {
            if (this.lastExecutedAt == null) {
                startAt = this.scheduleStart;
            } else if (this.lastExecutedAt.getTime() < startAt.getTime()) {
                startAt = this.scheduleStart;
            } else {
                if (this.getScheduleInterval() == null) {
                    return null;
                }
                Trigger testT = TriggerBuilder.newTrigger().withIdentity("TEST").withSchedule((ScheduleBuilder)CalendarIntervalScheduleBuilder.calendarIntervalSchedule().withInterval(this.intervalCount.intValue(), DateBuilder.IntervalUnit.valueOf((String)this.intervalPeriod.toString().toUpperCase()))).startAt(this.scheduleStart).build();
                Date nextFireFromNow = testT.getFireTimeAfter(new Date());
                Date nextFireFromLast = testT.getFireTimeAfter(this.lastExecutedAt);
                startAt = nextFireFromLast.getTime() < nextFireFromNow.getTime() ? this.scheduleStart : nextFireFromNow;
            }
        }
        Trigger trigger = this.getScheduleInterval() == null ? TriggerBuilder.newTrigger().withIdentity(triggerName).startAt(startAt).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withMisfireHandlingInstructionFireNow()).build() : TriggerBuilder.newTrigger().withIdentity(triggerName).startAt(startAt).endAt(endAt).withSchedule((ScheduleBuilder)CalendarIntervalScheduleBuilder.calendarIntervalSchedule().withMisfireHandlingInstructionFireAndProceed().withInterval(this.intervalCount.intValue(), DateBuilder.IntervalUnit.valueOf((String)this.intervalPeriod.toString().toUpperCase()))).build();
        return trigger;
    }
}

