/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.time.Duration;
import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;

public class TestHelper {
    private static final Log logger = LogFactory.getLog(TestHelper.class);

    public static void assertThrows(Runnable action, Class<?> expectedException, String failMessage) {
        try {
            action.run();
        }
        catch (Throwable ex) {
            Assert.assertTrue((String)("The caught exception [" + ex.getClass().getSimpleName() + "] is not the expected exception:" + expectedException.getSimpleName()), (boolean)expectedException.isInstance(ex));
            return;
        }
        Assert.fail((String)(String.valueOf(failMessage) + " So failed to throw expected exception: " + expectedException.getSimpleName()));
    }

    public static <T> T waitBeforeRetry(Supplier<T> supplier, T requiredResult, int maxRetry, long waitTimeInMillis) throws InterruptedException {
        T t;
        int retryCount = 0;
        do {
            Thread.sleep(waitTimeInMillis);
            t = supplier.get();
            if (!requiredResult.equals(t)) continue;
            return t;
        } while (++retryCount < maxRetry);
        return t;
    }

    @SafeVarargs
    public static void waitForMethodToFinish(Duration timeout, Runnable method, Class<? extends Throwable> ... expectedExceptions) {
        logger.debug((Object)"Waiting for method to succeed.");
        long delayMillis = timeout.toMillis() > 10L ? timeout.toMillis() / 10L : 1L;
        int step = 0;
        while ((long)step <= 10L) {
            try {
                method.run();
                logger.debug((Object)"Method succeeded.");
                return;
            }
            catch (Throwable e) {
                if (Arrays.stream(expectedExceptions).noneMatch(expEx -> expEx.isInstance(e))) {
                    throw e;
                }
                if ((long)step == 10L) {
                    logger.debug((Object)"Method failed - no more waiting.");
                    throw e;
                }
                logger.debug((Object)"Method failed. Waiting until it succeeds.", e);
                try {
                    Thread.sleep(delayMillis);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    Assert.fail((String)"Thread has been interrupted.");
                }
                ++step;
            }
        }
        throw new IllegalStateException("Unexpected.");
    }
}

