/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class, NeverRunsTests.class})
public class VersionableAspectTest
extends TestCase {
    public static final String AUTO_VERSION_KEY = "version.store.enableAutoVersioning";
    public static final String AUTO_VERSION_PROPS_KEY = "version.store.enableAutoVersionOnUpdateProps";
    private static final String NAME_AND_EXT_DELIMETER = ".";
    private static final String NAME_AND_EXT_DELIMETER_REGEXP = "\\.";
    private static final String ADMIN_CREDENTIAL = "admin";
    private static final String ROOT_NODE_TERM = "PATH:\"/app\\:company_home\"";
    private static final String DOCUMENT_NAME = "ChildDocumentWithVersionLabel-.txt";
    private static final String PARENT_FOLDER_NAME = "ParentFolder-" + System.currentTimeMillis();
    private static final String TEST_CONTENT_01 = "Test Content version 0.1\n";
    private static final String TEST_CONTENT_10 = "Test Content version 1.0\n";
    private ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext();
    private NodeService nodeService = (NodeService)this.applicationContext.getBean("nodeService");
    private LockService lockService = (LockService)this.applicationContext.getBean("lockService");
    private SearchService searchService = (SearchService)this.applicationContext.getBean("searchService");
    private ContentService contentService = (ContentService)this.applicationContext.getBean("contentService");
    private TransactionService transactionService = (TransactionService)this.applicationContext.getBean("transactionService");
    private CheckOutCheckInService checkOutCheckInService = (CheckOutCheckInService)this.applicationContext.getBean("checkOutCheckInService");
    private AuthenticationService authenticationService = (AuthenticationService)this.applicationContext.getBean("authenticationService");
    private Properties globalProperties = (Properties)this.applicationContext.getBean("global-properties");
    private NodeRef document;
    private NodeRef parentFolder;

    protected void setUp() throws Exception {
        this.globalProperties.setProperty(AUTO_VERSION_PROPS_KEY, "true");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                VersionableAspectTest.this.authenticationService.authenticate(VersionableAspectTest.ADMIN_CREDENTIAL, VersionableAspectTest.ADMIN_CREDENTIAL.toCharArray());
                NodeRef rootNode = null;
                try (ResultSet query = null;){
                    query = VersionableAspectTest.this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "lucene", VersionableAspectTest.ROOT_NODE_TERM);
                    rootNode = query.getNodeRef(0);
                }
                HashMap<QName, String> properties = new HashMap<QName, String>();
                properties.put(ContentModel.PROP_NAME, PARENT_FOLDER_NAME);
                VersionableAspectTest.this.parentFolder = VersionableAspectTest.this.nodeService.createNode(rootNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/user/1.0", (String)PARENT_FOLDER_NAME), ContentModel.TYPE_FOLDER, properties).getChildRef();
                properties.clear();
                properties.put(ContentModel.PROP_NAME, VersionableAspectTest.DOCUMENT_NAME);
                VersionableAspectTest.this.document = VersionableAspectTest.this.nodeService.createNode(VersionableAspectTest.this.parentFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/user/1.0", (String)VersionableAspectTest.DOCUMENT_NAME), ContentModel.TYPE_CONTENT, properties).getChildRef();
                VersionableAspectTest.this.contentService.getWriter(VersionableAspectTest.this.document, ContentModel.PROP_CONTENT, true).putContent(VersionableAspectTest.TEST_CONTENT_01);
                if (!VersionableAspectTest.this.nodeService.hasAspect(VersionableAspectTest.this.document, ContentModel.ASPECT_VERSIONABLE)) {
                    HashMap<QName, Object> versionProperties = new HashMap<QName, Object>();
                    versionProperties.put(ContentModel.PROP_VERSION_LABEL, "0.1");
                    versionProperties.put(ContentModel.PROP_INITIAL_VERSION, true);
                    versionProperties.put(ContentModel.PROP_VERSION_TYPE, VersionType.MINOR);
                    VersionableAspectTest.this.nodeService.addAspect(VersionableAspectTest.this.document, ContentModel.ASPECT_VERSIONABLE, versionProperties);
                }
                return null;
            }
        });
    }

    protected void tearDown() throws Exception {
        this.globalProperties.setProperty(AUTO_VERSION_PROPS_KEY, "false");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (VersionableAspectTest.this.parentFolder != null) {
                    VersionableAspectTest.this.nodeService.deleteNode(VersionableAspectTest.this.parentFolder);
                }
                VersionableAspectTest.this.authenticationService.clearCurrentSecurityContext();
                return null;
            }
        });
    }

    public void testAutoVersionIncrementOnPropertiesUpdateAfterCheckInAlf14584() throws Exception {
        final String name02 = this.generateDocumentName(DOCUMENT_NAME, "0.2");
        final String name11 = this.generateDocumentName(DOCUMENT_NAME, "1.1");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Map properties = VersionableAspectTest.this.getAndAssertProperties(VersionableAspectTest.this.document, "0.1");
                Serializable autoVersionProps = (Serializable)properties.get(ContentModel.PROP_AUTO_VERSION_PROPS);
                VersionableAspectTest.assertNotNull((String)("Autoversion property is NULL! NodeRef = '" + VersionableAspectTest.this.document.toString() + "'"), (Object)autoVersionProps);
                VersionableAspectTest.assertTrue((String)("Autoversion must be TRUE! NodeRef = '" + VersionableAspectTest.this.document.toString() + "'"), (boolean)((Boolean)autoVersionProps));
                VersionableAspectTest.this.nodeService.setProperty(VersionableAspectTest.this.document, ContentModel.PROP_NAME, (Serializable)((Object)name02));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Map properties = VersionableAspectTest.this.getAndAssertProperties(VersionableAspectTest.this.document, "0.2");
                VersionableAspectTest.assertEquals((Object)name02, properties.get(ContentModel.PROP_NAME));
                NodeRef workingCopy = VersionableAspectTest.this.checkOutCheckInService.checkout(VersionableAspectTest.this.document);
                VersionableAspectTest.this.contentService.getWriter(workingCopy, ContentModel.PROP_CONTENT, true).putContent(VersionableAspectTest.TEST_CONTENT_10);
                HashMap<String, VersionType> versionProperties = new HashMap<String, VersionType>();
                versionProperties.put("versionType", VersionType.MAJOR);
                VersionableAspectTest.this.document = VersionableAspectTest.this.checkOutCheckInService.checkin(workingCopy, versionProperties);
                return null;
            }
        });
        this.assertDocumentVersionAndName("1.0", name02, VersionType.MAJOR);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                VersionableAspectTest.this.nodeService.setProperty(VersionableAspectTest.this.document, ContentModel.PROP_NAME, (Serializable)((Object)name11));
                return null;
            }
        });
        this.assertDocumentVersionAndName("1.1", name11, VersionType.MINOR);
    }

    public void testAutoVersionIncrementOnPropertiesUpdateByLockOwnerAlf14584() throws Exception {
        final String name = this.generateDocumentName(DOCUMENT_NAME, "0.2");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Map properties = VersionableAspectTest.this.getAndAssertProperties(VersionableAspectTest.this.document, "0.1");
                Serializable autoVersionProps = (Serializable)properties.get(ContentModel.PROP_AUTO_VERSION_PROPS);
                VersionableAspectTest.assertNotNull((String)("Autoversion property is NULL! NodeRef = '" + VersionableAspectTest.this.document.toString() + "'"), (Object)autoVersionProps);
                VersionableAspectTest.assertTrue((String)("Autoversion must be TRUE! NodeRef = '" + VersionableAspectTest.this.document.toString() + "'"), (boolean)((Boolean)autoVersionProps));
                VersionableAspectTest.this.lockService.lock(VersionableAspectTest.this.document, LockType.WRITE_LOCK);
                VersionableAspectTest.this.lockService.getLockStatus(VersionableAspectTest.this.document);
                VersionableAspectTest.assertTrue((String)("Node with NodeRef = '" + VersionableAspectTest.this.document.toString() + "' should be locked for " + AuthenticationUtil.getFullyAuthenticatedUser() + " user! The user is lock owner"), (boolean)VersionableAspectTest.this.lockService.isLocked(VersionableAspectTest.this.document));
                VersionableAspectTest.assertEquals((Object)LockStatus.LOCK_OWNER, (Object)VersionableAspectTest.this.lockService.getLockStatus(VersionableAspectTest.this.document));
                VersionableAspectTest.this.nodeService.setProperty(VersionableAspectTest.this.document, ContentModel.PROP_NAME, (Serializable)((Object)name));
                return null;
            }
        });
        this.assertDocumentVersionAndName("0.2", name);
    }

    private void assertDocumentVersionAndName(String versionLabel, String name) {
        this.assertDocumentVersionAndName(versionLabel, name, null);
    }

    private void assertDocumentVersionAndName(final String versionLabel, final String name, final VersionType versionType) {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Map properties = VersionableAspectTest.this.getAndAssertProperties(VersionableAspectTest.this.document, versionLabel);
                VersionableAspectTest.assertEquals((Object)name, properties.get(ContentModel.PROP_NAME));
                if (versionType != null) {
                    Serializable versionTypeProperty = VersionableAspectTest.this.nodeService.getProperty(VersionableAspectTest.this.document, ContentModel.PROP_VERSION_TYPE);
                    VersionableAspectTest.assertNotNull((Object)versionTypeProperty);
                    VersionableAspectTest.assertTrue((boolean)versionTypeProperty.toString().equals(versionType.toString()));
                }
                return null;
            }
        }, true);
    }

    private Map<QName, Serializable> getAndAssertProperties(NodeRef nodeRef, String versionLabel) {
        VersionableAspectTest.assertNotNull((String)"NodeRef of document is NULL!", (Object)nodeRef);
        Map properties = this.nodeService.getProperties(nodeRef);
        VersionableAspectTest.assertNotNull((String)("Properties must not be NULL! NodeRef = '" + nodeRef.toString() + "'"), (Object)properties);
        VersionableAspectTest.assertFalse((String)("Version specific properties can't be found! NodeRef = '" + nodeRef.toString() + "'"), (boolean)properties.isEmpty());
        VersionableAspectTest.assertEquals((Object)versionLabel, properties.get(ContentModel.PROP_VERSION_LABEL));
        return properties;
    }

    private String generateDocumentName(String namePattern, String versionLabel) {
        int i = 0;
        String[] nameAndExt = namePattern.split(NAME_AND_EXT_DELIMETER_REGEXP);
        StringBuilder result = new StringBuilder(nameAndExt[i++]).append(versionLabel).append(NAME_AND_EXT_DELIMETER).append(nameAndExt[i++]);
        return result.toString();
    }
}

