/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import org.alfresco.repo.content.AbstractContentStore;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.ContentStoreCaps;
import org.alfresco.repo.tenant.MultiTAdminServiceImpl;
import org.alfresco.repo.tenant.TenantDeployer;
import org.alfresco.repo.tenant.TenantRoutingContentStore;
import org.alfresco.service.cmr.repository.ContentReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiTAdminServiceImplTest {
    private MultiTAdminServiceImpl tenantAdmin;

    @Before
    public void setUp() throws Exception {
        this.tenantAdmin = new MultiTAdminServiceImpl();
    }

    @Test
    public void testTenantDeployer() {
        ConcreteTenantDeployer contentStore = new ConcreteTenantDeployer();
        TenantDeployer tenantDeployer = this.tenantAdmin.tenantDeployer((ContentStore)contentStore);
        Assert.assertNotNull((Object)tenantDeployer);
    }

    @Test
    public void testTenantDeployerRetrievedByContentStoreCaps() {
        FakeSubsystemProxy contentStore = new FakeSubsystemProxy(false);
        TenantDeployer tenantDeployer = this.tenantAdmin.tenantDeployer((ContentStore)contentStore);
        Assert.assertNotNull((Object)tenantDeployer);
    }

    @Test
    public void testTenantDeployerMayBeNullWhenInterfaceNotImplemented() {
        BaseStore contentStore = new BaseStore(null, null);
        TenantDeployer tenantDeployer = this.tenantAdmin.tenantDeployer((ContentStore)contentStore);
        Assert.assertNull((Object)tenantDeployer);
    }

    @Test
    public void testTenantDeployerMayBeNullWhenProxyingAndInterfaceNotImplemented() {
        FakeSubsystemProxy contentStore = new FakeSubsystemProxy(true);
        TenantDeployer tenantDeployer = this.tenantAdmin.tenantDeployer((ContentStore)contentStore);
        Assert.assertNull((Object)tenantDeployer);
    }

    @Test
    public void testTenantRoutingContentStore() {
        ConcreteTenantRoutingContentStore contentStore = new ConcreteTenantRoutingContentStore();
        TenantRoutingContentStore router = this.tenantAdmin.tenantRoutingContentStore((ContentStore)contentStore);
        Assert.assertNotNull((Object)router);
    }

    @Test
    public void testTenantRoutingContentStoreRetrievedByContentStoreCaps() {
        FakeSubsystemProxy contentStore = new FakeSubsystemProxy(false);
        TenantRoutingContentStore router = this.tenantAdmin.tenantRoutingContentStore((ContentStore)contentStore);
        Assert.assertNotNull((Object)router);
    }

    @Test
    public void testTenantRoutingContentStoreMayBeNullWhenInterfaceNotImplemented() {
        BaseStore contentStore = new BaseStore(null, null);
        TenantRoutingContentStore router = this.tenantAdmin.tenantRoutingContentStore((ContentStore)contentStore);
        Assert.assertNull((Object)router);
    }

    @Test
    public void testTenantRoutingContentStoreMayBeNullWhenProxyingAndInterfaceNotImplemented() {
        FakeSubsystemProxy contentStore = new FakeSubsystemProxy(true);
        TenantRoutingContentStore router = this.tenantAdmin.tenantRoutingContentStore((ContentStore)contentStore);
        Assert.assertNull((Object)router);
    }

    private static class BaseStore
    extends AbstractContentStore {
        private BaseStore() {
        }

        public boolean isWriteSupported() {
            return false;
        }

        public ContentReader getReader(String contentUrl) {
            return null;
        }

        /* synthetic */ BaseStore(BaseStore baseStore, BaseStore baseStore2) {
            this();
        }
    }

    private static class ConcreteTenantDeployer
    extends BaseStore
    implements TenantDeployer {
        private ConcreteTenantDeployer() {
        }

        public void onEnableTenant() {
        }

        public void onDisableTenant() {
        }

        public void init() {
        }

        public void destroy() {
        }
    }

    private static class ConcreteTenantRoutingContentStore
    extends BaseStore
    implements TenantRoutingContentStore {
        private ConcreteTenantRoutingContentStore() {
        }

        public void onEnableTenant() {
        }

        public void onDisableTenant() {
        }

        public void init() {
        }

        public void destroy() {
        }
    }

    private static class FakeSubsystemProxy
    extends BaseStore
    implements ContentStoreCaps {
        private boolean returnNull;

        FakeSubsystemProxy(boolean returnNull) {
            this.returnNull = returnNull;
        }

        public TenantDeployer getTenantRoutingContentStore() {
            return this.returnNull ? null : new ConcreteTenantRoutingContentStore();
        }

        public TenantDeployer getTenantDeployer() {
            return this.returnNull ? null : new ConcreteTenantDeployer();
        }
    }
}

