/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQueryFactory;
import org.alfresco.query.CannedQueryResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.person.GetPeopleCannedQuery;
import org.alfresco.repo.security.person.GetPeopleCannedQueryFactory;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.Pair;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.alfresco.util.testing.category.DBTests;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Category(value={DBTests.class})
public class GetPeopleCannedQueryTest
extends BaseSpringTest {
    @Autowired
    @Qualifier(value="personServiceCannedQueryRegistry")
    private NamedObjectRegistry<CannedQueryFactory<NodeRef>> cannedQueryRegistry;
    @Autowired
    @Qualifier(value="PersonService")
    private PersonService personService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private NodeService nodeService;

    private Map<QName, Serializable> createDefaultProperties(String userName, String firstName, String lastName, String email, String orgId) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        properties.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)firstName));
        properties.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)lastName));
        properties.put(ContentModel.PROP_EMAIL, (Serializable)((Object)email));
        properties.put(ContentModel.PROP_ORGID, (Serializable)((Object)orgId));
        return properties;
    }

    @Before
    public void before() {
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            for (NodeRef nodeRef : this.personService.getAllPeople()) {
                String uid = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
                if (uid.equals(AuthenticationUtil.getAdminUserName()) || uid.equals(AuthenticationUtil.getGuestUserName())) continue;
                this.personService.deletePerson(nodeRef);
            }
            return null;
        });
    }

    @After
    public void after() {
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    private CannedQueryResults<NodeRef> executeGetPeopleQuery(PagingRequest pagingRequest, String pattern, List<QName> filterProps, boolean includeAdministrators, List<Pair<QName, Boolean>> sortProps) {
        GetPeopleCannedQueryFactory getPeopleCannedQueryFactory = (GetPeopleCannedQueryFactory)this.cannedQueryRegistry.getNamedObject("getPeopleCannedQueryFactory");
        GetPeopleCannedQuery cq = (GetPeopleCannedQuery)getPeopleCannedQueryFactory.getCannedQuery(this.personService.getPeopleContainer(), pattern, filterProps, null, null, includeAdministrators, sortProps, pagingRequest);
        return (CannedQueryResults)this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> ((GetPeopleCannedQuery)cq).execute(), true);
    }

    @Test
    public void testPeopleFiltering() {
        int startPeopleNumber = this.personService.countPeople();
        NodeRef person1 = this.personService.createPerson(this.createDefaultProperties("aa", "Aa", "Aa", "aa@aa", "alfresco1"));
        this.personService.createPerson(this.createDefaultProperties("bc", "c", "C", "bc@bc", "alfresco2"));
        this.personService.createPerson(this.createDefaultProperties("yy", "B", "D", "yy@yy", "alfresco3"));
        this.personService.createPerson(this.createDefaultProperties("Yz", "yz", "B", "yz@yz", "alfresco4"));
        this.personService.createPerson(this.createDefaultProperties("xx-middle-xx", "Middle", "Middle", "aa@aa", "alfresco5"));
        this.personService.createPerson(this.createDefaultProperties("xx-xx-end", "End", "End", "aa@aa", "alfresco6"));
        int newPeopleNumber = startPeopleNumber + 6;
        GetPeopleCannedQueryTest.assertEquals((String)("There should be " + newPeopleNumber + " more people created"), (int)newPeopleNumber, (int)this.personService.countPeople());
        PagingRequest pagingRequest = new PagingRequest(0, 100, null);
        pagingRequest.setRequestTotalCountMax(0);
        CannedQueryResults<NodeRef> people = this.executeGetPeopleQuery(pagingRequest, null, null, false, null);
        GetPeopleCannedQueryTest.assertEquals((String)"Administrators not filtered", (int)(newPeopleNumber - 1), (int)people.getPagedResultCount());
        ArrayList<QName> filters = new ArrayList<QName>(4);
        filters.clear();
        filters.add(ContentModel.PROP_USERNAME);
        GetPeopleCannedQueryTest.assertEquals((String)"Pattern filtering is not correct", (int)2, (int)this.executeGetPeopleQuery(pagingRequest, "y", filters, true, null).getPagedResultCount());
        filters.clear();
        filters.add(ContentModel.PROP_USERNAME);
        filters.add(ContentModel.PROP_FIRSTNAME);
        filters.add(ContentModel.PROP_LASTNAME);
        GetPeopleCannedQueryTest.assertEquals((String)"Pattern filtering is not correct", (int)3, (int)this.executeGetPeopleQuery(pagingRequest, "b", filters, true, null).getPagedResultCount());
        filters.clear();
        filters.add(ContentModel.PROP_USERNAME);
        GetPeopleCannedQueryTest.assertEquals((String)"Pattern filtering is not correct", (int)2, (int)this.executeGetPeopleQuery(pagingRequest, "A", filters, true, null).getPagedResultCount());
        this.personService.deletePerson(person1);
        filters.clear();
        filters.add(ContentModel.PROP_USERNAME);
        GetPeopleCannedQueryTest.assertEquals((String)"Pattern filtering is not correct", (int)1, (int)this.executeGetPeopleQuery(pagingRequest, "a", filters, true, null).getPagedResultCount());
        filters.clear();
        filters.add(ContentModel.PROP_USERNAME);
        GetPeopleCannedQueryTest.assertEquals((String)"Pattern filtering is not correct", (int)1, (int)this.executeGetPeopleQuery(pagingRequest, "a*", filters, true, null).getPagedResultCount());
        filters.clear();
        filters.add(ContentModel.PROP_USERNAME);
        GetPeopleCannedQueryTest.assertEquals((int)(newPeopleNumber - 1), (int)this.personService.countPeople());
        GetPeopleCannedQueryTest.assertEquals((String)"Pattern filtering is not correct", (int)(newPeopleNumber - 1), (int)this.executeGetPeopleQuery(pagingRequest, "*", filters, true, null).getPagedResultCount());
        filters.clear();
        filters.add(ContentModel.PROP_USERNAME);
        GetPeopleCannedQueryTest.assertEquals((String)"Pattern filtering is not correct", (int)1, (int)this.executeGetPeopleQuery(pagingRequest, "*-middle-*", filters, true, null).getPagedResultCount());
        filters.clear();
        filters.add(ContentModel.PROP_USERNAME);
        GetPeopleCannedQueryTest.assertEquals((String)"Pattern filtering is not correct", (int)1, (int)this.executeGetPeopleQuery(pagingRequest, "middle-*", filters, true, null).getPagedResultCount());
        filters.clear();
        filters.add(ContentModel.PROP_USERNAME);
        GetPeopleCannedQueryTest.assertEquals((String)"Pattern filtering is not correct", (int)1, (int)this.executeGetPeopleQuery(pagingRequest, "*-end", filters, true, null).getPagedResultCount());
        filters.clear();
        filters.add(ContentModel.PROP_USERNAME);
        GetPeopleCannedQueryTest.assertEquals((String)"Pattern filtering is not correct", (int)1, (int)this.executeGetPeopleQuery(pagingRequest, "-end", filters, true, null).getPagedResultCount());
        filters.clear();
        filters.add(ContentModel.PROP_USERNAME);
        GetPeopleCannedQueryTest.assertEquals((String)"Pattern filtering is not correct", (int)1, (int)this.executeGetPeopleQuery(pagingRequest, "-mi__le-", filters, true, null).getPagedResultCount());
        filters.clear();
        filters.add(ContentModel.PROP_USERNAME);
        GetPeopleCannedQueryTest.assertEquals((String)"Pattern filtering is not correct", (int)1, (int)this.executeGetPeopleQuery(pagingRequest, "-mi%le-", filters, true, null).getPagedResultCount());
        filters.clear();
        filters.add(ContentModel.PROP_USERNAME);
        GetPeopleCannedQueryTest.assertEquals((String)"Pattern filtering is not correct", (int)1, (int)this.executeGetPeopleQuery(pagingRequest, "-mi*le-", filters, true, null).getPagedResultCount());
    }

    @Test
    public void testPeopleSortingPaging() {
        int startPeopleNumber = this.personService.countPeople();
        NodeRef p1 = this.personService.getPerson(AuthenticationUtil.getAdminUserName());
        NodeRef p2 = this.personService.getPerson(AuthenticationUtil.getGuestUserName());
        NodeRef p3 = this.personService.createPerson(this.createDefaultProperties("aa", "Dd", "Aa", "hh@hh", "alfresco1"));
        NodeRef p4 = this.personService.createPerson(this.createDefaultProperties("cc", "Aa", "Cc", "dd@dd", "alfresco2"));
        NodeRef p5 = this.personService.createPerson(this.createDefaultProperties("hh", "Cc", "Hh", "cc@cc", "alfresco3"));
        NodeRef p6 = this.personService.createPerson(this.createDefaultProperties("bb", "Hh", "Bb", "bb@bb", "alfresco4"));
        NodeRef p7 = this.personService.createPerson(this.createDefaultProperties("dd", "Bb", "Dd", "aa@aa", "alfresco5"));
        int newPeopleNumber = startPeopleNumber + 5;
        GetPeopleCannedQueryTest.assertEquals((String)("There should be " + newPeopleNumber + " more people created"), (int)newPeopleNumber, (int)this.personService.countPeople());
        ArrayList<Object> sort = new ArrayList<Pair<QName, Boolean>>(1);
        sort.add(new Pair((Object)ContentModel.PROP_USERNAME, (Object)true));
        PagingRequest pr = new PagingRequest(0, 2, null);
        CannedQueryResults<NodeRef> ppr = this.executeGetPeopleQuery(pr, null, null, true, sort);
        List results = ppr.getPage();
        GetPeopleCannedQueryTest.assertEquals((int)3, (int)results.size());
        GetPeopleCannedQueryTest.assertEquals((Object)p3, results.get(0));
        GetPeopleCannedQueryTest.assertEquals((Object)p1, results.get(1));
        GetPeopleCannedQueryTest.assertEquals((Object)p6, results.get(2));
        pr = new PagingRequest(2, 2, null);
        pr.setRequestTotalCountMax(Integer.MAX_VALUE);
        ppr = this.executeGetPeopleQuery(pr, null, null, true, sort);
        results = ppr.getPage();
        GetPeopleCannedQueryTest.assertEquals((int)5, (int)results.size());
        GetPeopleCannedQueryTest.assertEquals((Object)p6, results.get(0));
        GetPeopleCannedQueryTest.assertEquals((Object)p4, results.get(1));
        GetPeopleCannedQueryTest.assertEquals((Object)p7, results.get(2));
        GetPeopleCannedQueryTest.assertEquals((Object)p2, results.get(3));
        GetPeopleCannedQueryTest.assertEquals((Object)p5, results.get(4));
        GetPeopleCannedQueryTest.assertEquals((Object)new Pair((Object)7, (Object)7), (Object)ppr.getTotalResultCount());
        pr = new PagingRequest(4, 2, null);
        ppr = this.executeGetPeopleQuery(pr, null, null, true, sort);
        results = ppr.getPage();
        GetPeopleCannedQueryTest.assertEquals((int)3, (int)results.size());
        GetPeopleCannedQueryTest.assertEquals((Object)p7, results.get(0));
        GetPeopleCannedQueryTest.assertEquals((Object)p2, results.get(1));
        GetPeopleCannedQueryTest.assertEquals((Object)p5, results.get(2));
        pr = new PagingRequest(6, 2, null);
        pr.setRequestTotalCountMax(Integer.MAX_VALUE);
        ppr = this.executeGetPeopleQuery(pr, null, null, true, sort);
        results = ppr.getPage();
        GetPeopleCannedQueryTest.assertEquals((int)1, (int)results.size());
        GetPeopleCannedQueryTest.assertEquals((Object)p5, results.get(0));
        GetPeopleCannedQueryTest.assertEquals((Object)new Pair((Object)7, (Object)7), (Object)ppr.getTotalResultCount());
        sort = new ArrayList(1);
        sort.add((Pair<QName, Boolean>)new Pair((Object)ContentModel.PROP_FIRSTNAME, (Object)true));
        pr = new PagingRequest(0, 2, null);
        ppr = this.executeGetPeopleQuery(pr, null, null, true, sort);
        results = ppr.getPage();
        GetPeopleCannedQueryTest.assertEquals((int)3, (int)results.size());
        GetPeopleCannedQueryTest.assertEquals((Object)p4, results.get(0));
        GetPeopleCannedQueryTest.assertEquals((Object)p1, results.get(1));
        GetPeopleCannedQueryTest.assertEquals((Object)p7, results.get(2));
        pr = new PagingRequest(2, 2, null);
        pr.setRequestTotalCountMax(Integer.MAX_VALUE);
        ppr = this.executeGetPeopleQuery(pr, null, null, true, sort);
        results = ppr.getPage();
        GetPeopleCannedQueryTest.assertEquals((int)5, (int)results.size());
        GetPeopleCannedQueryTest.assertEquals((Object)p7, results.get(0));
        GetPeopleCannedQueryTest.assertEquals((Object)p5, results.get(1));
        GetPeopleCannedQueryTest.assertEquals((Object)p3, results.get(2));
        GetPeopleCannedQueryTest.assertEquals((Object)p2, results.get(3));
        GetPeopleCannedQueryTest.assertEquals((Object)p6, results.get(4));
        GetPeopleCannedQueryTest.assertEquals((Object)new Pair((Object)7, (Object)7), (Object)ppr.getTotalResultCount());
        pr = new PagingRequest(4, 2, null);
        ppr = this.executeGetPeopleQuery(pr, null, null, true, sort);
        results = ppr.getPage();
        GetPeopleCannedQueryTest.assertEquals((int)3, (int)results.size());
        GetPeopleCannedQueryTest.assertEquals((Object)p3, results.get(0));
        GetPeopleCannedQueryTest.assertEquals((Object)p2, results.get(1));
        GetPeopleCannedQueryTest.assertEquals((Object)p6, results.get(2));
        pr = new PagingRequest(6, 2, null);
        pr.setRequestTotalCountMax(Integer.MAX_VALUE);
        ppr = this.executeGetPeopleQuery(pr, null, null, true, sort);
        results = ppr.getPage();
        GetPeopleCannedQueryTest.assertEquals((int)1, (int)results.size());
        GetPeopleCannedQueryTest.assertEquals((Object)p6, results.get(0));
        GetPeopleCannedQueryTest.assertEquals((Object)new Pair((Object)7, (Object)7), (Object)ppr.getTotalResultCount());
    }
}

