/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataIntegrityViolationException;

@Category(value={OwnJVMTestsCategory.class})
public class DuplicateAuthorityTest
extends TestCase {
    private static final ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private AuthenticationComponent authenticationComponent;
    private TransactionService transactionService;
    private RetryingTransactionHelper retryingTransactionHelper;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private NodeRef rootNodeRef;
    private NodeRef workingRootNodeRef;
    private AuthorityService authorityService;
    private PersonService personService;
    private static ThreadGroup threadGroup = new ThreadGroup("DuplicateAuthorityTest");
    private static int threadNumber = -1;

    public void setUp() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            throw new AlfrescoRuntimeException("A previous tests did not clean up transaction: " + AlfrescoTransactionSupport.getTransactionId());
        }
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.retryingTransactionHelper = this.transactionService.getRetryingTransactionHelper();
        this.retryingTransactionHelper.setMaxRetryWaitMs(10);
        this.nodeService = serviceRegistry.getNodeService();
        this.fileFolderService = serviceRegistry.getFileFolderService();
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.authorityService = (AuthorityService)ctx.getBean("authorityService");
        this.personService = (PersonService)ctx.getBean("personService");
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> callback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                DuplicateAuthorityTest.this.authenticationComponent.setCurrentUser(DuplicateAuthorityTest.this.authenticationComponent.getSystemUserName());
                StoreRef storeRef = DuplicateAuthorityTest.this.nodeService.createStore("workspace", String.valueOf(DuplicateAuthorityTest.this.getName()) + System.currentTimeMillis());
                DuplicateAuthorityTest.this.rootNodeRef = DuplicateAuthorityTest.this.nodeService.getRootNode(storeRef);
                NodeRef nodeRef = DuplicateAuthorityTest.this.nodeService.createNode(DuplicateAuthorityTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"working root"), ContentModel.TYPE_FOLDER).getChildRef();
                return nodeRef;
            }
        };
        this.workingRootNodeRef = (NodeRef)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
    }

    public void tearDown() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback1 = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() {
                int i = 0;
                while (i <= 11) {
                    if (DuplicateAuthorityTest.this.authorityService.authorityExists("GROUP_" + i)) {
                        DuplicateAuthorityTest.this.authorityService.deleteAuthority("GROUP_" + i);
                    }
                    ++i;
                }
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback1, false, true);
    }

    public void testDuplicateGroupDetection() throws Exception {
    }

    public void testDuplicatePersonDetection() throws Exception {
    }

    private class AuthThread
    extends Thread {
        private CountDownLatch endLatch;
        private Throwable error;
        private String success;

        public AuthThread(CountDownLatch endLatch) {
            ThreadGroup threadGroup = threadGroup;
            StringBuilder stringBuilder = new StringBuilder("Worker ");
            int n = threadNumber + 1;
            threadNumber = n;
            super(threadGroup, stringBuilder.append(n).toString());
            this.endLatch = endLatch;
        }

        @Override
        public void run() {
            String result = null;
            int number = 0;
            while (true) {
                CreateAuthorityCallback callback = new CreateAuthorityCallback(number);
                try {
                    System.out.println("Thread " + this.getName() + " attempting file: " + number);
                    System.out.flush();
                    this.success = result = (String)DuplicateAuthorityTest.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
                }
                catch (DataIntegrityViolationException dataIntegrityViolationException) {
                    ++number;
                    continue;
                }
                catch (Throwable e) {
                    this.error = e;
                }
                break;
            }
            if (this.error != null) {
                System.err.println("Thread " + this.getName() + " failed to create file " + number + ":");
                System.err.flush();
                this.error.printStackTrace();
            } else {
                System.out.println("\t\t\tThread " + this.getName() + " created auth: " + this.success);
                System.out.flush();
            }
            this.endLatch.countDown();
        }
    }

    private class CreateAuthorityCallback
    implements RetryingTransactionHelper.RetryingTransactionCallback<String> {
        private final int number;

        public CreateAuthorityCallback(int number) {
            this.number = number;
        }

        public String execute() throws Throwable {
            DuplicateAuthorityTest.this.authenticationComponent.setCurrentUser(DuplicateAuthorityTest.this.authenticationComponent.getSystemUserName());
            return DuplicateAuthorityTest.this.authorityService.createAuthority(AuthorityType.GROUP, "" + this.number);
        }
    }

    private class CreatePersonCallback
    implements RetryingTransactionHelper.RetryingTransactionCallback<String> {
        private final int number;

        public CreatePersonCallback(int number) {
            this.number = number;
        }

        public String execute() throws Throwable {
            DuplicateAuthorityTest.this.authenticationComponent.setCurrentUser(DuplicateAuthorityTest.this.authenticationComponent.getSystemUserName());
            HashMap<QName, String> properties = new HashMap<QName, String>();
            properties.put(ContentModel.PROP_USERNAME, "Person_" + this.number);
            properties.put(ContentModel.PROP_HOMEFOLDER, (String)DuplicateAuthorityTest.this.rootNodeRef);
            properties.put(ContentModel.PROP_FIRSTNAME, "Person_" + this.number);
            properties.put(ContentModel.PROP_LASTNAME, "Person_" + this.number);
            properties.put(ContentModel.PROP_EMAIL, "Person_" + this.number);
            properties.put(ContentModel.PROP_ORGID, "Person_" + this.number);
            DuplicateAuthorityTest.this.personService.createPerson(properties);
            return "Person_" + this.number;
        }
    }

    private class PersonThread
    extends Thread {
        private CountDownLatch endLatch;
        private Throwable error;
        private String success;

        public PersonThread(CountDownLatch endLatch) {
            ThreadGroup threadGroup = threadGroup;
            StringBuilder stringBuilder = new StringBuilder("Worker ");
            int n = threadNumber + 1;
            threadNumber = n;
            super(threadGroup, stringBuilder.append(n).toString());
            this.endLatch = endLatch;
        }

        @Override
        public void run() {
            String result = null;
            int number = 0;
            while (true) {
                CreatePersonCallback callback = new CreatePersonCallback(number);
                try {
                    System.out.println("Thread " + this.getName() + " attempting file: " + number);
                    System.out.flush();
                    this.success = result = (String)DuplicateAuthorityTest.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
                }
                catch (DataIntegrityViolationException dataIntegrityViolationException) {
                    ++number;
                    continue;
                }
                catch (Throwable e) {
                    this.error = e;
                }
                break;
            }
            if (this.error != null) {
                System.err.println("Thread " + this.getName() + " failed to create file " + number + ":");
                System.err.flush();
                this.error.printStackTrace();
            } else {
                System.out.println("\t\t\tThread " + this.getName() + " created auth: " + this.success);
                System.out.flush();
            }
            this.endLatch.countDown();
        }
    }
}

