/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.GrantedAuthorityImpl;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.context.Context;
import net.sf.acegisecurity.context.ContextHolder;
import net.sf.acegisecurity.context.security.SecureContext;
import net.sf.acegisecurity.context.security.SecureContextImpl;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import net.sf.acegisecurity.providers.dao.User;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.GUID;

public class TestAuthenticationServiceImpl
implements MutableAuthenticationService {
    private Map<String, String> userNamesAndPasswords = new HashMap<String, String>();
    private Set<String> disabledUsers = new HashSet<String>();
    private Map<String, String> userToTicket = new HashMap<String, String>();
    String domain;
    boolean allowCreate;
    boolean allowDelete;
    boolean allowUpdate;
    boolean allowGuest;
    private static final String SYSTEM_USER_NAME = "System";

    public TestAuthenticationServiceImpl(String domain, boolean allowCreate, boolean allowDelete, boolean allowUpdate, boolean allowGuest) {
        this.domain = domain;
        this.allowCreate = allowCreate;
        this.allowDelete = allowDelete;
        this.allowUpdate = allowUpdate;
        this.allowGuest = allowGuest;
    }

    public TestAuthenticationServiceImpl(String domain, boolean allowCreate, boolean allowDelete, boolean allowUpdate, boolean allowGuest, Map<String, String> users, Set<String> disabled) {
        this(domain, allowCreate, allowDelete, allowUpdate, allowGuest);
        if (users != null) {
            this.userNamesAndPasswords.putAll(users);
        }
        if (disabled != null) {
            this.disabledUsers.addAll(disabled);
        }
    }

    public void createAuthentication(String userName, char[] password) throws AuthenticationException {
        if (!this.allowCreate) {
            throw new AuthenticationException("Create not allowed");
        }
        if (this.userNamesAndPasswords.containsKey(userName)) {
            throw new AuthenticationException("User exists");
        }
        this.userNamesAndPasswords.put(userName, new String(password));
    }

    public void updateAuthentication(String userName, char[] oldPassword, char[] newPassword) throws AuthenticationException {
        if (!this.allowUpdate) {
            throw new AuthenticationException("Update not allowed");
        }
        if (!this.userNamesAndPasswords.containsKey(userName)) {
            throw new AuthenticationException("User does not exist");
        }
        if (!this.userNamesAndPasswords.get(userName).equals(new String(oldPassword))) {
            throw new AuthenticationException("Password does not match existing");
        }
        this.userNamesAndPasswords.put(userName, new String(newPassword));
    }

    public void setAuthentication(String userName, char[] newPassword) throws AuthenticationException {
        if (!this.allowUpdate) {
            throw new AuthenticationException("Update not allowed");
        }
        if (!this.userNamesAndPasswords.containsKey(userName)) {
            throw new AuthenticationException("User does not exist");
        }
        this.userNamesAndPasswords.put(userName, new String(newPassword));
    }

    public void deleteAuthentication(String userName) throws AuthenticationException {
        if (!this.allowDelete) {
            throw new AuthenticationException("Delete not allowed");
        }
        if (!this.userNamesAndPasswords.containsKey(userName)) {
            throw new AuthenticationException("User does not exist");
        }
        this.userNamesAndPasswords.remove(userName);
    }

    public void setAuthenticationEnabled(String userName, boolean enabled) throws AuthenticationException {
        if (!this.allowUpdate) {
            throw new AuthenticationException("Update not allowed");
        }
        if (!this.userNamesAndPasswords.containsKey(userName)) {
            throw new AuthenticationException("User does not exist");
        }
        if (enabled) {
            this.disabledUsers.remove(userName);
        } else {
            this.disabledUsers.add(userName);
        }
    }

    public boolean getAuthenticationEnabled(String userName) throws AuthenticationException {
        if (!this.userNamesAndPasswords.containsKey(userName)) {
            return false;
        }
        return !this.disabledUsers.contains(userName);
    }

    public void authenticate(String userName, char[] password) throws AuthenticationException {
        if (!this.userNamesAndPasswords.containsKey(userName)) {
            throw new AuthenticationException("User does not exist");
        }
        if (this.disabledUsers.contains(userName)) {
            throw new AuthenticationException("User disabled0");
        }
        if (!this.userNamesAndPasswords.get(userName).equals(new String(password))) {
            throw new AuthenticationException("Unknown user/password");
        }
        this.setCurrentUser(userName);
    }

    public void authenticateAsGuest() throws AuthenticationException {
        if (!this.allowGuest) {
            throw new AuthenticationException("Guest access denied");
        }
        this.setCurrentUser(AuthenticationUtil.getGuestUserName());
    }

    public boolean guestUserAuthenticationAllowed() {
        return this.allowGuest;
    }

    public boolean authenticationExists(String userName) {
        return this.userNamesAndPasswords.containsKey(userName);
    }

    public boolean isAuthenticationMutable(String userName) {
        return this.authenticationExists(userName);
    }

    public boolean isAuthenticationCreationAllowed() {
        return this.allowCreate;
    }

    public String getCurrentUserName() throws AuthenticationException {
        Context context = ContextHolder.getContext();
        if (context == null || !(context instanceof SecureContext)) {
            return null;
        }
        return this.getUserName(((SecureContext)context).getAuthentication());
    }

    private String getUserName(Authentication authentication) {
        String username = authentication.getPrincipal().toString();
        if (authentication.getPrincipal() instanceof UserDetails) {
            username = ((UserDetails)authentication.getPrincipal()).getUsername();
        }
        return username;
    }

    public void invalidateUserSession(String userName) throws AuthenticationException {
        this.userToTicket.remove(userName);
    }

    public void invalidateTicket(String ticket) throws AuthenticationException {
        String userToRemove = null;
        for (String user : this.userToTicket.keySet()) {
            String currentTicket = this.userToTicket.get(user);
            if (!EqualsHelper.nullSafeEquals((Object)currentTicket, (Object)ticket)) continue;
            userToRemove = user;
        }
        if (userToRemove != null) {
            this.userToTicket.remove(userToRemove);
        }
    }

    public void validate(String ticket) throws AuthenticationException {
        String userToSet = null;
        for (String user : this.userToTicket.keySet()) {
            String currentTicket = this.userToTicket.get(user);
            if (!EqualsHelper.nullSafeEquals((Object)currentTicket, (Object)ticket)) continue;
            userToSet = user;
        }
        if (userToSet == null) {
            throw new AuthenticationException("Invalid ticket");
        }
        this.setCurrentUser(userToSet);
    }

    public String getCurrentTicket() {
        String currentUser = this.getCurrentUserName();
        String ticket = this.userToTicket.get(currentUser);
        if (ticket == null) {
            ticket = GUID.generate();
            this.userToTicket.put(currentUser, ticket);
        }
        return ticket;
    }

    public String getNewTicket() {
        String currentUser = this.getCurrentUserName();
        String ticket = this.userToTicket.get(currentUser);
        if (ticket == null) {
            ticket = GUID.generate();
            this.userToTicket.put(currentUser, ticket);
        }
        return ticket;
    }

    public void clearCurrentSecurityContext() {
        ContextHolder.setContext(null);
    }

    public boolean isCurrentUserTheSystemUser() {
        String userName = this.getCurrentUserName();
        return userName != null && userName.equals(SYSTEM_USER_NAME);
    }

    public Set<String> getDomains() {
        return Collections.singleton(this.domain);
    }

    public Set<String> getDomainsThatAllowUserCreation() {
        if (this.allowCreate) {
            return Collections.singleton(this.domain);
        }
        return Collections.emptySet();
    }

    public Set<String> getDomainsThatAllowUserDeletion() {
        if (this.allowDelete) {
            return Collections.singleton(this.domain);
        }
        return Collections.emptySet();
    }

    public Set<String> getDomiansThatAllowUserPasswordChanges() {
        if (this.allowUpdate) {
            return Collections.singleton(this.domain);
        }
        return Collections.emptySet();
    }

    public Authentication setCurrentUser(String userName) throws AuthenticationException {
        if (userName == null) {
            throw new AuthenticationException("Null user name");
        }
        try {
            GrantedAuthority[] gas;
            UserDetails ud = null;
            if (userName.equals(SYSTEM_USER_NAME)) {
                gas = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_SYSTEM")};
                ud = new User(SYSTEM_USER_NAME, "", true, true, true, true, gas);
            } else if (userName.equalsIgnoreCase(AuthenticationUtil.getGuestUserName())) {
                gas = new GrantedAuthority[]{};
                ud = new User(AuthenticationUtil.getGuestUserName().toLowerCase(), "", true, true, true, true, gas);
            } else {
                ud = this.getUserDetails(userName);
            }
            UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)ud, (Object)"", ud.getAuthorities());
            auth.setDetails((Object)ud);
            auth.setAuthenticated(true);
            return this.setCurrentAuthentication((Authentication)auth);
        }
        catch (net.sf.acegisecurity.AuthenticationException ae) {
            throw new AuthenticationException(ae.getMessage(), (Throwable)ae);
        }
    }

    protected UserDetails getUserDetails(String userName) {
        GrantedAuthority[] gas = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_AUTHENTICATED")};
        User ud = new User(userName, "", true, true, true, true, gas);
        return ud;
    }

    public Authentication setCurrentAuthentication(Authentication authentication) {
        Context context = ContextHolder.getContext();
        SecureContextImpl sc = null;
        if (context == null || !(context instanceof SecureContext)) {
            sc = new SecureContextImpl();
            ContextHolder.setContext((Context)sc);
        } else {
            sc = (SecureContext)context;
        }
        authentication.setAuthenticated(true);
        sc.setAuthentication(authentication);
        return authentication;
    }

    public Set<String> getDefaultAdministratorUserNames() {
        return Collections.singleton(AuthenticationUtil.getAdminUserName());
    }

    public Set<String> getDefaultGuestUserNames() {
        return Collections.singleton(AuthenticationUtil.getGuestUserName());
    }
}

