/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.db;

import jakarta.transaction.UserTransaction;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.testing.category.DBTests;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.test.annotation.Commit;
import org.springframework.test.context.transaction.TestTransaction;
import org.springframework.transaction.annotation.Transactional;

@Category(value={DBTests.class})
@Transactional
public class DbNodeServiceImplPropagationTest
extends BaseSpringTest {
    private TransactionService txnService;
    private NodeDAO nodeDAO;
    private NodeService nodeService;
    private AuthenticationComponent authenticationComponent;
    protected DictionaryService dictionaryService;
    private UserTransaction txn = null;
    private Dialect dialect;

    @Before
    public void before() throws Exception {
        this.txnService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.nodeDAO = (NodeDAO)this.applicationContext.getBean("nodeDAO");
        this.dialect = (Dialect)this.applicationContext.getBean("dialect");
        this.nodeService = (NodeService)this.applicationContext.getBean("dbNodeService");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        DictionaryDAO dictionaryDao = (DictionaryDAO)this.applicationContext.getBean("dictionaryDAO");
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("alfresco/model/contentModel.xml");
        DbNodeServiceImplPropagationTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        modelStream = cl.getResourceAsStream("org/alfresco/repo/node/BaseNodeServiceTest_model.xml");
        DbNodeServiceImplPropagationTest.assertNotNull((Object)modelStream);
        model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        DictionaryComponent dictionary = new DictionaryComponent();
        dictionary.setDictionaryDAO(dictionaryDao);
        this.dictionaryService = DbNodeServiceImplPropagationTest.loadModel(this.applicationContext);
        this.restartAuditableTxn();
    }

    @After
    public void after() throws Exception {
        try {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Throwable throwable) {}
    }

    public static DictionaryService loadModel(ApplicationContext applicationContext) {
        DictionaryDAO dictionaryDao = (DictionaryDAO)applicationContext.getBean("dictionaryDAO");
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("alfresco/model/contentModel.xml");
        DbNodeServiceImplPropagationTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        modelStream = cl.getResourceAsStream("org/alfresco/repo/node/BaseNodeServiceTest_model.xml");
        DbNodeServiceImplPropagationTest.assertNotNull((Object)modelStream);
        model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        DictionaryComponent dictionary = new DictionaryComponent();
        dictionary.setDictionaryDAO(dictionaryDao);
        return dictionary;
    }

    @Commit
    @Test
    public void testAuditablePropagation() throws Exception {
        String fullyAuthenticatedUser = AuthenticationUtil.getFullyAuthenticatedUser();
        QName TYPE_NOT_AUDITABLE = ContentModel.TYPE_CONTAINER;
        QName TYPE_AUDITABLE = ContentModel.TYPE_CONTENT;
        QName ASSOC_NOT_AUDITABLE = ContentModel.ASSOC_CHILDREN;
        QName ASSOC_AUDITABLE = ContentModel.ASSOC_CONTAINS;
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        NodeRef rootNodeRef = this.nodeService.getRootNode(storeRef);
        Map<QName, ChildAssociationRef> assocRefs = BaseNodeServiceTest.buildNodeGraph(this.nodeService, rootNodeRef);
        Date modifiedAt = null;
        ChildAssociationRef n2pn4Ref = assocRefs.get(QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"n2_p_n4"));
        NodeRef n2Ref = n2pn4Ref.getParentRef();
        long n2Id = (Long)this.nodeDAO.getNodePair(n2Ref).getFirst();
        DbNodeServiceImplPropagationTest.assertFalse((String)("Shouldn't be auditable in " + this.nodeService.getAspects(n2Ref)), (boolean)this.nodeService.getAspects(n2Ref).contains(ContentModel.ASPECT_AUDITABLE));
        QName typeBefore = this.nodeService.getType(n2Ref);
        TestTransaction.flagForCommit();
        this.restartAuditableTxn();
        NodeRef naC = this.nodeService.createNode(n2Ref, ASSOC_NOT_AUDITABLE, QName.createQName((String)"not-auditable"), TYPE_NOT_AUDITABLE).getChildRef();
        this.logger.debug((Object)("Created non-auditable child " + naC));
        this.restartAuditableTxn();
        DbNodeServiceImplPropagationTest.assertNull((Object)this.nodeService.getProperty(n2Ref, ContentModel.PROP_MODIFIED));
        DbNodeServiceImplPropagationTest.assertNull((Object)this.nodeService.getProperty(n2Ref, ContentModel.PROP_MODIFIER));
        NodeRef adC = this.nodeService.createNode(n2Ref, ASSOC_NOT_AUDITABLE, QName.createQName((String)"is-auditable"), TYPE_AUDITABLE).getChildRef();
        this.nodeService.addAspect(adC, ContentModel.ASPECT_AUDITABLE, null);
        this.logger.debug((Object)("Created auditable child " + naC + " of non-auditable parent " + n2Ref));
        this.restartAuditableTxn();
        DbNodeServiceImplPropagationTest.assertNull((Object)this.nodeService.getProperty(n2Ref, ContentModel.PROP_MODIFIED));
        DbNodeServiceImplPropagationTest.assertNull((Object)this.nodeService.getProperty(n2Ref, ContentModel.PROP_MODIFIER));
        DbNodeServiceImplPropagationTest.assertNotNull((Object)this.nodeService.getProperty(adC, ContentModel.PROP_MODIFIED));
        DbNodeServiceImplPropagationTest.assertNotNull((Object)this.nodeService.getProperty(adC, ContentModel.PROP_MODIFIER));
        this.nodeService.addAspect(n2Ref, ContentModel.ASPECT_AUDITABLE, null);
        this.nodeService.setType(n2Ref, ContentModel.TYPE_FOLDER);
        this.restartAuditableTxn();
        Date modified = new Date();
        this.nodeDAO.setModifiedProperties(Long.valueOf(n2Id), modified, "TestModifier");
        this.restartAuditableTxn();
        DbNodeServiceImplPropagationTest.assertEquals((long)modified.getTime(), (long)((Date)this.nodeDAO.getNodeProperty(Long.valueOf(n2Id), ContentModel.PROP_MODIFIED)).getTime());
        DbNodeServiceImplPropagationTest.assertEquals((Object)"TestModifier", (Object)this.nodeDAO.getNodeProperty(Long.valueOf(n2Id), ContentModel.PROP_MODIFIER));
        this.logger.debug((Object)("Deleting non-auditable child " + naC + " of auditable parent " + n2Ref));
        this.nodeService.addAspect(naC, ContentModel.ASPECT_TEMPORARY, null);
        this.nodeService.deleteNode(naC);
        this.restartAuditableTxn();
        DbNodeServiceImplPropagationTest.assertEquals((long)modified.getTime(), (long)((Date)this.nodeDAO.getNodeProperty(Long.valueOf(n2Id), ContentModel.PROP_MODIFIED)).getTime());
        DbNodeServiceImplPropagationTest.assertEquals((Object)"TestModifier", (Object)this.nodeDAO.getNodeProperty(Long.valueOf(n2Id), ContentModel.PROP_MODIFIER));
        adC = this.nodeService.createNode(n2Ref, ASSOC_AUDITABLE, QName.createQName((String)"is-auditable"), TYPE_AUDITABLE).getChildRef();
        long adCId = (Long)this.nodeDAO.getNodePair(adC).getFirst();
        this.restartAuditableTxn();
        modifiedAt = (Date)this.nodeService.getProperty(n2Ref, ContentModel.PROP_MODIFIED);
        DbNodeServiceImplPropagationTest.assertNotNull((Object)modifiedAt);
        DbNodeServiceImplPropagationTest.assertEquals((double)new Date().getTime(), (double)modifiedAt.getTime(), (double)10000.0);
        DbNodeServiceImplPropagationTest.assertEquals((Object)fullyAuthenticatedUser, (Object)this.nodeService.getProperty(n2Ref, ContentModel.PROP_MODIFIER));
        this.nodeDAO.setModifiedProperties(Long.valueOf(n2Id), new Date(Integer.MIN_VALUE), "TestModifierPrnt");
        this.nodeDAO.setModifiedProperties(Long.valueOf(adCId), new Date(Integer.MIN_VALUE), "TestModifierChld");
        this.restartAuditableTxn();
        this.logger.debug((Object)("Deleting auditable child " + adC + " of auditable parent " + n2Ref));
        this.nodeService.deleteNode(adC);
        this.restartAuditableTxn();
        modifiedAt = (Date)this.nodeService.getProperty(n2Ref, ContentModel.PROP_MODIFIED);
        DbNodeServiceImplPropagationTest.assertNotNull((Object)modifiedAt);
        DbNodeServiceImplPropagationTest.assertEquals((double)new Date().getTime(), (double)modifiedAt.getTime(), (double)10000.0);
        DbNodeServiceImplPropagationTest.assertEquals((Object)fullyAuthenticatedUser, (Object)this.nodeService.getProperty(n2Ref, ContentModel.PROP_MODIFIER));
        modified = new Date();
        this.nodeDAO.setModifiedProperties(Long.valueOf(n2Id), modified, "ModOn2");
        this.restartAuditableTxn();
        DbNodeServiceImplPropagationTest.assertEquals((Object)"ModOn2", (Object)this.nodeService.getProperty(n2Ref, ContentModel.PROP_MODIFIER));
        NodeRef ac1 = this.nodeService.createNode(n2Ref, ASSOC_AUDITABLE, QName.createQName((String)"is-auditable-1"), TYPE_AUDITABLE).getChildRef();
        NodeRef ac2 = this.nodeService.createNode(n2Ref, ASSOC_AUDITABLE, QName.createQName((String)"is-auditable-2"), TYPE_AUDITABLE).getChildRef();
        long ac1Id = (Long)this.nodeDAO.getNodePair(ac1).getFirst();
        long ac2Id = (Long)this.nodeDAO.getNodePair(ac2).getFirst();
        this.nodeDAO.setModifiedProperties(Long.valueOf(ac1Id), new Date(), "ModAC1");
        this.nodeDAO.setModifiedProperties(Long.valueOf(ac2Id), new Date(), "ModAC2");
        this.nodeDAO.setModifiedProperties(Long.valueOf(n2Id), new Date(Integer.MIN_VALUE), "ModOn2");
        this.restartAuditableTxn();
        DbNodeServiceImplPropagationTest.assertNotNull((Object)this.nodeService.getProperty(n2Ref, ContentModel.PROP_MODIFIED));
        DbNodeServiceImplPropagationTest.assertNotNull((Object)this.nodeService.getProperty(ac1, ContentModel.PROP_MODIFIED));
        DbNodeServiceImplPropagationTest.assertNotNull((Object)this.nodeService.getProperty(ac2, ContentModel.PROP_MODIFIED));
        DbNodeServiceImplPropagationTest.assertEquals((Object)fullyAuthenticatedUser, (Object)this.nodeService.getProperty(n2Ref, ContentModel.PROP_MODIFIER));
        DbNodeServiceImplPropagationTest.assertEquals((Object)fullyAuthenticatedUser, (Object)this.nodeService.getProperty(ac1, ContentModel.PROP_MODIFIER));
        DbNodeServiceImplPropagationTest.assertEquals((Object)fullyAuthenticatedUser, (Object)this.nodeService.getProperty(ac2, ContentModel.PROP_MODIFIER));
        Date now = new Date();
        long futureShift = 4000L;
        Date future = new Date(now.getTime() + futureShift);
        this.nodeDAO.setModifiedProperties(Long.valueOf(n2Id), future, "TestModifierPrnt");
        NodeRef ac3 = this.nodeService.createNode(n2Ref, ASSOC_AUDITABLE, QName.createQName((String)"is-auditable-3"), TYPE_AUDITABLE).getChildRef();
        this.restartAuditableTxn();
        DbNodeServiceImplPropagationTest.assertEquals((Object)"TestModifierPrnt", (Object)this.nodeService.getProperty(n2Ref, ContentModel.PROP_MODIFIER));
        DbNodeServiceImplPropagationTest.assertEquals((Object)fullyAuthenticatedUser, (Object)this.nodeService.getProperty(ac3, ContentModel.PROP_MODIFIER));
        modifiedAt = (Date)this.nodeService.getProperty(n2Ref, ContentModel.PROP_MODIFIED);
        DbNodeServiceImplPropagationTest.assertEquals((double)future.getTime(), (double)modifiedAt.getTime(), (double)1000.0);
        modifiedAt = (Date)this.nodeService.getProperty(ac3, ContentModel.PROP_MODIFIED);
        DbNodeServiceImplPropagationTest.assertEquals((double)now.getTime(), (double)modifiedAt.getTime(), (double)1000.0);
        this.nodeService.setType(n2Ref, typeBefore);
        this.restartAuditableTxn();
        try {
            Thread.sleep(futureShift);
        }
        catch (InterruptedException interruptedException) {}
        modified = new Date();
        this.nodeDAO.setModifiedProperties(Long.valueOf(n2Id), modified, "TestModifier");
        this.restartAuditableTxn();
        DbNodeServiceImplPropagationTest.assertEquals((Object)"TestModifier", (Object)this.nodeService.getProperty(n2Ref, ContentModel.PROP_MODIFIER));
        NodeRef ac4 = this.nodeService.createNode(n2Ref, ASSOC_NOT_AUDITABLE, QName.createQName((String)"is-auditable-4"), TYPE_AUDITABLE).getChildRef();
        this.restartAuditableTxn();
        DbNodeServiceImplPropagationTest.assertEquals((Object)"TestModifier", (Object)this.nodeService.getProperty(n2Ref, ContentModel.PROP_MODIFIER));
        DbNodeServiceImplPropagationTest.assertEquals((Object)fullyAuthenticatedUser, (Object)this.nodeService.getProperty(ac4, ContentModel.PROP_MODIFIER));
        modifiedAt = (Date)this.nodeService.getProperty(n2Ref, ContentModel.PROP_MODIFIED);
        DbNodeServiceImplPropagationTest.assertEquals((long)modified.getTime(), (long)modifiedAt.getTime());
        modifiedAt = (Date)this.nodeService.getProperty(ac4, ContentModel.PROP_MODIFIED);
        DbNodeServiceImplPropagationTest.assertEquals((double)new Date().getTime(), (double)modifiedAt.getTime(), (double)3000.0);
    }

    private void restartAuditableTxn() throws Exception {
        TestTransaction.end();
        try {
            Thread.sleep(1250L);
        }
        catch (InterruptedException interruptedException) {}
        TestTransaction.start();
    }
}

