/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.workflow;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.alfresco.repo.forms.FieldDefinition;
import org.alfresco.repo.forms.Form;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.Item;
import org.alfresco.repo.forms.processor.FieldProcessorRegistry;
import org.alfresco.repo.forms.processor.Filter;
import org.alfresco.repo.forms.processor.FilterRegistry;
import org.alfresco.repo.forms.processor.node.DefaultFieldProcessor;
import org.alfresco.repo.forms.processor.node.MockClassAttributeDefinition;
import org.alfresco.repo.forms.processor.node.MockFieldProcessorRegistry;
import org.alfresco.repo.forms.processor.workflow.AbstractWorkflowFormProcessor;
import org.alfresco.repo.forms.processor.workflow.WorkflowFormFilter;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class FormProcessorTest
extends TestCase {
    protected static final String TASK_DEF_NAME = "TaskDef";
    protected static final QName DESC_NAME = WorkflowModel.PROP_DESCRIPTION;
    protected static final QName STATUS_NAME = WorkflowModel.PROP_STATUS;
    protected static final QName PROP_WITH_ = QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"some_prop");
    protected static final QName ACTORS_NAME = WorkflowModel.ASSOC_POOLED_ACTORS;
    protected static final QName ASSIGNEE_NAME = WorkflowModel.ASSOC_ASSIGNEE;
    protected static final QName ASSOC_WITH_ = QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"some_assoc");
    protected static final NodeRef FAKE_NODE = new NodeRef("http://www.alfresco.org/model/bpm/1.0/FakeNode");
    protected static final NodeRef FAKE_NODE2 = new NodeRef("http://www.alfresco.org/model/bpm/1.0/FakeNode2");
    protected static final NodeRef FAKE_NODE3 = new NodeRef("http://www.alfresco.org/model/bpm/1.0/FakeNode3");
    protected static final NodeRef PCKG_NODE = new NodeRef("http://www.alfresco.org/model/bpm/1.0/FakePackage");
    protected WorkflowService workflowService;
    protected NodeService nodeService;
    protected NamespaceService namespaceService;
    protected AbstractWorkflowFormProcessor processor;
    protected Item item;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected DefaultFieldProcessor makeDefaultFieldProcessor(DictionaryService dictionaryService) throws Exception {
        DefaultFieldProcessor defaultProcessor = new DefaultFieldProcessor();
        defaultProcessor.setDictionaryService(dictionaryService);
        defaultProcessor.setNamespaceService(this.namespaceService);
        defaultProcessor.afterPropertiesSet();
        return defaultProcessor;
    }

    public void testPersistPropertyComment(String taskId) throws Exception {
        int maxLengthPropery;
        StringBuilder wikiHamlet = new StringBuilder();
        wikiHamlet.append("Hamlet is the son of the King of Denmark. When Hamlet`s father dies, his uncle Claudius becomes king and marries Hamlet`s mother (Gertrude).");
        wikiHamlet.append("Hamlet`s father appears as a ghost and tells Hamlet that he was murdered by Claudius. Hamlet is not sure that the ghost is really his father.");
        wikiHamlet.append("He gets some travelling actors to perform a play which shows the murder of a king in the same way Hamlet`s father said he was killed.");
        wikiHamlet.append("When Claudius reacts badly to seeing this, Hamlet believes he is guilty.");
        wikiHamlet.append("Hamlet tells his mother that he knows about the murder. While there he kills Polonius, who is the king`s advisor, because he thinks he is Claudius.");
        wikiHamlet.append("Rosencrantz and Guildenstern were Hamlet`s childhood friends.");
        wikiHamlet.append("Claudius sends Rosencrantz and Guildenstern with Hamlet to England to have Hamlet killed, but their ship is attacked by pirates who take Hamlet prisoner but then return him to Denmark.");
        wikiHamlet.append("Rosencrantz and Guildenstern are taken to England where they die. Ophelia is Polonius` daughter . After her father, Polonius, is killed by Hamlet she goes mad.");
        wikiHamlet.append("Then she falls into a river and drowns. Hamlet returns just as her funeral is happening. Laertes, her brother, decides to kill Hamlet in revenge.");
        wikiHamlet.append("He challenges Hamlet to a sword fight, and puts poison on his own sword. Claudius makes some poisoned wine for Hamlet to drink in case that does not work.");
        wikiHamlet.append("At first Hamlet wins the sword fight, and in the meantime his mother drinks the poisoned wine without knowing, and dies.");
        wikiHamlet.append("On the other hand Laertes falsely pierces Hamlet with a poisoned blade, but then Hamlet stabs Laertes with the same sword. Laertes tells Hamlet about the plot and then dies.");
        wikiHamlet.append("Hamlet kills Claudius with the poisoned sword. Horatio, Hamlet`s friend, tells everyone about the murder of the old king.");
        wikiHamlet.append("Hamlet tells everyone that the Norwegian prince, Fortinbras, should be king, and then dies from the poison.");
        wikiHamlet.append("When Fortinbras arrives, Horatio recounts the tale and Fortinbras orders Hamlet`s body borne off in honour.");
        wikiHamlet.append("Hamlet is one of the hardest parts for an actor to perform. It is one of the largest roles written by Shakespeare.");
        wikiHamlet.append("Many people disagree about what Hamlet is really thinking. For many actors, playing Hamlet is one of the most important parts of their career.");
        String maxLength = "4000";
        String dir = System.getProperty("user.dir");
        File propFile = new File(String.valueOf(dir) + File.separator + "config" + File.separator + "alfresco" + File.separator + "repository.properties");
        if (propFile.exists()) {
            try (FileInputStream propStream = null;){
                propStream = new FileInputStream(propFile);
                Properties properties = new Properties();
                properties.load(propStream);
                maxLength = properties.getProperty("system.workflow.comment.property.max.length");
            }
        }
        try {
            maxLengthPropery = Integer.valueOf(maxLength);
        }
        catch (NumberFormatException numberFormatException) {
            maxLengthPropery = 4000;
        }
        FormData data = new FormData();
        boolean repeatTest = true;
        String test = wikiHamlet.toString();
        Item item = new Item("task", taskId);
        while (repeatTest) {
            data.addFieldData("prop_bpm_comment", (Object)test);
            int value = test.getBytes().length;
            try {
                this.processor.persist(item, data);
                FormProcessorTest.assertTrue((String)("Value is " + value), (value < maxLengthPropery ? 1 : 0) != 0);
            }
            catch (Exception exception) {
                FormProcessorTest.assertTrue((String)("Caught Exception, value is " + value), (value > maxLengthPropery ? 1 : 0) != 0);
            }
            if (value < maxLengthPropery) {
                test = String.valueOf(test) + wikiHamlet.toString();
                continue;
            }
            repeatTest = false;
        }
    }

    protected AbstractWorkflowFormProcessor makeTaskFormProcessor(AbstractWorkflowFormProcessor processor1, DictionaryService dictionaryService, MockFieldProcessorRegistry fieldProcessorRegistry, DefaultFieldProcessor defaultProcessor) {
        processor1.setWorkflowService(this.workflowService);
        processor1.setNodeService(this.nodeService);
        processor1.setNamespaceService(this.namespaceService);
        processor1.setDictionaryService(dictionaryService);
        processor1.setFieldProcessorRegistry((FieldProcessorRegistry)fieldProcessorRegistry);
        processor1.setBehaviourFilter((BehaviourFilter)Mockito.mock(BehaviourFilter.class));
        FilterRegistry filterRegistry = new FilterRegistry();
        filterRegistry.addFilter((Filter)new WorkflowFormFilter());
        processor1.setFilterRegistry(filterRegistry);
        return processor1;
    }

    protected void mockPackageItems(NodeRef ... children) {
        ArrayList<ChildAssociationRef> results = new ArrayList<ChildAssociationRef>(children.length);
        NodeRef[] nodeRefArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            NodeRef nodeRef = nodeRefArray[n2];
            ChildAssociationRef child = new ChildAssociationRef(WorkflowModel.ASSOC_PACKAGE_CONTAINS, PCKG_NODE, null, nodeRef);
            results.add(child);
            ++n2;
        }
        Mockito.when((Object)this.nodeService.getChildAssocs((NodeRef)Mockito.eq((Object)PCKG_NODE), (QNamePattern)Mockito.any(), (QNamePattern)Mockito.any())).thenReturn(results);
    }

    protected void checkRemovedPackageItem(NodeRef child, boolean wasCalled) {
        int times = wasCalled ? 1 : 0;
        ((NodeService)Mockito.verify((Object)this.nodeService, (VerificationMode)Mockito.times((int)times))).removeChild(PCKG_NODE, child);
    }

    protected void checkAddPackageItem(NodeRef child, boolean wasCalled) {
        int times = wasCalled ? 1 : 0;
        ((NodeService)Mockito.verify((Object)this.nodeService, (VerificationMode)Mockito.times((int)times))).addChild((NodeRef)Mockito.eq((Object)PCKG_NODE), (NodeRef)Mockito.eq((Object)child), (QName)Mockito.eq((Object)WorkflowModel.ASSOC_PACKAGE_CONTAINS), (QName)Mockito.any());
    }

    protected void checkSingleProperty(Form form, String fieldName, Serializable fieldData) {
        String expDataKey = this.makeDataKeyName(fieldName);
        this.checkSingleField(form, fieldName, fieldData, expDataKey);
    }

    protected void checkSingleAssociation(Form form, String fieldName, Serializable fieldData) {
        String expDataKey = this.makeAssociationDataKey(fieldName);
        this.checkSingleField(form, fieldName, fieldData, expDataKey);
    }

    protected void checkSingleField(Form form, String fieldName, Serializable fieldData, String expDataKey) {
        List fieldDefs = form.getFieldDefinitions();
        FormProcessorTest.assertEquals((int)1, (int)fieldDefs.size());
        FieldDefinition fieldDef = (FieldDefinition)fieldDefs.get(0);
        FormProcessorTest.assertEquals((String)fieldName, (String)fieldDef.getName());
        String dataKey = fieldDef.getDataKeyName();
        FormProcessorTest.assertEquals((String)expDataKey, (String)dataKey);
        FormData.FieldData data = form.getFormData().getFieldData(dataKey);
        if (fieldData != null && data != null) {
            FormProcessorTest.assertEquals((Object)fieldData, (Object)data.getValue());
        } else {
            FormProcessorTest.assertNull((Object)data);
        }
    }

    protected String makeDataKeyName(String fieldName) {
        return "prop_" + fieldName.replace(":", "_");
    }

    protected String makeDataKeyName(String fieldName, boolean added) {
        String assocDataKey = this.makeAssociationDataKey(fieldName);
        String suffix = added ? "_added" : "_removed";
        return String.valueOf(assocDataKey) + suffix;
    }

    protected String makeAssociationDataKey(String fieldName) {
        return "assoc_" + fieldName.replace(":", "_");
    }

    protected Map<QName, AssociationDefinition> makeTaskAssociationDefs() {
        HashMap<QName, AssociationDefinition> associations = new HashMap<QName, AssociationDefinition>();
        QName actorName = QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"Actor");
        MockClassAttributeDefinition assigneeDef = MockClassAttributeDefinition.mockAssociationDefinition(ASSIGNEE_NAME, actorName);
        associations.put(ASSIGNEE_NAME, assigneeDef);
        MockClassAttributeDefinition actorsDef = MockClassAttributeDefinition.mockAssociationDefinition(ACTORS_NAME, actorName);
        associations.put(ACTORS_NAME, actorsDef);
        MockClassAttributeDefinition with_ = MockClassAttributeDefinition.mockAssociationDefinition(ASSOC_WITH_, actorName);
        associations.put(ASSOC_WITH_, with_);
        return associations;
    }
}

