/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.exporter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.exporter.ACPExportPackageHandler;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.view.ExportPackageHandler;
import org.alfresco.service.cmr.view.Exporter;
import org.alfresco.service.cmr.view.ExporterContext;
import org.alfresco.service.cmr.view.ExporterCrawlerParameters;
import org.alfresco.service.cmr.view.ExporterService;
import org.alfresco.service.cmr.view.ImportPackageHandler;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.debug.NodeStoreInspector;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.transaction.annotation.Transactional;

@Category(value={OwnJVMTestsCategory.class, LuceneTests.class})
@Transactional
public class ExporterComponentTest
extends BaseSpringTest {
    private NodeService nodeService;
    private ExporterService exporterService;
    private ImporterService importerService;
    private FileFolderService fileFolderService;
    private CategoryService categoryService;
    private TransactionService transactionService;
    private ContentService contentService;
    private StoreRef storeRef;
    private AuthenticationComponent authenticationComponent;
    private PermissionServiceSPI permissionService;
    private MutableAuthenticationService authenticationService;
    private Locale contentLocaleToRestore;
    private Locale localeToRestore;

    @Before
    public void before() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean(ServiceRegistry.NODE_SERVICE.getLocalName());
        this.exporterService = (ExporterService)this.applicationContext.getBean("exporterComponent");
        this.importerService = (ImporterService)this.applicationContext.getBean("importerComponent");
        this.fileFolderService = (FileFolderService)this.applicationContext.getBean("fileFolderService");
        this.categoryService = (CategoryService)this.applicationContext.getBean("categoryService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionService");
        this.permissionService = (PermissionServiceSPI)this.applicationContext.getBean("permissionService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.contentLocaleToRestore = I18NUtil.getContentLocale();
        this.localeToRestore = I18NUtil.getLocale();
    }

    @After
    public void after() {
        I18NUtil.setContentLocale((Locale)this.contentLocaleToRestore);
        I18NUtil.setLocale((Locale)this.localeToRestore);
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    @Test
    public void testExport() throws Exception {
        TestProgress testProgress = new TestProgress();
        Location location = new Location(this.storeRef);
        InputStream test = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/repo/importer/importercomponent_test.xml");
        InputStreamReader testReader = new InputStreamReader(test, "UTF-8");
        this.importerService.importView((Reader)testReader, location, null, null);
        this.dumpNodeStore(Locale.ENGLISH);
        this.dumpNodeStore(Locale.FRENCH);
        this.dumpNodeStore(Locale.GERMAN);
        location.setPath("/system");
        File tempFile = TempFileProvider.createTempFile((String)"xmlexporttest", (String)".xml");
        FileOutputStream output = new FileOutputStream(tempFile);
        ExporterCrawlerParameters parameters = new ExporterCrawlerParameters();
        parameters.setExportFrom(location);
        File acpFile = TempFileProvider.createTempFile((String)"alf", (String)"acp");
        File dataFile = new File("test");
        File contentDir = new File("test");
        ACPExportPackageHandler acpHandler = new ACPExportPackageHandler((OutputStream)new FileOutputStream(acpFile), dataFile, contentDir, null);
        acpHandler.setNodeService(this.nodeService);
        acpHandler.setExportAsFolders(true);
        this.exporterService.exportView((ExportPackageHandler)acpHandler, parameters, (Exporter)testProgress);
        ((OutputStream)output).close();
    }

    @Test
    public void testExportWithChunkedList() throws Exception {
        NodeRef nodeRef;
        TestProgress testProgress = new TestProgress();
        Location location = new Location(this.storeRef);
        String testFile = "_testFile";
        int numberOfNodesToExport = 20;
        location.setPath("/system");
        File tempFile = TempFileProvider.createTempFile((String)"xmlexporttest", (String)".xml");
        FileOutputStream output = new FileOutputStream(tempFile);
        ExporterCrawlerParameters parameters = new ExporterCrawlerParameters();
        parameters.setExportFrom(location);
        File acpFile = TempFileProvider.createTempFile((String)"alf", (String)"acp");
        File dataFile = new File("test");
        File contentDir = new File("test");
        ACPExportPackageHandler acpHandler = new ACPExportPackageHandler((OutputStream)new FileOutputStream(acpFile), dataFile, contentDir, null);
        acpHandler.setNodeService(this.nodeService);
        acpHandler.setExportAsFolders(true);
        NodeRef nodeRef2 = nodeRef = location == null ? null : location.getNodeRef();
        if (nodeRef == null) {
            nodeRef = this.nodeService.getRootNode(location.getStoreRef());
        }
        NodeRef[] childRefs = new NodeRef[numberOfNodesToExport];
        int i = 0;
        while (i < numberOfNodesToExport) {
            HashMap<QName, String> props = new HashMap<QName, String>();
            props.put(ContentModel.PROP_NAME, ((Object)((Object)this)).getClass() + testFile + i);
            childRefs[i] = this.nodeService.createNode(nodeRef, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ContentModel.TYPE_CONTENT, props).getChildRef();
            ++i;
        }
        parameters.getExportFrom().setNodeRefs(childRefs);
        parameters.setCrawlSelf(true);
        this.exporterService.setExportChunkSize("3");
        this.exporterService.exportView((ExportPackageHandler)acpHandler, parameters, (Exporter)testProgress);
        ((OutputStream)output).close();
        ZipFile zipFile = new ZipFile(acpFile.getAbsolutePath());
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        int numberOfExportedNodes = 0;
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            InputStream stream = zipFile.getInputStream(entry);
            Throwable throwable = null;
            Object var20_23 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (!line.contains(testFile)) continue;
                    ++numberOfExportedNodes;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            stream.close();
        }
        zipFile.close();
        ExporterComponentTest.assertEquals((int)numberOfNodesToExport, (int)numberOfExportedNodes);
        parameters.getExportFrom().setNodeRefs(null);
        int i2 = 0;
        while (i2 < numberOfNodesToExport) {
            this.nodeService.deleteNode(childRefs[i2]);
            ++i2;
        }
    }

    @Category(value={RedundantTests.class})
    @Test
    public void testRoundTripKeepsCategoriesWhenWithinSameStore() throws Exception {
        StoreRef storeRef = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
        NodeRef rootNode = this.nodeService.getRootNode(storeRef);
        ChildAssociationRef contentChildAssocRef = this.createContentWithCategories(storeRef, rootNode);
        File acpFile = this.exportContent(contentChildAssocRef.getParentRef());
        FileInfo importFolderFileInfo = this.importContent(acpFile, rootNode);
        NodeRef importedFileNode = this.fileFolderService.searchSimple(importFolderFileInfo.getNodeRef(), "test.txt");
        ExporterComponentTest.assertNotNull((String)"Couldn't find imported file: test.txt", (Object)importedFileNode);
        ExporterComponentTest.assertTrue((boolean)this.nodeService.hasAspect(importedFileNode, ContentModel.ASPECT_GEN_CLASSIFIABLE));
        List importedFileCategories = (List)((Object)this.nodeService.getProperty(importedFileNode, ContentModel.PROP_CATEGORIES));
        this.assertCategoriesEqual(importedFileCategories, "Regions", "Software Document Classification");
    }

    @Category(value={RedundantTests.class})
    @Test
    public void testRoundTripLosesCategoriesImportingToDifferentStore() throws Exception {
        StoreRef storeRef = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
        NodeRef rootNode = this.nodeService.getRootNode(storeRef);
        ChildAssociationRef contentChildAssocRef = this.createContentWithCategories(storeRef, rootNode);
        File acpFile = this.exportContent(contentChildAssocRef.getParentRef());
        NodeRef destRootNode = this.nodeService.getRootNode(this.storeRef);
        FileInfo importFolderFileInfo = this.importContent(acpFile, destRootNode);
        NodeRef importedFileNode = this.fileFolderService.searchSimple(importFolderFileInfo.getNodeRef(), "test.txt");
        ExporterComponentTest.assertNotNull((String)"Couldn't find imported file: test.txt", (Object)importedFileNode);
        ExporterComponentTest.assertTrue((boolean)this.nodeService.hasAspect(importedFileNode, ContentModel.ASPECT_GEN_CLASSIFIABLE));
        List importedFileCategories = (List)((Object)this.nodeService.getProperty(importedFileNode, ContentModel.PROP_CATEGORIES));
        ExporterComponentTest.assertEquals((String)"No categories should have been imported for the content", (int)0, (int)importedFileCategories.size());
    }

    @Test
    public void testMLText() throws Exception {
        NodeRef rootNode = this.nodeService.getRootNode(this.storeRef);
        NodeRef folderNodeRef = this.nodeService.createNode(rootNode, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER).getChildRef();
        FileInfo exportFolder = this.fileFolderService.create(folderNodeRef, "export", ContentModel.TYPE_FOLDER);
        FileInfo content = this.fileFolderService.create(exportFolder.getNodeRef(), "file", ContentModel.TYPE_CONTENT);
        MLText title = new MLText();
        title.addValue(Locale.ENGLISH, null);
        title.addValue(Locale.FRENCH, "bonjour");
        this.nodeService.setProperty(content.getNodeRef(), ContentModel.PROP_TITLE, (Serializable)title);
        this.nodeService.setProperty(content.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)"file"));
        FileInfo importFolder = this.fileFolderService.create(folderNodeRef, "import", ContentModel.TYPE_FOLDER);
        File acpFile = this.exportContent(exportFolder.getNodeRef());
        FileInfo importFolderFileInfo = this.importContent(acpFile, importFolder.getNodeRef());
        ExporterComponentTest.assertNotNull((Object)importFolderFileInfo);
        NodeRef importedFileNode = this.fileFolderService.searchSimple(importFolderFileInfo.getNodeRef(), "file");
        ExporterComponentTest.assertNotNull((String)"Couldn't find imported file: file", (Object)importedFileNode);
        Locale currentLocale = I18NUtil.getContentLocale();
        try {
            I18NUtil.setContentLocale((Locale)Locale.ENGLISH);
            String importedTitle = (String)((Object)this.nodeService.getProperty(importedFileNode, ContentModel.PROP_TITLE));
            ExporterComponentTest.assertNull((Object)importedTitle);
            I18NUtil.setContentLocale((Locale)Locale.FRENCH);
            importedTitle = (String)((Object)this.nodeService.getProperty(importedFileNode, ContentModel.PROP_TITLE));
            ExporterComponentTest.assertNotNull((Object)importedTitle);
            ExporterComponentTest.assertEquals((String)"bonjour", (String)importedTitle);
        }
        finally {
            I18NUtil.setContentLocale((Locale)currentLocale);
        }
    }

    @Test
    public void testMNT12504() throws Exception {
        boolean isFixed;
        block6: {
            String testUser = "testUserMnt12504";
            StoreRef storeRef = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
            NodeRef rootNode = this.nodeService.getRootNode(storeRef);
            NodeRef folder = this.fileFolderService.create(rootNode, String.valueOf(((Object)((Object)this)).getClass().getName()) + "testMNT12504" + GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef docA = this.nodeService.createNode(folder, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, Collections.singletonMap(ContentModel.PROP_NAME, "docA.txt")).getChildRef();
            NodeRef docB = this.nodeService.createNode(folder, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, Collections.singletonMap(ContentModel.PROP_NAME, "docB.txt")).getChildRef();
            this.nodeService.createAssociation(docA, docB, ContentModel.ASSOC_REFERENCES);
            this.permissionService.setPermission(folder, testUser, "Read", true);
            this.permissionService.setInheritParentPermissions(folder, false);
            this.permissionService.setPermission(docA, testUser, "Read", true);
            this.permissionService.setPermission(docB, testUser, "Read", false);
            if (!this.authenticationService.authenticationExists(testUser)) {
                this.authenticationService.createAuthentication(testUser, testUser.toCharArray());
            }
            this.authenticationComponent.authenticate(testUser, testUser.toCharArray());
            ExporterComponentTest.assertTrue((boolean)this.authenticationComponent.getCurrentUserName().equals(testUser));
            ExporterComponentTest.assertTrue((boolean)this.permissionService.hasPermission(folder, "Read").equals((Object)AccessStatus.ALLOWED));
            ExporterComponentTest.assertTrue((boolean)this.permissionService.hasPermission(docA, "Read").equals((Object)AccessStatus.ALLOWED));
            ExporterComponentTest.assertTrue((boolean)this.permissionService.hasPermission(docB, "Read").equals((Object)AccessStatus.DENIED));
            ExporterCrawlerParameters crawlerParameters = new ExporterCrawlerParameters();
            crawlerParameters.setExportFrom(new Location(folder));
            crawlerParameters.setCrawlSelf(true);
            crawlerParameters.setExcludeAspects(new QName[]{ContentModel.ASPECT_WORKING_COPY});
            File acpFile = TempFileProvider.createTempFile((String)"alf", (String)"acp");
            ACPExportPackageHandler acpHandler = new ACPExportPackageHandler((OutputStream)new FileOutputStream(acpFile), new File("test"), new File("test"), null);
            acpHandler.setNodeService(this.nodeService);
            acpHandler.setExportAsFolders(true);
            isFixed = true;
            try {
                try {
                    this.exporterService.exportView((ExportPackageHandler)acpHandler, crawlerParameters, null);
                }
                catch (AccessDeniedException accessDeniedException) {
                    isFixed = false;
                    this.authenticationComponent.setSystemUserAsCurrentUser();
                    this.nodeService.deleteNode(folder);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.authenticationComponent.setSystemUserAsCurrentUser();
                this.nodeService.deleteNode(folder);
                throw throwable;
            }
            this.authenticationComponent.setSystemUserAsCurrentUser();
            this.nodeService.deleteNode(folder);
        }
        ExporterComponentTest.assertTrue((String)"The MNT12504 is reproduced.", (boolean)isFixed);
    }

    private File exportContent(NodeRef nodeRef) throws FileNotFoundException, IOException {
        TestProgress testProgress = new TestProgress();
        Location location = new Location(nodeRef);
        ExporterCrawlerParameters parameters = new ExporterCrawlerParameters();
        parameters.setExportFrom(location);
        File acpFile = TempFileProvider.createTempFile((String)"category-export-test", (String)"acp");
        System.out.println("Exporting to file: " + acpFile.getAbsolutePath());
        File dataFile = new File("test-data-file");
        File contentDir = new File("test-content-dir");
        FileOutputStream fos = new FileOutputStream(acpFile);
        ACPExportPackageHandler acpHandler = new ACPExportPackageHandler((OutputStream)fos, dataFile, contentDir, null);
        acpHandler.setNodeService(this.nodeService);
        acpHandler.setExportAsFolders(true);
        this.exporterService.exportView((ExportPackageHandler)acpHandler, parameters, (Exporter)testProgress);
        ((OutputStream)fos).close();
        return acpFile;
    }

    private ChildAssociationRef createContentWithCategories(StoreRef storeRef, NodeRef rootNode) {
        Collection assocRefs = this.categoryService.getRootCategories(storeRef, ContentModel.ASPECT_GEN_CLASSIFIABLE);
        ExporterComponentTest.assertTrue((String)"Pre-condition failure: not enough categories", (assocRefs.size() >= 2 ? 1 : 0) != 0);
        Iterator it = assocRefs.iterator();
        NodeRef softwareDocCategoryNode = ((ChildAssociationRef)it.next()).getChildRef();
        it.next();
        NodeRef regionsCategoryNode = ((ChildAssociationRef)it.next()).getChildRef();
        FileInfo exportFileInfo = this.fileFolderService.create(rootNode, "Export Folder", ContentModel.TYPE_FOLDER);
        Map<QName, String> properties = Collections.singletonMap(ContentModel.PROP_NAME, "test.txt");
        ChildAssociationRef contentChildAssocRef = this.nodeService.createNode(exportFileInfo.getNodeRef(), ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, properties);
        NodeRef contentNodeRef = contentChildAssocRef.getChildRef();
        ArrayList<NodeRef> categories = new ArrayList<NodeRef>(2);
        categories.add(softwareDocCategoryNode);
        categories.add(regionsCategoryNode);
        if (!this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_GEN_CLASSIFIABLE)) {
            HashMap<QName, ArrayList<NodeRef>> props = new HashMap<QName, ArrayList<NodeRef>>();
            props.put(ContentModel.PROP_CATEGORIES, categories);
            this.nodeService.addAspect(contentNodeRef, ContentModel.ASPECT_GEN_CLASSIFIABLE, props);
        } else {
            this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_CATEGORIES, categories);
        }
        return contentChildAssocRef;
    }

    private FileInfo importContent(File acpFile, NodeRef destRootNode) {
        FileInfo importFolderFileInfo = this.fileFolderService.create(destRootNode, "Import Folder", ContentModel.TYPE_FOLDER);
        ACPImportPackageHandler importHandler = new ACPImportPackageHandler(acpFile, "UTF-8");
        this.importerService.importView((ImportPackageHandler)importHandler, new Location(importFolderFileInfo.getNodeRef()), null, null);
        return importFolderFileInfo;
    }

    private void assertCategoriesEqual(List<NodeRef> categories, String ... expectedCategoryNames) {
        ExporterComponentTest.assertEquals((String)"Number of categories is not as expected.", (int)expectedCategoryNames.length, (int)categories.size());
        ArrayList<String> categoryNames = new ArrayList<String>(10);
        for (NodeRef nodeRef : categories) {
            String name = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            categoryNames.add(name);
        }
        Collections.sort(categoryNames);
        int i = 0;
        while (i < expectedCategoryNames.length) {
            ExporterComponentTest.assertEquals((String)expectedCategoryNames[i], (String)((String)categoryNames.get(i)));
            ++i;
        }
    }

    private void dumpNodeStore(Locale locale) {
        System.out.println(String.valueOf(locale.getDisplayLanguage()) + " LOCALE: ");
        I18NUtil.setLocale((Locale)locale);
        System.out.println(NodeStoreInspector.dumpNodeStore((NodeService)((NodeService)this.applicationContext.getBean("NodeService")), (StoreRef)this.storeRef));
    }

    private static class TestProgress
    implements Exporter {
        private TestProgress() {
        }

        public void start(ExporterContext exportNodeRef) {
            System.out.println("TestProgress: start");
        }

        public void startNamespace(String prefix, String uri) {
        }

        public void endNamespace(String prefix) {
        }

        public void startNode(NodeRef nodeRef) {
            System.out.println("TestProgress: start node " + nodeRef);
        }

        public void endNode(NodeRef nodeRef) {
        }

        public void startAspect(NodeRef nodeRef, QName aspect) {
        }

        public void endAspect(NodeRef nodeRef, QName aspect) {
        }

        public void startProperty(NodeRef nodeRef, QName property) {
        }

        public void endProperty(NodeRef nodeRef, QName property) {
        }

        public void startValueCollection(NodeRef nodeRef, QName property) {
        }

        public void endValueCollection(NodeRef nodeRef, QName property) {
        }

        public void value(NodeRef nodeRef, QName property, Object value, int index) {
        }

        public void content(NodeRef nodeRef, QName property, InputStream content, ContentData contentData, int index) {
        }

        public void startAssoc(NodeRef nodeRef, QName assoc) {
        }

        public void endAssoc(NodeRef nodeRef, QName assoc) {
        }

        public void warning(String warning) {
            System.out.println("TestProgress: warning " + warning);
        }

        public void end() {
            System.out.println("TestProgress: end");
        }

        public void startProperties(NodeRef nodeRef) {
        }

        public void endProperties(NodeRef nodeRef) {
        }

        public void startAspects(NodeRef nodeRef) {
        }

        public void endAspects(NodeRef nodeRef) {
        }

        public void startAssocs(NodeRef nodeRef) {
        }

        public void endAssocs(NodeRef nodeRef) {
        }

        public void startACL(NodeRef nodeRef) {
        }

        public void permission(NodeRef nodeRef, AccessPermission permission) {
        }

        public void endACL(NodeRef nodeRef) {
        }

        public void startReference(NodeRef nodeRef, QName childName) {
        }

        public void endReference(NodeRef nodeRef) {
        }

        public void endValueMLText(NodeRef nodeRef) {
        }

        public void startValueMLText(NodeRef nodeRef, Locale locale, boolean isNull) {
        }
    }
}

