/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.download;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.acegisecurity.Authentication;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.download.DownloadModel;
import org.alfresco.repo.download.DownloadStorage;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.node.SystemNodeUtils;
import org.alfresco.repo.node.integrity.IntegrityChecker;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.download.DownloadService;
import org.alfresco.service.cmr.download.DownloadStatus;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.TemporaryNodes;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@Category(value={OwnJVMTestsCategory.class})
public class DownloadServiceIntegrationTest {
    public static final long MAX_TIME = 5000L;
    private static final long PAUSE_TIME = 1000L;
    public static ApplicationContextInit APP_CONTEXT_INIT = new ApplicationContextInit();
    public static AlfrescoPerson TEST_USER = new AlfrescoPerson(APP_CONTEXT_INIT, "User");
    public static AlfrescoPerson TEST_USER2 = new AlfrescoPerson(APP_CONTEXT_INIT, "User 2");
    public static String TEST_USER_NAME = "some-user";
    public static TemporaryNodes STATIC_TEST_NODES = new TemporaryNodes(APP_CONTEXT_INIT);
    @ClassRule
    public static RuleChain ruleChain = RuleChain.outerRule((TestRule)APP_CONTEXT_INIT).around((TestRule)TEST_USER).around((TestRule)STATIC_TEST_NODES);
    @Rule
    public TemporaryNodes testNodes = new TemporaryNodes(APP_CONTEXT_INIT);
    public static DownloadService DOWNLOAD_SERVICE;
    private static DownloadStorage DOWNLOAD_STORAGE;
    private static CheckOutCheckInService CHECK_OUT_CHECK_IN_SERVICE;
    private static ContentService CONTENT_SERVICE;
    private static NodeService NODE_SERVICE;
    private static PermissionService PERMISSION_SERVICE;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private static IntegrityChecker INTEGRITY_CHECKER;
    private static RepoAdminService REPO_ADMIN_SERVICE;
    private static RuleService RULE_SERVICE;
    private static ActionService ACTION_SERVICE;
    private NodeRef rootFolder;
    private NodeRef rootFile;
    private NodeRef secondaryNode;
    private NodeRef level1Folder1;
    private NodeRef level1Folder2;
    private Set<String> allEntries;
    private NodeRef fileToCheckout;
    private static final String CUSTOM_FOLDER_MODEL_XML = "<model name=\"custom:customModel\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Custom Model</description>   <author></author>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>      <import uri=\"http://www.alfresco.org/model/content/1.0\" prefix=\"cm\"/>   </imports>   <namespaces>      <namespace uri=\"custom.model\" prefix=\"custom\"/>   </namespaces>   <types>      <type name=\"custom:folderx\">         <title>Custom FolderX</title>         <parent>cm:folder</parent>         <properties>            <property name=\"custom:invoice\">               <type>d:text</type>            </property>         </properties>         <associations>         </associations>      </type>   </types>   <aspects>   </aspects></model>";

    @BeforeClass
    public static void init() {
        CHECK_OUT_CHECK_IN_SERVICE = (CheckOutCheckInService)APP_CONTEXT_INIT.getApplicationContext().getBean("CheckOutCheckInService", CheckOutCheckInService.class);
        CONTENT_SERVICE = (ContentService)APP_CONTEXT_INIT.getApplicationContext().getBean("contentService", ContentService.class);
        DOWNLOAD_SERVICE = (DownloadService)APP_CONTEXT_INIT.getApplicationContext().getBean("DownloadService", DownloadService.class);
        DOWNLOAD_STORAGE = (DownloadStorage)APP_CONTEXT_INIT.getApplicationContext().getBean("downloadStorage", DownloadStorage.class);
        NODE_SERVICE = (NodeService)APP_CONTEXT_INIT.getApplicationContext().getBean("NodeService", NodeService.class);
        PERMISSION_SERVICE = (PermissionService)APP_CONTEXT_INIT.getApplicationContext().getBean("PermissionService", PermissionService.class);
        TRANSACTION_HELPER = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        INTEGRITY_CHECKER = (IntegrityChecker)APP_CONTEXT_INIT.getApplicationContext().getBean("integrityChecker", IntegrityChecker.class);
        INTEGRITY_CHECKER.setEnabled(true);
        INTEGRITY_CHECKER.setFailOnViolation(true);
        INTEGRITY_CHECKER.setTraceOn(true);
        REPO_ADMIN_SERVICE = (RepoAdminService)APP_CONTEXT_INIT.getApplicationContext().getBean("RepoAdminService", RepoAdminService.class);
        RULE_SERVICE = (RuleService)APP_CONTEXT_INIT.getApplicationContext().getBean("ruleService", RuleService.class);
        ACTION_SERVICE = (ActionService)APP_CONTEXT_INIT.getApplicationContext().getBean("actionService", ActionService.class);
    }

    @Before
    public void createContent() {
        this.allEntries = new TreeSet<String>();
        AuthenticationUtil.setRunAsUserSystem();
        Repository repositoryHelper = (Repository)APP_CONTEXT_INIT.getApplicationContext().getBean("repositoryHelper");
        NodeRef COMPANY_HOME = repositoryHelper.getCompanyHome();
        this.rootFolder = this.testNodes.createNode(COMPANY_HOME, "rootFolder", ContentModel.TYPE_FOLDER, AuthenticationUtil.getAdminUserName());
        this.allEntries.add("rootFolder/");
        TRANSACTION_HELPER.doInTransaction(() -> {
            org.alfresco.service.cmr.rule.Rule parentRule = new org.alfresco.service.cmr.rule.Rule();
            parentRule.setRuleTypes(Collections.singletonList("inbound"));
            parentRule.setTitle("DownloadServiceIntegrationTest" + GUID.generate());
            parentRule.setDescription("Add Classifiable");
            Action action = ACTION_SERVICE.createAction("add-features");
            action.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_CLASSIFIABLE);
            parentRule.setAction(action);
            parentRule.applyToChildren(true);
            RULE_SERVICE.saveRule(this.rootFolder, parentRule);
            return null;
        }, false, true);
        this.rootFile = this.testNodes.createNodeWithTextContent(COMPANY_HOME, "rootFile.txt", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName(), "Root file content");
        this.allEntries.add("rootFile.txt");
        NodeRef createdNode = this.testNodes.createNodeWithTextContent(this.rootFolder, "level1File.txt", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName(), "Level 1 file content");
        Assert.assertTrue((boolean)NODE_SERVICE.hasAspect(createdNode, ContentModel.ASPECT_CLASSIFIABLE));
        this.allEntries.add("rootFolder/level1File.txt");
        this.level1Folder1 = this.testNodes.createNode(this.rootFolder, "level1Folder1", ContentModel.TYPE_FOLDER, AuthenticationUtil.getAdminUserName());
        Assert.assertTrue((boolean)NODE_SERVICE.hasAspect(this.level1Folder1, ContentModel.ASPECT_CLASSIFIABLE));
        this.allEntries.add("rootFolder/level1Folder1/");
        this.level1Folder2 = this.testNodes.createNode(this.rootFolder, "level1Folder2", ContentModel.TYPE_FOLDER, AuthenticationUtil.getAdminUserName());
        Assert.assertTrue((boolean)NODE_SERVICE.hasAspect(this.level1Folder2, ContentModel.ASPECT_CLASSIFIABLE));
        this.allEntries.add("rootFolder/level1Folder2/");
        createdNode = this.testNodes.createNode(this.rootFolder, "level1EmptyFolder", ContentModel.TYPE_FOLDER, AuthenticationUtil.getAdminUserName());
        Assert.assertTrue((boolean)NODE_SERVICE.hasAspect(createdNode, ContentModel.ASPECT_CLASSIFIABLE));
        this.allEntries.add("rootFolder/level1EmptyFolder/");
        createdNode = this.testNodes.createNodeWithTextContent(this.level1Folder1, "level2File.txt", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName(), "Level 2 file content");
        Assert.assertTrue((boolean)NODE_SERVICE.hasAspect(createdNode, ContentModel.ASPECT_CLASSIFIABLE));
        this.allEntries.add("rootFolder/level1Folder1/level2File.txt");
        createdNode = this.testNodes.createNodeWithTextContent(this.level1Folder2, "level2File.txt", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName(), "Level 2 file content");
        Assert.assertTrue((boolean)NODE_SERVICE.hasAspect(createdNode, ContentModel.ASPECT_CLASSIFIABLE));
        this.allEntries.add("rootFolder/level1Folder2/level2File.txt");
        this.secondaryNode = this.testNodes.createNodeWithTextContent(COMPANY_HOME, "secondaryNodeFile.txt", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName(), "Secondary node");
        ChildAssociationRef assoc = NODE_SERVICE.addChild(this.rootFolder, this.secondaryNode, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS);
        Assert.assertFalse((boolean)assoc.isPrimary());
        this.allEntries.add("rootFolder/secondaryNodeFile.txt");
        this.fileToCheckout = this.testNodes.createNodeWithTextContent(this.level1Folder2, "fileToCheckout.txt", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName(), "Level 2 file content");
        NODE_SERVICE.addAspect(this.fileToCheckout, ContentModel.ASPECT_VERSIONABLE, null);
        NODE_SERVICE.addAspect(this.fileToCheckout, ContentModel.ASPECT_LOCKABLE, null);
        Assert.assertTrue((boolean)NODE_SERVICE.hasAspect(this.fileToCheckout, ContentModel.ASPECT_CLASSIFIABLE));
        this.allEntries.add("rootFolder/level1Folder2/fileToCheckout.txt");
        PERMISSION_SERVICE.setPermission(this.level1Folder2, TEST_USER.getUsername(), "All", true);
        PERMISSION_SERVICE.setPermission(this.fileToCheckout, TEST_USER.getUsername(), "All", true);
        ByteArrayInputStream modelStream = null;
        try {
            modelStream = new ByteArrayInputStream(CUSTOM_FOLDER_MODEL_XML.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        REPO_ADMIN_SERVICE.deployModel((InputStream)modelStream, "model-MNT-21671.xml");
        QName customFolderType = QName.createQName((String)"{custom.model}folderx");
        this.testNodes.createNode(this.rootFolder, "level1CustomFolder", customFolderType, AuthenticationUtil.getAdminUserName());
        this.allEntries.add("rootFolder/level1CustomFolder/");
    }

    @Test
    public void createDownload() throws IOException, InterruptedException {
        final NodeRef downloadNode = DOWNLOAD_SERVICE.createDownload(new NodeRef[]{this.rootFile, this.rootFolder}, true);
        Assert.assertNotNull((Object)downloadNode);
        this.testNodes.addNodeRef(downloadNode);
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                Map properties = NODE_SERVICE.getProperties(downloadNode);
                Assert.assertEquals((Object)Boolean.TRUE, properties.get(DownloadModel.PROP_RECURSIVE));
                List associations = NODE_SERVICE.getTargetAssocs(downloadNode, (QNamePattern)DownloadModel.ASSOC_REQUESTED_NODES);
                for (AssociationRef association : associations) {
                    Assert.assertTrue((association.getTargetRef().equals((Object)DownloadServiceIntegrationTest.this.rootFile) || association.getTargetRef().equals((Object)DownloadServiceIntegrationTest.this.rootFolder) ? 1 : 0) != 0);
                }
                Assert.assertTrue((boolean)NODE_SERVICE.hasAspect(downloadNode, ContentModel.ASPECT_INDEX_CONTROL));
                Assert.assertEquals((Object)Boolean.FALSE, properties.get(ContentModel.PROP_IS_INDEXED));
                Assert.assertEquals((Object)Boolean.FALSE, properties.get(ContentModel.PROP_IS_CONTENT_INDEXED));
                return null;
            }
        });
        DownloadStatus status = this.getDownloadStatus(downloadNode);
        while (status.getStatus() == DownloadStatus.Status.PENDING) {
            Thread.sleep(1000L);
            status = this.getDownloadStatus(downloadNode);
        }
        Assert.assertEquals((long)6L, (long)status.getTotalFiles());
        long elapsedTime = this.waitForDownload(downloadNode);
        Assert.assertTrue((String)"Maximum creation time exceeded!", (elapsedTime < 5000L ? 1 : 0) != 0);
        Set<String> entryNames = this.getEntries(downloadNode);
        this.validateEntries(entryNames, this.allEntries, true);
    }

    @Test
    public void createDownloadWithName() throws IOException, InterruptedException {
        final NodeRef downloadNode = DOWNLOAD_SERVICE.createDownload(new NodeRef[]{this.rootFile}, false, "test.zip");
        Assert.assertNotNull((Object)downloadNode);
        this.testNodes.addNodeRef(downloadNode);
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                Map properties = NODE_SERVICE.getProperties(downloadNode);
                Assert.assertEquals((Object)Boolean.FALSE, properties.get(DownloadModel.PROP_RECURSIVE));
                Assert.assertEquals((Object)"test.zip", properties.get(ContentModel.PROP_NAME));
                return null;
            }
        });
    }

    private void validateEntries(Set<String> entryNames, Set<String> expectedEntries, boolean onlyExpected) {
        TreeSet<String> copy = new TreeSet<String>(entryNames);
        for (String expectedEntry : expectedEntries) {
            Assert.assertTrue((String)("Missing entry:- " + expectedEntry), (boolean)copy.contains(expectedEntry));
            copy.remove(expectedEntry);
        }
        if (onlyExpected) {
            Assert.assertTrue((String)"Unexpected entries", (boolean)copy.isEmpty());
        }
    }

    private Set<String> getEntries(final NodeRef downloadNode) {
        return (Set)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Set<String>>(){

            public Set<String> execute() throws Throwable {
                TreeSet<String> entryNames = new TreeSet<String>();
                ContentReader reader = CONTENT_SERVICE.getReader(downloadNode, ContentModel.PROP_CONTENT);
                try (ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream(reader.getContentInputStream());){
                    ZipArchiveEntry zipEntry = zipInputStream.getNextZipEntry();
                    while (zipEntry != null) {
                        String name = zipEntry.getName();
                        entryNames.add(name);
                        zipEntry = zipInputStream.getNextZipEntry();
                    }
                }
                return entryNames;
            }
        });
    }

    private long waitForDownload(NodeRef downloadNode) throws InterruptedException {
        long elapsedTime;
        DownloadStatus status;
        long startTime = System.currentTimeMillis();
        do {
            status = this.getDownloadStatus(downloadNode);
            elapsedTime = System.currentTimeMillis() - startTime;
            if (status.isComplete()) continue;
            Thread.sleep(1000L);
        } while (!status.isComplete() && elapsedTime < 5000L);
        return elapsedTime;
    }

    private DownloadStatus getDownloadStatus(final NodeRef downloadNode) {
        return (DownloadStatus)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<DownloadStatus>(){

            public DownloadStatus execute() throws Throwable {
                return DOWNLOAD_SERVICE.getDownloadStatus(downloadNode);
            }
        });
    }

    @Test
    public void deleteBeforeDateAsSystem() throws InterruptedException {
        NodeRef beforeNodeRef = DOWNLOAD_SERVICE.createDownload(new NodeRef[]{this.level1Folder1}, true);
        this.testNodes.addNodeRef(beforeNodeRef);
        this.waitForDownload(beforeNodeRef);
        Date beforeTime = new Date();
        NodeRef afterNodeRef = DOWNLOAD_SERVICE.createDownload(new NodeRef[]{this.level1Folder2}, true);
        this.testNodes.addNodeRef(afterNodeRef);
        this.waitForDownload(afterNodeRef);
        DOWNLOAD_SERVICE.deleteDownloads(beforeTime);
        Assert.assertFalse((boolean)NODE_SERVICE.exists(beforeNodeRef));
        Assert.assertTrue((boolean)NODE_SERVICE.exists(afterNodeRef));
    }

    @Test
    public void deleteBeforeDateAsNormalUser() throws InterruptedException {
        NodeRef afterNodeRef;
        Date beforeTime;
        NodeRef beforeNodeRef;
        String randomUsername = this.createRandomUser();
        Authentication previousAuth = AuthenticationUtil.getFullAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)randomUsername);
        try {
            beforeNodeRef = DOWNLOAD_SERVICE.createDownload(new NodeRef[]{this.level1Folder1}, true);
            this.testNodes.addNodeRef(beforeNodeRef);
            this.waitForDownload(beforeNodeRef);
            beforeTime = new Date();
            afterNodeRef = DOWNLOAD_SERVICE.createDownload(new NodeRef[]{this.level1Folder2}, true);
            this.testNodes.addNodeRef(afterNodeRef);
            this.waitForDownload(afterNodeRef);
        }
        finally {
            AuthenticationUtil.setFullAuthentication((Authentication)previousAuth);
        }
        DOWNLOAD_SERVICE.deleteDownloads(beforeTime, 1000, false);
        Assert.assertFalse((boolean)NODE_SERVICE.exists(beforeNodeRef));
        Assert.assertTrue((boolean)NODE_SERVICE.exists(afterNodeRef));
    }

    @Test
    public void deleteBeforeDateAsNormalUserFromAllSysDownloadFolders() throws InterruptedException {
        String randomUsername = this.createRandomUser();
        NamespaceService namespaceService = (NamespaceService)APP_CONTEXT_INIT.getApplicationContext().getBean("namespaceService", NamespaceService.class);
        Repository repositoryHelper = (Repository)APP_CONTEXT_INIT.getApplicationContext().getBean("repositoryHelper", Repository.class);
        FileFolderService fileFolderService = (FileFolderService)APP_CONTEXT_INIT.getApplicationContext().getBean("fileFolderService", FileFolderService.class);
        QName container = QName.createQName((String)"sys:downloads", (NamespacePrefixResolver)namespaceService);
        NodeRef problematicDuplicateSystemDownloadNode = this.createProblematicDuplicateSystemNode(container, NODE_SERVICE, repositoryHelper);
        try {
            NodeRef afterNodeRef;
            Date beforeTime;
            NodeRef beforeNodeRef;
            Assert.assertNotEquals((Object)problematicDuplicateSystemDownloadNode.getId(), (Object)"sys:downloads");
            Assert.assertNotEquals((Object)problematicDuplicateSystemDownloadNode.getId(), (Object)"downloads_container");
            Authentication previousAuth = AuthenticationUtil.getFullAuthentication();
            AuthenticationUtil.setFullyAuthenticatedUser((String)randomUsername);
            try {
                beforeNodeRef = DOWNLOAD_SERVICE.createDownload(new NodeRef[]{this.level1Folder1}, true);
                this.testNodes.addNodeRef(beforeNodeRef);
                this.waitForDownload(beforeNodeRef);
                beforeTime = new Date();
                afterNodeRef = DOWNLOAD_SERVICE.createDownload(new NodeRef[]{this.level1Folder2}, true);
                this.testNodes.addNodeRef(afterNodeRef);
                this.waitForDownload(afterNodeRef);
            }
            finally {
                AuthenticationUtil.setFullAuthentication((Authentication)previousAuth);
            }
            this.moveDownloadedFileToProblematicFolder(fileFolderService, problematicDuplicateSystemDownloadNode, beforeNodeRef);
            this.deleteDownloadsAndCheckParameters(beforeNodeRef, afterNodeRef, beforeTime);
        }
        finally {
            this.cleanProblematicFolder(problematicDuplicateSystemDownloadNode);
        }
    }

    private void deleteDownloadsAndCheckParameters(final NodeRef beforeNodeRef, final NodeRef afterNodeRef, final Date beforeTime) {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() {
                DOWNLOAD_SERVICE.deleteDownloads(beforeTime, 1000, false);
                Assert.assertTrue((boolean)NODE_SERVICE.exists(beforeNodeRef));
                Assert.assertTrue((boolean)NODE_SERVICE.exists(afterNodeRef));
                DOWNLOAD_SERVICE.deleteDownloads(beforeTime, 1000, true);
                Assert.assertTrue((boolean)NODE_SERVICE.exists(beforeNodeRef));
                Assert.assertTrue((boolean)NODE_SERVICE.exists(afterNodeRef));
                Date newBeforeTime = new Date();
                DOWNLOAD_SERVICE.deleteDownloads(newBeforeTime, 1000, true);
                Assert.assertFalse((boolean)NODE_SERVICE.exists(beforeNodeRef));
                Assert.assertFalse((boolean)NODE_SERVICE.exists(afterNodeRef));
                return null;
            }
        }, false, true);
    }

    private void moveDownloadedFileToProblematicFolder(final FileFolderService fileFolderService, final NodeRef problematicDuplicateSystemDownloadNode, final NodeRef beforeNodeRef) {
        FileInfo fileInfo = (FileInfo)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

            public FileInfo execute() {
                try {
                    return fileFolderService.move(beforeNodeRef, problematicDuplicateSystemDownloadNode, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                    return null;
                }
            }
        }, false, true);
        if (fileInfo == null) {
            Assert.fail((String)"The node move should have succeeded");
        }
    }

    private String createRandomUser() {
        final String randomUsername = String.valueOf(TEST_USER_NAME) + GUID.generate();
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() {
                DownloadServiceIntegrationTest.this.createUser(randomUsername);
                return null;
            }
        }, false, true);
        return randomUsername;
    }

    private NodeRef createProblematicDuplicateSystemNode(final QName childName, final NodeService nodeService, final Repository repositoryHelper) {
        return (NodeRef)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() {
                return (NodeRef)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                    public NodeRef doWork() throws Exception {
                        NodeRef system = SystemNodeUtils.getSystemContainer((NodeService)nodeService, (Repository)repositoryHelper);
                        NodeRef container = nodeService.createNode(system, ContentModel.ASSOC_CHILDREN, childName, ContentModel.TYPE_CONTAINER).getChildRef();
                        nodeService.setProperty(container, ContentModel.PROP_NAME, (Serializable)((Object)childName.getLocalName()));
                        return container;
                    }
                });
            }
        }, false, true);
    }

    private void cleanProblematicFolder(final NodeRef problematicDuplicateSystemDownloadNode) {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() {
                NODE_SERVICE.deleteNode(problematicDuplicateSystemDownloadNode);
                return null;
            }
        }, false, true);
    }

    @Test
    public void cancel() throws InterruptedException {
        NodeRef downloadNode = DOWNLOAD_SERVICE.createDownload(new NodeRef[]{this.rootFile, this.rootFolder}, true);
        Assert.assertNotNull((Object)downloadNode);
        this.testNodes.addNodeRef(downloadNode);
        DOWNLOAD_SERVICE.cancelDownload(downloadNode);
        DownloadStatus status = this.getDownloadStatus(downloadNode);
        int retryCount = 0;
        while (status.getStatus() != DownloadStatus.Status.CANCELLED && retryCount < 5) {
            ++retryCount;
            Thread.sleep(1000L);
            status = this.getDownloadStatus(downloadNode);
        }
        Assert.assertEquals((Object)DownloadStatus.Status.CANCELLED, (Object)status.getStatus());
    }

    @Test
    public void workingCopies() throws InterruptedException {
        NodeRef workingCopy;
        TreeSet<String> preCheckoutExpectedEntries = new TreeSet<String>();
        preCheckoutExpectedEntries.add("level1Folder2/");
        preCheckoutExpectedEntries.add("level1Folder2/level2File.txt");
        preCheckoutExpectedEntries.add("level1Folder2/fileToCheckout.txt");
        this.validateWorkingCopyFolder(preCheckoutExpectedEntries, this.level1Folder2, TEST_USER.getUsername());
        this.validateWorkingCopyFolder(preCheckoutExpectedEntries, this.level1Folder2, TEST_USER2.getUsername());
        Authentication previousAuth = AuthenticationUtil.getFullAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER.getUsername());
        try {
            workingCopy = CHECK_OUT_CHECK_IN_SERVICE.checkout(this.fileToCheckout);
        }
        finally {
            AuthenticationUtil.setFullAuthentication((Authentication)previousAuth);
        }
        try {
            this.validateWorkingCopyFolder(preCheckoutExpectedEntries, this.level1Folder2, TEST_USER2.getUsername());
            TreeSet<String> postCheckoutExpectedEntries = new TreeSet<String>();
            postCheckoutExpectedEntries.add("level1Folder2/");
            postCheckoutExpectedEntries.add("level1Folder2/level2File.txt");
            postCheckoutExpectedEntries.add("level1Folder2/fileToCheckout (Working Copy).txt");
            this.validateWorkingCopyFolder(postCheckoutExpectedEntries, this.level1Folder2, TEST_USER.getUsername());
        }
        finally {
            previousAuth = AuthenticationUtil.getFullAuthentication();
            AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER.getUsername());
            try {
                CHECK_OUT_CHECK_IN_SERVICE.checkin(workingCopy, null);
            }
            finally {
                AuthenticationUtil.setFullAuthentication((Authentication)previousAuth);
            }
        }
        this.validateWorkingCopyFolder(preCheckoutExpectedEntries, this.level1Folder2, TEST_USER.getUsername());
        this.validateWorkingCopyFolder(preCheckoutExpectedEntries, this.level1Folder2, TEST_USER2.getUsername());
    }

    private void validateWorkingCopyFolder(Set<String> expectedEntries, NodeRef folder, String userID) throws InterruptedException {
        Authentication previousAuthentication = AuthenticationUtil.getFullAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)userID);
        try {
            NodeRef downloadNode = DOWNLOAD_SERVICE.createDownload(new NodeRef[]{folder}, true);
            this.testNodes.addNodeRef(downloadNode);
            this.waitForDownload(downloadNode);
            this.validateEntries(this.getEntries(downloadNode), expectedEntries, true);
        }
        finally {
            AuthenticationUtil.setFullAuthentication((Authentication)previousAuthentication);
        }
    }

    @Test
    public void deleteAssociationAfterDownload() throws Exception {
        final NodeRef nodeRef = DOWNLOAD_SERVICE.createDownload(new NodeRef[]{this.level1Folder1}, true);
        this.testNodes.addNodeRef(nodeRef);
        this.waitForDownload(nodeRef);
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                try {
                    List assocsList = NODE_SERVICE.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL);
                    Assert.assertEquals((long)1L, (long)assocsList.size());
                    NODE_SERVICE.removeAssociation(((AssociationRef)assocsList.get(0)).getSourceRef(), ((AssociationRef)assocsList.get(0)).getTargetRef(), DownloadModel.ASSOC_REQUESTED_NODES);
                    INTEGRITY_CHECKER.checkIntegrity();
                }
                catch (Exception exception) {
                    Assert.fail((String)"The association should have been removed successfully from the target node.");
                }
                return null;
            }
        });
    }

    @Test
    public void checkNormalUsersCanNotAccessSysDownloadFolder() throws Exception {
        NodeRef containerFolderForDownloads = DOWNLOAD_STORAGE.getOrCreateDowloadContainer();
        String randomUsername = this.createRandomUser();
        Authentication previousAuth = AuthenticationUtil.getFullAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)randomUsername);
        try {
            try {
                NODE_SERVICE.getProperties(containerFolderForDownloads);
                Assert.fail((String)"The normal user should not be able to read the sys:Download node properties");
            }
            catch (AccessDeniedException accessDeniedException) {}
            try {
                NODE_SERVICE.getChildAssocs(containerFolderForDownloads);
                Assert.fail((String)"The normal user should not be able to list the sys:Download node children");
            }
            catch (AccessDeniedException accessDeniedException) {}
        }
        finally {
            AuthenticationUtil.setFullAuthentication((Authentication)previousAuth);
        }
    }

    private void createUser(String username) {
        PersonService personService = (PersonService)APP_CONTEXT_INIT.getApplicationContext().getBean("PersonService", PersonService.class);
        MutableAuthenticationService mutableAuthenticationService = (MutableAuthenticationService)APP_CONTEXT_INIT.getApplicationContext().getBean("authenticationService", MutableAuthenticationService.class);
        if (mutableAuthenticationService.authenticationExists(username)) {
            return;
        }
        mutableAuthenticationService.createAuthentication(username, "password".toCharArray());
        PropertyMap personProperties = new PropertyMap();
        personProperties.put((Object)ContentModel.PROP_USERNAME, (Object)username);
        personProperties.put((Object)ContentModel.PROP_AUTHORITY_DISPLAY_NAME, (Object)("title" + username));
        personProperties.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
        personProperties.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
        personProperties.put((Object)ContentModel.PROP_EMAIL, (Object)(String.valueOf(username) + "@example.com"));
        personProperties.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
        personService.createPerson((Map)personProperties);
    }
}

