/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.download;

import java.io.Serializable;

public class DownloadStatus
implements Serializable {
    private static final long serialVersionUID = 4513872550314507598L;
    private long done;
    private long total;
    private long filesAddedCount;
    private long totalFileCount;
    private Status status;

    public DownloadStatus(Status status, long done, long total, long filesAdded, long totalFiles) {
        this.status = status;
        this.done = done;
        this.total = total;
        this.filesAddedCount = filesAdded;
        this.totalFileCount = totalFiles;
    }

    public long getPercentageComplete() {
        return this.done * 100L / this.total;
    }

    public boolean isComplete() {
        return this.status == Status.DONE;
    }

    public Status getStatus() {
        return this.status;
    }

    public long getDone() {
        return this.done;
    }

    public long getTotal() {
        return this.total;
    }

    public long getTotalFiles() {
        return this.totalFileCount;
    }

    public long getFilesAdded() {
        return this.filesAddedCount;
    }

    public static enum Status {
        PENDING,
        IN_PROGRESS,
        DONE,
        MAX_CONTENT_SIZE_EXCEEDED,
        CANCELLED;

    }
}

