/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.thumbnail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.rendition2.RenditionDefinition2;
import org.alfresco.repo.rendition2.RenditionDefinitionRegistry2;
import org.alfresco.repo.rendition2.TransformationOptionsConverter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.repo.thumbnail.ThumbnailRenditionConvertor;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.cmr.thumbnail.ThumbnailException;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.transform.registry.TransformServiceRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

@Deprecated
public class ThumbnailRegistry
implements ApplicationContextAware,
ApplicationListener<ApplicationContextEvent> {
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"org.alfresco.repo.thumbnail.ThumbnailRegistry");
    private static final long LOCK_TTL = 60000L;
    private static Log logger = LogFactory.getLog(ThumbnailRegistry.class);
    protected TransactionService transactionService;
    protected RenditionService renditionService;
    protected TenantAdminService tenantAdminService;
    private JobLockService jobLockService;
    private TransformServiceRegistry transformServiceRegistry;
    private TransformServiceRegistry localTransformServiceRegistry;
    private TransformationOptionsConverter converter;
    private RenditionDefinitionRegistry2 renditionDefinitionRegistry2;
    private boolean redeployStaticDefsOnStartup;
    private Map<String, ThumbnailDefinition> thumbnailDefinitions = new HashMap<String, ThumbnailDefinition>();
    private Map<String, List<ThumbnailDefinitionLimits>> mimetypeMap = new HashMap<String, List<ThumbnailDefinitionLimits>>(17);
    private ThumbnailRenditionConvertor thumbnailRenditionConvertor;
    private RegistryLifecycle lifecycle = new RegistryLifecycle();

    public void setThumbnailRenditionConvertor(ThumbnailRenditionConvertor thumbnailRenditionConvertor) {
        this.thumbnailRenditionConvertor = thumbnailRenditionConvertor;
    }

    public ThumbnailRenditionConvertor getThumbnailRenditionConvertor() {
        return this.thumbnailRenditionConvertor;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setRenditionService(RenditionService renditionService) {
        this.renditionService = renditionService;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setRedeployStaticDefsOnStartup(boolean redeployStaticDefsOnStartup) {
        this.redeployStaticDefsOnStartup = redeployStaticDefsOnStartup;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setTransformServiceRegistry(TransformServiceRegistry transformServiceRegistry) {
        this.transformServiceRegistry = transformServiceRegistry;
        this.mimetypeMap.clear();
    }

    public void setLocalTransformServiceRegistry(TransformServiceRegistry localTransformServiceRegistry) {
        this.localTransformServiceRegistry = localTransformServiceRegistry;
    }

    public void setConverter(TransformationOptionsConverter converter) {
        this.converter = converter;
    }

    public void setRenditionDefinitionRegistry2(RenditionDefinitionRegistry2 renditionDefinitionRegistry2) {
        this.renditionDefinitionRegistry2 = renditionDefinitionRegistry2;
    }

    public void setThumbnailDefinitions(List<ThumbnailDefinition> thumbnailDefinitions) {
        for (ThumbnailDefinition td : thumbnailDefinitions) {
            String thumbnailName = td.getName();
            if (thumbnailName == null) {
                throw new ThumbnailException("When adding a thumbnail details object make sure the name is set.");
            }
            td.getTransformationOptions().setUse(thumbnailName);
            this.thumbnailDefinitions.put(thumbnailName, td);
        }
    }

    public void initThumbnailDefinitions() {
        block15: {
            String lockToken = null;
            try {
                try {
                    lockToken = this.jobLockService.getLock(LOCK_QNAME, 60000L);
                    this.initThumbnailDefinitionsTransaction();
                }
                catch (LockAcquisitionException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Skipping initialisation from thumbnail definitions (could not get lock): " + e.getMessage()));
                    }
                    if (lockToken != null) {
                        try {
                            this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
                        }
                        catch (LockAcquisitionException lockAcquisitionException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (lockToken != null) {
                    try {
                        this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
                    }
                    catch (LockAcquisitionException lockAcquisitionException) {}
                }
                throw throwable;
            }
            if (lockToken != null) {
                try {
                    this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
                }
                catch (LockAcquisitionException lockAcquisitionException) {}
            }
        }
    }

    private void initThumbnailDefinitionsTransaction() {
        RetryingTransactionHelper transactionHelper = this.transactionService.getRetryingTransactionHelper();
        transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                for (String thumbnailDefName : ThumbnailRegistry.this.thumbnailDefinitions.keySet()) {
                    ThumbnailDefinition thumbnailDefinition = (ThumbnailDefinition)ThumbnailRegistry.this.thumbnailDefinitions.get(thumbnailDefName);
                    RenditionDefinition renditionDef = ThumbnailRegistry.this.thumbnailRenditionConvertor.convert(thumbnailDefinition, null);
                    ThumbnailRegistry.this.renditionService.saveRenditionDefinition(renditionDef);
                }
                return null;
            }
        });
    }

    public List<ThumbnailDefinition> getThumbnailDefinitions() {
        return new ArrayList<ThumbnailDefinition>(this.thumbnailDefinitions.values());
    }

    public List<ThumbnailDefinition> getThumbnailDefinitions(String mimetype) {
        return this.getThumbnailDefinitions(mimetype, -1L);
    }

    public List<ThumbnailDefinition> getThumbnailDefinitions(String mimetype, long sourceSize) {
        long maxSourceSizeBytes;
        List<ThumbnailDefinitionLimits> thumbnailDefinitionsLimitsForMimetype = this.mimetypeMap.get(mimetype);
        if (thumbnailDefinitionsLimitsForMimetype == null) {
            boolean foundAtLeastOneTransformer = false;
            thumbnailDefinitionsLimitsForMimetype = new ArrayList<ThumbnailDefinitionLimits>(7);
            for (ThumbnailDefinition thumbnailDefinition : this.thumbnailDefinitions.values()) {
                maxSourceSizeBytes = this.getMaxSourceSizeBytes(mimetype, thumbnailDefinition);
                if (maxSourceSizeBytes == 0L) continue;
                thumbnailDefinitionsLimitsForMimetype.add(new ThumbnailDefinitionLimits(thumbnailDefinition, maxSourceSizeBytes));
                foundAtLeastOneTransformer = true;
            }
            if (foundAtLeastOneTransformer) {
                this.mimetypeMap.put(mimetype, thumbnailDefinitionsLimitsForMimetype);
            }
        }
        ArrayList<ThumbnailDefinition> result = new ArrayList<ThumbnailDefinition>(thumbnailDefinitionsLimitsForMimetype.size());
        for (ThumbnailDefinitionLimits thumbnailDefinitionLimits : thumbnailDefinitionsLimitsForMimetype) {
            maxSourceSizeBytes = thumbnailDefinitionLimits.getMaxSourceSizeBytes();
            if (sourceSize > 0L && maxSourceSizeBytes >= 0L && maxSourceSizeBytes < sourceSize) continue;
            result.add(thumbnailDefinitionLimits.getThumbnailDefinition());
        }
        return result;
    }

    @Deprecated
    public List<ThumbnailDefinition> getThumnailDefintions(String mimetype) {
        return this.getThumbnailDefinitions(mimetype);
    }

    public boolean isThumbnailDefinitionAvailable(String sourceUrl, String sourceMimetype, long sourceSize, NodeRef sourceNodeRef, ThumbnailDefinition thumbnailDefinition) {
        boolean supported = false;
        String targetMimetype = thumbnailDefinition.getMimetype();
        RenditionDefinition2 renditionDefinition = this.getEquivalentRenditionDefinition2(thumbnailDefinition);
        if (renditionDefinition != null) {
            Map<String, String> options = renditionDefinition.getTransformOptions();
            String renditionName = renditionDefinition.getRenditionName();
            supported = this.transformServiceRegistry.isSupported(sourceMimetype, sourceSize, targetMimetype, options, renditionName);
        } else {
            boolean orig = TransformerDebug.setDebugOutput(false);
            try {
                TransformationOptions transformationOptions = thumbnailDefinition.getTransformationOptions();
                String renditionName = thumbnailDefinition.getName();
                Map<String, String> options = this.converter.getOptions(transformationOptions, sourceMimetype, targetMimetype);
                supported = this.localTransformServiceRegistry.isSupported(sourceMimetype, sourceSize, targetMimetype, options, renditionName);
            }
            finally {
                TransformerDebug.setDebugOutput(orig);
            }
        }
        return supported;
    }

    public boolean isThumbnailDefinitionAvailable(String sourceUrl, String sourceMimeType, long sourceSize, ThumbnailDefinition thumbnailDefinition) {
        return this.isThumbnailDefinitionAvailable(sourceUrl, sourceMimeType, sourceSize, null, thumbnailDefinition);
    }

    public long getMaxSourceSizeBytes(String sourceMimetype, ThumbnailDefinition thumbnailDefinition) {
        long maxSize = 0L;
        String targetMimetype = thumbnailDefinition.getMimetype();
        RenditionDefinition2 renditionDefinition = this.getEquivalentRenditionDefinition2(thumbnailDefinition);
        if (renditionDefinition != null) {
            Map<String, String> options = renditionDefinition.getTransformOptions();
            String renditionName = renditionDefinition.getRenditionName();
            maxSize = this.transformServiceRegistry.findMaxSize(sourceMimetype, targetMimetype, options, renditionName);
        } else {
            boolean orig = TransformerDebug.setDebugOutput(false);
            try {
                TransformationOptions transformationOptions = thumbnailDefinition.getTransformationOptions();
                String renditionName = thumbnailDefinition.getName();
                Map<String, String> options = this.converter.getOptions(transformationOptions, sourceMimetype, targetMimetype);
                maxSize = this.localTransformServiceRegistry.findMaxSize(sourceMimetype, targetMimetype, options, renditionName);
            }
            finally {
                TransformerDebug.setDebugOutput(orig);
            }
        }
        return maxSize;
    }

    private RenditionDefinition2 getEquivalentRenditionDefinition2(ThumbnailDefinition thumbnailDefinition) {
        String renditionName = thumbnailDefinition.getName();
        RenditionDefinition2 renditionDefinition = this.renditionDefinitionRegistry2.getRenditionDefinition(renditionName);
        if (renditionDefinition != null) {
            String thumbnailTargetMimetype = thumbnailDefinition.getMimetype();
            String renditionTargetMimetype = renditionDefinition.getTargetMimetype();
            if (!renditionTargetMimetype.equals(thumbnailTargetMimetype)) {
                renditionDefinition = null;
            }
        }
        return renditionDefinition;
    }

    public void addThumbnailDefinition(ThumbnailDefinition thumbnailDetails) {
        String thumbnailName = thumbnailDetails.getName();
        if (thumbnailName == null) {
            throw new ThumbnailException("When adding a thumbnail details object make sure the name is set.");
        }
        this.thumbnailDefinitions.put(thumbnailName, thumbnailDetails);
    }

    public ThumbnailDefinition getThumbnailDefinition(String thumbnailName) {
        return this.thumbnailDefinitions.get(thumbnailName);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.lifecycle.setApplicationContext(applicationContext);
    }

    public void onApplicationEvent(ApplicationContextEvent event) {
        this.lifecycle.onApplicationEvent((ApplicationEvent)event);
    }

    protected boolean redeploy() {
        return (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                if (ThumbnailRegistry.this.getThumbnailDefinitions().size() > 0 && (ThumbnailRegistry.this.redeployStaticDefsOnStartup || ThumbnailRegistry.this.renditionService.loadRenditionDefinitions().size() == 0)) {
                    return true;
                }
                return false;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    protected class RegistryLifecycle
    extends AbstractLifecycleBean {
        protected RegistryLifecycle() {
        }

        protected void onBootstrap(ApplicationEvent event) {
            if (ThumbnailRegistry.this.redeploy()) {
                long start = System.currentTimeMillis();
                if (ThumbnailRegistry.this.transactionService.isReadOnly()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"TransactionService is in read-only mode. Therefore no thumbnail definitions have been initialised.");
                    }
                    return;
                }
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        ThumbnailRegistry.this.initThumbnailDefinitions();
                        return null;
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
                if (ThumbnailRegistry.this.tenantAdminService.isEnabled()) {
                    List<Tenant> tenants = ThumbnailRegistry.this.tenantAdminService.getAllTenants();
                    for (Tenant tenant : tenants) {
                        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                            public Object doWork() throws Exception {
                                ThumbnailRegistry.this.initThumbnailDefinitions();
                                return null;
                            }
                        }, (String)ThumbnailRegistry.this.tenantAdminService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenant.getTenantDomain()));
                    }
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Init'ed thumbnail defs in " + (System.currentTimeMillis() - start) + " ms"));
                }
            }
        }

        protected void onShutdown(ApplicationEvent event) {
        }
    }

    private class ThumbnailDefinitionLimits {
        private ThumbnailDefinition thumbnailDefinition;
        private long maxSourceSizeBytes;

        public ThumbnailDefinitionLimits(ThumbnailDefinition thumbnailDefinition, long maxSourceSizeBytes) {
            this.thumbnailDefinition = thumbnailDefinition;
            this.maxSourceSizeBytes = maxSourceSizeBytes;
        }

        public ThumbnailDefinition getThumbnailDefinition() {
            return this.thumbnailDefinition;
        }

        public long getMaxSourceSizeBytes() {
            return this.maxSourceSizeBytes;
        }
    }
}

