/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl;

import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.AbstractPermissionEntry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;

public final class SimplePermissionEntry
extends AbstractPermissionEntry {
    private NodeRef nodeRef;
    private PermissionReference permissionReference;
    private String authority;
    private AccessStatus accessStatus;
    private int position;

    public SimplePermissionEntry(NodeRef nodeRef, PermissionReference permissionReference, String authority, AccessStatus accessStatus) {
        this(nodeRef, permissionReference, authority, accessStatus, 0);
    }

    public SimplePermissionEntry(NodeRef nodeRef, PermissionReference permissionReference, String authority, AccessStatus accessStatus, int position) {
        this.nodeRef = nodeRef;
        this.permissionReference = permissionReference;
        this.authority = authority;
        this.accessStatus = accessStatus;
        this.position = position;
    }

    @Override
    public PermissionReference getPermissionReference() {
        return this.permissionReference;
    }

    @Override
    public String getAuthority() {
        return this.authority;
    }

    @Override
    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    @Override
    public boolean isDenied() {
        return this.accessStatus == AccessStatus.DENIED;
    }

    @Override
    public boolean isAllowed() {
        return this.accessStatus == AccessStatus.ALLOWED;
    }

    @Override
    public AccessStatus getAccessStatus() {
        return this.accessStatus;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public boolean isInherited() {
        return this.position > 0;
    }
}

