/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr.facet.handler;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.impl.solr.facet.handler.AbstractFacetLabelDisplayHandler;
import org.alfresco.repo.search.impl.solr.facet.handler.FacetLabel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.springframework.extensions.surf.util.ParameterCheck;

public class UserNameDisplayHandler
extends AbstractFacetLabelDisplayHandler {
    public UserNameDisplayHandler(Set<String> supportedFieldFacets) {
        ParameterCheck.mandatory((String)"supportedFieldFacets", supportedFieldFacets);
        this.supportedFieldFacets = Collections.unmodifiableSet(new HashSet<String>(supportedFieldFacets));
    }

    @Override
    public FacetLabel getDisplayLabel(String value) {
        String name = null;
        NodeRef personRef = this.serviceRegistry.getPersonService().getPersonOrNull(value);
        if (personRef != null) {
            NodeService nodeService = this.serviceRegistry.getNodeService();
            String firstName = (String)((Object)nodeService.getProperty(personRef, ContentModel.PROP_FIRSTNAME));
            String lastName = (String)((Object)nodeService.getProperty(personRef, ContentModel.PROP_LASTNAME));
            name = String.valueOf(firstName != null ? String.valueOf(firstName) + " " : "") + (lastName != null ? lastName : "");
        }
        return new FacetLabel(value, name == null ? value : name.trim(), -1);
    }
}

