/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Iterator;
import org.alfresco.tools.RenameUser;
import org.alfresco.tools.ToolArgumentException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenameUserTest {
    private String[] args;
    private File file;
    private RenameUser renameUser = new RenameUser();

    @Before
    public void setUp() throws Exception {
        this.args = new String[6];
        this.args[0] = "-user";
        this.args[1] = "admin";
        this.args[2] = "-pwd";
        this.args[3] = "admin";
        this.args[4] = "oldUsername";
        this.args[5] = "newUsername";
    }

    @After
    public void tearDown() {
        if (this.file != null && this.file.exists()) {
            this.file.delete();
        }
    }

    private void createFile(String content) throws Exception {
        this.file = File.createTempFile("RenameUserTest", ".txt");
        this.args[4] = "-file";
        this.args[5] = this.file.getPath();
        BufferedWriter out = new BufferedWriter(new FileWriter(this.file));
        out.write(content);
        out.close();
    }

    private void processArgsAndValidate() {
        this.renameUser.processArgs(this.args);
        this.renameUser.context.validate();
    }

    private void assertUsers(String ... usernames) {
        int length = usernames.length / 2;
        Assert.assertEquals((String)"Must have an even number of usernames passed to assertUsers", (long)usernames.length, (long)(length * 2));
        Assert.assertEquals((long)length, (long)this.renameUser.context.userCount());
        Iterator iterator = this.renameUser.context.iterator();
        int i = 0;
        while (i < length) {
            RenameUser.User user = (RenameUser.User)iterator.next();
            Assert.assertEquals((Object)usernames[i * 2], (Object)user.getOldUsername());
            Assert.assertEquals((Object)usernames[i * 2 + 1], (Object)user.getNewUsername());
            ++i;
        }
    }

    @Test
    public void testLoginUsernameAndPassword() throws Exception {
        this.args[3] = "password";
        this.renameUser.processArgs(this.args);
        Assert.assertEquals((Object)"admin", (Object)this.renameUser.context.getUsername());
        Assert.assertEquals((Object)"password", (Object)this.renameUser.context.getPassword());
    }

    @Test
    public void testCmdLineUsernames() throws Exception {
        this.renameUser.processArgs(this.args);
        this.assertUsers("oldUsername", "newUsername");
    }

    @Test
    public void testFileUsernames() throws Exception {
        this.createFile("oldUsername1,newUsername1\n");
        this.processArgsAndValidate();
        this.assertUsers("oldUsername1", "newUsername1");
    }

    @Test
    public void testFileUsernamesWithSpaces() throws Exception {
        this.createFile(" oldUsername1 , newUsername1 \n");
        this.processArgsAndValidate();
        this.assertUsers("oldUsername1", "newUsername1");
    }

    @Test
    public void testFileMultipleUsernames() throws Exception {
        this.createFile("oldUsername1,newUsername1\noldUsername2,newUsername2\n");
        this.processArgsAndValidate();
        this.assertUsers("oldUsername1", "newUsername1", "oldUsername2", "newUsername2");
    }

    @Test
    public void testFileNoNewlineAtEndOfFile() throws Exception {
        this.createFile("oldUsername1,newUsername1");
        this.processArgsAndValidate();
        this.assertUsers("oldUsername1", "newUsername1");
    }

    @Test
    public void testEmptyLines() throws Exception {
        this.createFile("\n\noldUsername1,newUsername1\n\n");
        this.processArgsAndValidate();
        this.assertUsers("oldUsername1", "newUsername1");
    }

    @Test
    public void testComments() throws Exception {
        this.createFile("#A header comment\noldUsername1,newUsername1  #end of line comment\n\n");
        this.processArgsAndValidate();
        this.assertUsers("oldUsername1", "newUsername1");
    }

    @Test(expected=ToolArgumentException.class)
    public void testBadFilename() throws Exception {
        this.createFile("oldUsername1,newUsername1\n");
        this.args[5] = "rubbish.txt";
        this.processArgsAndValidate();
    }

    @Test(expected=ToolArgumentException.class)
    public void testFileNoUsernames() throws Exception {
        this.createFile("#A comment\n");
        this.processArgsAndValidate();
    }

    @Test(expected=ToolArgumentException.class)
    public void testTooManyUsernamesOnALine() throws Exception {
        this.createFile("\nname1,name2,name3\n");
        this.processArgsAndValidate();
    }

    @Test(expected=ToolArgumentException.class)
    public void testDuplicateNewUsername() throws Exception {
        this.createFile("name1,name2\nname3,name1\n");
        this.processArgsAndValidate();
    }

    @Test(expected=ToolArgumentException.class)
    public void testDuplicateOldUsername() throws Exception {
        this.createFile("name1,name2\nname2,name3\n");
        this.processArgsAndValidate();
    }

    @Test(expected=ToolArgumentException.class)
    public void testSameUsernameCmdLine() throws Exception {
        this.args[5] = "oldUsername";
        this.processArgsAndValidate();
    }

    @Test(expected=ToolArgumentException.class)
    public void testSameUsernameFile() throws Exception {
        this.createFile("name1,name1");
        this.processArgsAndValidate();
    }
}

