/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.acegi;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.ConfigAttribute;
import net.sf.acegisecurity.ConfigAttributeDefinition;
import net.sf.acegisecurity.vote.AccessDecisionVoter;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.repo.security.permissions.impl.acegi.ACLEntryVoterException;
import org.alfresco.repo.security.permissions.impl.acegi.ACLEntryVoterUtils;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class ACLEntryVoter
implements AccessDecisionVoter,
InitializingBean {
    private static Log log = LogFactory.getLog(ACLEntryVoter.class);
    private static final String ACL_NODE = "ACL_NODE";
    private static final String ACL_ITEM = "ACL_ITEM";
    private static final String ACL_PRI_CHILD_ASSOC_ON_CHILD = "ACL_PRI_CHILD_ASSOC_ON_CHILD";
    private static final String ACL_PARENT = "ACL_PARENT";
    private static final String ACL_ALLOW = "ACL_ALLOW";
    private static final String ACL_METHOD = "ACL_METHOD";
    private static final String ACL_DENY = "ACL_DENY";
    private PermissionService permissionService;
    private NamespacePrefixResolver nspr;
    private NodeService nodeService;
    private OwnableService ownableService;
    private AuthorityService authorityService;
    private Set<QName> abstainForClassQNames = new HashSet<QName>();
    private Set<String> abstainFor = null;

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.nspr;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver nspr) {
        this.nspr = nspr;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public OwnableService getOwnableService() {
        return this.ownableService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        log.warn((Object)"Bean property 'authenticationService' no longer required on 'ACLEntryVoter'.");
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setAbstainFor(Set<String> abstainFor) {
        this.abstainFor = abstainFor;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.permissionService == null) {
            throw new IllegalArgumentException("There must be a permission service");
        }
        if (this.nspr == null) {
            throw new IllegalArgumentException("There must be a namespace service");
        }
        if (this.nodeService == null) {
            throw new IllegalArgumentException("There must be a node service");
        }
        if (this.authorityService == null) {
            throw new IllegalArgumentException("There must be an authority service");
        }
        if (this.abstainFor != null) {
            for (String qnameString : this.abstainFor) {
                QName qname = QName.resolveToQName((NamespacePrefixResolver)this.nspr, (String)qnameString);
                this.abstainForClassQNames.add(qname);
            }
        }
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && (attribute.getAttribute().startsWith(ACL_NODE) || attribute.getAttribute().startsWith(ACL_ITEM) || attribute.getAttribute().startsWith(ACL_PRI_CHILD_ASSOC_ON_CHILD) || attribute.getAttribute().startsWith(ACL_PARENT) || attribute.getAttribute().equals(ACL_ALLOW) || attribute.getAttribute().startsWith(ACL_METHOD) || attribute.getAttribute().equals(ACL_DENY));
    }

    public boolean supports(Class clazz) {
        return MethodInvocation.class.isAssignableFrom(clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        if (log.isDebugEnabled()) {
            MethodInvocation mi = (MethodInvocation)object;
            log.debug((Object)("Method: " + mi.getMethod().toString()));
        }
        if (AuthenticationUtil.isRunAsUserTheSystemUser()) {
            if (!log.isDebugEnabled()) return 1;
            log.debug((Object)"Access granted for the system user");
            return 1;
        }
        List<ConfigAttributeDefintion> supportedDefinitions = this.extractSupportedDefinitions(config);
        if (supportedDefinitions.size() == 0) {
            return 0;
        }
        MethodInvocation invocation = (MethodInvocation)object;
        Method method = invocation.getMethod();
        Class<?>[] params = method.getParameterTypes();
        Boolean hasMethodEntry = null;
        for (ConfigAttributeDefintion cad : supportedDefinitions) {
            ChildAssociationRef testParentRef;
            NodeRef testNodeRef = null;
            if (cad.typeString.equals(ACL_DENY)) {
                return -1;
            }
            if (cad.typeString.equals(ACL_ALLOW)) {
                return 1;
            }
            if (cad.typeString.equals(ACL_METHOD)) {
                if (hasMethodEntry == null) {
                    hasMethodEntry = Boolean.FALSE;
                }
                if (cad.authority.equals(AuthenticationUtil.getRunAsUser())) {
                    hasMethodEntry = Boolean.TRUE;
                } else if (this.authorityService.getAuthorities().contains(cad.authority)) {
                    hasMethodEntry = Boolean.TRUE;
                }
            } else if (cad.typeString.equals(ACL_PRI_CHILD_ASSOC_ON_CHILD)) {
                if (cad.parameter.length == 2 && NodeRef.class.isAssignableFrom(params[cad.parameter[0]]) && NodeRef.class.isAssignableFrom(params[cad.parameter[1]])) {
                    testNodeRef = (NodeRef)this.getArgument(invocation, cad.parameter[1]);
                    if (testNodeRef != null) {
                        if (this.nodeService.exists(testNodeRef)) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("\tPermission test on node " + this.nodeService.getPath(testNodeRef)));
                            }
                            ChildAssociationRef primaryParent = this.nodeService.getPrimaryParent(testNodeRef);
                            NodeRef testParentNodeRef = (NodeRef)this.getArgument(invocation, cad.parameter[0]);
                            if (primaryParent == null || testParentNodeRef == null || !testParentNodeRef.equals((Object)primaryParent.getParentRef())) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("\tPermission test ignoring secondary parent association to " + testParentNodeRef));
                                }
                                testNodeRef = null;
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug((Object)("\tPermission test on non-existing node " + testNodeRef));
                        }
                    }
                } else {
                    if (cad.parameter.length != 1 || !ChildAssociationRef.class.isAssignableFrom(params[cad.parameter[0]])) throw new ACLEntryVoterException("The specified parameter is not a NodeRef or ChildAssociationRef");
                    testParentRef = (ChildAssociationRef)this.getArgument(invocation, cad.parameter[0]);
                    if (testParentRef != null) {
                        if (testParentRef.isPrimary()) {
                            testNodeRef = testParentRef.getChildRef();
                            if (log.isDebugEnabled()) {
                                if (this.nodeService.exists(testNodeRef)) {
                                    log.debug((Object)("\tPermission test on node " + this.nodeService.getPath(testNodeRef)));
                                } else {
                                    log.debug((Object)("\tPermission test on non-existing node " + testNodeRef));
                                }
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug((Object)("\tPermission test ignoring secondary parent association to " + testParentRef.getParentRef()));
                        }
                    }
                }
            } else if (cad.typeString.equals(ACL_NODE)) {
                if (cad.parameter.length != 1) {
                    throw new ACLEntryVoterException("The specified parameter is not a NodeRef or ChildAssociationRef");
                }
                if (List.class.isAssignableFrom(params[cad.parameter[0]])) {
                    List listArgument = (List)this.getArgument(invocation, cad.parameter[0]);
                    if (listArgument != null) {
                        Integer accessAbstainOrDeny = null;
                        for (Object listElement : listArgument) {
                            NodeRef listNodeRef = ACLEntryVoterUtils.getNodeRef(listElement, this.nodeService);
                            Integer currentValue = ACLEntryVoterUtils.shouldAbstainOrDeny(cad.required, listNodeRef, this.abstainForClassQNames, this.nodeService, this.permissionService);
                            if (currentValue == null) continue;
                            if (currentValue == -1) {
                                return -1;
                            }
                            accessAbstainOrDeny = currentValue;
                        }
                        if (accessAbstainOrDeny != null) {
                            return accessAbstainOrDeny;
                        }
                        if (hasMethodEntry != null && !hasMethodEntry.booleanValue()) return -1;
                        return 1;
                    }
                } else {
                    Object testObject = this.getArgument(invocation, cad.parameter[0]);
                    testNodeRef = ACLEntryVoterUtils.getNodeRef(testObject, this.nodeService);
                }
            } else if (cad.typeString.equals(ACL_ITEM)) {
                if (!NodeRef.class.isAssignableFrom(params[cad.parameter[0]])) throw new ACLEntryVoterException("The specified parameter is not a Item");
                if (Map.class.isAssignableFrom(params[1]) || Map.class.isAssignableFrom(params[2])) {
                    Map properties = (Map)(Map.class.isAssignableFrom(params[1]) ? this.getArgument(invocation, 1) : this.getArgument(invocation, 2));
                    if (properties != null && properties.containsKey(ContentModel.PROP_OWNER)) {
                        boolean isChanged;
                        testNodeRef = (NodeRef)this.getArgument(invocation, cad.parameter[0]);
                        boolean bl = isChanged = !((Serializable)properties.get(ContentModel.PROP_OWNER)).toString().equals(this.ownableService.getOwner(testNodeRef));
                        if (!isChanged) {
                            testNodeRef = null;
                        }
                        if (log.isDebugEnabled() && testNodeRef != null) {
                            if (this.nodeService.exists(testNodeRef)) {
                                log.debug((Object)("\tPermission test on node " + this.nodeService.getPath(testNodeRef)));
                            } else {
                                log.debug((Object)("\tPermission test on non-existing node " + testNodeRef));
                            }
                        }
                    }
                } else if (QName.class.isAssignableFrom(params[1]) && params[2] != null) {
                    testNodeRef = (NodeRef)this.getArgument(invocation, cad.parameter[0]);
                    QName arg1 = (QName)this.getArgument(invocation, 1);
                    boolean isOwnerProperty = ContentModel.PROP_OWNER.equals((Object)arg1);
                    if (isOwnerProperty) {
                        boolean isChanged;
                        Object arg2 = this.getArgument(invocation, 2);
                        boolean bl = isChanged = arg2 != null && !arg2.toString().equals(this.ownableService.getOwner(testNodeRef));
                        if (!isChanged) {
                            testNodeRef = null;
                        }
                    } else {
                        testNodeRef = null;
                    }
                    if (log.isDebugEnabled() && testNodeRef != null) {
                        if (this.nodeService.exists(testNodeRef)) {
                            log.debug((Object)("\tPermission test on node " + this.nodeService.getPath(testNodeRef)));
                        } else {
                            log.debug((Object)("\tPermission test on non-existing node " + testNodeRef));
                        }
                    }
                }
            } else if (cad.typeString.equals(ACL_PARENT)) {
                if (cad.parameter.length != 1) {
                    throw new ACLEntryVoterException("The specified parameter is not a NodeRef or ChildAssociationRef");
                }
                if (NodeRef.class.isAssignableFrom(params[cad.parameter[0]])) {
                    NodeRef child = (NodeRef)this.getArgument(invocation, cad.parameter[0]);
                    if (child != null) {
                        testNodeRef = this.nodeService.getPrimaryParent(child).getParentRef();
                        if (log.isDebugEnabled()) {
                            if (this.nodeService.exists(testNodeRef)) {
                                log.debug((Object)("\tPermission test for parent on node " + this.nodeService.getPath(testNodeRef)));
                            } else {
                                log.debug((Object)("\tPermission test for parent on non-existing node " + testNodeRef));
                            }
                            log.debug((Object)("\tPermission test for parent on node " + this.nodeService.getPath(testNodeRef)));
                        }
                    }
                } else {
                    if (!ChildAssociationRef.class.isAssignableFrom(params[cad.parameter[0]])) throw new ACLEntryVoterException("The specified parameter is not a ChildAssociationRef");
                    testParentRef = (ChildAssociationRef)this.getArgument(invocation, cad.parameter[0]);
                    if (testParentRef != null) {
                        testNodeRef = testParentRef.getParentRef();
                        if (log.isDebugEnabled()) {
                            if (this.nodeService.exists(testNodeRef)) {
                                log.debug((Object)("\tPermission test for parent on child assoc ref for node " + this.nodeService.getPath(testNodeRef)));
                            } else {
                                log.debug((Object)("\tPermission test for parent on child assoc ref for non existing node " + testNodeRef));
                            }
                        }
                    }
                }
            }
            Integer accessAbstainOrDeny = ACLEntryVoterUtils.shouldAbstainOrDeny(cad.required, testNodeRef, this.abstainForClassQNames, this.nodeService, this.permissionService);
            if (accessAbstainOrDeny == null) continue;
            return accessAbstainOrDeny;
        }
        if (hasMethodEntry != null && !hasMethodEntry.booleanValue()) return -1;
        return 1;
    }

    private <T> T getArgument(MethodInvocation invocation, int index) {
        Object[] args = invocation.getArguments();
        return (T)(index > args.length ? null : args[index]);
    }

    private List<ConfigAttributeDefintion> extractSupportedDefinitions(ConfigAttributeDefinition config) {
        ArrayList<ConfigAttributeDefintion> definitions = new ArrayList<ConfigAttributeDefintion>(2);
        Iterator iter = config.getConfigAttributes();
        while (iter.hasNext()) {
            ConfigAttribute attr = (ConfigAttribute)iter.next();
            if (!this.supports(attr)) continue;
            definitions.add(new ConfigAttributeDefintion(attr));
        }
        return definitions;
    }

    private class ConfigAttributeDefintion {
        String typeString;
        SimplePermissionReference required;
        int[] parameter;
        String authority;

        ConfigAttributeDefintion(ConfigAttribute attr) {
            StringTokenizer st = new StringTokenizer(attr.getAttribute(), ".", false);
            if (st.countTokens() < 1) {
                throw new ACLEntryVoterException("There must be at least one token in a config attribute");
            }
            this.typeString = st.nextToken();
            if (!(this.typeString.equals(ACLEntryVoter.ACL_NODE) || this.typeString.equals(ACLEntryVoter.ACL_ITEM) || this.typeString.equals(ACLEntryVoter.ACL_PRI_CHILD_ASSOC_ON_CHILD) || this.typeString.equals(ACLEntryVoter.ACL_PARENT) || this.typeString.equals(ACLEntryVoter.ACL_ALLOW) || this.typeString.equals(ACLEntryVoter.ACL_METHOD) || this.typeString.equals(ACLEntryVoter.ACL_DENY))) {
                throw new ACLEntryVoterException("Invalid type: must be ACL_NODE, ACL_ITEM, ACL_PARENT or ACL_ALLOW");
            }
            if (this.typeString.equals(ACLEntryVoter.ACL_NODE) || this.typeString.equals(ACLEntryVoter.ACL_ITEM) || this.typeString.equals(ACLEntryVoter.ACL_PRI_CHILD_ASSOC_ON_CHILD) || this.typeString.equals(ACLEntryVoter.ACL_PARENT)) {
                int count = st.countTokens();
                if (this.typeString.equals(ACLEntryVoter.ACL_PRI_CHILD_ASSOC_ON_CHILD)) {
                    if (count != 3 && count != 4) {
                        throw new ACLEntryVoterException("There must be three or four . separated tokens in each config attribute");
                    }
                } else if (count != 3) {
                    throw new ACLEntryVoterException("There must be three . separated tokens in each config attribute");
                }
                this.parameter = new int[count - 2];
                int i = 0;
                while (i < this.parameter.length) {
                    this.parameter[i] = Integer.parseInt(st.nextToken());
                    ++i;
                }
                String qNameString = st.nextToken();
                String permissionString = st.nextToken();
                QName qName = QName.createQName((String)qNameString, (NamespacePrefixResolver)ACLEntryVoter.this.nspr);
                this.required = SimplePermissionReference.getPermissionReference(qName, permissionString);
            } else if (this.typeString.equals(ACLEntryVoter.ACL_METHOD)) {
                if (st.countTokens() != 1) {
                    throw new ACLEntryVoterException("There must be two . separated tokens in each group or role config attribute");
                }
                this.authority = st.nextToken();
            }
        }
    }
}

