/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl;

import java.io.Serializable;
import java.util.List;
import org.alfresco.repo.search.impl.NodeSearcher;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.XPathException;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.QueryParameter;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.SearchLanguageConversion;

public class SearchServiceSubSystemDelegator
implements SearchService {
    private SearchService subSystem;
    private NodeService nodeService;
    private DictionaryService dictionaryService;

    public void setSubSystem(SearchService subSystem) {
        this.subSystem = subSystem;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public ResultSet query(StoreRef store, String language, String query) {
        return this.subSystem.query(store, language, query);
    }

    public ResultSet query(StoreRef store, String language, String query, QueryParameterDefinition[] queryParameterDefinitions) {
        return this.subSystem.query(store, language, query, queryParameterDefinitions);
    }

    public ResultSet query(StoreRef store, QName queryId, QueryParameter[] queryParameters) {
        return this.subSystem.query(store, queryId, queryParameters);
    }

    public ResultSet query(SearchParameters searchParameters) {
        return this.subSystem.query(searchParameters);
    }

    public List<NodeRef> selectNodes(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks) throws InvalidNodeRefException, XPathException {
        return this.selectNodes(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, "xpath");
    }

    public List<NodeRef> selectNodes(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks, String language) throws InvalidNodeRefException, XPathException {
        NodeSearcher nodeSearcher = new NodeSearcher(this.nodeService, this.dictionaryService, this);
        return nodeSearcher.selectNodes(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, language);
    }

    public List<Serializable> selectProperties(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks) throws InvalidNodeRefException, XPathException {
        return this.selectProperties(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, "xpath");
    }

    public List<Serializable> selectProperties(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks, String language) throws InvalidNodeRefException, XPathException {
        NodeSearcher nodeSearcher = new NodeSearcher(this.nodeService, this.dictionaryService, this);
        return nodeSearcher.selectProperties(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, language);
    }

    public boolean contains(NodeRef nodeRef, QName propertyQName, String googleLikePattern) throws InvalidNodeRefException {
        return this.subSystem.contains(nodeRef, propertyQName, googleLikePattern);
    }

    public boolean contains(NodeRef nodeRef, QName propertyQName, String googleLikePattern, SearchParameters.Operator defaultOperator) throws InvalidNodeRefException {
        return this.subSystem.contains(nodeRef, propertyQName, googleLikePattern, defaultOperator);
    }

    public boolean like(NodeRef nodeRef, QName propertyQName, String sqlLikePattern, boolean includeFTS) throws InvalidNodeRefException {
        if (propertyQName == null) {
            throw new IllegalArgumentException("Property QName is mandatory for the like expression");
        }
        if (includeFTS) {
            return this.subSystem.like(nodeRef, propertyQName, sqlLikePattern, includeFTS);
        }
        String pattern = SearchLanguageConversion.convertXPathLikeToRegex((String)sqlLikePattern.toLowerCase());
        Serializable property = this.nodeService.getProperty(nodeRef, propertyQName);
        if (property == null) {
            return false;
        }
        String propertyString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, propertyQName));
        return propertyString.toLowerCase().matches(pattern);
    }
}

