/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.favourites;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PageDetails;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.favourites.PersonFavourite;
import org.alfresco.repo.policy.ClassPolicy;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.favourites.FavouritesService;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.QName;
import org.alfresco.sync.events.types.ActivityEvent;
import org.alfresco.sync.events.types.Event;
import org.alfresco.sync.repo.Client;
import org.alfresco.sync.repo.events.EventPreparator;
import org.alfresco.sync.repo.events.EventPublisher;
import org.alfresco.util.ISO8601DateFormat;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class FavouritesServiceImpl
implements FavouritesService,
InitializingBean {
    private static final Log logger = LogFactory.getLog(FavouritesServiceImpl.class);
    private Map<FavouritesService.Type, PrefKeys> prefKeys;
    private PreferenceService preferenceService;
    private NodeService nodeService;
    private DictionaryService dictionaryService;
    private SiteService siteService;
    private PolicyComponent policyComponent;
    private PermissionService permissionService;
    private PersonService personService;
    private EventPublisher eventPublisher;
    private AuthenticationContext authenticationContext;
    private ClassPolicyDelegate<OnAddFavouritePolicy> onAddFavouriteDelegate;
    private ClassPolicyDelegate<OnRemoveFavouritePolicy> onRemoveFavouriteDelegate;
    private Collator collator = Collator.getInstance();

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setPreferenceService(PreferenceService preferenceService) {
        this.preferenceService = preferenceService;
    }

    public void afterPropertiesSet() throws Exception {
        this.prefKeys = new HashMap<FavouritesService.Type, PrefKeys>();
        this.prefKeys.put(FavouritesService.Type.SITE, new PrefKeys("org.alfresco.share.sites.favourites.", "org.alfresco.ext.sites.favourites."));
        this.prefKeys.put(FavouritesService.Type.FILE, new PrefKeys("org.alfresco.share.documents.favourites", "org.alfresco.ext.documents.favourites."));
        this.prefKeys.put(FavouritesService.Type.FOLDER, new PrefKeys("org.alfresco.share.folders.favourites", "org.alfresco.ext.folders.favourites."));
    }

    public void init() {
        this.onAddFavouriteDelegate = this.policyComponent.registerClassPolicy(OnAddFavouritePolicy.class);
        this.onRemoveFavouriteDelegate = this.policyComponent.registerClassPolicy(OnRemoveFavouritePolicy.class);
    }

    private PrefKeys getPrefKeys(FavouritesService.Type type) {
        PrefKeys prefKey = this.prefKeys.get((Object)type);
        return prefKey;
    }

    private boolean removeFavouriteSite(String userName, NodeRef nodeRef) {
        PrefKeys prefKeys = this.getPrefKeys(FavouritesService.Type.SITE);
        boolean exists = false;
        SiteInfo siteInfo = this.siteService.getSite(nodeRef);
        if (siteInfo == null) {
            throw new IllegalArgumentException("NodeRef " + nodeRef + " is not a site");
        }
        StringBuilder sitePrefKeyBuilder = new StringBuilder(prefKeys.getSharePrefKey());
        sitePrefKeyBuilder.append(siteInfo.getShortName());
        String sitePrefKey = sitePrefKeyBuilder.toString();
        String siteFavouritedKey = this.siteFavouritedKey(siteInfo);
        exists = this.preferenceService.getPreference(userName, siteFavouritedKey) != null;
        this.preferenceService.clearPreferences(userName, sitePrefKey);
        return exists;
    }

    private String siteFavouritedKey(SiteInfo siteInfo) {
        String sitePrefKey;
        PrefKeys prefKeys = this.getPrefKeys(FavouritesService.Type.SITE);
        StringBuilder sitePrefKeyBuilder = new StringBuilder(prefKeys.getSharePrefKey());
        sitePrefKeyBuilder.append(siteInfo.getShortName());
        String favouritedKey = sitePrefKey = sitePrefKeyBuilder.toString();
        return favouritedKey;
    }

    private String siteCreatedAtKey(SiteInfo siteInfo) {
        PrefKeys prefKeys = this.getPrefKeys(FavouritesService.Type.SITE);
        StringBuilder sitePrefKeyBuilder = new StringBuilder(prefKeys.getAlfrescoPrefKey());
        sitePrefKeyBuilder.append(siteInfo.getShortName());
        String sitePrefKey = sitePrefKeyBuilder.toString();
        StringBuilder createdAtKeyBuilder = new StringBuilder(sitePrefKey);
        createdAtKeyBuilder.append(".createdAt");
        String createdAtKey = createdAtKeyBuilder.toString();
        return createdAtKey;
    }

    private Comparator<PersonFavourite.PersonFavouriteKey> getComparator(final List<Pair<FavouritesService.SortFields, Boolean>> sortProps) {
        Comparator<PersonFavourite.PersonFavouriteKey> comparator = new Comparator<PersonFavourite.PersonFavouriteKey>(){

            @Override
            public int compare(PersonFavourite.PersonFavouriteKey o1, PersonFavourite.PersonFavouriteKey o2) {
                int ret = 0;
                for (Pair sort : sortProps) {
                    FavouritesService.SortFields field = (FavouritesService.SortFields)((Object)sort.getFirst());
                    Boolean ascending = (Boolean)sort.getSecond();
                    if (field.equals((Object)FavouritesService.SortFields.username)) {
                        ret = ascending != false ? FavouritesServiceImpl.this.collator.compare(o1.getUserName(), o2.getUserName()) : o2.getUserName().compareTo(o1.getUserName());
                        if (ret == 0) continue;
                        break;
                    }
                    if (field.equals((Object)FavouritesService.SortFields.type)) {
                        ret = ascending != false ? o1.getType().compareTo(o2.getType()) : o2.getType().compareTo(o1.getType());
                        if (ret == 0) continue;
                        break;
                    }
                    if (field.equals((Object)FavouritesService.SortFields.createdAt)) {
                        if (ascending.booleanValue()) {
                            if (o1.getCreatedAt() != null && o2.getCreatedAt() != null) {
                                ret = o1.getCreatedAt().compareTo(o2.getCreatedAt());
                            }
                        } else if (o1.getCreatedAt() != null && o2.getCreatedAt() != null) {
                            ret = o2.getCreatedAt().compareTo(o1.getCreatedAt());
                        }
                        if (ret == 0) continue;
                        break;
                    }
                    if (!field.equals((Object)FavouritesService.SortFields.title)) continue;
                    if (ascending.booleanValue()) {
                        if (o1.getTitle() != null && o2.getTitle() != null) {
                            ret = FavouritesServiceImpl.this.collator.compare(o1.getTitle(), o2.getTitle());
                        }
                    } else if (o1.getTitle() != null && o2.getTitle() != null) {
                        ret = FavouritesServiceImpl.this.collator.compare(o2.getTitle(), o1.getTitle());
                    }
                    if (ret != 0) break;
                }
                if (ret == 0) {
                    ret = o1.getNodeRef().toString().compareTo(o2.getNodeRef().toString());
                }
                return ret;
            }
        };
        return comparator;
    }

    private PersonFavourite addFavouriteSite(String userName, NodeRef nodeRef) {
        PersonFavourite favourite = null;
        SiteInfo siteInfo = this.siteService.getSite(nodeRef);
        if (siteInfo != null) {
            favourite = this.getFavouriteSite(userName, siteInfo);
            if (favourite == null) {
                HashMap<String, Serializable> preferences = new HashMap<String, Serializable>(1);
                String siteFavouritedKey = this.siteFavouritedKey(siteInfo);
                preferences.put(siteFavouritedKey, Boolean.TRUE);
                String siteCreatedAtKey = this.siteCreatedAtKey(siteInfo);
                Date createdAt = new Date();
                String createdAtStr = ISO8601DateFormat.format((Date)createdAt);
                preferences.put(siteCreatedAtKey, (Serializable)((Object)createdAtStr));
                this.preferenceService.setPreferences(userName, preferences);
                favourite = new PersonFavourite(userName, siteInfo.getNodeRef(), FavouritesService.Type.SITE, siteInfo.getTitle(), createdAt);
                QName nodeClass = this.nodeService.getType(nodeRef);
                OnAddFavouritePolicy policy = this.onAddFavouriteDelegate.get(nodeRef, nodeClass);
                policy.onAddFavourite(userName, nodeRef);
            }
        } else {
            logger.warn((Object)("Unable to get site for " + nodeRef));
        }
        return favourite;
    }

    private PersonFavourite getFavouriteSite(String userName, SiteInfo siteInfo) {
        PersonFavourite favourite = null;
        String siteFavouritedKey = this.siteFavouritedKey(siteInfo);
        String siteCreatedAtKey = this.siteCreatedAtKey(siteInfo);
        Boolean isFavourited = false;
        Serializable s = this.preferenceService.getPreference(userName, siteFavouritedKey);
        if (s != null) {
            if (s instanceof String) {
                isFavourited = Boolean.valueOf((String)((Object)s));
            } else if (s instanceof Boolean) {
                isFavourited = (Boolean)s;
            } else {
                throw new AlfrescoRuntimeException("Unexpected favourites preference value");
            }
        }
        if (isFavourited.booleanValue()) {
            String createdAtStr = (String)((Object)this.preferenceService.getPreference(userName, siteCreatedAtKey));
            Date createdAt = createdAtStr == null ? null : ISO8601DateFormat.parse((String)createdAtStr);
            favourite = new PersonFavourite(userName, siteInfo.getNodeRef(), FavouritesService.Type.SITE, siteInfo.getTitle(), createdAt);
        }
        return favourite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFavouriteSite(String userName, NodeRef nodeRef) {
        Boolean isFavourited = Boolean.FALSE;
        SiteInfo siteInfo = this.siteService.getSite(nodeRef);
        if (siteInfo == null) throw new IllegalArgumentException("NodeRef " + nodeRef + " is not a site");
        String favouritedPrefKey = this.siteFavouritedKey(siteInfo);
        Serializable value = this.preferenceService.getPreference(userName, favouritedPrefKey);
        if (value == null) return isFavourited;
        if (value instanceof String) {
            isFavourited = Boolean.valueOf((String)((Object)value));
            return isFavourited;
        } else {
            if (!(value instanceof Boolean)) throw new AlfrescoRuntimeException("Unexpected favourites preference value");
            isFavourited = (Boolean)value;
        }
        return isFavourited;
    }

    private void updateFavouriteNodes(String userName, FavouritesService.Type type, Map<PersonFavourite.PersonFavouriteKey, PersonFavourite> favouriteNodes) {
        PrefKeys prefKeys = this.getPrefKeys(type);
        HashMap<String, Serializable> preferences = new HashMap<String, Serializable>(1);
        StringBuilder values = new StringBuilder();
        for (PersonFavourite node : favouriteNodes.values()) {
            NodeRef nodeRef = node.getNodeRef();
            values.append(nodeRef.toString());
            values.append(",");
            StringBuilder sb = new StringBuilder(prefKeys.getAlfrescoPrefKey());
            sb.append(nodeRef.toString());
            sb.append(".createdAt");
            String createdAtKey = sb.toString();
            Date createdAt = node.getCreatedAt();
            if (createdAt == null) continue;
            String createdAtStr = ISO8601DateFormat.format((Date)createdAt);
            preferences.put(createdAtKey, (Serializable)((Object)createdAtStr));
        }
        if (values.length() > 1) {
            values.delete(values.length() - 1, values.length());
        }
        preferences.put(prefKeys.getSharePrefKey(), (Serializable)((Object)values.toString()));
        this.preferenceService.setPreferences(userName, preferences);
    }

    private Map<PersonFavourite.PersonFavouriteKey, PersonFavourite> getFavouriteNodes(String userName, FavouritesService.Type type) {
        PrefKeys prefKeys = this.getPrefKeys(type);
        Map<PersonFavourite.PersonFavouriteKey, PersonFavourite> favouriteNodes = Collections.emptyMap();
        Map<String, Serializable> prefs = this.preferenceService.getPreferences(userName, prefKeys.getSharePrefKey());
        String nodes = (String)((Object)prefs.get(prefKeys.getSharePrefKey()));
        favouriteNodes = nodes != null ? this.extractFavouriteNodes(userName, type, nodes) : new HashMap();
        return favouriteNodes;
    }

    private Map<PersonFavourite.PersonFavouriteKey, PersonFavourite> extractFavouriteNodes(String userName, FavouritesService.Type type, String nodes) {
        PrefKeys prefKeys = this.getPrefKeys(type);
        HashMap<PersonFavourite.PersonFavouriteKey, PersonFavourite> favouriteNodes = new HashMap<PersonFavourite.PersonFavouriteKey, PersonFavourite>();
        StringTokenizer st = new StringTokenizer(nodes, ",");
        while (st.hasMoreTokens()) {
            NodeRef nodeRef;
            String nodeRefStr = st.nextToken();
            if (!NodeRef.isNodeRef((String)(nodeRefStr = nodeRefStr.trim())) || !this.nodeService.exists(nodeRef = new NodeRef(nodeRefStr)) || this.permissionService.hasPermission(nodeRef, "ReadProperties") == AccessStatus.DENIED) continue;
            StringBuilder builder = new StringBuilder(prefKeys.getAlfrescoPrefKey());
            builder.append(nodeRef.toString());
            builder.append(".createdAt");
            String prefKey = builder.toString();
            String createdAtStr = (String)((Object)this.preferenceService.getPreference(userName, prefKey));
            Date createdAt = createdAtStr != null ? ISO8601DateFormat.parse((String)createdAtStr) : null;
            String name = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            PersonFavourite personFavourite = new PersonFavourite(userName, nodeRef, type, name, createdAt);
            PersonFavourite.PersonFavouriteKey key = personFavourite.getKey();
            favouriteNodes.put(key, personFavourite);
        }
        return favouriteNodes;
    }

    private void extractFavouriteSite(String userName, FavouritesService.Type type, Map<PersonFavourite.PersonFavouriteKey, PersonFavourite> sortedFavouriteNodes, Map<String, Serializable> preferences, String key) {
        Serializable pref = preferences.get(key);
        Boolean isFavourite = (Boolean)pref;
        if (isFavourite.booleanValue()) {
            PrefKeys sitePrefKeys = this.getPrefKeys(FavouritesService.Type.SITE);
            int length = sitePrefKeys.getSharePrefKey().length();
            String siteId = key.substring(length);
            try {
                SiteInfo siteInfo = this.siteService.getSite(siteId);
                if (siteInfo != null) {
                    StringBuilder builder = new StringBuilder(sitePrefKeys.getAlfrescoPrefKey());
                    builder.append(siteId);
                    builder.append(".createdAt");
                    String createdAtPrefKey = builder.toString();
                    String createdAtStr = (String)((Object)preferences.get(createdAtPrefKey));
                    Date createdAt = null;
                    if (createdAtStr != null) {
                        createdAt = createdAtStr != null ? ISO8601DateFormat.parse((String)createdAtStr) : null;
                    }
                    PersonFavourite personFavourite = new PersonFavourite(userName, siteInfo.getNodeRef(), FavouritesService.Type.SITE, siteId, createdAt);
                    sortedFavouriteNodes.put(personFavourite.getKey(), personFavourite);
                }
            }
            catch (AccessDeniedException accessDeniedException) {
                return;
            }
        }
    }

    private PersonFavourite getFavouriteDocumentOrFolder(String userName, FavouritesService.Type type, NodeRef nodeRef) {
        PersonFavourite favourite = null;
        PrefKeys prefKeys = this.getPrefKeys(type);
        Map<String, Serializable> preferences = this.preferenceService.getPreferences(userName, prefKeys.getSharePrefKey());
        String nodes = (String)((Object)preferences.get(prefKeys.getSharePrefKey()));
        if (nodes != null) {
            Map<PersonFavourite.PersonFavouriteKey, PersonFavourite> favouriteNodes = this.extractFavouriteNodes(userName, type, nodes);
            String title = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_TITLE));
            PersonFavourite.PersonFavouriteKey key = new PersonFavourite.PersonFavouriteKey(userName, title, type, nodeRef);
            favourite = favouriteNodes.get(key);
        }
        return favourite;
    }

    private PersonFavourite getPersonFavourite(String userName, FavouritesService.Type type, NodeRef nodeRef) {
        PersonFavourite ret = null;
        if (type.equals((Object)FavouritesService.Type.SITE)) {
            SiteInfo siteInfo = this.siteService.getSite(nodeRef);
            if (siteInfo != null) {
                ret = this.getFavouriteSite(userName, siteInfo);
            } else {
                logger.warn((Object)("Unable to get site for " + nodeRef));
            }
        } else if (type.equals((Object)FavouritesService.Type.FILE)) {
            ret = this.getFavouriteDocumentOrFolder(userName, type, nodeRef);
        } else if (type.equals((Object)FavouritesService.Type.FOLDER)) {
            ret = this.getFavouriteDocumentOrFolder(userName, type, nodeRef);
        } else {
            throw new AlfrescoRuntimeException("Unexpected favourite type");
        }
        return ret;
    }

    private PersonFavourite addFavouriteDocumentOrFolder(String userName, FavouritesService.Type type, NodeRef nodeRef) {
        Map<PersonFavourite.PersonFavouriteKey, PersonFavourite> personFavourites = this.getFavouriteNodes(userName, type);
        PersonFavourite personFavourite = this.getPersonFavourite(userName, type, nodeRef);
        if (personFavourite == null) {
            Date createdAt = new Date();
            final String name = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            personFavourite = new PersonFavourite(userName, nodeRef, type, name, createdAt);
            personFavourites.put(personFavourite.getKey(), personFavourite);
            this.updateFavouriteNodes(userName, type, personFavourites);
            QName nodeClass = this.nodeService.getType(nodeRef);
            final String finalRef = nodeRef.getId();
            final QName nodeType = nodeClass;
            this.eventPublisher.publishEvent(new EventPreparator(){

                public Event prepareEvent(String user, String networkId, String transactionId) {
                    return new ActivityEvent("favorite.added", transactionId, networkId, user, finalRef, null, nodeType == null ? null : nodeType.toString(), Client.asType((Client.ClientType)Client.ClientType.script), null, name, null, 0L, null);
                }
            });
            OnAddFavouritePolicy policy = this.onAddFavouriteDelegate.get(nodeRef, nodeClass);
            policy.onAddFavourite(userName, nodeRef);
        }
        return personFavourite;
    }

    private boolean isFavouriteNode(String userName, FavouritesService.Type type, NodeRef nodeRef) {
        Map<PersonFavourite.PersonFavouriteKey, PersonFavourite> personFavourites = this.getFavouriteNodes(userName, type);
        PersonFavourite.PersonFavouriteKey personFavouriteKey = new PersonFavourite.PersonFavouriteKey(userName, null, type, nodeRef);
        boolean isFavourite = personFavourites.containsKey(personFavouriteKey);
        return isFavourite;
    }

    @Override
    public FavouritesService.Type getType(NodeRef nodeRef) {
        FavouritesService.Type favouriteType = null;
        QName type = this.nodeService.getType(nodeRef);
        boolean isSite = this.dictionaryService.isSubClass(type, SiteModel.TYPE_SITE);
        if (isSite) {
            favouriteType = FavouritesService.Type.SITE;
        } else {
            boolean isContainer;
            boolean bl = isContainer = this.dictionaryService.isSubClass(type, ContentModel.TYPE_FOLDER) && !this.dictionaryService.isSubClass(type, ContentModel.TYPE_SYSTEM_FOLDER);
            if (isContainer) {
                favouriteType = FavouritesService.Type.FOLDER;
            } else {
                boolean isFile = this.dictionaryService.isSubClass(type, ContentModel.TYPE_CONTENT);
                if (isFile) {
                    favouriteType = FavouritesService.Type.FILE;
                }
            }
        }
        return favouriteType;
    }

    private boolean removeFavouriteNode(String userName, FavouritesService.Type type, NodeRef nodeRef) {
        PersonFavourite.PersonFavouriteKey personFavouriteKey;
        boolean exists = false;
        Map<PersonFavourite.PersonFavouriteKey, PersonFavourite> personFavourites = this.getFavouriteNodes(userName, type);
        PersonFavourite personFavourite = personFavourites.remove(personFavouriteKey = new PersonFavourite.PersonFavouriteKey(userName, null, type, nodeRef));
        exists = personFavourite != null;
        this.updateFavouriteNodes(userName, type, personFavourites);
        QName nodeClass = this.nodeService.getType(nodeRef);
        final String finalRef = nodeRef.getId();
        final QName nodeType = nodeClass;
        this.eventPublisher.publishEvent(new EventPreparator(){

            public Event prepareEvent(String user, String networkId, String transactionId) {
                return new ActivityEvent("favorite.removed", transactionId, networkId, user, finalRef, null, nodeType == null ? null : nodeType.toString(), Client.asType((Client.ClientType)Client.ClientType.script), null, null, null, 0L, null);
            }
        });
        OnRemoveFavouritePolicy policy = this.onRemoveFavouriteDelegate.get(nodeRef, nodeClass);
        policy.onRemoveFavourite(userName, nodeRef);
        return exists;
    }

    @Override
    public PersonFavourite addFavourite(String userName, NodeRef nodeRef) {
        PersonFavourite personFavourite = null;
        FavouritesService.Type type = this.getType(nodeRef);
        if (type == null) {
            throw new IllegalArgumentException("Cannot favourite this node");
        }
        if (type.equals((Object)FavouritesService.Type.FILE)) {
            personFavourite = this.addFavouriteDocumentOrFolder(userName, FavouritesService.Type.FILE, nodeRef);
        } else if (type.equals((Object)FavouritesService.Type.FOLDER)) {
            personFavourite = this.addFavouriteDocumentOrFolder(userName, FavouritesService.Type.FOLDER, nodeRef);
        } else if (type.equals((Object)FavouritesService.Type.SITE)) {
            personFavourite = this.addFavouriteSite(userName, nodeRef);
        } else {
            throw new IllegalArgumentException("Cannot favourite this node");
        }
        return personFavourite;
    }

    @Override
    public boolean removeFavourite(String userName, NodeRef nodeRef) {
        boolean exists = false;
        FavouritesService.Type type = this.getType(nodeRef);
        if (type == null) {
            throw new IllegalArgumentException("Cannot un-favourite this node");
        }
        if (type.equals((Object)FavouritesService.Type.FILE)) {
            exists = this.removeFavouriteNode(userName, type, nodeRef);
        } else if (type.equals((Object)FavouritesService.Type.FOLDER)) {
            exists = this.removeFavouriteNode(userName, type, nodeRef);
        } else if (type.equals((Object)FavouritesService.Type.SITE)) {
            exists = this.removeFavouriteSite(userName, nodeRef);
        } else {
            throw new IllegalArgumentException("Cannot un-favourite this node");
        }
        return exists;
    }

    @Override
    public boolean isFavourite(String userName, NodeRef nodeRef) {
        boolean isFavourite = false;
        FavouritesService.Type type = this.getType(nodeRef);
        if (type == null) {
            throw new IllegalArgumentException("Unsupported node type");
        }
        if (type.equals((Object)FavouritesService.Type.FILE)) {
            isFavourite = this.isFavouriteNode(userName, type, nodeRef);
        } else if (type.equals((Object)FavouritesService.Type.FOLDER)) {
            isFavourite = this.isFavouriteNode(userName, type, nodeRef);
        } else if (type.equals((Object)FavouritesService.Type.SITE)) {
            isFavourite = this.isFavouriteSite(userName, nodeRef);
        } else {
            throw new IllegalArgumentException("Unsupported node type");
        }
        return isFavourite;
    }

    @Override
    public PagingResults<PersonFavourite> getPagedFavourites(String userName, Set<FavouritesService.Type> types, List<Pair<FavouritesService.SortFields, Boolean>> sortProps, PagingRequest pagingRequest) {
        NodeRef personNodeRef = this.personService.getPerson(userName);
        if (personNodeRef == null) {
            throw new AlfrescoRuntimeException("Can not get preferences for " + userName + " because he/she does not exist.");
        }
        boolean includeFiles = types.contains((Object)FavouritesService.Type.FILE);
        boolean includeFolders = types.contains((Object)FavouritesService.Type.FOLDER);
        boolean includeSites = types.contains((Object)FavouritesService.Type.SITE);
        String currentUserName = AuthenticationUtil.getFullyAuthenticatedUser();
        if (this.authenticationContext.isSystemUserName(currentUserName) || this.permissionService.hasPermission(personNodeRef, "Write") == AccessStatus.ALLOWED || userName.equals(currentUserName)) {
            final TreeMap<PersonFavourite.PersonFavouriteKey, PersonFavourite> sortedFavouriteNodes = new TreeMap<PersonFavourite.PersonFavouriteKey, PersonFavourite>(this.getComparator(sortProps));
            PrefKeys sitePrefKeys = this.getPrefKeys(FavouritesService.Type.SITE);
            PrefKeys documentsPrefKeys = this.getPrefKeys(FavouritesService.Type.FILE);
            PrefKeys foldersPrefKeys = this.getPrefKeys(FavouritesService.Type.FOLDER);
            Map<String, Serializable> preferences = this.preferenceService.getPreferences(userName);
            for (String key : preferences.keySet()) {
                String nodes;
                if (includeFiles && key.startsWith(documentsPrefKeys.sharePrefKey)) {
                    nodes = (String)((Object)preferences.get(key));
                    if (nodes == null) continue;
                    sortedFavouriteNodes.putAll(this.extractFavouriteNodes(userName, FavouritesService.Type.FILE, nodes));
                    continue;
                }
                if (includeFolders && key.startsWith(foldersPrefKeys.sharePrefKey)) {
                    nodes = (String)((Object)preferences.get(key));
                    if (nodes == null) continue;
                    sortedFavouriteNodes.putAll(this.extractFavouriteNodes(userName, FavouritesService.Type.FOLDER, nodes));
                    continue;
                }
                if (!includeSites || !key.startsWith(sitePrefKeys.getSharePrefKey()) || key.endsWith(".createdAt")) continue;
                this.extractFavouriteSite(userName, FavouritesService.Type.SITE, sortedFavouriteNodes, preferences, key);
            }
            int totalSize = sortedFavouriteNodes.size();
            final PageDetails pageDetails = PageDetails.getPageDetails((PagingRequest)pagingRequest, (int)totalSize);
            final ArrayList<PersonFavourite> page = new ArrayList<PersonFavourite>(pageDetails.getPageSize());
            Iterator it = sortedFavouriteNodes.values().iterator();
            int counter = 0;
            while (counter < pageDetails.getEnd() && it.hasNext()) {
                PersonFavourite favouriteNode = (PersonFavourite)it.next();
                if (counter >= pageDetails.getSkipCount()) {
                    if (counter > pageDetails.getEnd() - 1) break;
                    page.add(favouriteNode);
                }
                ++counter;
            }
            return new PagingResults<PersonFavourite>(){

                public List<PersonFavourite> getPage() {
                    return page;
                }

                public boolean hasMoreItems() {
                    return pageDetails.hasMoreItems();
                }

                public Pair<Integer, Integer> getTotalResultCount() {
                    Integer total = sortedFavouriteNodes.size();
                    return new Pair((Object)total, (Object)total);
                }

                public String getQueryExecutionId() {
                    return null;
                }
            };
        }
        throw new AccessDeniedException("The current user " + currentUserName + " does not have sufficient permissions to get the favourites of the user " + userName);
    }

    @Override
    public PersonFavourite getFavourite(String userName, NodeRef nodeRef) {
        FavouritesService.Type type = this.getType(nodeRef);
        return this.getPersonFavourite(userName, type, nodeRef);
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public static interface OnAddFavouritePolicy
    extends ClassPolicy {
        public static final QName QNAME = QName.createQName((String)"http://www.alfresco.org", (String)"onAddfavourite");

        public void onAddFavourite(String var1, NodeRef var2);
    }

    public static interface OnRemoveFavouritePolicy
    extends ClassPolicy {
        public static final QName QNAME = QName.createQName((String)"http://www.alfresco.org", (String)"onRemovefavourite");

        public void onRemoveFavourite(String var1, NodeRef var2);
    }

    private static class PrefKeys {
        private String sharePrefKey;
        private String alfrescoPrefKey;

        public PrefKeys(String sharePrefKey, String alfrescoPrefKey) {
            this.sharePrefKey = sharePrefKey;
            this.alfrescoPrefKey = alfrescoPrefKey;
        }

        public String getSharePrefKey() {
            return this.sharePrefKey;
        }

        public String getAlfrescoPrefKey() {
            return this.alfrescoPrefKey;
        }
    }
}

