/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.replication;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.AbstractContentStore;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.UnsupportedContentUrlException;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.DirectAccessUrl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AggregatingContentStore
extends AbstractContentStore {
    private static final Log logger = LogFactory.getLog(AggregatingContentStore.class);
    public static final String REPLICATING_CONTENT_STORE_NOT_INITIALISED = "ReplicatingContentStore not initialised";
    public static final String SECONDARY_STORE_COULD_NOT_HANDLE_CONTENT_URL = "Secondary store %s could not handle content URL: %s";
    public static final String PRIMARY_STORE_COULD_NOT_HANDLE_CONTENT_URL = "Primary store could not handle content URL: %s";
    private ContentStore primaryStore;
    private List<ContentStore> secondaryStores;
    private Lock readLock;

    public AggregatingContentStore() {
        ReentrantReadWriteLock storeLock = new ReentrantReadWriteLock();
        this.readLock = storeLock.readLock();
    }

    public void setPrimaryStore(ContentStore primaryStore) {
        this.primaryStore = primaryStore;
    }

    public void setSecondaryStores(List<ContentStore> secondaryStores) {
        this.secondaryStores = secondaryStores;
    }

    public boolean isWriteSupported() {
        return this.primaryStore.isWriteSupported();
    }

    @Override
    public boolean isContentUrlSupported(String contentUrl) {
        return this.primaryStore.isContentUrlSupported(contentUrl);
    }

    @Override
    public String getRootLocation() {
        return this.primaryStore.getRootLocation();
    }

    public ContentReader getReader(String contentUrl) throws ContentIOException {
        this.checkPrimaryStore();
        this.readLock.lock();
        try {
            ContentReader primaryReader = this.primaryStore.getReader(contentUrl);
            if (primaryReader.exists()) {
                ContentReader contentReader = primaryReader;
                return contentReader;
            }
            for (ContentStore store : this.secondaryStores) {
                ContentReader reader = store.getReader(contentUrl);
                if (!reader.exists()) continue;
                ContentReader contentReader = reader;
                return contentReader;
            }
            ContentReader contentReader = primaryReader;
            return contentReader;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean exists(String contentUrl) {
        this.checkPrimaryStore();
        this.readLock.lock();
        try {
            boolean contentUrlSupported = false;
            boolean contentUrlExists = false;
            try {
                contentUrlExists = this.primaryStore.exists(contentUrl);
                contentUrlSupported = true;
            }
            catch (UnsupportedContentUrlException unsupportedContentUrlException) {}
            if (contentUrlExists) {
                return true;
            }
            for (ContentStore store : this.secondaryStores) {
                contentUrlExists = false;
                try {
                    contentUrlExists = store.exists(contentUrl);
                    contentUrlSupported = true;
                }
                catch (UnsupportedContentUrlException unsupportedContentUrlException) {}
                if (contentUrlExists) break;
            }
            if (!contentUrlSupported) {
                throw new UnsupportedContentUrlException(this, contentUrl);
            }
            boolean bl = contentUrlExists;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ContentWriter getWriter(ContentContext ctx) {
        ContentWriter writer = this.primaryStore.getWriter(ctx);
        return writer;
    }

    @Override
    public boolean delete(String contentUrl) throws ContentIOException {
        boolean deleted = this.primaryStore.delete(contentUrl);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleted content for URL: " + contentUrl));
        }
        return deleted;
    }

    public boolean isContentDirectUrlEnabled() {
        boolean isContentDirectUrlEnabled = this.primaryStore.isContentDirectUrlEnabled();
        if (!isContentDirectUrlEnabled) {
            for (ContentStore store : this.secondaryStores) {
                isContentDirectUrlEnabled = store.isContentDirectUrlEnabled();
                if (isContentDirectUrlEnabled) break;
            }
        }
        return isContentDirectUrlEnabled;
    }

    public boolean isContentDirectUrlEnabled(String contentUrl) {
        boolean isContentDirectUrlEnabled = this.primaryStore.isContentDirectUrlEnabled(contentUrl);
        if (!isContentDirectUrlEnabled) {
            for (ContentStore store : this.secondaryStores) {
                isContentDirectUrlEnabled = store.isContentDirectUrlEnabled(contentUrl);
                if (isContentDirectUrlEnabled) break;
            }
        }
        return isContentDirectUrlEnabled;
    }

    public DirectAccessUrl requestContentDirectUrl(String contentUrl, boolean attachment, String fileName, String mimetype, Long validFor) {
        this.checkPrimaryStore();
        this.readLock.lock();
        try {
            boolean contentUrlSupported = true;
            boolean directAccessUrlSupported = true;
            DirectAccessUrl directAccessUrl = null;
            try {
                directAccessUrl = this.primaryStore.requestContentDirectUrl(contentUrl, attachment, fileName, mimetype, validFor);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                directAccessUrlSupported = false;
            }
            catch (UnsupportedContentUrlException unsupportedContentUrlException) {
                contentUrlSupported = false;
            }
            if (directAccessUrl != null) {
                DirectAccessUrl directAccessUrl2 = directAccessUrl;
                return directAccessUrl2;
            }
            for (ContentStore store : this.secondaryStores) {
                try {
                    directAccessUrl = store.requestContentDirectUrl(contentUrl, attachment, fileName, mimetype, validFor);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    directAccessUrlSupported = false;
                }
                catch (UnsupportedContentUrlException unsupportedContentUrlException) {
                    contentUrlSupported = false;
                }
                if (directAccessUrl != null) break;
            }
            if (directAccessUrl == null) {
                if (!directAccessUrlSupported) {
                    throw new UnsupportedOperationException("Retrieving direct access URLs is not supported by this content store.");
                }
                if (!contentUrlSupported) {
                    throw new UnsupportedContentUrlException(this, contentUrl);
                }
            }
            DirectAccessUrl directAccessUrl3 = directAccessUrl;
            return directAccessUrl3;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Map<String, String> getStorageProperties(String contentUrl) {
        this.checkPrimaryStore();
        this.readLock.lock();
        try {
            Optional<Object> objectStoragePropertiesMap = Optional.empty();
            try {
                objectStoragePropertiesMap = Optional.of(this.primaryStore.getStorageProperties(contentUrl));
            }
            catch (UnsupportedContentUrlException unsupportedContentUrlException) {
                String message = String.format(PRIMARY_STORE_COULD_NOT_HANDLE_CONTENT_URL, contentUrl);
                logger.trace((Object)message);
            }
            if (objectStoragePropertiesMap.isEmpty() || ((Map)objectStoragePropertiesMap.get()).isEmpty()) {
                for (ContentStore store : this.secondaryStores) {
                    try {
                        objectStoragePropertiesMap = Optional.of(store.getStorageProperties(contentUrl));
                    }
                    catch (UnsupportedContentUrlException unsupportedContentUrlException) {
                        String message = String.format(SECONDARY_STORE_COULD_NOT_HANDLE_CONTENT_URL, store, contentUrl);
                        logger.trace((Object)message);
                    }
                    if (!objectStoragePropertiesMap.isPresent()) continue;
                    Map map = (Map)objectStoragePropertiesMap.get();
                    return map;
                }
                throw new UnsupportedContentUrlException(this, contentUrl);
            }
            Map<String, String> map = objectStoragePropertiesMap.orElse(Collections.emptyMap());
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean requestSendContentToArchive(String contentUrl, Map<String, Serializable> archiveParams) {
        return this.callContentArchiveRequest(contentUrl, archiveParams, false);
    }

    public boolean requestRestoreContentFromArchive(String contentUrl, Map<String, Serializable> restoreParams) {
        return this.callContentArchiveRequest(contentUrl, restoreParams, true);
    }

    private boolean callContentArchiveRequest(String contentUrl, Map<String, Serializable> requestParams, boolean restore) {
        this.checkPrimaryStore();
        this.readLock.lock();
        boolean archiveRequestSucceeded = false;
        boolean primaryContentUrlUnsupported = false;
        boolean secondaryContentUrlUnsupported = false;
        try {
            String message;
            try {
                archiveRequestSucceeded = this.archiveRequestResult(contentUrl, requestParams, restore, this.primaryStore);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                message = String.format("Primary store does not handle this operation for content URL: %s", contentUrl);
                logger.trace((Object)message);
            }
            catch (UnsupportedContentUrlException unsupportedContentUrlException) {
                message = String.format(PRIMARY_STORE_COULD_NOT_HANDLE_CONTENT_URL, contentUrl);
                logger.trace((Object)message);
                primaryContentUrlUnsupported = true;
            }
            if (archiveRequestSucceeded) {
                return true;
            }
            for (ContentStore store : this.secondaryStores) {
                String message2;
                try {
                    archiveRequestSucceeded = this.archiveRequestResult(contentUrl, requestParams, restore, store);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    message2 = String.format("Secondary store %s does not handle this operation for content URL: %s", store, contentUrl);
                    logger.trace((Object)message2);
                }
                catch (UnsupportedContentUrlException unsupportedContentUrlException) {
                    secondaryContentUrlUnsupported = true;
                    message2 = String.format(SECONDARY_STORE_COULD_NOT_HANDLE_CONTENT_URL, store, contentUrl);
                    logger.trace((Object)message2);
                }
            }
            if (archiveRequestSucceeded) {
                return true;
            }
            if (primaryContentUrlUnsupported || secondaryContentUrlUnsupported) {
                boolean bl = this.callSuperMethod(contentUrl, requestParams, restore);
                return bl;
            }
            boolean bl = this.callSuperMethod(contentUrl, requestParams, restore);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean callSuperMethod(String contentUrl, Map<String, Serializable> requestParams, boolean restore) {
        return restore ? super.requestRestoreContentFromArchive(contentUrl, requestParams) : super.requestSendContentToArchive(contentUrl, requestParams);
    }

    private boolean archiveRequestResult(String contentUrl, Map<String, Serializable> requestParams, boolean restore, ContentStore store) {
        return restore ? store.requestRestoreContentFromArchive(contentUrl, requestParams) : store.requestSendContentToArchive(contentUrl, requestParams);
    }

    private void checkPrimaryStore() {
        if (this.primaryStore == null) {
            throw new AlfrescoRuntimeException(REPLICATING_CONTENT_STORE_NOT_INITIALISED);
        }
    }
}

