/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import jakarta.transaction.UserTransaction;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.UnsupportedContentUrlException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.BaseApplicationContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.springframework.context.ApplicationContext;

public abstract class AbstractReadOnlyContentStoreTest {
    protected static ApplicationContext ctx;
    private static Log logger;
    @Rule
    public TestName name = new TestName();
    protected TransactionService transactionService;
    private UserTransaction txn;

    static {
        logger = LogFactory.getLog(AbstractReadOnlyContentStoreTest.class);
    }

    protected String getName() {
        return this.name.getMethodName();
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        ctx = BaseApplicationContextHelper.getApplicationContext((String[])ApplicationContextHelper.CONFIG_LOCATIONS);
    }

    @Before
    public void before() throws Exception {
        this.transactionService = (TransactionService)ctx.getBean("TransactionService");
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
    }

    @After
    public void after() throws Exception {
        try {
            this.txn.rollback();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected abstract ContentStore getStore();

    protected final ContentReader getReader(String contentUrl) {
        return this.getStore().getReader(contentUrl);
    }

    @Test
    public void testSetUp() throws Exception {
        ContentStore store = this.getStore();
        Assert.assertNotNull((String)"No store provided", (Object)store);
        Assert.assertTrue((String)"The same instance of the store must be returned for getStore", (store == this.getStore() ? 1 : 0) != 0);
    }

    private void checkIllegalReadContentUrl(ContentStore store, String contentUrl) {
        Assert.assertFalse((String)"This check is for unsupported content URLs only", (boolean)store.isContentUrlSupported(contentUrl));
        try {
            store.getReader(contentUrl);
            Assert.fail((String)("Expected UnsupportedContentUrlException for getReader(), but got nothing: " + contentUrl));
        }
        catch (UnsupportedContentUrlException unsupportedContentUrlException) {}
        try {
            store.exists(contentUrl);
            Assert.fail((String)("Expected UnsupportedContentUrlException for exists(), but got nothing: " + contentUrl));
        }
        catch (UnsupportedContentUrlException unsupportedContentUrlException) {}
    }

    protected abstract String getExistingContentUrl();

    @Test
    public void testIllegalReadableContentUrls() {
        ContentStore store = this.getStore();
        this.checkIllegalReadContentUrl(store, "://bogus");
        this.checkIllegalReadContentUrl(store, "bogus://");
        this.checkIllegalReadContentUrl(store, "bogus://bogus");
    }

    @Test
    public void testGetReaderForExistingContentUrl() throws Exception {
        ContentStore store = this.getStore();
        String contentUrl = this.getExistingContentUrl();
        if (contentUrl == null) {
            logger.warn((Object)("Store test testGetReaderForExistingContentUrl not possible on " + store.getClass().getName()));
            return;
        }
        Assert.assertTrue((String)"URL returned in set seems to no longer exist", (boolean)store.exists(contentUrl));
        ContentReader reader = store.getReader(contentUrl);
        Assert.assertNotNull((String)"Reader should never be null", (Object)reader);
        Assert.assertTrue((String)"Reader says content doesn't exist", (boolean)reader.exists());
        Assert.assertFalse((String)"Reader should not be closed before a read", (boolean)reader.isClosed());
        Assert.assertFalse((String)"The reader channel should not be open yet", (boolean)reader.isChannelOpen());
        ReadableByteChannel readChannel = reader.getReadableChannel();
        readChannel.read(ByteBuffer.wrap(new byte[500]));
        Assert.assertFalse((String)"Reader should not be closed during a read", (boolean)reader.isClosed());
        Assert.assertTrue((String)"The reader channel should be open during a read", (boolean)reader.isChannelOpen());
        readChannel.close();
        Assert.assertTrue((String)"Reader should be closed after a read", (boolean)reader.isClosed());
        Assert.assertFalse((String)"The reader channel should be closed after a read", (boolean)reader.isChannelOpen());
    }

    @Test
    public void testRandomAccessRead() throws Exception {
        ContentStore store = this.getStore();
        String contentUrl = this.getExistingContentUrl();
        if (contentUrl == null) {
            logger.warn((Object)("Store test testRandomAccessRead not possible on " + store.getClass().getName()));
            return;
        }
        ContentReader reader = store.getReader(contentUrl);
        Assert.assertNotNull((String)"Reader should never be null", (Object)reader);
        FileChannel fileChannel = reader.getFileChannel();
        Assert.assertNotNull((String)"No channel given", (Object)fileChannel);
        try {
            reader.getReadableChannel();
            Assert.fail((String)"Second channel access allowed");
        }
        catch (RuntimeException runtimeException) {}
        fileChannel.close();
    }

    @Test
    public void testBlockedWriteOperations() throws Exception {
        ContentStore store = this.getStore();
        if (store.isWriteSupported()) {
            return;
        }
        try {
            store.getWriter(ContentStore.NEW_CONTENT_CONTEXT);
            Assert.fail((String)("Read-only store provided a writer: " + store));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        String contentUrl = this.getExistingContentUrl();
        if (contentUrl == null) {
            logger.warn((Object)("Store test testBlockedWriteOperations not possible on " + store.getClass().getName()));
            return;
        }
        try {
            store.delete(contentUrl);
            Assert.fail((String)("Read-only store allowed deletion: " + store));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }
}

