/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tagging;

import java.util.List;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.tagging.TagDetails;
import org.alfresco.service.cmr.tagging.TagScope;

public class TagScopeImpl
implements TagScope {
    private NodeRef nodeRef;
    private List<TagDetails> tagDetails;

    TagScopeImpl(NodeRef nodeRef, List<TagDetails> tagDetails) {
        this.nodeRef = nodeRef;
        this.tagDetails = tagDetails;
    }

    @Override
    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    @Override
    public List<TagDetails> getTags() {
        return this.tagDetails;
    }

    @Override
    public List<TagDetails> getTags(int topN) {
        if (this.tagDetails.size() < topN) {
            topN = this.tagDetails.size();
        }
        return this.tagDetails.subList(0, topN);
    }

    @Override
    public TagDetails getTag(String tag) {
        TagDetails result = null;
        for (TagDetails tagDetails : this.tagDetails) {
            if (!tagDetails.getName().equals(tag)) continue;
            result = tagDetails;
            break;
        }
        return result;
    }

    @Override
    public boolean isTagInScope(String tag) {
        return this.getTag(tag) != null;
    }

    public int hashCode() {
        return this.nodeRef.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TagScopeImpl) {
            TagScopeImpl that = (TagScopeImpl)obj;
            return this.nodeRef.equals((Object)that.nodeRef);
        }
        return false;
    }
}

