/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.content.caching.CacheMissException;
import org.alfresco.repo.content.caching.ContentCache;
import org.alfresco.repo.content.caching.FileHandler;
import org.alfresco.repo.content.caching.Key;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentCacheImpl
implements ContentCache {
    private static final Log log = LogFactory.getLog(ContentCacheImpl.class);
    private static final String CACHE_FILE_EXT = ".bin";
    private static final String CACHE_FILE_TEMP_EXT = ".tmp";
    private File cacheRoot;
    private SimpleCache<Key, String> memoryStore;

    @Override
    public boolean contains(String contentUrl) {
        return this.memoryStore.contains((Serializable)Key.forUrl(contentUrl));
    }

    public boolean contains(Key key) {
        return this.memoryStore.contains((Serializable)key);
    }

    public void putIntoLookup(Key key, String value) {
        this.memoryStore.put((Serializable)key, (Object)value);
    }

    public String getCacheFilePath(String contentUrl) {
        return (String)this.memoryStore.get((Serializable)Key.forUrl(contentUrl));
    }

    public String getContentUrl(File file) {
        return (String)this.memoryStore.get((Serializable)Key.forCacheFile(file));
    }

    @Override
    public ContentReader getReader(String contentUrl) {
        Key url = Key.forUrl(contentUrl);
        if (this.memoryStore.contains((Serializable)url)) {
            String path = (String)this.memoryStore.get((Serializable)url);
            this.memoryStore.get((Serializable)Key.forCacheFile(path));
            File cacheFile = new File(path);
            if (cacheFile.exists()) {
                return new FileContentReader(cacheFile, contentUrl);
            }
        }
        throw new CacheMissException(contentUrl);
    }

    @Override
    public boolean put(String contentUrl, ContentReader source) {
        File tempFile = this.createCacheFile();
        if (source.getSize() > 0L) {
            source.getContent(tempFile);
            File cacheFile = this.renameTempToActive(tempFile);
            this.recordCacheEntries(contentUrl, cacheFile);
            return true;
        }
        return false;
    }

    private void recordCacheEntries(String contentUrl, File cacheFile) {
        this.memoryStore.put((Serializable)Key.forUrl(contentUrl), (Object)cacheFile.getAbsolutePath());
        this.memoryStore.put((Serializable)Key.forCacheFile(cacheFile), (Object)contentUrl);
    }

    private File createCacheFile() {
        File file = new File(this.cacheRoot, ContentCacheImpl.createNewTempCacheFilePath());
        File parentDir = file.getParentFile();
        parentDir.mkdirs();
        return file;
    }

    @Override
    public void remove(String contentUrl) {
        String path = this.getCacheFilePath(contentUrl);
        this.memoryStore.remove((Serializable)Key.forUrl(contentUrl));
        this.memoryStore.remove((Serializable)Key.forCacheFile(path));
    }

    public void removeAll() {
        this.memoryStore.clear();
    }

    @Override
    public void deleteFile(String url) {
        File cacheFile = new File(this.getCacheFilePath(url));
        cacheFile.delete();
    }

    @Override
    public ContentWriter getWriter(final String url) {
        final File tempFile = this.createCacheFile();
        final CacheWriter writer = new CacheWriter(tempFile, url);
        writer.addListener(new ContentStreamListener(){

            public void contentStreamClosed() throws ContentIOException {
                File cacheFile = ContentCacheImpl.this.renameTempToActive(tempFile);
                writer.setCacheFile(cacheFile);
                ContentCacheImpl.this.recordCacheEntries(url, cacheFile);
            }
        });
        return writer;
    }

    private File renameTempToActive(File tempFile) {
        String fullPath = tempFile.getPath();
        int extIndex = fullPath.lastIndexOf(CACHE_FILE_TEMP_EXT);
        if (extIndex > 0) {
            String prefix = fullPath.substring(0, extIndex);
            File dest = new File(String.valueOf(prefix) + CACHE_FILE_EXT);
            boolean renamed = tempFile.renameTo(dest);
            if (renamed) {
                return dest;
            }
            throw new IllegalStateException("Temp file couldn't be renamed to active cache file, temp=" + tempFile.getPath() + ", dest=" + dest.getPath());
        }
        throw new IllegalArgumentException("Invalid temp file name: " + tempFile.getPath());
    }

    public static String createNewCacheFilePath() {
        return ContentCacheImpl.createNewCacheFilePath(false);
    }

    private static String createNewTempCacheFilePath() {
        return ContentCacheImpl.createNewCacheFilePath(true);
    }

    private static String createNewCacheFilePath(boolean tempFile) {
        GregorianCalendar calendar = new GregorianCalendar();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        StringBuilder sb = new StringBuilder(20);
        sb.append(year).append('/').append(month).append('/').append(day).append('/').append(hour).append('/').append(minute).append('/').append(GUID.generate());
        if (tempFile) {
            sb.append(CACHE_FILE_TEMP_EXT);
        } else {
            sb.append(CACHE_FILE_EXT);
        }
        return sb.toString();
    }

    public void setMemoryStore(SimpleCache<Key, String> memoryStore) {
        this.memoryStore = memoryStore;
    }

    public void setCacheRoot(File cacheRoot) {
        if (cacheRoot == null) {
            throw new IllegalArgumentException("cacheRoot cannot be null.");
        }
        if (!cacheRoot.exists()) {
            cacheRoot.mkdirs();
        }
        this.cacheRoot = cacheRoot;
    }

    @Override
    public File getCacheRoot() {
        return this.cacheRoot;
    }

    public void processFiles(FileHandler handler) {
        this.handleDir(this.cacheRoot, handler);
    }

    private void handleDir(File dir, FileHandler handler) {
        if (dir.isDirectory()) {
            File[] files;
            File[] fileArray = files = this.sortFiles(dir);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.handleDir(file, handler);
                } else if (file.getName().endsWith(CACHE_FILE_EXT)) {
                    handler.handle(file);
                }
                ++n2;
            }
        } else {
            throw new IllegalArgumentException("handleDir() called with non-directory: " + dir.getAbsolutePath());
        }
    }

    private File[] sortFiles(File dir) {
        ArrayList<File> dirs = new ArrayList<File>();
        ArrayList<File> files = new ArrayList<File>();
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File item = fileArray[n2];
            if (item.isDirectory()) {
                dirs.add(item);
            } else {
                files.add(item);
            }
            ++n2;
        }
        Collections.sort(dirs, new NumericFileNameComparator());
        ArrayList<File> all = new ArrayList<File>();
        all.addAll(dirs);
        all.addAll(files);
        return all.toArray(new File[0]);
    }

    public static class CacheWriter
    extends FileContentWriter {
        private File cacheFile = null;

        public CacheWriter(File file, String url) {
            super(file, url, null);
        }

        public void setCacheFile(File file) {
            this.cacheFile = file;
        }

        @Override
        public File getFile() {
            if (this.cacheFile != null) {
                return this.cacheFile;
            }
            return super.getFile();
        }

        @Override
        protected ContentReader createReader() throws ContentIOException {
            FileContentReader reader = new FileContentReader(this.getFile(), this.getContentUrl());
            return reader;
        }

        @Override
        public long getSize() {
            File file = this.getFile();
            if (file == null) {
                return 0L;
            }
            if (!file.exists()) {
                return 0L;
            }
            return file.length();
        }
    }

    protected static class NumericFileNameComparator
    implements Comparator<File> {
        protected NumericFileNameComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            Integer n1 = this.parse(o1.getName());
            Integer n2 = this.parse(o2.getName());
            return n1.compareTo(n2);
        }

        private int parse(String s) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                return Integer.MAX_VALUE;
            }
        }
    }
}

