/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.thumbnail;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.content.MimetypeMap;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.magick.ImageResizeOptions;
import org.alfresco.repo.content.transform.magick.ImageTransformationOptions;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.dialect.Oracle9Dialect;
import org.alfresco.repo.domain.dialect.SQLServerDialect;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.rendition2.SynchronousTransformClient;
import org.alfresco.repo.rendition2.TransformationOptionsConverter;
import org.alfresco.repo.thumbnail.FailureHandlingOptions;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.repo.thumbnail.ThumbnailHelper;
import org.alfresco.repo.thumbnail.ThumbnailRegistry;
import org.alfresco.repo.thumbnail.script.ScriptThumbnailService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.PagedSourceOptions;
import org.alfresco.service.cmr.repository.ScriptLocation;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.cmr.repository.TransformationSourceOptions;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.thumbnail.FailedThumbnailInfo;
import org.alfresco.service.cmr.thumbnail.ThumbnailParentAssociationDetails;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.log4j.Log4jAppenderUtil;
import org.alfresco.util.transaction.TransactionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.transaction.TestTransaction;
import org.springframework.transaction.annotation.Transactional;

@Deprecated
@Category(value={OwnJVMTestsCategory.class})
@Transactional
@ContextConfiguration(value={"classpath:alfresco/application-context.xml", "classpath:org/alfresco/repo/rendition2/test-transform-context.xml"})
public class ThumbnailServiceImplTest
extends BaseAlfrescoSpringTest {
    private static Log logger = LogFactory.getLog(ThumbnailServiceImplTest.class);
    public static final String TEST_THUMBNAIL = "testThumbnail";
    private NodeService secureNodeService;
    private RenditionService renditionService;
    private ThumbnailService thumbnailService;
    private ScriptThumbnailService scriptThumbnailService;
    private ScriptService scriptService;
    private MimetypeMap mimetypeMap;
    private TransactionService transactionService;
    private ServiceRegistry services;
    private FailureHandlingOptions failureHandlingOptions;
    private Repository repositoryHelper;
    private PermissionService permissionService;
    private LockService lockService;
    private CopyService copyService;
    private SynchronousTransformClient synchronousTransformClient;
    private TransformationOptionsConverter converter;
    private NodeRef folder;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.secureNodeService = (NodeService)this.applicationContext.getBean("NodeService");
        this.renditionService = (RenditionService)this.applicationContext.getBean("RenditionService");
        this.thumbnailService = (ThumbnailService)this.applicationContext.getBean("ThumbnailService");
        this.scriptThumbnailService = (ScriptThumbnailService)this.applicationContext.getBean("thumbnailServiceScript");
        this.mimetypeMap = (MimetypeMap)this.applicationContext.getBean("mimetypeService");
        this.scriptService = (ScriptService)this.applicationContext.getBean("ScriptService");
        this.services = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionService");
        this.failureHandlingOptions = (FailureHandlingOptions)this.applicationContext.getBean("standardFailureOptions");
        this.repositoryHelper = (Repository)this.applicationContext.getBean("repositoryHelper");
        this.permissionService = (PermissionService)this.applicationContext.getBean("PermissionService");
        this.lockService = (LockService)this.applicationContext.getBean("lockService");
        this.copyService = (CopyService)this.applicationContext.getBean("CopyService");
        this.synchronousTransformClient = (SynchronousTransformClient)this.applicationContext.getBean("synchronousTransformClient");
        this.converter = (TransformationOptionsConverter)this.applicationContext.getBean("transformOptionsConverter");
        HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
        folderProps.put(ContentModel.PROP_NAME, "testFolder");
        this.folder = this.secureNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        ThumbnailRegistry thumbnailRegistry = this.thumbnailService.getThumbnailRegistry();
        ThumbnailServiceImplTest.createTestThumbnail(thumbnailRegistry);
    }

    public static void createTestThumbnail(ThumbnailRegistry thumbnailRegistry) {
        if (thumbnailRegistry.getThumbnailDefinition(TEST_THUMBNAIL) == null) {
            ThumbnailDefinition doclib = thumbnailRegistry.getThumbnailDefinition("doclib");
            ThumbnailDefinition testThumbnailDefinition = new ThumbnailDefinition(doclib.getMimetype(), doclib.getTransformationOptions(), TEST_THUMBNAIL);
            testThumbnailDefinition.setFailureHandlingOptions(doclib.getFailureHandlingOptions());
            testThumbnailDefinition.setPlaceHolderResourcePath(doclib.getPlaceHolderResourcePath());
            testThumbnailDefinition.setMimeAwarePlaceHolderResourcePath(doclib.getMimeAwarePlaceHolderResourcePath());
            testThumbnailDefinition.setRunAs(doclib.getRunAs());
            thumbnailRegistry.addThumbnailDefinition(testThumbnailDefinition);
        }
    }

    private void checkTransformer() {
        if (!this.synchronousTransformClient.isSupported("image/jpeg", -1L, null, "image/jpeg", Collections.emptyMap(), null, null)) {
            ThumbnailServiceImplTest.fail((String)"Image transformer is not working.  Please check your image conversion command setup.");
        }
    }

    @Test
    public void testCreateRenditionThumbnailFromImage() throws Exception {
        QName qname = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"doclib");
        ThumbnailDefinition details = this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition(qname.getLocalName());
        ThumbnailServiceImplTest.assertEquals((String)"doclib", (String)details.getName());
        ThumbnailServiceImplTest.assertEquals((String)"image/png", (String)details.getMimetype());
        ThumbnailServiceImplTest.assertEquals((String)"alfresco/thumbnail/thumbnail_placeholder_doclib.png", (String)details.getPlaceHolderResourcePath());
        this.checkTransformer();
        NodeRef jpgOrig = this.createOriginalContent(this.folder, "image/jpeg");
        NodeRef thumbnail0 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/jpeg", details.getTransformationOptions(), "doclib");
        ThumbnailServiceImplTest.assertNotNull((Object)thumbnail0);
        this.checkRenditioned(jpgOrig, Collections.singletonList(new ExpectedAssoc(RegexQNamePattern.MATCH_ALL, "doclib", 1)));
        this.checkRendition("doclib", thumbnail0);
        this.outputThumbnailTempContentLocation(thumbnail0, "jpg", "doclib test");
    }

    @Test
    public void testCreateRenditionThumbnailFromPdf() throws Exception {
        QName qname = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"doclib");
        ThumbnailDefinition details = this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition(qname.getLocalName());
        ThumbnailServiceImplTest.assertEquals((String)"doclib", (String)details.getName());
        ThumbnailServiceImplTest.assertEquals((String)"image/png", (String)details.getMimetype());
        ThumbnailServiceImplTest.assertEquals((String)"alfresco/thumbnail/thumbnail_placeholder_doclib.png", (String)details.getPlaceHolderResourcePath());
        this.checkTransformer();
        NodeRef pdfOrig = this.createOriginalContent(this.folder, "application/pdf");
        NodeRef thumbnail0 = this.thumbnailService.createThumbnail(pdfOrig, ContentModel.PROP_CONTENT, "image/jpeg", details.getTransformationOptions(), "doclib");
        ThumbnailServiceImplTest.assertNotNull((Object)thumbnail0);
        this.checkRenditioned(pdfOrig, Collections.singletonList(new ExpectedAssoc(RegexQNamePattern.MATCH_ALL, "doclib", 1)));
        this.checkRendition("doclib", thumbnail0);
        this.outputThumbnailTempContentLocation(thumbnail0, "jpg", "doclib test");
    }

    @Test
    public void testCreateRenditionThumbnailFromPdfPage2() throws Exception {
        ImageTransformationOptions options = new ImageTransformationOptions();
        PagedSourceOptions pagedSourceOptions = new PagedSourceOptions();
        pagedSourceOptions.setStartPageNumber(Integer.valueOf(2));
        pagedSourceOptions.setEndPageNumber(Integer.valueOf(2));
        options.addSourceOptions((TransformationSourceOptions)pagedSourceOptions);
        ThumbnailDefinition thumbnailDefinition = new ThumbnailDefinition("application/pdf", (TransformationOptions)options, "doclib_2");
        this.thumbnailService.getThumbnailRegistry().addThumbnailDefinition(thumbnailDefinition);
        this.checkTransformer();
        NodeRef pdfOrig = this.createOriginalContent(this.folder, "application/pdf");
        NodeRef thumbnail0 = this.thumbnailService.createThumbnail(pdfOrig, ContentModel.PROP_CONTENT, "image/jpeg", thumbnailDefinition.getTransformationOptions(), "doclib_2");
        ThumbnailServiceImplTest.assertNotNull((Object)thumbnail0);
        this.checkRenditioned(pdfOrig, Collections.singletonList(new ExpectedAssoc(RegexQNamePattern.MATCH_ALL, "doclib_2", 1)));
        this.checkRendition("doclib_2", thumbnail0);
        File tempFile = TempFileProvider.createTempFile((String)"thumbnailServiceImplTest", (String)".jpg");
        ContentReader reader = this.contentService.getReader(thumbnail0, ContentModel.PROP_CONTENT);
        long size = reader.getSize();
        reader.getContent(tempFile);
        ThumbnailServiceImplTest.assertTrue((String)("Page 2 should be blank and less than 4500 bytes. It was " + size + " bytes. tempFile=" + tempFile.getPath()), (size < 4500L ? 1 : 0) != 0);
    }

    @Test
    public void testCreateThumbnailFromImage() throws Exception {
        this.checkTransformer();
        NodeRef jpgOrig = this.createOriginalContent(this.folder, "image/jpeg");
        NodeRef gifOrig = this.createOriginalContent(this.folder, "image/gif");
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        imageResizeOptions.setWidth(64);
        imageResizeOptions.setHeight(64);
        imageResizeOptions.setResizeToThumbnail(true);
        ImageTransformationOptions imageTransformationOptions = new ImageTransformationOptions();
        imageTransformationOptions.setResizeOptions(imageResizeOptions);
        NodeRef thumbnail1 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/jpeg", (TransformationOptions)imageTransformationOptions, "small");
        ThumbnailServiceImplTest.assertNotNull((Object)thumbnail1);
        this.checkRenditioned(jpgOrig, Collections.singletonList(new ExpectedAssoc(RegexQNamePattern.MATCH_ALL, "small", 1)));
        this.checkRendition("small", thumbnail1);
        this.outputThumbnailTempContentLocation(thumbnail1, "jpg", "small - 64x64, marked as thumbnail");
        ImageResizeOptions imageResizeOptions2 = new ImageResizeOptions();
        imageResizeOptions2.setWidth(64);
        imageResizeOptions2.setHeight(64);
        imageResizeOptions2.setMaintainAspectRatio(false);
        ImageTransformationOptions imageTransformationOptions2 = new ImageTransformationOptions();
        imageTransformationOptions2.setResizeOptions(imageResizeOptions2);
        NodeRef thumbnail2 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/jpeg", (TransformationOptions)imageTransformationOptions2, "small2");
        this.checkRenditioned(jpgOrig, Collections.singletonList(new ExpectedAssoc(RegexQNamePattern.MATCH_ALL, "small2", 1)));
        this.checkRendition("small2", thumbnail2);
        this.outputThumbnailTempContentLocation(thumbnail2, "jpg", "small2 - 64x64, aspect not maintained");
        ImageResizeOptions imageResizeOptions3 = new ImageResizeOptions();
        imageResizeOptions3.setWidth(50);
        imageResizeOptions3.setHeight(50);
        imageResizeOptions3.setPercentResize(true);
        ImageTransformationOptions imageTransformationOptions3 = new ImageTransformationOptions();
        imageTransformationOptions3.setResizeOptions(imageResizeOptions3);
        NodeRef thumbnail3 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/jpeg", (TransformationOptions)imageTransformationOptions3, "half");
        this.checkRenditioned(jpgOrig, Collections.singletonList(new ExpectedAssoc(RegexQNamePattern.MATCH_ALL, "half", 1)));
        this.checkRendition("half", thumbnail3);
        this.outputThumbnailTempContentLocation(thumbnail3, "jpg", "half - 50%x50%");
        ImageResizeOptions imageResizeOptions4 = new ImageResizeOptions();
        imageResizeOptions4.setWidth(50);
        imageResizeOptions4.setHeight(50);
        imageResizeOptions4.setPercentResize(true);
        ImageTransformationOptions imageTransformationOptions4 = new ImageTransformationOptions();
        imageTransformationOptions4.setResizeOptions(imageResizeOptions4);
        NodeRef thumbnail4 = this.thumbnailService.createThumbnail(gifOrig, ContentModel.PROP_CONTENT, "image/jpeg", (TransformationOptions)imageTransformationOptions4, "half2");
        this.checkRenditioned(gifOrig, Collections.singletonList(new ExpectedAssoc(RegexQNamePattern.MATCH_ALL, "half2", 1)));
        this.checkRendition("half2", thumbnail4);
        this.outputThumbnailTempContentLocation(thumbnail4, "jpg", "half2 - 50%x50%, from gif");
    }

    @Test
    public void testDuplicationNames() throws Exception {
        this.checkTransformer();
        NodeRef jpgOrig = this.createOriginalContent(this.folder, "image/jpeg");
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        imageResizeOptions.setWidth(64);
        imageResizeOptions.setHeight(64);
        imageResizeOptions.setResizeToThumbnail(true);
        ImageTransformationOptions imageTransformationOptions = new ImageTransformationOptions();
        imageTransformationOptions.setResizeOptions(imageResizeOptions);
        NodeRef thumbnail1 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/jpeg", (TransformationOptions)imageTransformationOptions, "small");
        ThumbnailServiceImplTest.assertNotNull((Object)thumbnail1);
        this.checkRenditioned(jpgOrig, Collections.singletonList(new ExpectedAssoc(RegexQNamePattern.MATCH_ALL, "small", 1)));
        this.checkRendition("small", thumbnail1);
        NodeRef duplicate = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/jpeg", (TransformationOptions)imageTransformationOptions, "small");
        ThumbnailServiceImplTest.assertNotNull((Object)duplicate);
        ThumbnailServiceImplTest.assertEquals((Object)duplicate, (Object)thumbnail1);
    }

    @Test
    public void testCreateFailingThumbnail() throws Exception {
        if (this.shouldTestBeSkippedForCurrentDB()) {
            return;
        }
        logger.debug((Object)"Starting testCreateFailingThumbnail");
        final NodeRef corruptNode = this.createCorruptedContent(this.folder);
        logger.debug((Object)("Running failing thumbnail on " + corruptNode));
        ThumbnailServiceImplTest.assertFalse((boolean)this.secureNodeService.hasAspect(corruptNode, RenditionModel.ASPECT_RENDITIONED));
        ThumbnailServiceImplTest.assertFalse((boolean)this.secureNodeService.hasAspect(corruptNode, ContentModel.ASPECT_FAILED_THUMBNAIL_SOURCE));
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ThumbnailDefinition thumbnailDef = ThumbnailServiceImplTest.this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition(ThumbnailServiceImplTest.TEST_THUMBNAIL);
                Action createThumbnailAction = ThumbnailHelper.createCreateThumbnailAction((ThumbnailDefinition)thumbnailDef, (ServiceRegistry)ThumbnailServiceImplTest.this.services);
                ThumbnailServiceImplTest.this.actionService.executeAction(createThumbnailAction, corruptNode, true, true);
                return null;
            }
        });
        Thread.sleep(3000L);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ThumbnailServiceImplTest.assertFalse((String)"corrupt node should not have renditioned aspect", (boolean)ThumbnailServiceImplTest.this.secureNodeService.hasAspect(corruptNode, RenditionModel.ASPECT_RENDITIONED));
                ThumbnailServiceImplTest.assertTrue((String)"corrupt node should have failed thumbnails aspect", (boolean)ThumbnailServiceImplTest.this.secureNodeService.hasAspect(corruptNode, ContentModel.ASPECT_FAILED_THUMBNAIL_SOURCE));
                Map failedThumbnails = ThumbnailServiceImplTest.this.thumbnailService.getFailedThumbnails(corruptNode);
                ThumbnailServiceImplTest.assertEquals((String)"Wrong number of failed thumbnails", (int)1, (int)failedThumbnails.size());
                ThumbnailServiceImplTest.assertTrue((String)"Missing QName for failed thumbnail", (boolean)failedThumbnails.containsKey(ThumbnailServiceImplTest.TEST_THUMBNAIL));
                FailedThumbnailInfo doclibFailureInfo = (FailedThumbnailInfo)failedThumbnails.get(ThumbnailServiceImplTest.TEST_THUMBNAIL);
                ThumbnailServiceImplTest.assertNotNull((String)"Failure info was null", (Object)doclibFailureInfo);
                ThumbnailServiceImplTest.assertEquals((String)"Failure count was wrong.", (int)1, (int)doclibFailureInfo.getFailureCount());
                ThumbnailServiceImplTest.assertEquals((String)"thumbnail name was wrong.", (String)ThumbnailServiceImplTest.TEST_THUMBNAIL, (String)doclibFailureInfo.getThumbnailDefinitionName());
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ThumbnailDefinition thumbnailDef = ThumbnailServiceImplTest.this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition(ThumbnailServiceImplTest.TEST_THUMBNAIL);
                Action createThumbnailAction = ThumbnailHelper.createCreateThumbnailAction((ThumbnailDefinition)thumbnailDef, (ServiceRegistry)ThumbnailServiceImplTest.this.services);
                ThumbnailServiceImplTest.this.actionService.executeAction(createThumbnailAction, corruptNode, true, true);
                return null;
            }
        });
        Thread.sleep(3000L);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Map failedThumbnails = ThumbnailServiceImplTest.this.thumbnailService.getFailedThumbnails(corruptNode);
                ThumbnailServiceImplTest.assertEquals((String)"Wrong number of failed thumbnails", (int)1, (int)failedThumbnails.size());
                ThumbnailServiceImplTest.assertTrue((String)"Missing QName for failed thumbnail", (boolean)failedThumbnails.containsKey(ThumbnailServiceImplTest.TEST_THUMBNAIL));
                FailedThumbnailInfo doclibFailureInfo = (FailedThumbnailInfo)failedThumbnails.get(ThumbnailServiceImplTest.TEST_THUMBNAIL);
                ThumbnailServiceImplTest.assertNotNull((String)"Failure info was null", (Object)doclibFailureInfo);
                ThumbnailServiceImplTest.assertEquals((String)"Failure count was wrong.", (int)1, (int)doclibFailureInfo.getFailureCount());
                ThumbnailServiceImplTest.assertEquals((String)"thumbnail name was wrong.", (String)ThumbnailServiceImplTest.TEST_THUMBNAIL, (String)doclibFailureInfo.getThumbnailDefinitionName());
                return null;
            }
        });
    }

    @Test
    public void testRuleExecutionOnFailedThumbnailChild() throws Exception {
        HashMap<String, QName> params = new HashMap<String, QName>(1);
        params.put("aspect-name", ContentModel.ASPECT_GEN_CLASSIFIABLE);
        Rule rule = new Rule();
        rule.setRuleType("inbound");
        rule.setTitle("Rule name");
        Action action = this.actionService.createAction("add-features", params);
        ActionCondition condition = this.actionService.createActionCondition("no-condition", null);
        action.addActionCondition(condition);
        rule.setAction(action);
        rule.applyToChildren(true);
        this.services.getRuleService().saveRule(this.folder, rule);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        final NodeRef corruptNode = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                return ThumbnailServiceImplTest.this.createCorruptedContent(ThumbnailServiceImplTest.this.folder);
            }
        });
        ThumbnailServiceImplTest.assertFalse((boolean)this.secureNodeService.hasAspect(corruptNode, ContentModel.ASPECT_FAILED_THUMBNAIL_SOURCE));
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ThumbnailDefinition thumbnailDef = ThumbnailServiceImplTest.this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition(ThumbnailServiceImplTest.TEST_THUMBNAIL);
                Action createThumbnailAction = ThumbnailHelper.createCreateThumbnailAction((ThumbnailDefinition)thumbnailDef, (ServiceRegistry)ThumbnailServiceImplTest.this.services);
                ThumbnailServiceImplTest.this.actionService.executeAction(createThumbnailAction, corruptNode, true, true);
                return null;
            }
        });
        Thread.sleep(3000L);
        NodeRef failedThumbnailNode = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                ThumbnailServiceImplTest.assertTrue((String)"corrupt node should have failed thumbnails aspect", (boolean)ThumbnailServiceImplTest.this.secureNodeService.hasAspect(corruptNode, ContentModel.ASPECT_FAILED_THUMBNAIL_SOURCE));
                Map failedThumbnails = ThumbnailServiceImplTest.this.thumbnailService.getFailedThumbnails(corruptNode);
                ThumbnailServiceImplTest.assertEquals((String)"Wrong number of failed thumbnails", (int)1, (int)failedThumbnails.size());
                ThumbnailServiceImplTest.assertTrue((String)"Missing QName for failed thumbnail", (boolean)failedThumbnails.containsKey(ThumbnailServiceImplTest.TEST_THUMBNAIL));
                FailedThumbnailInfo doclibFailureInfo = (FailedThumbnailInfo)failedThumbnails.get(ThumbnailServiceImplTest.TEST_THUMBNAIL);
                ThumbnailServiceImplTest.assertNotNull((String)"Failure info was null", (Object)doclibFailureInfo);
                return doclibFailureInfo.getFailedThumbnailNode();
            }
        });
        ThumbnailServiceImplTest.assertTrue((String)"Rule must not be executed on document", (boolean)this.secureNodeService.hasAspect(corruptNode, ContentModel.ASPECT_GEN_CLASSIFIABLE));
        ThumbnailServiceImplTest.assertFalse((String)"Rule must not be executed on failed thumbnail", (boolean)this.secureNodeService.hasAspect(failedThumbnailNode, ContentModel.ASPECT_GEN_CLASSIFIABLE));
    }

    @Test
    public void testCreateTransientlyFailingThumbnail() throws Exception {
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, "transientThumbnail.transientThumbnail");
        final NodeRef testNode = this.secureNodeService.createNode(this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"transientThumbnail.transientThumbnail"), ContentModel.TYPE_CONTENT, props).getChildRef();
        this.secureNodeService.setProperty(testNode, ContentModel.PROP_CONTENT, (Serializable)new ContentData(null, "application/vnd.alfresco.test.transientfailure", 0L, null));
        File testFile = AbstractContentTransformerTest.loadNamedQuickTestFile("quick.pdf");
        ThumbnailServiceImplTest.assertNotNull((String)"Failed to load required test file.", (Object)testFile);
        ContentWriter writer = this.contentService.getWriter(testNode, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("application/vnd.alfresco.test.transientfailure");
        writer.setEncoding("UTF-8");
        writer.putContent(testFile);
        logger.debug((Object)("Running failing thumbnail on " + testNode));
        ThumbnailServiceImplTest.assertFalse((boolean)this.secureNodeService.hasAspect(testNode, RenditionModel.ASPECT_RENDITIONED));
        ThumbnailServiceImplTest.assertFalse((boolean)this.secureNodeService.hasAspect(testNode, ContentModel.ASPECT_FAILED_THUMBNAIL_SOURCE));
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ThumbnailDefinition thumbnailDef = ThumbnailServiceImplTest.this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition(ThumbnailServiceImplTest.TEST_THUMBNAIL);
                Action createThumbnailAction = ThumbnailHelper.createCreateThumbnailAction((ThumbnailDefinition)thumbnailDef, (ServiceRegistry)ThumbnailServiceImplTest.this.services);
                ThumbnailServiceImplTest.this.actionService.executeAction(createThumbnailAction, testNode, true, true);
                return null;
            }
        });
        Thread.sleep(3000L);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ThumbnailServiceImplTest.assertFalse((String)"Node should not have renditioned aspect", (boolean)ThumbnailServiceImplTest.this.secureNodeService.hasAspect(testNode, RenditionModel.ASPECT_RENDITIONED));
                ThumbnailServiceImplTest.assertFalse((String)"Node should not have failed thumbnails aspect", (boolean)ThumbnailServiceImplTest.this.secureNodeService.hasAspect(testNode, ContentModel.ASPECT_FAILED_THUMBNAIL_SOURCE));
                return null;
            }
        });
    }

    @Test
    public void testThumbnailUpdate() throws Exception {
        this.checkTransformer();
        NodeRef jpgOrig = this.createOriginalContent(this.folder, "image/jpeg");
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        imageResizeOptions.setWidth(64);
        imageResizeOptions.setHeight(64);
        imageResizeOptions.setResizeToThumbnail(true);
        ImageTransformationOptions imageTransformationOptions = new ImageTransformationOptions();
        imageTransformationOptions.setResizeOptions(imageResizeOptions);
        NodeRef thumbnail1 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/jpeg", (TransformationOptions)imageTransformationOptions, "small");
        ThumbnailServiceImplTest.assertEquals((Object)ContentModel.TYPE_THUMBNAIL, (Object)this.secureNodeService.getType(thumbnail1));
        this.thumbnailService.updateThumbnail(thumbnail1, (TransformationOptions)imageTransformationOptions);
        ThumbnailServiceImplTest.assertEquals((Object)ContentModel.TYPE_THUMBNAIL, (Object)this.secureNodeService.getType(thumbnail1));
    }

    @Test
    public void testGetThumbnailByName() throws Exception {
        this.checkTransformer();
        NodeRef jpgOrig = this.createOriginalContent(this.folder, "image/jpeg");
        NodeRef result1 = this.thumbnailService.getThumbnailByName(jpgOrig, ContentModel.PROP_CONTENT, "small");
        ThumbnailServiceImplTest.assertNull((String)"The thumbnail 'small' should have been missing", (Object)result1);
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        imageResizeOptions.setWidth(64);
        imageResizeOptions.setHeight(64);
        imageResizeOptions.setResizeToThumbnail(true);
        ImageTransformationOptions imageTransformationOptions = new ImageTransformationOptions();
        imageTransformationOptions.setResizeOptions(imageResizeOptions);
        this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/jpeg", (TransformationOptions)imageTransformationOptions, "small");
        NodeRef result2 = this.thumbnailService.getThumbnailByName(jpgOrig, ContentModel.PROP_CONTENT, "small");
        ThumbnailServiceImplTest.assertNotNull((Object)result2);
        this.checkRendition("small", result2);
        NodeRef result3 = this.thumbnailService.getThumbnailByName(jpgOrig, ContentModel.PROP_CONTENT, "anotherone");
        ThumbnailServiceImplTest.assertNull((String)"The thumbnail 'anotherone' should have been missing", (Object)result3);
    }

    @Test
    public void testIfNodesExistsAfterCreateThumbnail() throws IOException {
        LogErrorAppender logErrorAppender = new LogErrorAppender();
        Logger rootLogger = LogManager.getRootLogger();
        Log4jAppenderUtil.addAbstractAppenderToLogger(logErrorAppender, rootLogger);
        final NodeRef pdfOrig = this.createOriginalContent(this.folder, "application/pdf");
        QName qname = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"doclib");
        final ThumbnailDefinition details = this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition(qname.getLocalName());
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TestNodeDeleterListener testNodeDeleterListener = new TestNodeDeleterListener(pdfOrig);
                AlfrescoTransactionSupport.bindListener((TransactionListener)testNodeDeleterListener, (int)1);
                ThumbnailServiceImplTest.this.thumbnailService.createThumbnail(pdfOrig, ContentModel.PROP_CONTENT, "image/jpeg", details.getTransformationOptions(), "doclib");
                return null;
            }
        }, false, true);
        ThumbnailServiceImplTest.assertEquals((String)"There should be no error anymore", (int)0, (int)logErrorAppender.getLog().size());
    }

    @Test
    public void testLastThumbnailModificationDataContentUpdates() throws Exception {
        final NodeRef pdfOrig = this.createOriginalContent(this.folder, "application/pdf");
        QName qname = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"doclib");
        ThumbnailDefinition details = this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition(qname.getLocalName());
        NodeRef thumbnail = this.thumbnailService.createThumbnail(pdfOrig, ContentModel.PROP_CONTENT, "image/jpeg", details.getTransformationOptions(), "doclib");
        ThumbnailServiceImplTest.assertNotNull((Object)thumbnail);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        Thread.sleep(1000L);
        String lastThumbnailDataV1 = (String)((List)((Object)this.secureNodeService.getProperty(pdfOrig, ContentModel.PROP_LAST_THUMBNAIL_MODIFICATION_DATA))).get(0);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ThumbnailServiceImplTest.this.setNewContent(pdfOrig, "quick-size-limit.", "application/pdf");
                return null;
            }
        }, false, true);
        Thread.sleep(1000L);
        String lastThumbnailDataV2 = (String)((List)((Object)this.secureNodeService.getProperty(pdfOrig, ContentModel.PROP_LAST_THUMBNAIL_MODIFICATION_DATA))).get(0);
        ThumbnailServiceImplTest.assertFalse((String)"Property 'Last thumbnail modification data' has not changed", (boolean)lastThumbnailDataV1.equals(lastThumbnailDataV2));
    }

    @Test
    public void testLastThumbnailModificationDataContentCopy() throws Exception {
        NodeRef pdfOrig = this.createOriginalContent(this.folder, "application/pdf");
        QName qname = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"doclib");
        ThumbnailDefinition details = this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition(qname.getLocalName());
        NodeRef thumbnail = this.thumbnailService.createThumbnail(pdfOrig, ContentModel.PROP_CONTENT, "image/jpeg", details.getTransformationOptions(), "doclib");
        ThumbnailServiceImplTest.assertNotNull((Object)thumbnail);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        Thread.sleep(1000L);
        List lastThumbnailData = (List)((Object)this.secureNodeService.getProperty(pdfOrig, ContentModel.PROP_LAST_THUMBNAIL_MODIFICATION_DATA));
        ThumbnailServiceImplTest.assertNotNull((Object)lastThumbnailData);
        ThumbnailServiceImplTest.assertEquals((int)1, (int)lastThumbnailData.size());
        ThumbnailServiceImplTest.assertTrue((boolean)((String)lastThumbnailData.get(0)).contains("doclib:"));
        NodeRef pdfCopy = this.copyService.copy(pdfOrig, this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"copyOfOriginal"));
        List lastThumbnailDataCopy = (List)((Object)this.secureNodeService.getProperty(pdfCopy, ContentModel.PROP_LAST_THUMBNAIL_MODIFICATION_DATA));
        ThumbnailServiceImplTest.assertNull((Object)lastThumbnailDataCopy);
    }

    @Test
    public void testLockedContent() throws Exception {
        NodeRef sharedHomeNodeRef = this.repositoryHelper.getSharedHome();
        String user1 = "bob" + GUID.generate();
        this.createUser(user1);
        String user2 = "fred" + GUID.generate();
        this.createUser(user2);
        this.authenticationComponent.setCurrentUser(user1);
        NodeRef pdfOrig = this.createOriginalContent(sharedHomeNodeRef, "testLockedContent-" + GUID.generate(), "application/pdf");
        this.lockService.lock(pdfOrig, LockType.READ_ONLY_LOCK);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        TestTransaction.start();
        this.authenticationComponent.setCurrentUser(user2);
        ThumbnailServiceImplTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(pdfOrig, "Read"));
        ThumbnailServiceImplTest.assertEquals((Object)AccessStatus.DENIED, (Object)this.permissionService.hasPermission(pdfOrig, "Write"));
        QName qname = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"doclib");
        ThumbnailServiceImplTest.assertNull((Object)this.thumbnailService.getThumbnailByName(pdfOrig, ContentModel.PROP_CONTENT, qname.getLocalName()));
        ThumbnailServiceImplTest.assertNull((Object)this.secureNodeService.getProperty(pdfOrig, ContentModel.PROP_LAST_THUMBNAIL_MODIFICATION_DATA));
        ThumbnailDefinition details = this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition(qname.getLocalName());
        NodeRef thumbnail = this.thumbnailService.createThumbnail(pdfOrig, ContentModel.PROP_CONTENT, "image/jpeg", details.getTransformationOptions(), "doclib");
        ThumbnailServiceImplTest.assertNotNull((Object)thumbnail);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        Thread.sleep(1000L);
        TestTransaction.start();
        this.authenticationComponent.setCurrentUser(user1);
        ThumbnailServiceImplTest.assertNotNull((Object)this.thumbnailService.getThumbnailByName(pdfOrig, ContentModel.PROP_CONTENT, qname.getLocalName()));
        ThumbnailServiceImplTest.assertNotNull((Object)this.secureNodeService.getProperty(pdfOrig, ContentModel.PROP_LAST_THUMBNAIL_MODIFICATION_DATA));
        this.lockService.unlock(pdfOrig, false);
        this.secureNodeService.deleteNode(pdfOrig);
        TestTransaction.flagForCommit();
        TestTransaction.end();
    }

    private void setNewContent(NodeRef noderef, String quickFileName, String mimetype) throws IOException {
        String ext = this.mimetypeMap.getExtension(mimetype);
        File origFile = AbstractContentTransformerTest.loadNamedQuickTestFile(String.valueOf(quickFileName) + ext);
        ContentWriter writer = this.contentService.getWriter(noderef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(mimetype);
        writer.setEncoding("UTF-8");
        writer.putContent(origFile);
    }

    private void checkRenditioned(NodeRef contentNodeRef, List<ExpectedAssoc> expectedAssocs) {
        ThumbnailServiceImplTest.assertTrue((String)"Renditioned aspect should have been applied", (boolean)this.secureNodeService.hasAspect(contentNodeRef, RenditionModel.ASPECT_RENDITIONED));
        for (ExpectedAssoc expectedAssoc : expectedAssocs) {
            QName qNamePattern = expectedAssoc.getAssocName() != null ? QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)expectedAssoc.getAssocName()) : null;
            List assocs = this.secureNodeService.getChildAssocs(contentNodeRef, expectedAssoc.getAssocTypeQName(), (QNamePattern)qNamePattern);
            ThumbnailServiceImplTest.assertNotNull((Object)assocs);
            ThumbnailServiceImplTest.assertEquals((String)(expectedAssoc + " association count mismatch"), (int)expectedAssoc.getCount(), (int)assocs.size());
        }
    }

    private void checkRendition(String thumbnailName, NodeRef thumbnail) {
        ThumbnailServiceImplTest.assertTrue((String)"Thumbnail should have been a rendition", (boolean)this.renditionService.isRendition(thumbnail));
        if (thumbnailName != null) {
            ThumbnailServiceImplTest.assertEquals((Object)thumbnailName, (Object)this.secureNodeService.getProperty(thumbnail, ContentModel.PROP_NAME));
        }
        ThumbnailServiceImplTest.assertEquals((Object)ContentModel.PROP_CONTENT, (Object)this.secureNodeService.getProperty(thumbnail, ContentModel.PROP_CONTENT_PROPERTY_NAME));
        ThumbnailServiceImplTest.assertEquals((String)"The thumbnail node should be of type cm:thumbnail!", (Object)ContentModel.TYPE_THUMBNAIL, (Object)this.secureNodeService.getType(thumbnail));
        ThumbnailServiceImplTest.assertEquals((Object)thumbnailName, (Object)this.secureNodeService.getProperty(thumbnail, ContentModel.PROP_THUMBNAIL_NAME));
        ContentData thumbnailData = (ContentData)this.secureNodeService.getProperty(thumbnail, ContentModel.PROP_CONTENT);
        ThumbnailServiceImplTest.assertNotNull((String)"Thumbnail data was null", (Object)thumbnailData);
        ThumbnailServiceImplTest.assertTrue((String)"Thumbnail data was empty", (thumbnailData.getSize() > 0L ? 1 : 0) != 0);
    }

    private void outputThumbnailTempContentLocation(NodeRef thumbnail, String ext, String message) throws IOException {
        File tempFile = TempFileProvider.createTempFile((String)"thumbnailServiceImplTest", (String)("." + ext));
        ContentReader reader = this.contentService.getReader(thumbnail, ContentModel.PROP_CONTENT);
        reader.getContent(tempFile);
        System.out.println(String.valueOf(message) + ": " + tempFile.getPath());
    }

    private NodeRef createOriginalContent(NodeRef parentFolder, String mimetype) throws IOException {
        return this.createOriginalContent(parentFolder, "original", mimetype);
    }

    private NodeRef createOriginalContent(NodeRef parentFolder, String baseName, String mimetype) throws IOException {
        String ext = this.mimetypeMap.getExtension(mimetype);
        File origFile = AbstractContentTransformerTest.loadQuickTestFile(ext);
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NAME, String.valueOf(baseName) + "." + ext);
        NodeRef node = this.secureNodeService.createNode(parentFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("original." + ext)), ContentModel.TYPE_CONTENT, props).getChildRef();
        ContentWriter writer = this.contentService.getWriter(node, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(mimetype);
        writer.setEncoding("UTF-8");
        writer.putContent(origFile);
        return node;
    }

    private NodeRef createCorruptedContent(NodeRef parentFolder) throws IOException {
        File corruptPdfFile = AbstractContentTransformerTest.loadNamedQuickTestFile("quickCorrupt.pdf");
        ThumbnailServiceImplTest.assertNotNull((String)"Failed to load required test file.", (Object)corruptPdfFile);
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, "corrupt.pdf");
        NodeRef node = this.secureNodeService.createNode(parentFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"quickCorrupt.pdf"), ContentModel.TYPE_CONTENT, props).getChildRef();
        this.secureNodeService.setProperty(node, ContentModel.PROP_CONTENT, (Serializable)new ContentData(null, "application/pdf", 0L, null));
        ContentWriter writer = this.contentService.getWriter(node, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("application/pdf");
        writer.setEncoding("UTF-8");
        writer.putContent(corruptPdfFile);
        return node;
    }

    @Test
    public void testAutoUpdate() throws Exception {
        this.checkTransformer();
        final NodeRef jpgOrig = this.createOriginalContent(this.folder, "image/jpeg");
        ThumbnailDefinition details = this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition("medium");
        this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, details.getMimetype(), details.getTransformationOptions(), details.getName());
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                String ext = ThumbnailServiceImplTest.this.mimetypeMap.getExtension("image/jpeg");
                File origFile = AbstractContentTransformerTest.loadQuickTestFile(ext);
                ContentWriter writer = ThumbnailServiceImplTest.this.contentService.getWriter(jpgOrig, ContentModel.PROP_CONTENT, true);
                writer.putContent(origFile);
                return null;
            }
        });
    }

    @Test
    @Ignore(value="The test was never run and fails on remote transformer")
    public void testHTMLToImageAndSWF() throws Exception {
        ContentReader reader;
        NodeRef thumb;
        NodeRef nodeRef = this.createOriginalContent(this.folder, "text/html");
        ThumbnailDefinition def = this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition("medium");
        TransformationOptions transformationOptions = def.getTransformationOptions();
        Map options = this.converter.getOptions(transformationOptions, "text/html", def.getMimetype());
        String targetMimetype = def.getMimetype();
        boolean supported = this.synchronousTransformClient.isSupported("text/html", -1L, null, targetMimetype, options, null, null);
        if (supported) {
            thumb = this.thumbnailService.createThumbnail(nodeRef, ContentModel.PROP_CONTENT, def.getMimetype(), def.getTransformationOptions(), def.getName());
            ThumbnailServiceImplTest.assertNotNull((Object)thumb);
            reader = this.contentService.getReader(thumb, ContentModel.PROP_CONTENT);
            ThumbnailServiceImplTest.assertNotNull((Object)reader);
            ThumbnailServiceImplTest.assertEquals((String)def.getMimetype(), (String)reader.getMimetype());
            ThumbnailServiceImplTest.assertTrue((reader.getSize() != 0L ? 1 : 0) != 0);
        }
        def = this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition("webpreview");
        if (supported) {
            thumb = this.thumbnailService.createThumbnail(nodeRef, ContentModel.PROP_CONTENT, def.getMimetype(), def.getTransformationOptions(), def.getName());
            ThumbnailServiceImplTest.assertNotNull((Object)thumb);
            reader = this.contentService.getReader(thumb, ContentModel.PROP_CONTENT);
            ThumbnailServiceImplTest.assertNotNull((Object)reader);
            ThumbnailServiceImplTest.assertEquals((String)def.getMimetype(), (String)reader.getMimetype());
            ThumbnailServiceImplTest.assertTrue((reader.getSize() != 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testThumbnailServiceCreateApi() throws Exception {
        HashMap<QName, String> folderProps = new HashMap<QName, String>();
        folderProps.put(ContentModel.PROP_NAME, "otherTestFolder");
        NodeRef otherFolder = this.secureNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"otherTestFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        this.checkTransformer();
        NodeRef jpgOrig = this.createOriginalContent(this.folder, "image/jpeg");
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        imageResizeOptions.setWidth(64);
        imageResizeOptions.setHeight(64);
        imageResizeOptions.setResizeToThumbnail(true);
        ImageTransformationOptions imageTransformationOptions = new ImageTransformationOptions();
        imageTransformationOptions.setResizeOptions(imageResizeOptions);
        NodeRef thumbnail1 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/jpeg", (TransformationOptions)imageTransformationOptions, "smallJpeg");
        ThumbnailServiceImplTest.assertNotNull((Object)thumbnail1);
        this.checkRenditioned(jpgOrig, Collections.singletonList(new ExpectedAssoc(RegexQNamePattern.MATCH_ALL, "smallJpeg", 1)));
        this.checkRendition("smallJpeg", thumbnail1);
        this.outputThumbnailTempContentLocation(thumbnail1, "jpg", "smallJpeg - 64x64, marked as thumbnail");
        thumbnail1 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/png", (TransformationOptions)imageTransformationOptions, "smallPng");
        ThumbnailServiceImplTest.assertNotNull((Object)thumbnail1);
        this.checkRenditioned(jpgOrig, Collections.singletonList(new ExpectedAssoc(RegexQNamePattern.MATCH_ALL, "smallPng", 1)));
        this.checkRendition("smallPng", thumbnail1);
        this.outputThumbnailTempContentLocation(thumbnail1, "png", "smallPng - 64x64, marked as thumbnail");
        ThumbnailParentAssociationDetails tpad = new ThumbnailParentAssociationDetails(otherFolder, QName.createQName((String)"http://www.alfresco.org/model/rendition/1.0", (String)"foo"), QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"bar"));
        thumbnail1 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/png", (TransformationOptions)imageTransformationOptions, "targetDetails", tpad);
        ThumbnailServiceImplTest.assertNotNull((Object)thumbnail1);
        this.checkRenditioned(jpgOrig, Collections.singletonList(new ExpectedAssoc(RegexQNamePattern.MATCH_ALL, "targetDetails", 1)));
        this.checkRendition("targetDetails", thumbnail1);
        this.outputThumbnailTempContentLocation(thumbnail1, "png", "targetDetails - 64x64, marked as thumbnail");
        thumbnail1 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/png", (TransformationOptions)imageTransformationOptions, null);
        ThumbnailServiceImplTest.assertNotNull((Object)thumbnail1);
        this.checkRenditioned(jpgOrig, Collections.singletonList(new ExpectedAssoc(RegexQNamePattern.MATCH_ALL, null, 4)));
        this.checkRendition(null, thumbnail1);
        this.outputThumbnailTempContentLocation(thumbnail1, "png", "'null' - 64x64, marked as thumbnail");
    }

    @Test
    public void testRegistry() {
        ThumbnailRegistry thumbnailRegistry = this.thumbnailService.getThumbnailRegistry();
        List defs = thumbnailRegistry.getThumbnailDefinitions("text/html", -1L);
        ThumbnailServiceImplTest.assertFalse((String)"There should be some thumbnails", (boolean)defs.isEmpty());
        System.out.println("Definitions ...");
        for (ThumbnailDefinition def : defs) {
            System.out.println("Thumbnail Available: " + def.getName());
        }
    }

    @Test
    public void testJSAPI() throws Exception {
        NodeRef jpgOrig = this.createOriginalContent(this.folder, "image/jpeg");
        NodeRef gifOrig = this.createOriginalContent(this.folder, "image/gif");
        NodeRef pdfOrig = this.createOriginalContent(this.folder, "application/pdf");
        NodeRef docOrig = this.createOriginalContent(this.folder, "application/msword");
        HashMap<String, NodeRef> model = new HashMap<String, NodeRef>(2);
        model.put("jpgOrig", jpgOrig);
        model.put("gifOrig", gifOrig);
        model.put("pdfOrig", pdfOrig);
        model.put("docOrig", docOrig);
        ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/thumbnail/script/test_thumbnailAPI.js");
        this.scriptService.executeScript((ScriptLocation)location, model);
    }

    @Test
    public void testPlaceHoldersByMimeType() throws Exception {
        String doclibIcon = this.scriptThumbnailService.getPlaceHolderResourcePath("doclib");
        ThumbnailServiceImplTest.assertEquals((String)"alfresco/thumbnail/thumbnail_placeholder_doclib.png", (String)doclibIcon);
        doclibIcon = this.scriptThumbnailService.getMimeAwarePlaceHolderResourcePath("doclib", null);
        ThumbnailServiceImplTest.assertEquals((String)"alfresco/thumbnail/thumbnail_placeholder_doclib.png", (String)doclibIcon);
        String docxDoclibIcon = this.scriptThumbnailService.getMimeAwarePlaceHolderResourcePath("doclib", "application/msword");
        ThumbnailServiceImplTest.assertEquals((String)"alfresco/thumbnail/thumbnail_placeholder_doclib_doc.png", (String)docxDoclibIcon);
        String fallbackDoclibIcon = this.scriptThumbnailService.getMimeAwarePlaceHolderResourcePath("doclib", "application/wibble");
        ThumbnailServiceImplTest.assertEquals((String)"alfresco/thumbnail/thumbnail_placeholder_doclib.png", (String)fallbackDoclibIcon);
        String mediumIcon = this.scriptThumbnailService.getPlaceHolderResourcePath("medium");
        ThumbnailServiceImplTest.assertEquals((String)"alfresco/thumbnail/thumbnail_placeholder_medium.jpg", (String)mediumIcon);
    }

    protected void performLongRunningThumbnailTest(final List<ExpectedThumbnail> expectedThumbnails, final List<ExpectedAssoc> expectedAssocs, LongRunningConcurrentWork concurrentWork, Integer retryPeriod, Integer quietPeriod) throws Exception {
        long saveRetryPeriod = this.failureHandlingOptions.getRetryPeriod();
        long saveQuietPeriod = this.failureHandlingOptions.getQuietPeriod();
        try {
            HashMap<QName, String> props = new HashMap<QName, String>(1);
            props.put(ContentModel.PROP_NAME, "original.test");
            final NodeRef source = this.secureNodeService.createNode(this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"original.test"), ContentModel.TYPE_CONTENT, props).getChildRef();
            ContentWriter writer = this.contentService.getWriter(source, ContentModel.PROP_CONTENT, true);
            writer.setMimetype("application/vnd.alfresco.test.longrunning");
            writer.setEncoding("UTF-8");
            writer.putContent("OrigContent");
            logger.debug((Object)("Created source content: " + source));
            long startTime = new Date().getTime();
            if (retryPeriod != null) {
                this.failureHandlingOptions.setRetryPeriod((long)retryPeriod.intValue());
            }
            if (quietPeriod != null) {
                this.failureHandlingOptions.setQuietPeriod((long)quietPeriod.intValue());
            }
            for (ExpectedThumbnail expectedThumbnail : expectedThumbnails) {
                ThumbnailDefinition thumbnailDef = this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition(expectedThumbnail.getThumbnailName());
                Action createThumbnailAction = ThumbnailHelper.createCreateThumbnailAction((ThumbnailDefinition)thumbnailDef, (ServiceRegistry)this.services);
                logger.debug((Object)("Creating thumbnail " + expectedThumbnail.getThumbnailName() + " for " + source));
                this.actionService.executeAction(createThumbnailAction, source, true, true);
            }
            TestTransaction.flagForCommit();
            TestTransaction.end();
            if (concurrentWork != null) {
                logger.debug((Object)("Starting concurrent work for " + source));
                concurrentWork.run(source);
            }
            if (concurrentWork != null) {
                logger.debug((Object)("Verifying concurrent work for " + source));
                concurrentWork.verify(source);
            }
            long endTime = new Date().getTime();
            for (final ExpectedThumbnail expectedThumbnail : expectedThumbnails) {
                NodeRef thumbnail = null;
                while (endTime - startTime < 25000L) {
                    thumbnail = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                        public NodeRef execute() throws Throwable {
                            return ThumbnailServiceImplTest.this.thumbnailService.getThumbnailByName(source, ContentModel.PROP_CONTENT, expectedThumbnail.getThumbnailName());
                        }
                    }, true, true);
                    if (thumbnail != null) break;
                    Thread.sleep(200L);
                    logger.debug((Object)("Elapsed " + (endTime - startTime) + " ms of " + 25000L + " ms waiting for " + expectedThumbnail.getThumbnailName()));
                    endTime = new Date().getTime();
                }
                ThumbnailServiceImplTest.assertNotNull((String)("The thumbnail " + expectedThumbnail.getThumbnailName() + " was not generated in time."), thumbnail);
            }
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    for (ExpectedThumbnail expectedThumbnail : expectedThumbnails) {
                        String thumbnailName = expectedThumbnail.getThumbnailName();
                        NodeRef thumbnailNodeRef = ThumbnailServiceImplTest.this.thumbnailService.getThumbnailByName(source, ContentModel.PROP_CONTENT, thumbnailName);
                        ThumbnailServiceImplTest.this.checkRendition(thumbnailName, thumbnailNodeRef);
                    }
                    ThumbnailServiceImplTest.this.checkRenditioned(source, expectedAssocs);
                    return null;
                }
            });
        }
        finally {
            this.failureHandlingOptions.setRetryPeriod(saveRetryPeriod);
            this.failureHandlingOptions.setQuietPeriod(saveQuietPeriod);
        }
    }

    @Test
    public void testLongRunningThumbnails() throws Exception {
        logger.debug((Object)"Starting testLongRunningThumbnails");
        this.performLongRunningThumbnailTest(Collections.singletonList(ExpectedThumbnail.withName("imgpreview")), Collections.singletonList(new ExpectedAssoc(RegexQNamePattern.MATCH_ALL, "imgpreview", 1)), new EmptyLongRunningConcurrentWork(), 60, null);
    }

    @Test
    public void testUpdatePropertyDuringLongRunningThumbnail() throws Exception {
        if (this.shouldTestBeSkippedForCurrentDB()) {
            return;
        }
        logger.debug((Object)"Starting testUpdatePropertyDuringLongRunningThumbnail");
        LongRunningConcurrentWork updatePropertyWork = new LongRunningConcurrentWork(){

            @Override
            public void run(NodeRef source) throws Exception {
                Thread.sleep(500L);
                logger.debug((Object)("Updating description of a node: " + source));
                ThumbnailServiceImplTest.this.secureNodeService.setProperty(source, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"NewValue"));
            }

            @Override
            public void verify(NodeRef source) throws Exception {
                String description = (String)((Object)ThumbnailServiceImplTest.this.secureNodeService.getProperty(source, ContentModel.PROP_DESCRIPTION));
                ThumbnailServiceImplTest.assertEquals((String)"The node's property was not updated.", (String)"NewValue", (String)description);
            }
        };
        this.performLongRunningThumbnailTest(Collections.singletonList(ExpectedThumbnail.withName("imgpreview")), Collections.singletonList(new ExpectedAssoc(RegexQNamePattern.MATCH_ALL, "imgpreview", 1)), updatePropertyWork, 1, null);
    }

    @Test
    public void testCreateMultipleLongRunningThumbnails() throws Exception {
        logger.debug((Object)"Starting testCreateMultipleLongRunningThumbnails");
        ArrayList<ExpectedThumbnail> expectedThumbnails = new ArrayList<ExpectedThumbnail>(2);
        expectedThumbnails.add(ExpectedThumbnail.withName("imgpreview"));
        expectedThumbnails.add(ExpectedThumbnail.withName("avatar"));
        ArrayList<ExpectedAssoc> expectedAssocs = new ArrayList<ExpectedAssoc>(5);
        expectedAssocs.add(new ExpectedAssoc((QNamePattern)RenditionModel.ASSOC_RENDITION, "imgpreview", 1));
        expectedAssocs.add(new ExpectedAssoc((QNamePattern)RenditionModel.ASSOC_RENDITION, "avatar", 1));
        this.performLongRunningThumbnailTest(expectedThumbnails, expectedAssocs, new EmptyLongRunningConcurrentWork(), 1, 1);
    }

    private boolean shouldTestBeSkippedForCurrentDB() {
        Dialect dialect = (Dialect)this.applicationContext.getBean("dialect");
        return dialect instanceof Oracle9Dialect || dialect instanceof SQLServerDialect;
    }

    private class EmptyLongRunningConcurrentWork
    implements LongRunningConcurrentWork {
        private EmptyLongRunningConcurrentWork() {
        }

        @Override
        public void run(NodeRef source) throws Exception {
        }

        @Override
        public void verify(NodeRef source) throws Exception {
        }
    }

    private static class ExpectedAssoc {
        private QNamePattern assocTypeQName;
        private String assocName;
        private int count;

        public ExpectedAssoc(QNamePattern assocTypeQName, String assocName, int count) {
            this.assocTypeQName = assocTypeQName;
            this.assocName = assocName;
            this.count = count;
        }

        public QNamePattern getAssocTypeQName() {
            return this.assocTypeQName;
        }

        public String getAssocName() {
            return this.assocName;
        }

        public int getCount() {
            return this.count;
        }

        public String toString() {
            return "ExpectedAssoc [assocTypeQName=" + this.assocTypeQName + ", assocName=" + this.assocName + ", count=" + this.count + "]";
        }
    }

    private static class ExpectedThumbnail {
        private String thumbnailName;

        public static ExpectedThumbnail ignoredName() {
            return new ExpectedThumbnail();
        }

        public static ExpectedThumbnail withName(String thumbnailName) {
            return new ExpectedThumbnail(thumbnailName);
        }

        public ExpectedThumbnail() {
        }

        public ExpectedThumbnail(String thumbnailName) {
            this.thumbnailName = thumbnailName;
        }

        public String getThumbnailName() {
            return this.thumbnailName;
        }

        public String toString() {
            return "ExpectedThumbnail [thumbnailName=" + this.thumbnailName + "]";
        }
    }

    @Plugin(name="LogErrorAppender", category="Core")
    private class LogErrorAppender
    extends AbstractAppender {
        private final List<LogEvent> log;

        protected LogErrorAppender() {
            super("LogErrorAppender", null, null, false, null);
            this.log = new ArrayList<LogEvent>();
        }

        public void append(LogEvent loggingEvent) {
            if (loggingEvent.getLevel() == Level.ERROR) {
                this.log.add(loggingEvent);
            }
        }

        public List<LogEvent> getLog() {
            return new ArrayList<LogEvent>(this.log);
        }
    }

    private static interface LongRunningConcurrentWork {
        public void run(NodeRef var1) throws Exception;

        public void verify(NodeRef var1) throws Exception;
    }

    private class TestNodeDeleterListener
    extends TransactionListenerAdapter {
        private final NodeRef nodeRef;

        private TestNodeDeleterListener(NodeRef nodeRef) {
            this.nodeRef = nodeRef;
        }

        public void afterCommit() {
            ThumbnailServiceImplTest.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    ThumbnailServiceImplTest.this.secureNodeService.deleteNode(TestNodeDeleterListener.this.nodeRef);
                    return null;
                }
            }, false, true);
        }
    }
}

