/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.bundle;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.security.permissions.NodePermissionEntry;
import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.SimpleNodePermissionEntry;
import org.alfresco.repo.security.permissions.impl.traitextender.PermissionServiceExtension;
import org.alfresco.repo.security.permissions.impl.traitextender.PermissionServiceTrait;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.store.VirtualStore;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionContext;
import org.alfresco.service.namespace.QName;
import org.alfresco.traitextender.SpringBeanExtension;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VirtualPermissionServiceExtension
extends SpringBeanExtension<PermissionServiceExtension, PermissionServiceTrait>
implements PermissionServiceExtension {
    private static Log logger = LogFactory.getLog(VirtualPermissionServiceExtension.class);
    private VirtualStore smartStore;

    public VirtualPermissionServiceExtension() {
        super(PermissionServiceTrait.class);
    }

    public void setSmartStore(VirtualStore smartStore) {
        this.smartStore = smartStore;
    }

    public AccessStatus hasPermission(NodeRef nodeRef, String perm) {
        PermissionServiceTrait theTrait = (PermissionServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            return theTrait.hasPermission(nodeRef, perm);
        }
        AccessStatus virtualAccessStatus = this.smartStore.hasPermission(reference, perm);
        if (!AccessStatus.UNDETERMINED.equals((Object)virtualAccessStatus)) {
            return virtualAccessStatus;
        }
        NodeRef nodeToAdhereTo = this.establishPermisisonAdherence(reference);
        if (nodeToAdhereTo == null) {
            return AccessStatus.UNDETERMINED;
        }
        return theTrait.hasPermission(nodeToAdhereTo, perm);
    }

    @Override
    public AccessStatus hasPermission(NodeRef nodeRef, PermissionReference perm) {
        PermissionServiceTrait theTrait = (PermissionServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            return theTrait.hasPermission(nodeRef, perm);
        }
        AccessStatus virtualAccessStatus = this.smartStore.hasPermission(reference, perm);
        if (!AccessStatus.UNDETERMINED.equals((Object)virtualAccessStatus)) {
            return virtualAccessStatus;
        }
        NodeRef nodeToAdhereTo = this.establishPermisisonAdherence(reference);
        if (nodeToAdhereTo == null) {
            return AccessStatus.UNDETERMINED;
        }
        return theTrait.hasPermission(nodeToAdhereTo, perm);
    }

    @Override
    public PermissionReference getAllPermissionReference() {
        return ((PermissionServiceTrait)this.getTrait()).getAllPermissionReference();
    }

    @Override
    public Set<PermissionReference> getSettablePermissionReferences(QName type) {
        return ((PermissionServiceTrait)this.getTrait()).getSettablePermissionReferences(type);
    }

    @Override
    public Set<PermissionReference> getSettablePermissionReferences(NodeRef nodeRef) {
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            return ((PermissionServiceTrait)this.getTrait()).getSettablePermissionReferences(nodeRef);
        }
        return Collections.emptySet();
    }

    @Override
    public NodePermissionEntry getSetPermissions(NodeRef nodeRef) {
        List<Object> actualPermissionEntries;
        PermissionServiceTrait theTrait = (PermissionServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            return theTrait.getSetPermissions(nodeRef);
        }
        NodePermissionEntry virtualSetPermissions = this.smartStore.getSetPermissions(reference);
        NodeRef nodeToAdhereTo = this.establishPermisisonAdherence(reference);
        boolean inheritPermissions = false;
        if (nodeToAdhereTo != null) {
            NodePermissionEntry actualSetPermissions = theTrait.getSetPermissions(nodeToAdhereTo);
            actualPermissionEntries = actualSetPermissions.getPermissionEntries();
            inheritPermissions = actualSetPermissions.inheritPermissions();
        } else {
            actualPermissionEntries = Collections.emptyList();
            inheritPermissions = false;
        }
        LinkedList<PermissionEntry> mergedEntries = new LinkedList<PermissionEntry>();
        List<? extends PermissionEntry> virtualPermissionEntries = virtualSetPermissions.getPermissionEntries();
        HashSet<QName> overridenPermissions = new HashSet<QName>();
        for (PermissionEntry permissionEntry : virtualPermissionEntries) {
            overridenPermissions.add(permissionEntry.getPermissionReference().getQName());
            mergedEntries.add(permissionEntry);
        }
        for (PermissionEntry permissionEntry : actualPermissionEntries) {
            if (overridenPermissions.contains(permissionEntry.getPermissionReference().getQName())) continue;
            mergedEntries.add(permissionEntry);
        }
        return new SimpleNodePermissionEntry(nodeRef, inheritPermissions, mergedEntries);
    }

    private NodeRef establishPermisisonAdherence(Reference reference) {
        NodeRef nodeToAdhereTo = this.smartStore.adhere(reference, 2);
        if (logger.isDebugEnabled() && nodeToAdhereTo == null) {
            logger.debug((Object)("Could not establish permission adherence for " + reference.toString()));
        }
        return nodeToAdhereTo;
    }

    @Override
    public NodePermissionEntry explainPermission(NodeRef nodeRef, PermissionReference perm) {
        return ((PermissionServiceTrait)this.getTrait()).explainPermission(this.smartStore.materializeIfPossible(nodeRef), perm);
    }

    @Override
    public void deletePermissions(NodePermissionEntry nodePermissionEntry) {
        if (Reference.fromNodeRef(nodePermissionEntry.getNodeRef()) == null) {
            ((PermissionServiceTrait)this.getTrait()).deletePermissions(nodePermissionEntry);
        }
    }

    @Override
    public void deletePermission(PermissionEntry permissionEntry) {
        if (Reference.fromNodeRef(permissionEntry.getNodeRef()) == null) {
            ((PermissionServiceTrait)this.getTrait()).deletePermission(permissionEntry);
        }
    }

    @Override
    public void setPermission(PermissionEntry permissionEntry) {
        if (Reference.fromNodeRef(permissionEntry.getNodeRef()) == null) {
            ((PermissionServiceTrait)this.getTrait()).setPermission(permissionEntry);
        }
    }

    @Override
    public void setPermission(NodePermissionEntry nodePermissionEntry) {
        if (Reference.fromNodeRef(nodePermissionEntry.getNodeRef()) == null) {
            ((PermissionServiceTrait)this.getTrait()).setPermission(nodePermissionEntry);
        }
    }

    @Override
    public PermissionReference getPermissionReference(QName qname, String permissionName) {
        return ((PermissionServiceTrait)this.getTrait()).getPermissionReference(permissionName);
    }

    @Override
    public PermissionReference getPermissionReference(String permissionName) {
        return ((PermissionServiceTrait)this.getTrait()).getPermissionReference(permissionName);
    }

    @Override
    public String getPermission(PermissionReference permissionReference) {
        return ((PermissionServiceTrait)this.getTrait()).getPermission(permissionReference);
    }

    @Override
    public void deletePermissions(String recipient) {
        ((PermissionServiceTrait)this.getTrait()).deletePermissions(recipient);
    }

    @Override
    public NodePermissionEntry getSetPermissions(StoreRef storeRef) {
        return ((PermissionServiceTrait)this.getTrait()).getSetPermissions(storeRef);
    }

    public String getOwnerAuthority() {
        return ((PermissionServiceTrait)this.getTrait()).getOwnerAuthority();
    }

    public String getAllAuthorities() {
        return ((PermissionServiceTrait)this.getTrait()).getAllAuthorities();
    }

    public String getAllPermission() {
        return ((PermissionServiceTrait)this.getTrait()).getAllPermission();
    }

    public Set<AccessPermission> getPermissions(NodeRef nodeRef) {
        PermissionServiceTrait theTrait = (PermissionServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            return theTrait.getPermissions(nodeRef);
        }
        Set<AccessPermission> virtualSetPermissions = this.smartStore.getAllSetPermissions(reference);
        NodeRef nodeToAdhereTo = this.establishPermisisonAdherence(reference);
        HashSet<AccessPermission> mergedEntries = new HashSet<AccessPermission>(virtualSetPermissions);
        if (nodeToAdhereTo != null) {
            Set actualSetPermissions = theTrait.getPermissions(nodeToAdhereTo);
            mergedEntries.addAll(actualSetPermissions);
        }
        return mergedEntries;
    }

    public Set<AccessPermission> getAllSetPermissions(NodeRef nodeRef) {
        PermissionServiceTrait theTrait = (PermissionServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            return theTrait.getAllSetPermissions(nodeRef);
        }
        Set<AccessPermission> virtualSetPermissions = this.smartStore.getAllSetPermissions(reference);
        NodeRef nodeToAdhereTo = this.establishPermisisonAdherence(reference);
        Set actualSetPermissions = nodeToAdhereTo != null ? theTrait.getAllSetPermissions(nodeToAdhereTo) : Collections.emptySet();
        HashSet<String> overridenPermissions = new HashSet<String>();
        HashSet<AccessPermission> mergedEntries = new HashSet<AccessPermission>();
        for (AccessPermission permission : virtualSetPermissions) {
            overridenPermissions.add(permission.getPermission());
            mergedEntries.add(permission);
        }
        for (AccessPermission permission : actualSetPermissions) {
            if (overridenPermissions.contains(permission.getPermission())) continue;
            mergedEntries.add(permission);
        }
        return mergedEntries;
    }

    public Set<String> getSettablePermissions(NodeRef nodeRef) {
        if (Reference.fromNodeRef(nodeRef) == null) {
            return ((PermissionServiceTrait)this.getTrait()).getSettablePermissions(nodeRef);
        }
        return Collections.emptySet();
    }

    public Set<String> getSettablePermissions(QName type) {
        return ((PermissionServiceTrait)this.getTrait()).getSettablePermissions(type);
    }

    public AccessStatus hasReadPermission(NodeRef nodeRef) {
        return ((PermissionServiceTrait)this.getTrait()).hasReadPermission(nodeRef);
    }

    public Set<String> getReaders(Long aclId) {
        return ((PermissionServiceTrait)this.getTrait()).getReaders(aclId);
    }

    public Set<String> getReadersDenied(Long aclId) {
        return ((PermissionServiceTrait)this.getTrait()).getReadersDenied(aclId);
    }

    public AccessStatus hasPermission(Long aclID, PermissionContext context, String permission) {
        return ((PermissionServiceTrait)this.getTrait()).hasPermission(aclID, context, permission);
    }

    public void deletePermissions(NodeRef nodeRef) {
        if (Reference.fromNodeRef(nodeRef) == null) {
            ((PermissionServiceTrait)this.getTrait()).deletePermissions(nodeRef);
        }
    }

    public void clearPermission(NodeRef nodeRef, String authority) {
        if (Reference.fromNodeRef(nodeRef) == null) {
            ((PermissionServiceTrait)this.getTrait()).clearPermission(nodeRef, authority);
        }
    }

    public void deletePermission(NodeRef nodeRef, String authority, String permission) {
        if (Reference.fromNodeRef(nodeRef) == null) {
            ((PermissionServiceTrait)this.getTrait()).deletePermission(nodeRef, authority, permission);
        }
    }

    public void setPermission(NodeRef nodeRef, String authority, String permission, boolean allow) {
        if (Reference.fromNodeRef(nodeRef) == null) {
            ((PermissionServiceTrait)this.getTrait()).setPermission(nodeRef, authority, permission, allow);
        }
    }

    public void setInheritParentPermissions(NodeRef nodeRef, boolean inheritParentPermissions) {
        if (Reference.fromNodeRef(nodeRef) == null) {
            ((PermissionServiceTrait)this.getTrait()).setInheritParentPermissions(nodeRef, inheritParentPermissions);
        }
    }

    public boolean getInheritParentPermissions(NodeRef nodeRef) {
        if (Reference.fromNodeRef(nodeRef) == null) {
            return ((PermissionServiceTrait)this.getTrait()).getInheritParentPermissions(nodeRef);
        }
        return false;
    }

    public void setPermission(StoreRef storeRef, String authority, String permission, boolean allow) {
        ((PermissionServiceTrait)this.getTrait()).setPermission(storeRef, authority, permission, allow);
    }

    public void deletePermission(StoreRef storeRef, String authority, String permission) {
        ((PermissionServiceTrait)this.getTrait()).deletePermission(storeRef, authority, permission);
    }

    public void clearPermission(StoreRef storeRef, String authority) {
        ((PermissionServiceTrait)this.getTrait()).clearPermission(storeRef, authority);
    }

    public void deletePermissions(StoreRef storeRef) {
        ((PermissionServiceTrait)this.getTrait()).deletePermissions(storeRef);
    }

    public Set<AccessPermission> getAllSetPermissions(StoreRef storeRef) {
        return ((PermissionServiceTrait)this.getTrait()).getAllSetPermissions(storeRef);
    }

    public Set<String> getAuthorisations() {
        return ((PermissionServiceTrait)this.getTrait()).getAuthorisations();
    }

    public void setInheritParentPermissions(NodeRef nodeRef, boolean inheritParentPermissions, boolean asyncCall) {
        ((PermissionServiceTrait)this.getTrait()).setInheritParentPermissions(nodeRef, inheritParentPermissions, asyncCall);
    }
}

