/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.CompositePasswordEncoder;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.authentication.RepositoryAuthenticationDao;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;

public class UpgradePasswordHashWorker
implements ApplicationContextAware,
InitializingBean {
    private static final QName LOCK = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"UpgradePasswordHashWorker");
    private static final long LOCK_TTL = 60000L;
    private static Log logger = LogFactory.getLog(UpgradePasswordHashWorker.class);
    private JobLockService jobLockService;
    private TransactionService transactionService;
    private MutableAuthenticationDao authenticationDao;
    private CompositePasswordEncoder passwordEncoder;
    private NodeDAO nodeDAO;
    private PatchDAO patchDAO;
    private QNameDAO qnameDAO;
    private BehaviourFilter behaviourFilter;
    private ApplicationContext ctx;
    private int queryRange = 10000;
    private int threadCount = 2;
    private int batchSize = 100;

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuthenticationDao(MutableAuthenticationDao authenticationDao) {
        this.authenticationDao = authenticationDao;
    }

    public void setCompositePasswordEncoder(CompositePasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setQueryRange(int queryRange) {
        this.queryRange = queryRange;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"jobLockService", (Object)this.jobLockService);
        ParameterCheck.mandatory((String)"transactionService", (Object)this.transactionService);
        ParameterCheck.mandatory((String)"authenticationDao", (Object)this.authenticationDao);
        ParameterCheck.mandatory((String)"compositePasswordEncoder", (Object)this.passwordEncoder);
        ParameterCheck.mandatory((String)"nodeDAO", (Object)this.nodeDAO);
        ParameterCheck.mandatory((String)"patchDAO", (Object)this.patchDAO);
        ParameterCheck.mandatory((String)"qnameDAO", (Object)this.qnameDAO);
        ParameterCheck.mandatory((String)"behaviourFilter", (Object)this.behaviourFilter);
    }

    public UpgradePasswordHashWorkResult execute() {
        UpgradePasswordHashWorkResult progress;
        block13: {
            progress = new UpgradePasswordHashWorkResult();
            JobLockService.JobLockRefreshCallback lockCallback = new JobLockService.JobLockRefreshCallback(){

                @Override
                public void lockReleased() {
                    progress.inProgress.set(false);
                }

                @Override
                public boolean isActive() {
                    return progress.inProgress.get();
                }
            };
            String lockToken = null;
            try {
                progress.inProgress.set(true);
                lockToken = this.jobLockService.getLock(LOCK, 60000L);
                this.jobLockService.refreshLock(lockToken, LOCK, 60000L, lockCallback);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Starting upgrade password hash job.");
                }
                this.doWork(progress);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Finished upgrade password hash job: " + progress));
                }
            }
            catch (LockAcquisitionException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Skipping upgrade password hash job: " + e.getMessage()));
                }
                if (lockToken != null) {
                    this.jobLockService.releaseLock(lockToken, LOCK);
                }
                progress.inProgress.set(false);
                break block13;
            }
            catch (Exception e) {
                try {
                    progress.inProgress.set(false);
                    logger.error((Object)("Upgrade password hash job " + progress));
                    logger.error((Object)"Stopping upgrade password hash job with exception.", (Throwable)e);
                    if (lockToken != null) {
                        this.jobLockService.releaseLock(lockToken, LOCK);
                    }
                    progress.inProgress.set(false);
                    break block13;
                }
                catch (Throwable throwable) {
                    if (lockToken != null) {
                        this.jobLockService.releaseLock(lockToken, LOCK);
                    }
                    progress.inProgress.set(false);
                    throw throwable;
                }
            }
            if (lockToken != null) {
                this.jobLockService.releaseLock(lockToken, LOCK);
            }
            progress.inProgress.set(false);
        }
        return progress;
    }

    public boolean processPasswordHash(Map<QName, Serializable> properties) {
        Pair<List<String>, String> passwordHash = RepositoryAuthenticationDao.determinePasswordHash(properties);
        if (!this.passwordEncoder.lastEncodingIsPreferred((List)passwordHash.getFirst())) {
            String username = (String)((Object)properties.get(ContentModel.PROP_USER_USERNAME));
            ArrayList<String> nowHashed = new ArrayList<String>();
            nowHashed.addAll((Collection)passwordHash.getFirst());
            nowHashed.add(this.passwordEncoder.getPreferredEncoding());
            if (this.passwordEncoder.isSafeToEncodeChain(nowHashed)) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Double hashing user '" + username + "'."));
                }
                Serializable salt = properties.get(ContentModel.PROP_SALT);
                properties.put(ContentModel.PROP_PASSWORD_HASH, (Serializable)((Object)this.passwordEncoder.encodePreferred(new String((String)passwordHash.getSecond()), salt)));
                properties.put(ContentModel.PROP_HASH_INDICATOR, nowHashed);
                properties.remove(ContentModel.PROP_PASSWORD);
                properties.remove(ContentModel.PROP_PASSWORD_SHA256);
                return true;
            }
            logger.warn((Object)("Unable to upgrade password hash for user '" + username + "', please ask them to login."));
            return false;
        }
        List hashIndicator = (List)((Object)properties.get(ContentModel.PROP_HASH_INDICATOR));
        if (hashIndicator == null) {
            if (logger.isTraceEnabled()) {
                String username = (String)((Object)properties.get(ContentModel.PROP_USER_USERNAME));
                logger.trace((Object)("User '" + username + "' has preferred encoding, just updating properties to match."));
            }
            properties.put(ContentModel.PROP_HASH_INDICATOR, (Serializable)passwordHash.getFirst());
            properties.put(ContentModel.PROP_PASSWORD_HASH, (Serializable)passwordHash.getSecond());
            properties.remove(ContentModel.PROP_PASSWORD);
            properties.remove(ContentModel.PROP_PASSWORD_SHA256);
            return true;
        }
        return false;
    }

    private synchronized void doWork(UpgradePasswordHashWorkResult progress) throws Exception {
        UpgradePasswordHashWorkProvider workProvider = new UpgradePasswordHashWorkProvider(progress);
        UpgradePasswordHashBatch worker = new UpgradePasswordHashBatch(progress);
        RetryingTransactionHelper retryingTransactionHelper = this.transactionService.getRetryingTransactionHelper();
        retryingTransactionHelper.setForceWritable(true);
        retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                UpgradePasswordHashWorker.this.qnameDAO.getOrCreateQName(ContentModel.PROP_PASSWORD_HASH);
                UpgradePasswordHashWorker.this.qnameDAO.getOrCreateQName(ContentModel.PROP_HASH_INDICATOR);
                return null;
            }
        }, false, true);
        BatchProcessor<Long> batchProcessor = new BatchProcessor<Long>("UpgradePasswordHashWorker", retryingTransactionHelper, workProvider, this.threadCount, this.batchSize, (ApplicationEventPublisher)this.ctx, logger, 1000);
        batchProcessor.process(worker, true);
    }

    private class UpgradePasswordHashBatch
    extends BatchProcessor.BatchProcessWorkerAdaptor<Long> {
        private final UpgradePasswordHashWorkResult progress;

        private UpgradePasswordHashBatch(UpgradePasswordHashWorkResult progress) {
            this.progress = progress;
        }

        @Override
        public void beforeProcess() throws Throwable {
            AuthenticationUtil.setRunAsUser((String)AuthenticationUtil.getSystemUserName());
        }

        @Override
        public void process(Long nodeId) throws Throwable {
            block8: {
                this.progress.usersProcessed.incrementAndGet();
                try {
                    Map<QName, Serializable> userProps = UpgradePasswordHashWorker.this.nodeDAO.getNodeProperties(nodeId);
                    String username = (String)((Object)userProps.get(ContentModel.PROP_USER_USERNAME));
                    if (UpgradePasswordHashWorker.this.processPasswordHash(userProps)) {
                        this.progress.usersChanged.incrementAndGet();
                        try {
                            UpgradePasswordHashWorker.this.behaviourFilter.disableBehaviour();
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Saving password hash for user: " + username));
                            }
                            UpgradePasswordHashWorker.this.nodeDAO.setNodeProperties(nodeId, userProps);
                            break block8;
                        }
                        finally {
                            UpgradePasswordHashWorker.this.behaviourFilter.enableBehaviour();
                        }
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Encoding for user '" + username + "' was not changed."));
                    }
                }
                catch (Exception e) {
                    this.progress.errors.incrementAndGet();
                    throw e;
                }
            }
        }

        @Override
        public String getIdentifier(Long nodeId) {
            return (String)((Object)UpgradePasswordHashWorker.this.nodeDAO.getNodeProperty(nodeId, ContentModel.PROP_USER_USERNAME));
        }

        @Override
        public void afterProcess() throws Throwable {
            AuthenticationUtil.clearCurrentSecurityContext();
        }
    }

    public static class UpgradePasswordHashJob
    implements Job {
        public static final String JOB_DATA_WORKER = "upgradePasswordHashWorker";

        public void execute(JobExecutionContext context) throws JobExecutionException {
            JobDataMap jobData = context.getJobDetail().getJobDataMap();
            Object upgradePasswordHashWorkerObj = jobData.get((Object)JOB_DATA_WORKER);
            if (upgradePasswordHashWorkerObj == null || !(upgradePasswordHashWorkerObj instanceof UpgradePasswordHashWorker)) {
                throw new AlfrescoRuntimeException("UpgradePasswordHashJob data 'upgradePasswordHashWorker' must reference a " + UpgradePasswordHashWorker.class.getSimpleName());
            }
            UpgradePasswordHashWorker worker = (UpgradePasswordHashWorker)upgradePasswordHashWorkerObj;
            worker.execute();
        }
    }

    private class UpgradePasswordHashWorkProvider
    implements BatchProcessWorkProvider<Long> {
        private final long maxNodeId;
        private final UpgradePasswordHashWorkResult progress;
        private final Pair<Long, QName> userTypeId;

        private UpgradePasswordHashWorkProvider(UpgradePasswordHashWorkResult progress) {
            this.progress = progress;
            this.maxNodeId = UpgradePasswordHashWorker.this.patchDAO.getMaxAdmNodeID();
            this.userTypeId = UpgradePasswordHashWorker.this.qnameDAO.getQName(ContentModel.TYPE_USER);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Max NodeID: " + this.maxNodeId));
            }
        }

        @Override
        public int getTotalEstimatedWorkSize() {
            long totalUserCount = UpgradePasswordHashWorker.this.patchDAO.getCountNodesWithTypId(ContentModel.TYPE_USER);
            return (int)totalUserCount;
        }

        @Override
        public long getTotalEstimatedWorkSizeLong() {
            long totalUserCount = UpgradePasswordHashWorker.this.patchDAO.getCountNodesWithTypId(ContentModel.TYPE_USER);
            return totalUserCount;
        }

        @Override
        public Collection<Long> getNextWork() {
            if (this.progress.errors.get() > 1000) {
                logger.warn((Object)"Upgrade password hash work terminating; too many errors.");
                return Collections.emptyList();
            }
            List<Long> ret = Collections.emptyList();
            while (ret.isEmpty() && this.progress.currentMinNodeId.get() < this.maxNodeId) {
                Long minNodeId = null;
                if (this.progress.currentMinNodeId.get() == 0L) {
                    minNodeId = 1L;
                    this.progress.currentMinNodeId.set(minNodeId);
                } else {
                    minNodeId = this.progress.currentMinNodeId.addAndGet(UpgradePasswordHashWorker.this.queryRange);
                }
                long maxNodeId = minNodeId + (long)UpgradePasswordHashWorker.this.queryRange;
                ret = UpgradePasswordHashWorker.this.patchDAO.getNodesByTypeQNameId((Long)this.userTypeId.getFirst(), minNodeId, maxNodeId);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Upgrade password hash work provider found " + ret.size() + " users."));
            }
            return ret;
        }
    }

    public static class UpgradePasswordHashWorkResult {
        private final AtomicBoolean inProgress = new AtomicBoolean(false);
        private final AtomicInteger usersProcessed = new AtomicInteger(0);
        private final AtomicInteger usersChanged = new AtomicInteger(0);
        private final AtomicInteger errors = new AtomicInteger(0);
        private final AtomicLong currentMinNodeId = new AtomicLong(0L);

        public String toString() {
            String part1 = "Changed";
            String part2 = String.format(" %4d out of a potential %4d users. ", this.usersChanged.get(), this.usersProcessed.get());
            String part3 = String.format("[%2d Errors]", this.errors.get());
            return String.valueOf(part1) + part2 + part3;
        }

        public int getUsersProcessed() {
            return this.usersProcessed.get();
        }

        public int getUsersChanged() {
            return this.usersChanged.get();
        }

        public int getErrors() {
            return this.errors.get();
        }
    }
}

