/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.Column;
import org.alfresco.repo.search.impl.querymodel.Constraint;
import org.alfresco.repo.search.impl.querymodel.Function;
import org.alfresco.repo.search.impl.querymodel.FunctionArgument;
import org.alfresco.repo.search.impl.querymodel.Join;
import org.alfresco.repo.search.impl.querymodel.JoinType;
import org.alfresco.repo.search.impl.querymodel.ListArgument;
import org.alfresco.repo.search.impl.querymodel.LiteralArgument;
import org.alfresco.repo.search.impl.querymodel.Order;
import org.alfresco.repo.search.impl.querymodel.Ordering;
import org.alfresco.repo.search.impl.querymodel.ParameterArgument;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.Query;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.QueryModelFactory;
import org.alfresco.repo.search.impl.querymodel.Selector;
import org.alfresco.repo.search.impl.querymodel.SelectorArgument;
import org.alfresco.repo.search.impl.querymodel.Source;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBColumn;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBConjunction;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBDisjunction;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBFunctionArgument;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBFunctionalConstraint;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBJoin;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBListArgument;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBLiteralArgument;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBOrdering;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBParameterArgument;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBPropertyArgument;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQuery;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBSelector;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBSelectorArgument;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBChild;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBDescendant;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBEquals;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBExists;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBFTSFuzzyTerm;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBFTSPhrase;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBFTSPrefixTerm;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBFTSProximity;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBFTSRange;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBFTSTerm;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBFTSWildTerm;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBGreaterThan;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBGreaterThanOrEquals;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBIn;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBLessThan;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBLessThanOrEquals;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBLike;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBLower;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBNotEquals;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBPropertyAccessor;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBScore;
import org.alfresco.repo.search.impl.querymodel.impl.db.functions.DBUpper;
import org.alfresco.service.namespace.QName;

public class DBQueryModelFactory
implements QueryModelFactory {
    private HashMap<String, Function> functions = new HashMap();

    public DBQueryModelFactory() {
        this.functions.put("Equals", (Function)new DBEquals());
        this.functions.put("PropertyAccessor", (Function)new DBPropertyAccessor());
        this.functions.put("Score", (Function)new DBScore());
        this.functions.put("Upper", (Function)new DBUpper());
        this.functions.put("Lower", (Function)new DBLower());
        this.functions.put("NotEquals", (Function)new DBNotEquals());
        this.functions.put("LessThan", (Function)new DBLessThan());
        this.functions.put("LessThanOrEquals", (Function)new DBLessThanOrEquals());
        this.functions.put("GreaterThan", (Function)new DBGreaterThan());
        this.functions.put("GreaterThanOrEquals", (Function)new DBGreaterThanOrEquals());
        this.functions.put("In", (Function)new DBIn());
        this.functions.put("Like", (Function)new DBLike());
        this.functions.put("Exists", (Function)new DBExists());
        this.functions.put("Child", (Function)new DBChild());
        this.functions.put("Descendant", (Function)new DBDescendant());
        this.functions.put("FTSTerm", (Function)new DBFTSTerm());
        this.functions.put("FTSPhrase", (Function)new DBFTSPhrase());
        this.functions.put("FTSProximity", (Function)new DBFTSProximity());
        this.functions.put("FTSRange", (Function)new DBFTSRange());
        this.functions.put("FTSPrefixTerm", (Function)new DBFTSPrefixTerm());
        this.functions.put("FTSWildTerm", (Function)new DBFTSWildTerm());
        this.functions.put("FTSFuzzyTerm", (Function)new DBFTSFuzzyTerm());
    }

    public Query createQuery(List<Column> columns, Source source, Constraint constraint, List<Ordering> orderings) {
        return new DBQuery(columns, source, constraint, orderings);
    }

    public Selector createSelector(QName classQName, String alias) {
        return new DBSelector(classQName, alias);
    }

    public Join createJoin(Source left, Source right, JoinType joinType, Constraint joinCondition) {
        return new DBJoin(left, right, joinType, joinCondition);
    }

    public Constraint createConjunction(List<Constraint> constraints) {
        return new DBConjunction(constraints);
    }

    public Constraint createDisjunction(List<Constraint> constraints) {
        return new DBDisjunction(constraints);
    }

    public Constraint createFunctionalConstraint(Function function, Map<String, Argument> functionArguments) {
        return new DBFunctionalConstraint(function, functionArguments);
    }

    public Column createColumn(Function function, Map<String, Argument> functionArguments, String alias) {
        return new DBColumn(function, functionArguments, alias);
    }

    public LiteralArgument createLiteralArgument(String name, QName type, Serializable value) {
        return new DBLiteralArgument(name, type, value);
    }

    public Ordering createOrdering(Column column, Order order) {
        return new DBOrdering(column, order);
    }

    public ParameterArgument createParameterArgument(String name, String parameterName) {
        return new DBParameterArgument(name, parameterName);
    }

    public PropertyArgument createPropertyArgument(String name, boolean queryable, boolean orderable, String selectorAlias, String propertyName) {
        return new DBPropertyArgument(name, queryable, orderable, selectorAlias, propertyName);
    }

    public SelectorArgument createSelectorArgument(String name, String selectorAlias) {
        return new DBSelectorArgument(name, selectorAlias);
    }

    public Function getFunction(String functionName) {
        Function function = this.functions.get(functionName);
        if (function != null) {
            try {
                return (Function)function.getClass().newInstance();
            }
            catch (InstantiationException e) {
                throw new QueryModelException("InstantiationException", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new QueryModelException("IllegalAccessException", (Throwable)e);
            }
        }
        for (String key : this.functions.keySet()) {
            if (!key.equalsIgnoreCase(functionName)) continue;
            try {
                return (Function)this.functions.get(key).getClass().newInstance();
            }
            catch (InstantiationException e) {
                throw new QueryModelException("InstantiationException", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new QueryModelException("IllegalAccessException", (Throwable)e);
            }
        }
        return null;
    }

    public ListArgument createListArgument(String name, ArrayList<Argument> arguments) {
        return new DBListArgument(name, arguments);
    }

    public FunctionArgument createFunctionArgument(String name, Function function, Map<String, Argument> functionArguments) {
        return new DBFunctionArgument(name, function, functionArguments);
    }
}

