/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.Constraint;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.impl.BaseConjunction;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderJoinCommand;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderPredicatePartCommand;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderPredicatePartCommandType;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class DBConjunction
extends BaseConjunction
implements DBQueryBuilderComponent {
    public DBConjunction(List<Constraint> constraints) {
        super(constraints);
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public void prepare(NamespaceService namespaceService, DictionaryService dictionaryService, QNameDAO qnameDAO, NodeDAO nodeDAO, TenantService tenantService, Set<String> selectors, Map<String, Argument> functionArgs, FunctionEvaluationContext functionContext, boolean supportBooleanFloatAndDouble) {
        for (Constraint constraint : this.getConstraints()) {
            if (constraint instanceof DBQueryBuilderComponent) {
                if (constraint.getOccur() == Constraint.Occur.OPTIONAL) {
                    throw new QueryModelException("Disjunctions are not suported");
                }
                DBQueryBuilderComponent dbQueryBuilderComponent = (DBQueryBuilderComponent)constraint;
                dbQueryBuilderComponent.prepare(namespaceService, dictionaryService, qnameDAO, nodeDAO, tenantService, selectors, functionArgs, functionContext, supportBooleanFloatAndDouble);
                continue;
            }
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void buildJoins(Map<QName, DBQueryBuilderJoinCommand> singleJoins, List<DBQueryBuilderJoinCommand> multiJoins) {
        for (Constraint constraint : this.getConstraints()) {
            if (constraint instanceof DBQueryBuilderComponent) {
                DBQueryBuilderComponent dbQueryBuilderComponent = (DBQueryBuilderComponent)constraint;
                dbQueryBuilderComponent.buildJoins(singleJoins, multiJoins);
                continue;
            }
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void buildPredicateCommands(List<DBQueryBuilderPredicatePartCommand> predicatePartCommands) {
        DBQueryBuilderPredicatePartCommand open = new DBQueryBuilderPredicatePartCommand();
        open.setType(DBQueryBuilderPredicatePartCommandType.OPEN);
        predicatePartCommands.add(open);
        boolean requiresAnd = false;
        for (Constraint constraint : this.getConstraints()) {
            if (constraint instanceof DBQueryBuilderComponent) {
                if (requiresAnd) {
                    DBQueryBuilderPredicatePartCommand and = new DBQueryBuilderPredicatePartCommand();
                    and.setType(DBQueryBuilderPredicatePartCommandType.AND);
                    predicatePartCommands.add(and);
                } else {
                    requiresAnd = true;
                }
                if (constraint.getOccur() == Constraint.Occur.EXCLUDE) {
                    DBQueryBuilderPredicatePartCommand not = new DBQueryBuilderPredicatePartCommand();
                    not.setType(DBQueryBuilderPredicatePartCommandType.NOT);
                    predicatePartCommands.add(not);
                }
                DBQueryBuilderComponent dbQueryBuilderComponent = (DBQueryBuilderComponent)constraint;
                dbQueryBuilderComponent.buildPredicateCommands(predicatePartCommands);
                continue;
            }
            throw new UnsupportedOperationException();
        }
        DBQueryBuilderPredicatePartCommand close = new DBQueryBuilderPredicatePartCommand();
        close.setType(DBQueryBuilderPredicatePartCommandType.CLOSE);
        predicatePartCommands.add(close);
    }
}

