/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.noindex;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.error.StackTraceUtil;
import org.alfresco.repo.search.EmptyResultSet;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.solr.SolrSearchService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NoIndexSearchService
extends SolrSearchService {
    private static Log s_logger = LogFactory.getLog(NoIndexSearchService.class);

    private void trace() {
        if (s_logger.isTraceEnabled()) {
            Exception e = new Exception();
            e.fillInStackTrace();
            StringBuilder sb = new StringBuilder(1024);
            StackTraceUtil.buildStackTrace((String)"Search trace ...", (StackTraceElement[])e.getStackTrace(), (StringBuilder)sb, (int)-1);
            s_logger.trace((Object)sb);
        }
    }

    @Override
    public ResultSet query(SearchParameters searchParameters) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("query   searchParameters = " + searchParameters));
        }
        this.trace();
        try {
            return super.query(searchParameters);
        }
        catch (SearcherException searcherException) {
            return new EmptyResultSet();
        }
        catch (QueryModelException queryModelException) {
            return new EmptyResultSet();
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {
            return new EmptyResultSet();
        }
    }
}

