/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.nodelocator.AbstractNodeLocator;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteService;

public class DocLibNodeLocator
extends AbstractNodeLocator {
    public static final String NAME = "doclib";
    private SiteService siteService;
    private Repository repositoryHelper;

    @Override
    public NodeRef getNode(NodeRef source, Map<String, Serializable> params) {
        String siteName;
        NodeRef docLib = null;
        if (source != null && (siteName = this.siteService.getSiteShortName(source)) != null) {
            String containerId = "documentLibrary";
            docLib = this.siteService.getContainer(siteName, containerId);
        }
        if (docLib == null) {
            docLib = this.repositoryHelper.getCompanyHome();
        }
        return docLib;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setRepositoryHelper(Repository repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }
}

