/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock.mem;

import java.io.Serializable;
import java.util.Date;
import org.alfresco.repo.lock.mem.Lifetime;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.NodeRef;

public final class LockState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final NodeRef nodeRef;
    private final LockType lockType;
    private final String owner;
    private final Date expires;
    private final Lifetime lifetime;
    private final String additionalInfo;

    private LockState(NodeRef nodeRef, LockType lockType, String owner, Date expires, Lifetime lifetime, String additionalInfo) {
        this.nodeRef = nodeRef;
        this.lockType = lockType;
        this.owner = owner;
        this.expires = expires == null ? null : new Date(expires.getTime());
        this.lifetime = lifetime;
        this.additionalInfo = additionalInfo;
    }

    public static LockState createLock(NodeRef nodeRef, LockType lockType, String owner, Date expires, Lifetime lifetime, String additionalInfo) {
        return new LockState(nodeRef, lockType, owner, expires, lifetime, additionalInfo);
    }

    public static LockState createWithLockType(LockState lockState, LockType lockType) {
        return new LockState(lockState.getNodeRef(), lockType, lockState.getOwner(), lockState.getExpires(), lockState.getLifetime(), lockState.getAdditionalInfo());
    }

    public static LockState createWithOwner(LockState lockState, String owner) {
        return new LockState(lockState.getNodeRef(), lockState.getLockType(), owner, lockState.getExpires(), lockState.getLifetime(), lockState.getAdditionalInfo());
    }

    public static LockState createWithExpires(LockState lockState, Date expires) {
        return new LockState(lockState.getNodeRef(), lockState.getLockType(), lockState.getOwner(), expires, lockState.getLifetime(), lockState.getAdditionalInfo());
    }

    public static LockState createWithLifetime(LockState lockState, Lifetime lifetime) {
        return new LockState(lockState.getNodeRef(), lockState.getLockType(), lockState.getOwner(), lockState.getExpires(), lifetime, lockState.getAdditionalInfo());
    }

    public static LockState createWithAdditionalInfo(LockState lockState, String additionalInfo) {
        return new LockState(lockState.getNodeRef(), lockState.getLockType(), lockState.getOwner(), lockState.getExpires(), lockState.getLifetime(), additionalInfo);
    }

    public static LockState createUnlocked(NodeRef nodeRef, String additionalInfo) {
        return new LockState(nodeRef, null, null, null, null, additionalInfo);
    }

    public static LockState createUnlocked(NodeRef nodeRef) {
        return new LockState(nodeRef, null, null, null, null, null);
    }

    public boolean isLockInfo() {
        return this.lockType != null;
    }

    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public LockType getLockType() {
        return this.lockType;
    }

    public String getOwner() {
        return this.owner;
    }

    public Date getExpires() {
        return this.expires;
    }

    public Lifetime getLifetime() {
        return this.lifetime;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.additionalInfo == null ? 0 : this.additionalInfo.hashCode());
        result = 31 * result + (this.expires == null ? 0 : this.expires.hashCode());
        result = 31 * result + (this.lifetime == null ? 0 : this.lifetime.hashCode());
        result = 31 * result + (this.lockType == null ? 0 : this.lockType.hashCode());
        result = 31 * result + (this.nodeRef == null ? 0 : this.nodeRef.hashCode());
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LockState other = (LockState)obj;
        if (this.additionalInfo == null ? other.additionalInfo != null : !this.additionalInfo.equals(other.additionalInfo)) {
            return false;
        }
        if (this.expires == null ? other.expires != null : !this.expires.equals(other.expires)) {
            return false;
        }
        if (this.lifetime != other.lifetime) {
            return false;
        }
        if (this.lockType != other.lockType) {
            return false;
        }
        if (this.nodeRef == null ? other.nodeRef != null : !this.nodeRef.equals((Object)other.nodeRef)) {
            return false;
        }
        return !(this.owner == null ? other.owner != null : !this.owner.equals(other.owner));
    }

    public String toString() {
        return "LockState [nodeRef=" + this.nodeRef + ", lockType=" + (Object)((Object)this.lockType) + ", owner=" + this.owner + ", expires=" + this.expires + ", lifetime=" + (Object)((Object)this.lifetime) + ", additionalInfo=" + this.additionalInfo + "]";
    }
}

