/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.DummyTransformServiceRegistry;
import org.alfresco.repo.content.transform.LocalTransformServiceRegistry;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.rendition2.SynchronousTransformClient;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.transform.registry.SupportedTransform;
import org.alfresco.transform.registry.TransformServiceRegistry;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.TempFileProvider;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AdminUiTransformerDebug
extends TransformerDebug
implements ApplicationContextAware {
    protected TransformServiceRegistry remoteTransformServiceRegistry;
    protected LocalTransformServiceRegistry localTransformServiceRegistry;
    private ApplicationContext applicationContext;
    private ContentService contentService;
    private SynchronousTransformClient synchronousTransformClient;
    private Repository repositoryHelper;
    private TransactionService transactionService;

    public void setLocalTransformServiceRegistry(LocalTransformServiceRegistry localTransformServiceRegistry) {
        this.localTransformServiceRegistry = localTransformServiceRegistry;
    }

    public void setRemoteTransformServiceRegistry(TransformServiceRegistry remoteTransformServiceRegistry) {
        this.remoteTransformServiceRegistry = remoteTransformServiceRegistry;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private ContentService getContentService() {
        if (this.contentService == null) {
            this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        }
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    private SynchronousTransformClient getSynchronousTransformClient() {
        if (this.synchronousTransformClient == null) {
            this.synchronousTransformClient = (SynchronousTransformClient)this.applicationContext.getBean("synchronousTransformClient");
        }
        return this.synchronousTransformClient;
    }

    public void setSynchronousTransformClient(SynchronousTransformClient transformClient) {
        this.synchronousTransformClient = transformClient;
    }

    public Repository getRepositoryHelper() {
        if (this.repositoryHelper == null) {
            this.repositoryHelper = (Repository)this.applicationContext.getBean("repositoryHelper");
        }
        return this.repositoryHelper;
    }

    public void setRepositoryHelper(Repository repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }

    public TransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (TransactionService)this.applicationContext.getBean("transactionService");
        }
        return this.transactionService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        PropertyCheck.mandatory((Object)this, (String)"localTransformServiceRegistry", (Object)((Object)this.localTransformServiceRegistry));
        PropertyCheck.mandatory((Object)this, (String)"remoteTransformServiceRegistry", (Object)this.remoteTransformServiceRegistry);
    }

    public String transformationsByExtension(String sourceExtension, String targetExtension, boolean toString) {
        if (this.getStringBuilder() != null) {
            return null;
        }
        List sourceMimetypes = sourceExtension != null ? this.getSourceMimetypes(sourceExtension) : this.mimetypeService.getMimetypes();
        List targetMimetypes = targetExtension != null ? this.getTargetMimetypes(sourceExtension, targetExtension, sourceMimetypes) : this.mimetypeService.getMimetypes();
        StringBuilder sb = null;
        try {
            if (toString) {
                sb = new StringBuilder();
                this.setStringBuilder(sb);
            }
            this.pushMisc();
            for (String sourceMimetype : sourceMimetypes) {
                for (String targetMimetype : targetMimetypes) {
                    List<SupportedTransform> localTransformers;
                    boolean supportedByTransformService = this.remoteTransformServiceRegistry == null || this.remoteTransformServiceRegistry instanceof DummyTransformServiceRegistry ? false : this.remoteTransformServiceRegistry.isSupported(sourceMimetype, -1L, targetMimetype, Collections.emptyMap(), null);
                    List<SupportedTransform> list = localTransformers = this.localTransformServiceRegistry == null ? Collections.emptyList() : this.localTransformServiceRegistry.findTransformers(sourceMimetype, targetMimetype, Collections.emptyMap(), null);
                    if (localTransformers.isEmpty() && !supportedByTransformService) continue;
                    try {
                        this.pushMisc();
                        int transformerCount = 0;
                        if (supportedByTransformService) {
                            long maxSourceSizeKBytes = this.remoteTransformServiceRegistry.findMaxSize(sourceMimetype, targetMimetype, Collections.emptyMap(), null);
                            this.activeTransformer(sourceMimetype, targetMimetype, transformerCount, "     ", "TransformService", maxSourceSizeKBytes, transformerCount++ == 0);
                        }
                        for (SupportedTransform localTransformer : localTransformers) {
                            long maxSourceSizeKBytes = localTransformer.getMaxSourceSizeBytes();
                            String transformName = "Local:" + localTransformer.getName();
                            String transformerPriority = "[" + localTransformer.getPriority() + ']';
                            transformerPriority = String.valueOf(this.spaces(5 - transformerPriority.length())) + transformerPriority;
                            this.activeTransformer(sourceMimetype, targetMimetype, transformerCount, transformerPriority, transformName, maxSourceSizeKBytes, transformerCount++ == 0);
                        }
                    }
                    finally {
                        this.popMisc();
                    }
                }
            }
        }
        finally {
            this.popMisc();
            this.setStringBuilder(null);
        }
        this.stripFinishedLine(sb);
        return this.stripLeadingNumber(sb);
    }

    protected void activeTransformer(String sourceMimetype, String targetMimetype, int transformerCount, String priority, String transformName, long maxSourceSizeKBytes, boolean firstTransformer) {
        String mimetypes = firstTransformer ? this.getSourceAndTargetExt(sourceMimetype, targetMimetype) : this.spaces(10);
        char c = (char)(97 + transformerCount);
        this.log(String.valueOf(mimetypes) + "  " + c + ") " + priority + ' ' + transformName + ' ' + this.fileSize(maxSourceSizeKBytes > 0L ? maxSourceSizeKBytes * 1024L : maxSourceSizeKBytes) + (maxSourceSizeKBytes == 0L ? " disabled" : ""));
    }

    void stripFinishedLine(StringBuilder sb) {
        int i;
        if (sb != null && (i = sb.lastIndexOf("Finished in ")) != -1) {
            sb.setLength(i);
            i = sb.lastIndexOf("\n", i);
            sb.setLength(i != -1 ? i : 0);
        }
    }

    String stripLeadingNumber(StringBuilder sb) {
        return sb == null ? null : Pattern.compile("^\\d+\\.", 8).matcher(sb).replaceAll("");
    }

    public Collection<String> getSourceMimetypes(String sourceExtension) {
        Collection sourceMimetypes = this.mimetypeService.getMimetypes(sourceExtension);
        if (sourceMimetypes.isEmpty()) {
            throw new IllegalArgumentException("Unknown source extension " + sourceExtension);
        }
        return sourceMimetypes;
    }

    public Collection<String> getTargetMimetypes(String sourceExtension, String targetExtension, Collection<String> sourceMimetypes) {
        Collection targetMimetypes;
        Collection collection = targetMimetypes = targetExtension == null && sourceExtension == null || targetExtension != null && targetExtension.equals(sourceExtension) ? sourceMimetypes : this.mimetypeService.getMimetypes(targetExtension);
        if (targetMimetypes.isEmpty()) {
            throw new IllegalArgumentException("Unknown target extension " + targetExtension);
        }
        return targetMimetypes;
    }

    public String testTransform(String sourceExtension, String targetExtension) {
        return new TestTransform().run(sourceExtension, targetExtension);
    }

    public String[] getTestFileExtensionsAndMimetypes() {
        ArrayList<String> sourceExtensions = new ArrayList<String>();
        Collection sourceMimetypes = this.mimetypeService.getMimetypes(null);
        for (String sourceMimetype : sourceMimetypes) {
            String sourceExtension = this.mimetypeService.getExtension(sourceMimetype);
            if (this.loadQuickTestFile(sourceExtension) == null) continue;
            sourceExtensions.add(String.valueOf(sourceExtension) + " - " + sourceMimetype);
        }
        return sourceExtensions.toArray(new String[sourceExtensions.size()]);
    }

    private URL loadQuickTestFile(String extension) {
        URL url = this.getClass().getClassLoader().getResource("quick/quick." + extension);
        return url == null ? null : url;
    }

    @Deprecated
    private class TestTransform {
        protected LinkedList<NodeRef> nodesToDeleteAfterTest = new LinkedList();

        private TestTransform() {
        }

        String run(final String sourceExtension, final String targetExtension) {
            RetryingTransactionHelper.RetryingTransactionCallback<String> makeNodeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                @Override
                public String execute() throws Throwable {
                    return TestTransform.this.runWithinTransaction(sourceExtension, targetExtension);
                }
            };
            return AdminUiTransformerDebug.this.getTransactionService().getRetryingTransactionHelper().doInTransaction(makeNodeCallback, false, true);
        }

        private String runWithinTransaction(String sourceExtension, String targetExtension) {
            StringBuilder sb;
            block5: {
                String targetMimetype = this.getMimetype(targetExtension, false);
                String sourceMimetype = this.getMimetype(sourceExtension, true);
                File tempFile = TempFileProvider.createTempFile((String)("TestTransform_" + sourceExtension + "_"), (String)("." + targetExtension));
                FileContentWriter writer = new FileContentWriter(tempFile);
                writer.setMimetype(targetMimetype);
                NodeRef sourceNodeRef = null;
                sb = new StringBuilder();
                try {
                    try {
                        AdminUiTransformerDebug.this.setStringBuilder(sb);
                        sourceNodeRef = this.createSourceNode(sourceExtension, sourceMimetype);
                        ContentReader reader = AdminUiTransformerDebug.this.contentService.getReader(sourceNodeRef, ContentModel.PROP_CONTENT);
                        SynchronousTransformClient synchronousTransformClient = AdminUiTransformerDebug.this.getSynchronousTransformClient();
                        Map<String, String> actualOptions = Collections.emptyMap();
                        synchronousTransformClient.transform(reader, writer, actualOptions, null, sourceNodeRef);
                    }
                    catch (Exception e) {
                        sb.append(e.getMessage());
                        AdminUiTransformerDebug.this.setStringBuilder(null);
                        this.deleteSourceNode(sourceNodeRef);
                        break block5;
                    }
                }
                catch (Throwable throwable) {
                    AdminUiTransformerDebug.this.setStringBuilder(null);
                    this.deleteSourceNode(sourceNodeRef);
                    throw throwable;
                }
                AdminUiTransformerDebug.this.setStringBuilder(null);
                this.deleteSourceNode(sourceNodeRef);
            }
            return sb.toString();
        }

        private String getMimetype(String extension, boolean isSource) {
            Iterator iterator;
            String mimetype = null;
            if (extension != null && (iterator = AdminUiTransformerDebug.this.mimetypeService.getMimetypes(extension).iterator()).hasNext()) {
                mimetype = (String)iterator.next();
            }
            if (mimetype == null) {
                throw new IllegalArgumentException("Unknown " + (isSource ? "source" : "target") + " extension: " + extension);
            }
            return mimetype;
        }

        public NodeRef createSourceNode(final String extension, final String sourceMimetype) {
            RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> makeNodeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                @Override
                public NodeRef execute() throws Throwable {
                    URL url = AdminUiTransformerDebug.this.loadQuickTestFile(extension);
                    URI uri = url.toURI();
                    File sourceFile = new File(uri);
                    NodeRef companyHome = AdminUiTransformerDebug.this.getRepositoryHelper().getCompanyHome();
                    HashMap<QName, String> props = new HashMap<QName, String>();
                    String localName = "TestTransform." + extension;
                    props.put(ContentModel.PROP_NAME, localName);
                    NodeRef node = ((TestTransform)TestTransform.this).AdminUiTransformerDebug.this.nodeService.createNode(companyHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)localName), ContentModel.TYPE_CONTENT, props).getChildRef();
                    ContentWriter writer = AdminUiTransformerDebug.this.getContentService().getWriter(node, ContentModel.PROP_CONTENT, true);
                    writer.setMimetype(sourceMimetype);
                    writer.setEncoding("UTF-8");
                    writer.putContent(sourceFile);
                    return node;
                }
            };
            NodeRef contentNodeRef = AdminUiTransformerDebug.this.getTransactionService().getRetryingTransactionHelper().doInTransaction(makeNodeCallback);
            this.nodesToDeleteAfterTest.add(contentNodeRef);
            return contentNodeRef;
        }

        public void deleteSourceNode(NodeRef sourceNodeRef) {
            if (sourceNodeRef != null) {
                AdminUiTransformerDebug.this.getTransactionService().getRetryingTransactionHelper().doInTransaction(() -> {
                    if (AdminUiTransformerDebug.this.nodeService.exists(sourceNodeRef)) {
                        AdminUiTransformerDebug.this.nodeService.deleteNode(sourceNodeRef);
                    }
                    return null;
                });
            }
        }
    }
}

