/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version.common;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.repo.version.VersionBaseModel;
import org.alfresco.repo.version.common.VersionImpl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.version.VersionServiceException;
import org.alfresco.service.cmr.version.VersionType;

public class VersionImplTest
extends TestCase {
    private static final String PROP_1 = "prop1";
    private static final String PROP_2 = "prop2";
    private static final String PROP_3 = "prop3";
    private static final String VALUE_1 = "value1";
    private static final String VALUE_2 = "value2";
    private static final String VALUE_3 = "value3";
    private static final String VALUE_DESCRIPTION = "This string describes the version details.";
    private static final VersionType VERSION_TYPE = VersionType.MINOR;
    private static final String USER_NAME = "userName";
    private static final String VERSION_1 = "1";
    private VersionImpl version = null;
    private NodeRef nodeRef = null;
    private Map<String, Serializable> versionProperties = null;
    private Date createdDate = new Date();

    protected void setUp() throws Exception {
        super.setUp();
        this.nodeRef = new NodeRef(new StoreRef("workspace", "testWS"), "testID");
        VersionImplTest.assertNotNull((Object)this.nodeRef);
        this.versionProperties = new HashMap<String, Serializable>();
        this.versionProperties.put("versionLabel", (Serializable)((Object)VERSION_1));
        this.versionProperties.put(VersionBaseModel.PROP_CREATED_DATE, this.createdDate);
        this.versionProperties.put(VersionBaseModel.PROP_CREATOR, (Serializable)((Object)USER_NAME));
        this.versionProperties.put("description", (Serializable)((Object)VALUE_DESCRIPTION));
        this.versionProperties.put("versionType", (Serializable)VERSION_TYPE);
        this.versionProperties.put(PROP_1, (Serializable)((Object)VALUE_1));
        this.versionProperties.put(PROP_2, (Serializable)((Object)VALUE_2));
        this.versionProperties.put(PROP_3, (Serializable)((Object)VALUE_3));
        this.version = new VersionImpl(this.versionProperties, this.nodeRef);
        VersionImplTest.assertNotNull((Object)this.version);
    }

    public void testGetCreatedDate() {
        Date createdDate1 = this.version.getCreatedDate();
        VersionImplTest.assertEquals((Object)this.createdDate, (Object)createdDate1);
    }

    public void testGetCreator() {
        VersionImplTest.assertEquals((String)USER_NAME, (String)this.version.getCreator());
    }

    public void testGetVersionLabel() {
        String versionLabel1 = this.version.getVersionLabel();
        VersionImplTest.assertEquals((String)VERSION_1, (String)versionLabel1);
    }

    public void testGetDescription() {
        String description = this.version.getDescription();
        VersionImplTest.assertEquals((String)VALUE_DESCRIPTION, (String)description);
    }

    public void testGetVersionType() {
        VersionType versionType = this.version.getVersionType();
        VersionImplTest.assertEquals((Object)VERSION_TYPE, (Object)versionType);
    }

    public void testGetVersionProperties() {
        Map versionProperties = this.version.getVersionProperties();
        VersionImplTest.assertNotNull((Object)versionProperties);
        VersionImplTest.assertEquals((int)this.versionProperties.size(), (int)versionProperties.size());
    }

    public void testGetVersionProperty() {
        String value1 = (String)((Object)this.version.getVersionProperty(PROP_1));
        VersionImplTest.assertEquals((String)value1, (String)VALUE_1);
        String value2 = (String)((Object)this.version.getVersionProperty(PROP_2));
        VersionImplTest.assertEquals((String)value2, (String)VALUE_2);
        String value3 = (String)((Object)this.version.getVersionProperty(PROP_3));
        VersionImplTest.assertEquals((String)value3, (String)VALUE_3);
    }

    public void testGetNodeRef() {
        NodeRef nodeRef = this.version.getFrozenStateNodeRef();
        VersionImplTest.assertNotNull((Object)nodeRef);
        VersionImplTest.assertEquals((String)nodeRef.toString(), (String)this.nodeRef.toString());
    }

    public void testNoNodeRefOnVersionCreate() {
        try {
            new VersionImpl(this.versionProperties, null);
            VersionImplTest.fail((String)"It is invalid to create a version object without a node ref specified.");
        }
        catch (VersionServiceException versionServiceException) {}
    }
}

