/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import org.alfresco.repo.search.impl.solr.SolrSQLJSONResultSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class SolrSQLJSONResultMetadataSetTest {
    @Test
    public void parseSQLResponse() throws JSONException {
        String response = "{\"result-set\":{\"docs\":[{\"SITE\":\"_REPOSITORY_\"},{\"SITE\":\"surf-config\"},{\"SITE\":\"swsdp\"},{\"RESPONSE_TIME\":96,\"EOF\":true}]}}";
        JSONObject json = new JSONObject(response);
        SolrSQLJSONResultSet ssjr = new SolrSQLJSONResultSet(json, null);
        Assert.assertNotNull((Object)ssjr);
        Assert.assertNotNull((Object)ssjr.getQueryTime());
        Assert.assertEquals((Object)96L, (Object)ssjr.getQueryTime());
        Assert.assertEquals((long)3L, (long)ssjr.getNumberFound());
        Assert.assertNotNull((Object)ssjr.getSolrResponse());
        Assert.assertEquals((Object)response, (Object)ssjr.getSolrResponse());
        JSONArray docs = ssjr.getDocs();
        Assert.assertNotNull((Object)docs);
        Assert.assertNotNull((Object)ssjr.getResultSetMetaData());
    }

    @Test
    public void parseSQLErrorResponse() throws JSONException {
        String response = "{\"result-set\":{\"docs\":[{\"EXCEPTION\":\"Column 'SIT1E' not found in any table\",\"EOF\":true,\"RESPONSE_TIME\":18943}]}}";
        try {
            JSONObject json = new JSONObject(response);
            SolrSQLJSONResultSet ssjr = new SolrSQLJSONResultSet(json, null);
            Assert.assertNull((Object)ssjr);
        }
        catch (RuntimeException e) {
            Assert.assertNotNull((Object)e);
            Assert.assertEquals((Object)"Unable to execute the query, error caused by: Column 'SIT1E' not found in any table", (Object)e.getMessage());
        }
    }

    @Test
    public void parseInvalidInsightEngineResponse() throws JSONException {
        String response = "{\"result-set\":{\"docs\":[{\"EXCEPTION\":\"/sql handler only works in Solr Cloud mode\",\"EOF\":true}]}}";
        try {
            JSONObject json = new JSONObject(response);
            SolrSQLJSONResultSet ssjr = new SolrSQLJSONResultSet(json, null);
            Assert.assertNull((Object)ssjr);
        }
        catch (RuntimeException e) {
            Assert.assertNotNull((Object)e);
            Assert.assertEquals((Object)"Unable to execute the query, this API requires InsightEngine.", (Object)e.getMessage());
        }
    }
}

