/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.usage;

import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.ChildAssocEntity;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.usage.UsageDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.DBTests;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.I18NUtil;

@Category(value={OwnJVMTestsCategory.class, DBTests.class})
public class UsageDAOTest
extends TestCase {
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private UsageDAO usageDAO;
    private NodeDAO nodeDAO;
    private static final StoreRef storeRef = new StoreRef("workspace", "SpacesStore");

    public void setUp() throws Exception {
        this.transactionService = (TransactionService)this.ctx.getBean("transactionService");
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.usageDAO = (UsageDAO)this.ctx.getBean("usageDAO");
        this.nodeDAO = (NodeDAO)this.ctx.getBean("nodeDAO");
    }

    private NodeRef getRootNodeRef() {
        return (NodeRef)this.nodeDAO.getRootNode(storeRef).getSecond();
    }

    private long getNodeId(NodeRef nodeRef) {
        return (Long)this.nodeDAO.getNodePair(nodeRef).getFirst();
    }

    private NodeRef createNode(long parentNodeId) {
        ChildAssocEntity assoc = this.nodeDAO.newNode(Long.valueOf(parentNodeId), ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, storeRef, null, ContentModel.TYPE_CONTENT, I18NUtil.getLocale(), null, null);
        return assoc.getChildNode().getNodeRef();
    }

    public void testCreateAndDeleteUsageDeltas() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef rootNodeRef = UsageDAOTest.this.getRootNodeRef();
                long rootNodeId = UsageDAOTest.this.getNodeId(rootNodeRef);
                UsageDAOTest.this.usageDAO.deleteDeltas(rootNodeId);
                Set usageDeltaNodes = UsageDAOTest.this.usageDAO.getUsageDeltaNodes();
                for (NodeRef nodeRef : usageDeltaNodes) {
                    long nodeId = UsageDAOTest.this.getNodeId(nodeRef);
                    UsageDAOTest.this.usageDAO.deleteDeltas(nodeId);
                }
                UsageDAOTest.assertEquals((int)0, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                UsageDAOTest.this.usageDAO.insertDelta(rootNodeRef, 100L);
                UsageDAOTest.assertEquals((long)100L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(rootNodeRef, false));
                UsageDAOTest.assertEquals((int)1, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                UsageDAOTest.this.usageDAO.insertDelta(rootNodeRef, 1000L);
                UsageDAOTest.assertEquals((long)1100L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(rootNodeRef, false));
                UsageDAOTest.assertEquals((int)1, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                UsageDAOTest.this.usageDAO.insertDelta(rootNodeRef, -500L);
                UsageDAOTest.assertEquals((long)600L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(rootNodeRef, false));
                UsageDAOTest.assertEquals((int)1, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                NodeRef nodeRef1 = UsageDAOTest.this.createNode(rootNodeId);
                long nodeId1 = UsageDAOTest.this.getNodeId(nodeRef1);
                UsageDAOTest.assertEquals((long)0L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(nodeRef1, false));
                NodeRef nodeRef2 = UsageDAOTest.this.createNode(rootNodeId);
                long nodeId2 = UsageDAOTest.this.getNodeId(nodeRef2);
                UsageDAOTest.assertEquals((long)0L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(nodeRef2, false));
                UsageDAOTest.assertEquals((int)1, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                UsageDAOTest.this.usageDAO.insertDelta(nodeRef1, 200L);
                UsageDAOTest.assertEquals((long)200L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(nodeRef1, false));
                UsageDAOTest.assertEquals((int)2, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                UsageDAOTest.this.usageDAO.insertDelta(nodeRef2, -400L);
                UsageDAOTest.assertEquals((long)-400L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(nodeRef2, false));
                UsageDAOTest.assertEquals((int)3, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                UsageDAOTest.this.usageDAO.deleteDeltas(rootNodeId);
                UsageDAOTest.assertEquals((long)0L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(rootNodeRef, false));
                UsageDAOTest.assertEquals((int)2, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                UsageDAOTest.this.usageDAO.deleteDeltas(nodeId1);
                UsageDAOTest.assertEquals((long)0L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(nodeRef1, false));
                UsageDAOTest.assertEquals((int)1, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                UsageDAOTest.this.usageDAO.deleteDeltas(nodeId2);
                UsageDAOTest.assertEquals((long)0L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(nodeRef2, false));
                UsageDAOTest.assertEquals((int)0, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
    }

    public void testCreateUsageDeltasWithRollback() throws Exception {
        Object voidCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef rootNodeRef = UsageDAOTest.this.getRootNodeRef();
                long rootNodeId = UsageDAOTest.this.getNodeId(rootNodeRef);
                UsageDAOTest.this.usageDAO.deleteDeltas(rootNodeId);
                UsageDAOTest.assertEquals((long)0L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(rootNodeRef, false));
                Set usageDeltaNodes = UsageDAOTest.this.usageDAO.getUsageDeltaNodes();
                for (NodeRef nodeRef : usageDeltaNodes) {
                    long nodeId = UsageDAOTest.this.getNodeId(nodeRef);
                    UsageDAOTest.this.usageDAO.deleteDeltas(nodeId);
                }
                UsageDAOTest.assertEquals((int)0, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)voidCallback);
        voidCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef usageNodeRef = UsageDAOTest.this.getRootNodeRef();
                UsageDAOTest.this.usageDAO.insertDelta(usageNodeRef, 100L);
                throw new RuntimeException("Forced");
            }
        };
        try {
            this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)voidCallback);
            UsageDAOTest.fail((String)"Transaction didn't roll back");
        }
        catch (RuntimeException runtimeException) {}
        voidCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef usageNodeRef = UsageDAOTest.this.getRootNodeRef();
                UsageDAOTest.assertEquals((long)0L, (long)UsageDAOTest.this.usageDAO.getTotalDeltaSize(usageNodeRef, false));
                UsageDAOTest.assertEquals((int)0, (int)UsageDAOTest.this.usageDAO.getUsageDeltaNodes().size());
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)voidCallback);
    }
}

