/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import junit.framework.TestCase;
import org.alfresco.repo.action.ActionConditionImpl;
import org.alfresco.repo.action.CompositeActionConditionImpl;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.CompositeActionCondition;
import org.alfresco.util.GUID;

public class CompositeActionConditionImplTest
extends TestCase {
    protected void setUp() throws Exception {
    }

    protected CompositeActionCondition create() {
        return new CompositeActionConditionImpl(GUID.generate());
    }

    public void testGetRuleConditionDefintion() {
        CompositeActionCondition temp = this.create();
        CompositeActionConditionImplTest.assertEquals((String)"composite-condition", (String)temp.getActionConditionDefinitionName());
    }

    public void testAddActionCondition() {
        CompositeActionCondition temp = this.create();
        CompositeActionConditionImplTest.assertEquals((int)temp.getActionConditions().size(), (int)0);
        temp.addActionCondition((ActionCondition)new ActionConditionImpl("id", "condName", null));
        CompositeActionConditionImplTest.assertEquals((int)temp.getActionConditions().size(), (int)1);
    }

    public void testHasActionConditions() {
        CompositeActionCondition temp = this.create();
        CompositeActionConditionImplTest.assertEquals((boolean)temp.hasActionConditions(), (boolean)false);
        temp.addActionCondition((ActionCondition)new ActionConditionImpl("id", "condName", null));
        CompositeActionConditionImplTest.assertEquals((boolean)temp.hasActionConditions(), (boolean)true);
    }

    public void testRemoveAllActionConditions() {
        CompositeActionCondition temp = this.create();
        CompositeActionConditionImplTest.assertEquals((boolean)temp.hasActionConditions(), (boolean)false);
        temp.addActionCondition((ActionCondition)new ActionConditionImpl("id", "condName", null));
        CompositeActionConditionImplTest.assertEquals((boolean)temp.hasActionConditions(), (boolean)true);
        temp.removeAllActionConditions();
        CompositeActionConditionImplTest.assertEquals((boolean)temp.hasActionConditions(), (boolean)false);
    }

    public void testSetORCondition() {
        CompositeActionCondition temp = this.create();
        CompositeActionConditionImplTest.assertEquals((boolean)temp.isORCondition(), (boolean)false);
        temp.setORCondition(true);
        CompositeActionConditionImplTest.assertEquals((boolean)temp.isORCondition(), (boolean)true);
    }

    public void testSetGetInvertCondition() {
        CompositeActionCondition temp = this.create();
        CompositeActionConditionImplTest.assertFalse((boolean)temp.getInvertCondition());
        temp.setInvertCondition(true);
        CompositeActionConditionImplTest.assertTrue((boolean)temp.getInvertCondition());
    }
}

