/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import org.alfresco.repo.virtual.ref.PathHasher;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.codec.binary.Base64;

public abstract class HierarchicalPathHasher
implements PathHasher {
    private static String normalizePath(String classpath) {
        String normalizedClasspath = classpath.trim();
        if (!normalizedClasspath.startsWith("/")) {
            normalizedClasspath = "/" + normalizedClasspath;
        }
        if (normalizedClasspath.endsWith("/")) {
            normalizedClasspath = normalizedClasspath.substring(0, normalizedClasspath.length() - 1);
        }
        return normalizedClasspath;
    }

    protected abstract String hashSubpath(String var1);

    protected abstract String lookupSubpathHash(String var1);

    @Override
    public Pair<String, String> hash(String path) {
        String normalClasspath;
        ParameterCheck.mandatoryString((String)"path", (String)path);
        String searchedClasspath = normalClasspath = HierarchicalPathHasher.normalizePath(path);
        String notFoundPath = null;
        String hash = this.hashSubpath(searchedClasspath);
        while (hash == null) {
            int lastSeparator = searchedClasspath.lastIndexOf(47);
            if (lastSeparator < 0) {
                String code = new String(Base64.encodeBase64((byte[])normalClasspath.getBytes(), (boolean)false));
                return new Pair(null, (Object)code);
            }
            notFoundPath = notFoundPath != null ? String.valueOf(searchedClasspath.substring(lastSeparator + 1)) + "/" + notFoundPath : searchedClasspath.substring(lastSeparator + 1);
            hash = this.hashSubpath(searchedClasspath = searchedClasspath.substring(0, lastSeparator));
            if (hash == null) continue;
            String notFoundClasspathBase64 = new String(Base64.encodeBase64((byte[])notFoundPath.getBytes(), (boolean)false));
            return new Pair((Object)hash, (Object)notFoundClasspathBase64);
        }
        return new Pair((Object)hash, null);
    }

    @Override
    public String lookup(Pair<String, String> hash) {
        if (hash.getSecond() == null) {
            return this.lookupSubpathHash((String)hash.getFirst());
        }
        if (hash.getFirst() == null) {
            return this.lookupSubpathCode((String)hash.getSecond());
        }
        String lHash = this.lookupSubpathHash((String)hash.getFirst());
        String lCode = this.lookupSubpathCode((String)hash.getSecond());
        return String.valueOf(lHash) + "/" + lCode;
    }

    private String lookupSubpathCode(String code) {
        if (code.isEmpty()) {
            return "/";
        }
        byte[] decodedBytes = Base64.decodeBase64((byte[])code.getBytes());
        return new String(decodedBytes);
    }
}

