/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.rendition.RenditionLocation;
import org.alfresco.repo.rendition.executer.AbstractRenderingEngine;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.rendition.RenditionServiceException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class RenditionNodeManager {
    private static Log logger = LogFactory.getLog(RenditionNodeManager.class);
    private static final List<QName> unchangedProperties = Arrays.asList(ContentModel.PROP_NODE_REF, ContentModel.PROP_STORE_NAME);
    private static final String LINE_BREAK = System.getProperty("line.separator", "\n");
    private final NodeRef sourceNode;
    private final NodeRef tempRenditionNode;
    private final RenditionDefinition renditionDefinition;
    private final RenditionLocation location;
    private final NodeService nodeService;
    private final BehaviourFilter behaviourFilter;
    private final RenditionService renditionService;
    private final NodeRef existingLinkedRendition;

    public RenditionNodeManager(NodeRef sourceNode, NodeRef tempRenditionNode, RenditionLocation location, RenditionDefinition renditionDefinition, NodeService nodeService, RenditionService renditionService, BehaviourFilter behaviourFilter) {
        this.sourceNode = sourceNode;
        this.tempRenditionNode = tempRenditionNode;
        this.location = location;
        this.renditionDefinition = renditionDefinition;
        this.nodeService = nodeService;
        this.renditionService = renditionService;
        this.behaviourFilter = behaviourFilter;
        this.existingLinkedRendition = this.getExistingRendition();
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Creating/updating rendition based on:").append(LINE_BREAK).append("    sourceNode: ").append(sourceNode).append(LINE_BREAK).append("    tempRendition: ").append(tempRenditionNode).append(LINE_BREAK).append("    parentNode: ").append(location.getParentRef()).append(LINE_BREAK).append("    childNode: ").append(location.getChildRef()).append(LINE_BREAK).append("    childName: ").append(location.getChildName()).append(LINE_BREAK).append("    renditionDefinition.name: ").append(renditionDefinition.getRenditionName());
            logger.debug((Object)msg.toString());
        }
    }

    public ChildAssociationRef findOrCreateRenditionNode() {
        ChildAssociationRef result;
        QName renditionName = this.renditionDefinition.getRenditionName();
        if (this.existingLinkedRendition == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No existing rendition was found to be linked from the source node.");
            }
            result = this.getSpecifiedRenditionOrCreateNewRendition(renditionName);
        } else if (this.isOldRenditionInCorrectLocation()) {
            result = this.nodeService.getPrimaryParent(this.existingLinkedRendition);
        } else {
            if (this.isOrphaningRequired()) {
                this.orphanOldRendition((QNamePattern)renditionName);
                result = this.getSpecifiedRenditionOrCreateNewRendition(renditionName);
            }
            result = this.moveOldRendition(renditionName);
        }
        this.transferNodeProperties(result);
        return result;
    }

    private ChildAssociationRef moveOldRendition(QName renditionName) {
        NodeRef parent = this.location.getParentRef();
        QName assocName = this.getAssociationName(parent.equals((Object)this.sourceNode), renditionName);
        QName assocType = this.sourceNode.equals((Object)parent) ? RenditionModel.ASSOC_RENDITION : ContentModel.ASSOC_CONTAINS;
        ChildAssociationRef result = this.nodeService.moveNode(this.existingLinkedRendition, parent, assocType, assocName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The old rendition was moved to " + result));
        }
        return result;
    }

    private void orphanOldRendition(QNamePattern renditionName) {
        ChildAssociationRef parentAssoc;
        List parents = this.nodeService.getParentAssocs(this.existingLinkedRendition, (QNamePattern)RenditionModel.ASSOC_RENDITION, renditionName);
        if (parents.size() == 1 && (parentAssoc = (ChildAssociationRef)parents.get(0)).getParentRef().equals((Object)this.sourceNode)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Orphaning old rendition node " + this.existingLinkedRendition));
            }
            this.behaviourFilter.disableBehaviour(this.existingLinkedRendition, ContentModel.ASPECT_AUDITABLE);
            this.behaviourFilter.disableBehaviour(this.sourceNode, ContentModel.ASPECT_AUDITABLE);
            try {
                this.nodeService.removeAspect(this.existingLinkedRendition, RenditionModel.ASPECT_HIDDEN_RENDITION);
                this.nodeService.removeAspect(this.existingLinkedRendition, RenditionModel.ASPECT_VISIBLE_RENDITION);
                this.nodeService.removeChildAssociation(parentAssoc);
            }
            finally {
                this.behaviourFilter.enableBehaviour(this.existingLinkedRendition, ContentModel.ASPECT_AUDITABLE);
                this.behaviourFilter.enableBehaviour(this.sourceNode, ContentModel.ASPECT_AUDITABLE);
            }
            return;
        }
        String msg = "Node: " + this.existingLinkedRendition + " is not a rendition of type: " + renditionName + " for source node: " + this.sourceNode;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)msg);
        }
        throw new RenditionServiceException(msg);
    }

    private boolean isOrphaningRequired() {
        boolean result = this.isOrphaningRequiredWithoutLog();
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("The old rendition does ");
            if (!result) {
                msg.append("not ");
            }
            msg.append("require orphaning.");
            logger.debug((Object)msg.toString());
        }
        return result;
    }

    private boolean isOrphaningRequiredWithoutLog() {
        if (this.location.getChildRef() != null) {
            return true;
        }
        return AbstractRenderingEngine.getParamWithDefault("orphan-existing-rendition", Boolean.FALSE, this.renditionDefinition);
    }

    private boolean isOldRenditionInCorrectLocation() {
        boolean result = this.isOldRenditionInCorrectLocationWithoutLog();
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("The old rendition was ");
            if (!result) {
                msg.append("not ");
            }
            msg.append("in the correct location");
            logger.debug((Object)msg.toString());
        }
        return result;
    }

    private boolean isOldRenditionInCorrectLocationWithoutLog() {
        NodeRef destination = this.location.getChildRef();
        if (destination != null) {
            return destination.equals((Object)this.existingLinkedRendition);
        }
        ChildAssociationRef oldParentAssoc = this.nodeService.getPrimaryParent(this.existingLinkedRendition);
        NodeRef oldParent = oldParentAssoc.getParentRef();
        if (oldParent.equals((Object)this.location.getParentRef())) {
            String childName = this.location.getChildName();
            if (childName == null) {
                return true;
            }
            Serializable oldName = this.nodeService.getProperty(this.existingLinkedRendition, ContentModel.PROP_NAME);
            return childName.equals(oldName);
        }
        return false;
    }

    private ChildAssociationRef getSpecifiedRenditionOrCreateNewRendition(QName renditionName) {
        ChildAssociationRef result;
        NodeRef destination = this.location.getChildRef();
        if (destination != null) {
            this.checkDestinationNodeIsAcceptable(destination);
            result = this.nodeService.getPrimaryParent(destination);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Destination was not null. Using primary parent of " + destination));
            }
        } else {
            QName nodeType = null;
            if (this.tempRenditionNode != null) {
                nodeType = this.nodeService.getType(this.tempRenditionNode);
            }
            result = this.createNewRendition(renditionName, nodeType);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using rendition " + result));
        }
        return result;
    }

    private void checkDestinationNodeIsAcceptable(NodeRef destination) {
        if (!this.nodeService.exists(destination)) {
            return;
        }
        if (!this.renditionService.isRendition(destination)) {
            throw new RenditionServiceException("Cannot perform a rendition to an existing node that is not a rendition.");
        }
        ChildAssociationRef sourceAssoc = this.renditionService.getSourceNode(destination);
        if (!sourceAssoc.getParentRef().equals((Object)this.sourceNode)) {
            throw new RenditionServiceException("Cannot perform a rendition to an existing rendition node whose source is different.");
        }
        if (!sourceAssoc.getQName().equals((Object)this.renditionDefinition.getRenditionName())) {
            throw new RenditionServiceException("Cannot perform a rendition to an existing rendition node whose rendition name is different.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using destination node " + destination + " with existing srcNode: " + sourceAssoc));
        }
    }

    private ChildAssociationRef createNewRendition(QName renditionName, QName nodeTypeQName) {
        QName assocTypeQName;
        NodeRef parentRef = this.location.getParentRef();
        boolean parentIsSource = parentRef.equals((Object)this.sourceNode);
        QName renditionType = RenditionModel.ASSOC_RENDITION;
        QName qName = assocTypeQName = parentIsSource ? renditionType : ContentModel.ASSOC_CONTAINS;
        if (nodeTypeQName == null) {
            nodeTypeQName = ContentModel.TYPE_CONTENT;
        }
        QName assocName = this.getAssociationName(parentIsSource, renditionName);
        ChildAssociationRef primaryAssoc = null;
        try {
            this.behaviourFilter.disableBehaviour(parentRef, ContentModel.ASPECT_AUDITABLE);
            Map<QName, Boolean> indexProps = Collections.singletonMap(ContentModel.PROP_IS_INDEXED, Boolean.FALSE);
            primaryAssoc = this.nodeService.createNode(parentRef, assocTypeQName, assocName, nodeTypeQName, indexProps);
        }
        finally {
            this.behaviourFilter.enableBehaviour(parentRef, ContentModel.ASPECT_AUDITABLE);
        }
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Created final rendition node ").append(primaryAssoc);
            logger.debug((Object)msg.toString());
        }
        if (!parentIsSource) {
            NodeRef rendition = primaryAssoc.getChildRef();
            ChildAssociationRef newChild = null;
            this.behaviourFilter.disableBehaviour(this.sourceNode, ContentModel.ASPECT_AUDITABLE);
            try {
                newChild = this.nodeService.addChild(this.sourceNode, rendition, renditionType, renditionName);
            }
            finally {
                this.behaviourFilter.enableBehaviour(this.sourceNode, ContentModel.ASPECT_AUDITABLE);
            }
            if (logger.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Added new rendition node as child of source node ").append(newChild);
                logger.debug((Object)msg.toString());
            }
        }
        return primaryAssoc;
    }

    private QName getAssociationName(boolean parentIsSource, QName renditionName) {
        QName assocName = renditionName;
        String childName = this.location.getChildName();
        if (!parentIsSource && childName != null && childName.length() > 0) {
            assocName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)childName);
        }
        return assocName;
    }

    private NodeRef getExistingRendition() {
        NodeRef result;
        QName renditionName = this.renditionDefinition.getRenditionName();
        ChildAssociationRef renditionAssoc = this.renditionService.getRenditionByName(this.sourceNode, renditionName);
        NodeRef nodeRef = result = renditionAssoc == null ? null : renditionAssoc.getChildRef();
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Existing rendition with name ").append(renditionName).append(": ").append(result);
            logger.debug((Object)msg.toString());
        }
        return result;
    }

    private void transferNodeProperties(ChildAssociationRef finalRenditionAssoc) {
        QName type;
        NodeRef targetNode = finalRenditionAssoc.getChildRef();
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Transferring some properties from ").append(this.tempRenditionNode).append(" to ").append(targetNode);
            logger.debug((Object)msg.toString());
        }
        if ((type = this.nodeService.getType(this.tempRenditionNode)) != null && !type.equals((Object)this.nodeService.getType(targetNode))) {
            this.nodeService.setType(targetNode, type);
        }
        Map newProps = this.nodeService.getProperties(targetNode);
        for (Map.Entry entry : this.nodeService.getProperties(this.tempRenditionNode).entrySet()) {
            QName propKey = (QName)entry.getKey();
            if (unchangedProperties.contains(propKey) || "http://www.alfresco.org/model/system/1.0".equals(propKey.getNamespaceURI())) continue;
            newProps.put(propKey, (Serializable)entry.getValue());
        }
        this.nodeService.setProperties(targetNode, newProps);
    }
}

