/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.BehaviourIndex;
import org.alfresco.repo.policy.CachedPolicyFactory;
import org.alfresco.repo.policy.ClassFeatureBehaviourBinding;
import org.alfresco.repo.policy.PolicyList;
import org.alfresco.repo.policy.PropertyPolicy;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

@AlfrescoPublicApi
public class PropertyPolicyDelegate<P extends PropertyPolicy> {
    private DictionaryService dictionary;
    private CachedPolicyFactory<ClassFeatureBehaviourBinding, P> factory;

    PropertyPolicyDelegate(DictionaryService dictionary, Class<P> policyClass, BehaviourIndex<ClassFeatureBehaviourBinding> index, long tryLockTimeout) {
        Collection<BehaviourDefinition> definitions = index.getAll();
        for (BehaviourDefinition definition : definitions) {
            definition.getBehaviour().getInterface(policyClass);
        }
        this.factory = new CachedPolicyFactory<ClassFeatureBehaviourBinding, P>(policyClass, index);
        this.factory.setTryLockTimeout(tryLockTimeout);
        this.dictionary = dictionary;
    }

    private void checkPropertyType(QName propertyQName) throws IllegalArgumentException {
        PropertyDefinition propertyDef = this.dictionary.getProperty(propertyQName);
        if (propertyDef == null) {
            throw new IllegalArgumentException("Property " + propertyQName + " has not been defined in the data dictionary");
        }
    }

    public P get(QName classQName, QName propertyQName) {
        return this.get(null, classQName, propertyQName);
    }

    public P get(NodeRef nodeRef, QName classQName, QName propertyQName) {
        this.checkPropertyType(propertyQName);
        return (P)((PropertyPolicy)this.factory.create(new ClassFeatureBehaviourBinding(this.dictionary, nodeRef, classQName, propertyQName)));
    }

    public Collection<P> getList(QName classQName, QName propertyQName) {
        return this.getList(null, classQName, propertyQName);
    }

    public Collection<P> getList(NodeRef nodeRef, QName classQName, QName propertyQName) {
        this.checkPropertyType(propertyQName);
        return this.factory.createList(new ClassFeatureBehaviourBinding(this.dictionary, nodeRef, classQName, propertyQName));
    }

    public P get(Set<QName> classQNames, QName propertyQName) {
        return this.get(null, classQNames, propertyQName);
    }

    public P get(NodeRef nodeRef, Set<QName> classQNames, QName propertyQName) {
        this.checkPropertyType(propertyQName);
        return (P)((PropertyPolicy)this.factory.toPolicy((Collection)this.getList(nodeRef, classQNames, propertyQName)));
    }

    public Collection<P> getList(Set<QName> classQNames, QName propertyQName) {
        return this.getList(null, classQNames, propertyQName);
    }

    public Collection<P> getList(NodeRef nodeRef, Set<QName> classQNames, QName propertyQName) {
        this.checkPropertyType(propertyQName);
        HashSet<Object> policies = new HashSet<Object>();
        for (QName classQName : classQNames) {
            PropertyPolicy policy = (PropertyPolicy)this.factory.create(new ClassFeatureBehaviourBinding(this.dictionary, nodeRef, classQName, propertyQName));
            if (policy instanceof PolicyList) {
                policies.addAll(((PolicyList)((Object)policy)).getPolicies());
                continue;
            }
            policies.add(policy);
        }
        return policies;
    }
}

