/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.tenant.ibatis;

import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.domain.tenant.AbstractTenantAdminDAOImpl;
import org.alfresco.repo.domain.tenant.TenantEntity;
import org.alfresco.repo.domain.tenant.TenantQueryEntity;
import org.mybatis.spring.SqlSessionTemplate;

public class TenantAdminDAOImpl
extends AbstractTenantAdminDAOImpl {
    private static final String INSERT_TENANT = "alfresco.tenants.insert_Tenant";
    private static final String SELECT_TENANT = "alfresco.tenants.select_Tenant";
    private static final String SELECT_TENANTS = "alfresco.tenants.select_Tenants";
    private static final String UPDATE_TENANT = "alfresco.tenants.update_Tenant";
    private static final String DELETE_TENANT = "alfresco.tenants.delete_Tenant";
    private SqlSessionTemplate template;

    public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    @Override
    protected TenantEntity createTenantEntity(TenantEntity entity) {
        entity.setVersion(0L);
        this.template.insert(INSERT_TENANT, (Object)entity);
        return entity;
    }

    @Override
    protected TenantEntity getTenantEntity(String tenantDomain) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("tenantDomain", tenantDomain);
        return (TenantEntity)this.template.selectOne(SELECT_TENANT, params);
    }

    @Override
    protected List<TenantEntity> getTenantEntities(Boolean enabled) {
        TenantQueryEntity entity = new TenantQueryEntity();
        entity.setEnabled(enabled);
        return this.template.selectList(SELECT_TENANTS, (Object)entity);
    }

    @Override
    protected int updateTenantEntity(TenantEntity tenantEntity) {
        tenantEntity.incrementVersion();
        return this.template.update(UPDATE_TENANT, (Object)tenantEntity);
    }

    @Override
    protected int deleteTenantEntity(String tenantDomain) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("tenantDomain", tenantDomain);
        return this.template.delete(DELETE_TENANT, params);
    }
}

