/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.FileNotFoundException;
import java.util.List;
import org.alfresco.filesys.repo.CifsHelper;
import org.alfresco.filesys.repo.ContentFileInfo;
import org.alfresco.filesys.repo.InFlightCorrectable;
import org.alfresco.filesys.repo.InFlightCorrector;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentSearchContext
extends SearchContext
implements InFlightCorrectable {
    private static final Log logger = LogFactory.getLog(ContentSearchContext.class);
    public static final int LinkFileSize = 512;
    private InFlightCorrector corrector;
    private CifsHelper cifsHelper;
    private List<NodeRef> results;
    private int index = -1;
    private boolean lockedFilesAsOffline;
    private int resumeId;
    private String m_relPath;
    private String m_lastFileName;

    @Override
    public void setInFlightCorrector(InFlightCorrector corrector) {
        this.corrector = corrector;
    }

    protected ContentSearchContext(CifsHelper cifsHelper, List<NodeRef> results, String searchStr, String relPath, boolean lockedFilesAsOffline) {
        super.setSearchString(searchStr);
        this.cifsHelper = cifsHelper;
        this.results = results;
        this.lockedFilesAsOffline = lockedFilesAsOffline;
        this.m_relPath = relPath;
        if (this.m_relPath != null && !this.m_relPath.endsWith("\\")) {
            this.m_relPath = String.valueOf(this.m_relPath) + "\\";
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(60);
        sb.append("[ContentSearchContext searchStr=");
        sb.append(this.getSearchString());
        sb.append(", resultCount=");
        sb.append(this.results.size());
        sb.append("]");
        return sb.toString();
    }

    public int getResumeId() {
        return this.resumeId;
    }

    public boolean hasMoreFiles() {
        return this.index < this.results.size() - 1;
    }

    public boolean nextFileInfo(FileInfo info) {
        ContentFileInfo nextInfo;
        block11: {
            if (!this.hasMoreFiles()) {
                return false;
            }
            ++this.index;
            ++this.resumeId;
            try {
                nextInfo = null;
                NodeRef nextNodeRef = null;
                while (nextInfo == null && this.index < this.results.size()) {
                    nextNodeRef = this.results.get(this.index);
                    try {
                        nextInfo = this.cifsHelper.getFileInformation(nextNodeRef, "", false, this.lockedFilesAsOffline);
                        info.copyFrom((FileInfo)nextInfo);
                        if (this.corrector == null) continue;
                        this.corrector.correct(info, this.m_relPath);
                    }
                    catch (InvalidNodeRefException invalidNodeRefException) {
                        if (logger.isWarnEnabled()) {
                            logger.warn((Object)("Noderef " + nextNodeRef + " no longer valid, ignoring"));
                        }
                        ++this.index;
                        ++this.resumeId;
                    }
                }
                if (nextInfo != null) break block11;
                return false;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
        }
        StringBuilder pathStr = new StringBuilder(this.m_relPath);
        pathStr.append(info.getFileName());
        if (nextInfo.isLinkNode()) {
            info.setFileSize(512L);
            if (!info.isReadOnly()) {
                info.setFileAttributes(info.getFileAttributes() + 1);
            }
            info.setFileType(3);
        } else {
            info.setFileType(1);
        }
        this.m_lastFileName = info.getFileName();
        return true;
    }

    public String nextFileName() {
        if (!this.hasMoreFiles()) {
            return null;
        }
        ++this.index;
        ++this.resumeId;
        NodeRef nextNodeRef = this.results.get(this.index);
        try {
            ContentFileInfo nextInfo = this.cifsHelper.getFileInformation(nextNodeRef, "", false, false);
            this.m_lastFileName = nextInfo.getFileName();
            return nextInfo.getFileName();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public boolean restartAt(FileInfo info) {
        int resId = 0;
        if (this.m_lastFileName != null && info.getFileName().equalsIgnoreCase(this.m_lastFileName)) {
            --this.index;
            --this.resumeId;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Fast search restart - " + this.m_lastFileName));
            }
            return true;
        }
        if (this.results != null) {
            int idx = 0;
            while (idx < this.results.size()) {
                String fname = this.cifsHelper.getFileName(this.results.get(idx));
                if (fname != null && fname.equals(info.getFileName())) {
                    this.index = idx - 1;
                    this.resumeId = resId - 1;
                    return true;
                }
                ++idx;
                ++resId;
            }
        }
        return false;
    }

    public boolean restartAt(int resumeIdParameter) {
        if (this.results != null && --resumeIdParameter < this.results.size()) {
            this.index = resumeIdParameter;
            this.resumeId = resumeIdParameter + 1;
            return true;
        }
        return false;
    }

    protected String getRelativePath() {
        return this.m_relPath;
    }

    protected int getResultsSize() {
        return this.results != null ? this.results.size() : 0;
    }
}

