/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.ArrayList;
import java.util.Collections;
import org.alfresco.util.BeanExtender;
import org.alfresco.util.GUID;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class BeanExtenderUnitTest {
    private static final String BEAN_NAME = GUID.generate();
    private static final String EXTENDING_BEAN_NAME = GUID.generate();
    @Mock
    private ConfigurableListableBeanFactory mockedBeanFactory;
    @Mock
    private BeanDefinition mockedBeanDefinition;
    @Mock
    private BeanDefinition mockedExtendingBeanDefinition;
    @Mock
    private MutablePropertyValues mockedPropertyValuesBean;
    @Mock
    private MutablePropertyValues mockedPropertyValuesExtendingBean;
    @InjectMocks
    private BeanExtender beanExtender;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void before() throws Exception {
        ((BeanDefinition)Mockito.doReturn((Object)this.mockedPropertyValuesBean).when((Object)this.mockedBeanDefinition)).getPropertyValues();
        ((BeanDefinition)Mockito.doReturn((Object)this.mockedPropertyValuesExtendingBean).when((Object)this.mockedExtendingBeanDefinition)).getPropertyValues();
    }

    @Test
    public void beanNameNotSet() {
        this.beanExtender.setExtendingBeanName(EXTENDING_BEAN_NAME);
        this.exception.expect(IllegalArgumentException.class);
        this.beanExtender.postProcessBeanFactory(this.mockedBeanFactory);
    }

    @Test
    public void extendingBeanNameNotSet() {
        this.beanExtender.setBeanName(BEAN_NAME);
        this.exception.expect(IllegalArgumentException.class);
        this.beanExtender.postProcessBeanFactory(this.mockedBeanFactory);
    }

    @Test
    public void beanDoesNotExist() {
        this.beanExtender.setBeanName(BEAN_NAME);
        this.beanExtender.setExtendingBeanName(EXTENDING_BEAN_NAME);
        ((ConfigurableListableBeanFactory)Mockito.doReturn((Object)false).when((Object)this.mockedBeanFactory)).containsBean(BEAN_NAME);
        this.exception.expect(NoSuchBeanDefinitionException.class);
        this.beanExtender.postProcessBeanFactory(this.mockedBeanFactory);
    }

    @Test
    public void extendingBeanDoesNotExist() {
        this.beanExtender.setBeanName(BEAN_NAME);
        this.beanExtender.setExtendingBeanName(EXTENDING_BEAN_NAME);
        ((ConfigurableListableBeanFactory)Mockito.doReturn((Object)true).when((Object)this.mockedBeanFactory)).containsBean(BEAN_NAME);
        ((ConfigurableListableBeanFactory)Mockito.doReturn((Object)false).when((Object)this.mockedBeanFactory)).containsBean(EXTENDING_BEAN_NAME);
        this.exception.expect(NoSuchBeanDefinitionException.class);
        this.beanExtender.postProcessBeanFactory(this.mockedBeanFactory);
    }

    @Test
    public void beanClassNameSet() {
        this.beanExtender.setBeanName(BEAN_NAME);
        this.beanExtender.setExtendingBeanName(EXTENDING_BEAN_NAME);
        ((ConfigurableListableBeanFactory)Mockito.doReturn((Object)true).when((Object)this.mockedBeanFactory)).containsBean(BEAN_NAME);
        ((ConfigurableListableBeanFactory)Mockito.doReturn((Object)true).when((Object)this.mockedBeanFactory)).containsBean(EXTENDING_BEAN_NAME);
        ((ConfigurableListableBeanFactory)Mockito.doReturn((Object)this.mockedBeanDefinition).when((Object)this.mockedBeanFactory)).getBeanDefinition(BEAN_NAME);
        ((ConfigurableListableBeanFactory)Mockito.doReturn((Object)this.mockedExtendingBeanDefinition).when((Object)this.mockedBeanFactory)).getBeanDefinition(EXTENDING_BEAN_NAME);
        ((BeanDefinition)Mockito.doReturn((Object)"a").when((Object)this.mockedBeanDefinition)).getBeanClassName();
        ((BeanDefinition)Mockito.doReturn((Object)"b").when((Object)this.mockedExtendingBeanDefinition)).getBeanClassName();
        ((MutablePropertyValues)Mockito.doReturn((Object)Collections.EMPTY_LIST).when((Object)this.mockedPropertyValuesExtendingBean)).getPropertyValueList();
        this.beanExtender.postProcessBeanFactory(this.mockedBeanFactory);
        ((BeanDefinition)Mockito.verify((Object)this.mockedBeanDefinition, (VerificationMode)Mockito.times((int)1))).setBeanClassName("b");
        ((MutablePropertyValues)Mockito.verify((Object)this.mockedPropertyValuesBean, (VerificationMode)Mockito.never())).add(ArgumentMatchers.anyString(), (Object)ArgumentMatchers.anyString());
    }

    @Test
    public void beanPropertyValuesSet() {
        this.beanExtender.setBeanName(BEAN_NAME);
        this.beanExtender.setExtendingBeanName(EXTENDING_BEAN_NAME);
        ((ConfigurableListableBeanFactory)Mockito.doReturn((Object)true).when((Object)this.mockedBeanFactory)).containsBean(BEAN_NAME);
        ((ConfigurableListableBeanFactory)Mockito.doReturn((Object)true).when((Object)this.mockedBeanFactory)).containsBean(EXTENDING_BEAN_NAME);
        ((ConfigurableListableBeanFactory)Mockito.doReturn((Object)this.mockedBeanDefinition).when((Object)this.mockedBeanFactory)).getBeanDefinition(BEAN_NAME);
        ((ConfigurableListableBeanFactory)Mockito.doReturn((Object)this.mockedExtendingBeanDefinition).when((Object)this.mockedBeanFactory)).getBeanDefinition(EXTENDING_BEAN_NAME);
        ((BeanDefinition)Mockito.doReturn(null).when((Object)this.mockedExtendingBeanDefinition)).getBeanClassName();
        PropertyValue mockedPropertyValueOne = this.generateMockedPropertyValue("one", "1");
        PropertyValue mockedPropertyValueTwo = this.generateMockedPropertyValue("two", "2");
        ArrayList<PropertyValue> list = new ArrayList<PropertyValue>(2);
        list.add(mockedPropertyValueOne);
        list.add(mockedPropertyValueTwo);
        ((MutablePropertyValues)Mockito.doReturn(list).when((Object)this.mockedPropertyValuesExtendingBean)).getPropertyValueList();
        this.beanExtender.postProcessBeanFactory(this.mockedBeanFactory);
        ((BeanDefinition)Mockito.verify((Object)this.mockedBeanDefinition, (VerificationMode)Mockito.never())).setBeanClassName(ArgumentMatchers.anyString());
        ((MutablePropertyValues)Mockito.verify((Object)this.mockedPropertyValuesBean, (VerificationMode)Mockito.times((int)1))).add("one", (Object)"1");
        ((MutablePropertyValues)Mockito.verify((Object)this.mockedPropertyValuesBean, (VerificationMode)Mockito.times((int)1))).add("two", (Object)"2");
    }

    private PropertyValue generateMockedPropertyValue(String name, String value) {
        PropertyValue result = (PropertyValue)Mockito.mock(PropertyValue.class);
        ((PropertyValue)Mockito.doReturn((Object)name).when((Object)result)).getName();
        ((PropertyValue)Mockito.doReturn((Object)value).when((Object)result)).getValue();
        return result;
    }
}

